# テスト方針書

## 概要

本ドキュメントは、QuickerSite（ASP/VBScriptベースのCMS）に対するテスト方針を定義します。現時点では自動テストの仕組みが実装されていないため、本書では手動テストを中心とした現実的なテスト戦略と、将来的なテスト自動化への推奨事項を提示します。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のASP関数・クラス（cls_database, cls_page等）の動作検証 | 開発者 |
| 結合テスト | インクルードファイル間の連携、データベース操作（Access/SQL Server）との統合確認 | 開発者/QA |
| システムテスト | CMS全体機能（ページ管理、フォーム、ギャラリー等）のエンドツーエンド検証 | QA |
| 受入テスト | ユーザー観点での機能確認、テンプレートシステムの動作確認 | エンドユーザー/顧客 |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | ページ編集、コンタクト管理、ギャラリー、ショップ機能等の機能検証 | 各機能開発完了時 |
| 性能テスト | 大量ページ/コンタクト時のレスポンス、データベースクエリ性能 | リリース前 |
| セキュリティテスト | SQLインジェクション、XSS、認証・認可、ファイルアップロード検証 | リリース前・定期 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| 開発環境 | 開発中のローカルテスト | IIS Express / Visual Studio Code, Access DB |
| ステージング環境 | 結合テスト・システムテスト | Windows Server (IIS 5以上), Access/SQL Server |
| 本番相当環境 | 受入テスト・性能テスト | Windows Server, ASP.NET 2.0, 本番同等構成 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| ブラウザ開発者ツール | フロントエンドデバッグ、ネットワーク監視 | 各ブラウザ最新版 |
| IIS Express | ローカル開発環境でのテスト実行 | Visual Studio付属版 |
| Postman/cURL | API・フォームポストのテスト | 最新版 |
| OWASP ZAP | セキュリティスキャン | 2.x |
| Apache JMeter | 性能テスト・負荷テスト | 5.x |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | N/A（ASP Classicは標準的なカバレッジ計測ツールなし） |
| 分岐カバレッジ | N/A |
| 機能カバレッジ | 主要機能100%（手動テスト） |

**注記**: ASP Classic/VBScriptには標準的なコードカバレッジ計測ツールが存在しないため、機能ベースのテストカバレッジ管理を推奨します。

## テストデータ

### データ準備方針

1. **初期データ**: QuickerSite.mdb/QuickerLabels.mdbのバックアップを使用
2. **テストユーザー**: デフォルトパスワード「admin」から変更したテストアカウント
3. **テストコンテンツ**: 各機能検証用のページ、フォーム、ギャラリーを準備
4. **境界値データ**: manyContacts（デフォルト250）超過時の動作検証用データ

### データクリーンアップ

- テスト前にAccessデータベースファイルをリセット
- テスト用アップロードファイルの削除（/UserFiles/配下）

## 不具合管理

### 管理方法

1. **報告**: 発見した不具合はGitHub Issues（またはプロジェクト指定のツール）に登録
2. **分類**:
   - Critical: セキュリティ、データ損失
   - High: 主要機能の障害
   - Medium: 機能制限、UI問題
   - Low: 軽微な表示問題
3. **追跡**: 不具合IDでコード修正を追跡

### 再テスト基準

- 修正完了後、同一環境・同一手順で再テスト実施
- 関連機能への影響確認（リグレッションテスト）

## CI/CD連携

### 現状

現時点ではCI/CDパイプラインは構成されていません。プロジェクトにはGitHub Actionsの設定ファイルが存在せず、自動テストスクリプトも実装されていません。

### 推奨事項

1. **静的解析の導入**: VBScriptリンターの導入検討
2. **デプロイ自動化**: IIS Webデプロイの自動化スクリプト作成
3. **スモークテスト**: デプロイ後の基本動作確認スクリプト（PowerShell/curl等）

```
# デプロイ後スモークテスト例（PowerShell）
$response = Invoke-WebRequest -Uri "http://localhost/default.asp" -UseBasicParsing
if ($response.StatusCode -ne 200) { exit 1 }
```

## 主要テスト対象機能

### コア機能

| 機能 | 関連ファイル | テスト観点 |
| --- | --- | --- |
| ページ管理 | bs_editPage.asp, includes/page.asp | CRUD操作、権限制御 |
| コンタクト管理 | bs_contactEdit.asp, includes/contact.asp | 大量データ時の動作 |
| フォーム | bs_form.asp, includes/form.asp | 入力検証、送信処理 |
| ギャラリー | bs_galleryEdit.asp, includes/gallery.asp | 画像アップロード、表示 |
| テンプレート | bs_template.asp, includes/template.asp | テンプレート適用、CSS |
| ショップ | bs_shopProduct.asp, includes/shopProduct.asp | カート、決済フロー |
| ニュースレター | bs_newsletterList.asp, includes/newsletter.asp | 送信、購読管理 |

### セキュリティテスト重点項目

| 項目 | 検証内容 |
| --- | --- |
| 認証 | ログイン試行制限（QS_number_of_allowed_attempts_to_login=5） |
| ファイル拡張子 | 危険な拡張子のブロック（php, exe, jsp等） |
| SQLインジェクション | パラメータ化クエリの確認 |
| XSS | ユーザー入力のエスケープ処理 |
| ファイルアップロード | /UserFiles/への不正ファイルアップロード |

## 備考

### ASP Classicの制限事項

- 自動テストフレームワークの選択肢が限定的
- コードカバレッジ計測が困難
- モダンなCI/CDとの統合に追加作業が必要

### 将来的な改善提案

1. **テスト自動化検討**: Selenium/Playwrightによるブラウザテスト自動化
2. **APIテスト**: AJAXエンドポイント（modules/ajax.asp等）の自動テスト
3. **データベーステスト**: Access/SQL Server操作の自動検証スクリプト
4. **ドキュメント整備**: テストケース仕様書の作成と管理
