# ER図 - QuickerSite CMS

## 概要

本文書はQuickerSite CMSのエンティティ関連図（ER図）をMermaid形式で記述したものである。

---

## 1. 全体概要図

```mermaid
erDiagram
    tblCustomer ||--o{ tblPage : "has"
    tblCustomer ||--o{ tblContact : "has"
    tblCustomer ||--o{ tblTemplate : "has"
    tblCustomer ||--o{ tblGallery : "has"
    tblCustomer ||--o{ tblNewsletter : "has"
    tblCustomer ||--o{ tblPoll : "has"
    tblCustomer ||--o{ tblGuestbook : "has"
    tblCustomer ||--o{ tblTheme : "has"
    tblCustomer ||--o{ tblFeed : "has"
    tblCustomer ||--o{ tblPopup : "has"
    tblCustomer ||--o{ tblConstant : "has"
    tblCustomer ||--o{ tblMonitor : "has"
    tblCustomer ||--o{ tblContactField : "has"
    tblCustomer ||--o{ tblNewsletterCategory : "has"

    tblPage ||--o{ tblPage : "parent-child"
    tblPage }o--|| tblTemplate : "uses"
    tblPage }o--o| tblTheme : "embeds"
    tblPage }o--o| tblFeed : "embeds"

    tblContact ||--o{ tblPost : "creates"
    tblContact ||--o{ tblContactValues : "has"
    tblContact ||--o{ tblContactPage : "has"
    tblContact ||--o{ tblThemeSubscription : "subscribes"
    tblContact ||--o{ tblThemeTopicSubscription : "subscribes"

    tblContactField ||--o{ tblContactValues : "defines"

    tblTheme ||--o{ tblPost : "contains"
    tblTheme ||--o{ tblThemeSubscription : "has"
    tblTheme }o--o| tblContact : "moderated-by"

    tblPost ||--o{ tblPost : "replies"
    tblPost ||--o{ tblThemeTopicSubscription : "has"

    tblPoll ||--o{ tblPollVote : "receives"

    tblGuestbook ||--o{ tblGuestbookItem : "contains"

    tblNewsletterCategory ||--o{ tblNewsletterCategorySubscriber : "has"
```

---

## 2. コア機能ER図（顧客・ページ・テンプレート）

```mermaid
erDiagram
    tblCustomer {
        int iId PK "顧客ID"
        string sName "顧客名"
        string sURL "サイトURL"
        boolean bOnline "オンライン状態"
        datetime dCreatedTS "作成日時"
        datetime dUpdatedTS "更新日時"
        int defaultTemplate FK "デフォルトテンプレートID"
        string language "言語"
        string adminPassword "管理者パスワード(SHA256)"
        string webmasterEmail "管理者メール"
        boolean bIntranet "イントラネット機能"
        boolean bCatalog "カタログ機能"
    }

    tblPage {
        int iId PK "ページID"
        int iCustomerID FK "顧客ID"
        int iParentID FK "親ページID"
        int iTemplateID FK "テンプレートID"
        string sTitle "タイトル"
        text sValue "本文HTML"
        boolean bOnline "オンライン状態"
        boolean bDeleted "削除フラグ"
        boolean bHomepage "ホームページ"
        boolean bIntranet "イントラネット"
        string sCode "ページコード"
        string sUserFriendlyURL "フレンドリーURL"
        int iHits "ヒット数"
        datetime createdTS "作成日時"
        datetime updatedTS "更新日時"
    }

    tblTemplate {
        int iId PK "テンプレートID"
        int iCustomerID FK "顧客ID"
        string sName "テンプレート名"
        text sValue "テンプレートHTML"
        text sPrintValue "印刷用"
        text sEmailValue "メール用"
        text sMobileValue "モバイル用"
        boolean bCompress "圧縮有効"
    }

    tblCustomer ||--o{ tblPage : "owns"
    tblCustomer ||--o{ tblTemplate : "owns"
    tblCustomer ||--|| tblTemplate : "default"
    tblPage ||--o{ tblPage : "parent"
    tblPage }o--|| tblTemplate : "uses"
```

---

## 3. ユーザー管理ER図

```mermaid
erDiagram
    tblContact {
        int iId PK "ユーザーID"
        int iCustomerID FK "顧客ID"
        string sEmail "メールアドレス"
        string sNickName "ニックネーム"
        string sPw "パスワード"
        int iStatus "ステータス"
        datetime dCreatedTS "作成日時"
        datetime dLastLoginTS "最終ログイン"
        boolean bGetEmailsFromSite "メール受信"
        string sAvatar "アバター"
    }

    tblContactField {
        int iId PK "フィールドID"
        int iCustomerID FK "顧客ID"
        string sName "フィールド名"
        string sType "データ型"
        boolean bMandatory "必須"
        boolean bProfile "プロファイル表示"
        int iRang "表示順"
    }

    tblContactValues {
        int iId PK "値ID"
        int iContactID FK "連絡先ID"
        int iFieldID FK "フィールドID"
        text sValue "値"
    }

    tblContactPage {
        int iId PK "権限ID"
        int iContactID FK "連絡先ID"
        int iTitleID "タイトル編集ページ"
        int iBodyID "本文編集ページ"
        int iLPID "リストページ"
    }

    tblContactRegistration {
        int iId PK "登録ID"
        int iCustomerID FK "顧客ID"
        string sEmail "メール"
        string sCode "確認コード"
        datetime dCreatedTS "作成日時"
    }

    tblCustomer ||--o{ tblContact : "has"
    tblCustomer ||--o{ tblContactField : "defines"
    tblContact ||--o{ tblContactValues : "has"
    tblContactField ||--o{ tblContactValues : "for"
    tblContact ||--o{ tblContactPage : "permissions"
```

---

## 4. フォーラム機能ER図

```mermaid
erDiagram
    tblTheme {
        int iId PK "フォーラムID"
        int iCustomerID FK "顧客ID"
        int iContactID FK "モデレーターID"
        string sName "フォーラム名"
        string sCode "コード"
        boolean bOnline "オンライン"
        boolean bLocked "ロック"
        boolean bAllowComments "コメント許可"
        boolean bAllowHTML "HTML許可"
        boolean bAllowAP "匿名投稿許可"
        int iPageSize "ページサイズ"
        int iSubLevel "購読レベル"
    }

    tblPost {
        int iId PK "投稿ID"
        int iThemeID FK "フォーラムID"
        int iContactID FK "投稿者ID"
        int iPostID FK "親投稿ID"
        string sSubject "件名"
        text sBody "本文"
        datetime dCreatedTS "作成日時"
        datetime dUpdatedTS "更新日時"
        boolean bNeedsToBeValidated "検証待ち"
        string sAnName "匿名名"
        string sFilename "添付ファイル"
    }

    tblThemeSubscription {
        int iId PK "購読ID"
        int iContactID FK "ユーザーID"
        int iThemeID FK "フォーラムID"
    }

    tblThemeTopicSubscription {
        int iId PK "購読ID"
        int iContactID FK "ユーザーID"
        int iPostID FK "投稿ID"
    }

    tblCustomer ||--o{ tblTheme : "owns"
    tblTheme ||--o{ tblPost : "contains"
    tblTheme }o--o| tblContact : "moderated-by"
    tblPost ||--o{ tblPost : "replies"
    tblContact ||--o{ tblPost : "creates"
    tblTheme ||--o{ tblThemeSubscription : "has"
    tblContact ||--o{ tblThemeSubscription : "subscribes"
    tblPost ||--o{ tblThemeTopicSubscription : "has"
    tblContact ||--o{ tblThemeTopicSubscription : "subscribes"
```

---

## 5. 投票・ゲストブック機能ER図

```mermaid
erDiagram
    tblPoll {
        int iId PK "投票ID"
        int iCustomerID FK "顧客ID"
        string sQuestion "質問"
        string sCode "コード"
        datetime dCreatedTS "作成日時"
        datetime dVoteFrom "投票開始"
        datetime dVoteUntil "投票終了"
        datetime dVoteDeadline "期限"
        boolean bShowTitle "タイトル表示"
        string sA1 "選択肢1"
        string sA2 "選択肢2"
        string sA3 "選択肢3"
    }

    tblPollVote {
        int iId PK "投票結果ID"
        int iPollID FK "投票ID"
        datetime dVoteTS "投票日時"
        int iVote "選択番号"
        string IP "IPアドレス"
    }

    tblGuestbook {
        int iId PK "ゲストブックID"
        int iCustomerID FK "顧客ID"
        string sCode "コード"
        string sName "名前"
        datetime dOnlineFrom "公開開始"
        datetime dOnlineUntil "公開終了"
        boolean bRequireValidation "検証必要"
        string sEmail "通知メール"
        int iPaging "ページング"
    }

    tblGuestbookItem {
        int iId PK "エントリID"
        int iGuestbookID FK "ゲストブックID"
        text sValue "メッセージ"
        string sMessageBy "投稿者名"
        string sMessageByEmail "投稿者メール"
        datetime dCreatedTS "作成日時"
        boolean bApproved "承認状態"
        string ip "IPアドレス"
        text sReply "管理者返信"
    }

    tblCustomer ||--o{ tblPoll : "has"
    tblPoll ||--o{ tblPollVote : "receives"
    tblCustomer ||--o{ tblGuestbook : "has"
    tblGuestbook ||--o{ tblGuestbookItem : "contains"
```

---

## 6. コンテンツ機能ER図

```mermaid
erDiagram
    tblGallery {
        int iId PK "ギャラリーID"
        int iCustomerID FK "顧客ID"
        string sName "ギャラリー名"
        string sCode "コード"
        string sPath "画像パス"
        int iType "タイプ"
        int iThumbSize "サムネイルサイズ"
        int iFullImageSize "フル画像サイズ"
        int iPicsInRow "行画像数"
    }

    tblNewsletter {
        int iId PK "ニュースレターID"
        int iCustomerID FK "顧客ID"
        string sName "名前"
        text sValue "本文"
        boolean bOnline "オンライン"
        string sSubject "件名"
        string sFromEmail "送信元メール"
        string sFromName "送信元名"
    }

    tblFeed {
        int iId PK "フィードID"
        int iCustomerID FK "顧客ID"
        string sName "フィード名"
        string sCode "コード"
        string sUrl "フィードURL"
        int iMaxItems "最大アイテム数"
        boolean bShowTitle "タイトル表示"
        int iCache "キャッシュ時間"
    }

    tblPopup {
        int iId PK "ポップアップID"
        int iCustomerID FK "顧客ID"
        string sName "名前"
        string sUrl "リンクURL"
        text sValue "本文"
        datetime dOnlineFrom "公開開始"
        datetime dOnlineUntil "公開終了"
        boolean bEnabled "有効"
        int iWidth "幅"
        int iHeight "高さ"
    }

    tblConstant {
        int iId PK "定数ID"
        int iCustomerID FK "顧客ID"
        string sConstant "定数名"
        text sValue "値"
        boolean bOnline "有効"
        int iType "タイプ"
    }

    tblCustomer ||--o{ tblGallery : "has"
    tblCustomer ||--o{ tblNewsletter : "has"
    tblCustomer ||--o{ tblFeed : "has"
    tblCustomer ||--o{ tblPopup : "has"
    tblCustomer ||--o{ tblConstant : "has"
```

---

## 7. 監視・ログ機能ER図

```mermaid
erDiagram
    tblMonitor {
        int iId PK "ログID"
        int iCustomerID FK "顧客ID"
        datetime dTS "日時"
        text sDetail "詳細情報"
    }

    tblSession {
        int iId PK "セッションID"
        int iCustomerID FK "顧客ID"
        string sSessionID "セッションキー"
        datetime dCreatedTS "作成日時"
    }

    tblMail {
        int iId PK "メールID"
        int iCustomerID FK "顧客ID"
        string sTo "宛先"
        string sSubject "件名"
        text sBody "本文"
        datetime dDateSent "送信日時"
    }

    tblCustomer ||--o{ tblMonitor : "logs"
    tblCustomer ||--o{ tblSession : "tracks"
    tblCustomer ||--o{ tblMail : "sends"
```

---

## 8. ショッピング機能ER図（オプション）

```mermaid
erDiagram
    tblQShopMake {
        int iId PK "メーカーID"
        int iCustomerID FK "顧客ID"
        string sName "メーカー名"
    }

    tblQShopProduct {
        int iId PK "製品ID"
        int iCustomerID FK "顧客ID"
        int iMakeID FK "メーカーID"
        string sName "製品名"
        text sDescription "説明"
        decimal dPrice "価格"
    }

    tblQShopCategory {
        int iId PK "カテゴリID"
        int iCustomerID FK "顧客ID"
        int iParentCatID FK "親カテゴリID"
        string sName "カテゴリ名"
    }

    tblQShopProdCat {
        int iId PK "関連ID"
        int iProductID FK "製品ID"
        int iCategoryID FK "カテゴリID"
    }

    tblCustomer ||--o{ tblQShopMake : "has"
    tblCustomer ||--o{ tblQShopProduct : "has"
    tblCustomer ||--o{ tblQShopCategory : "has"
    tblQShopMake ||--o{ tblQShopProduct : "manufactures"
    tblQShopProduct ||--o{ tblQShopProdCat : "categorized"
    tblQShopCategory ||--o{ tblQShopProdCat : "contains"
    tblQShopCategory ||--o{ tblQShopCategory : "parent"
```

---

## 9. 凡例

### 記号説明

| 記号 | 意味 |
|------|------|
| `||--o{` | 1対多 (One to Many) |
| `}o--||` | 多対1 (Many to One) |
| `||--||` | 1対1 (One to One) |
| `}o--o{` | 多対多 (Many to Many) |
| `o|` | 0または1 (Zero or One) |
| `PK` | Primary Key |
| `FK` | Foreign Key |

### カーディナリティ

- `||` : 必須 (exactly one)
- `o|` : オプション (zero or one)
- `|{` : 1以上 (one or more)
- `o{` : 0以上 (zero or more)

---

## 10. 変更履歴

| 版 | 日付 | 変更内容 | 担当者 |
|----|------|----------|--------|
| 1.0 | 2026-01-23 | 初版作成 | AI自動生成 |
