---
confidence_score: 0.78
coverage_score: 0.82
primary_sources:
  - path: "asp/includes/customer.asp"
    relevance: "high"
    description: "tblCustomerテーブルのカラム定義を含むcls_customerクラス"
  - path: "asp/includes/page.asp"
    relevance: "high"
    description: "tblPageテーブルのカラム定義を含むcls_pageクラス"
  - path: "asp/includes/contact.asp"
    relevance: "high"
    description: "tblContactおよび関連テーブルのカラム定義"
  - path: "asp/includes/post.asp"
    relevance: "high"
    description: "tblPostテーブルのカラム定義を含むcls_postクラス"
  - path: "asp/includes/theme.asp"
    relevance: "high"
    description: "tblThemeおよび関連テーブルのカラム定義"
  - path: "asp/includes/gallery.asp"
    relevance: "high"
    description: "tblGalleryテーブルのカラム定義"
  - path: "asp/includes/guestbook.asp"
    relevance: "high"
    description: "tblGuestbookおよびtblGuestbookItemテーブル"
  - path: "asp/includes/poll.asp"
    relevance: "high"
    description: "tblPollおよびtblPollVoteテーブル"
  - path: "asp/includes/newsletter.asp"
    relevance: "high"
    description: "tblNewsletterテーブルのカラム定義"
  - path: "asp/includes/template.asp"
    relevance: "high"
    description: "tblTemplateテーブルのカラム定義"
  - path: "asp/includes/feed.asp"
    relevance: "high"
    description: "tblFeedテーブルのカラム定義"
  - path: "asp/includes/popup.asp"
    relevance: "high"
    description: "tblPopupテーブルのカラム定義"
  - path: "asp/includes/constant.asp"
    relevance: "high"
    description: "tblConstantテーブルのカラム定義"
secondary_sources:
  - path: "asp/includes/database.asp"
    relevance: "medium"
    description: "データベース接続設定（Access .mdb）"
  - path: "asp/includes/shopMake.asp"
    relevance: "medium"
    description: "ショッピング機能のテーブル定義"
  - path: "asp/includes/shopProduct.asp"
    relevance: "medium"
    description: "ショッピング製品テーブル定義"
  - path: "asp/includes/language.asp"
    relevance: "medium"
    description: "tblLanguageテーブル定義"
  - path: "asp/includes/ac_calendarbooking.asp"
    relevance: "medium"
    description: "カレンダー予約テーブル定義"
verification_method: "code_analysis"
limitations:
  - "Access .mdbファイルへの直接アクセスが不可能なため、実際のスキーマは確認できていない"
  - "データ型はVBScript/ADOのコードから推測したものであり、実際のAccess型と異なる可能性がある"
  - "一部のテーブル（tblSecondAdmin、tblCustomerIntranetMessage等）は参照はあるが詳細定義が不完全"
  - "インデックス設計は推奨値であり、実際のデータベースインデックスは未確認"
  - "外部キー制約はAccessの仕様上、実装されていない可能性が高い"
assumptions:
  - "Classic ASPコードのRecordsetフィールド参照からカラム名を抽出"
  - "VBScript変数の命名規則（s=String, b=Boolean, i=Integer, d=Date）からデータ型を推測"
  - "ADO AddNew/Update処理からテーブル構造を分析"
  - "DELETE/SELECT文のWHERE句から外部キー関係を推定"
  - "AutoNumberはすべてのテーブルのiIdカラムに適用と仮定"
review_status: "draft"
last_updated: "2026-01-23"
---

# 根拠レポート - データベース設計書

## 1. 概要

本レポートは、「データベース設計書」および「ER図」の作成根拠について説明する。

### 1.1 信頼度スコア

| 指標 | スコア | 説明 |
|------|--------|------|
| 総合信頼度 | 0.78 | コード解析による推定であり、実DBスキーマ未確認 |
| カバレッジ | 0.82 | 主要テーブルの大半をカバー、一部詳細不明 |

---

## 2. 根拠となったソースファイル

### 2.1 主要ソース（Primary Sources）

以下のASPインクルードファイルから、VBScriptクラス定義とADO操作を解析してテーブル構造を抽出した。

| ファイル | 関連度 | 抽出内容 |
|---------|--------|----------|
| `asp/includes/customer.asp` | 高 | tblCustomer（110以上のカラム） |
| `asp/includes/page.asp` | 高 | tblPage（65以上のカラム） |
| `asp/includes/contact.asp` | 高 | tblContact, tblContactValues, tblContactPage |
| `asp/includes/post.asp` | 高 | tblPost（14カラム） |
| `asp/includes/theme.asp` | 高 | tblTheme, tblThemeSubscription, tblThemeTopicSubscription |
| `asp/includes/gallery.asp` | 高 | tblGallery（33以上のカラム） |
| `asp/includes/guestbook.asp` | 高 | tblGuestbook, tblGuestbookItem |
| `asp/includes/poll.asp` | 高 | tblPoll（45カラム含む選択肢）, tblPollVote |
| `asp/includes/newsletter.asp` | 高 | tblNewsletter（11カラム） |
| `asp/includes/template.asp` | 高 | tblTemplate（10カラム） |
| `asp/includes/feed.asp` | 高 | tblFeed（27カラム） |
| `asp/includes/popup.asp` | 高 | tblPopup（15カラム） |
| `asp/includes/constant.asp` | 高 | tblConstant（8カラム） |

### 2.2 補助ソース（Secondary Sources）

| ファイル | 関連度 | 抽出内容 |
|---------|--------|----------|
| `asp/includes/database.asp` | 中 | データベース接続設定 |
| `asp/includes/shopMake.asp` | 中 | tblQShopMake |
| `asp/includes/shopProduct.asp` | 中 | tblQShopProduct, tblQShopProdCat |
| `asp/includes/language.asp` | 中 | tblLanguage |
| `asp/includes/ac_calendarbooking.asp` | 中 | tblCalendarBooking |

---

## 3. 解析手法

### 3.1 カラム名の抽出方法

VBScriptクラス内のRecordsetフィールド参照から抽出:

```vbscript
' Pick関数内でのフィールド参照パターン
iId = rs("iId")
sName = rs("sName")
bOnline = rs("bOnline")
```

### 3.2 データ型の推定方法

VBScript変数のハンガリアン記法から推定:

| プレフィックス | 推定型 | Access型 |
|---------------|--------|----------|
| s | String | Text/Memo |
| i | Integer | Integer/Long |
| b | Boolean | Yes/No |
| d | Date/DateTime | Date/Time |

### 3.3 外部キー関係の特定方法

SQL文のJOIN句およびWHERE句から分析:

```vbscript
' 外部キー関係の例
sql = "select * from tblPage where iCustomerID=" & cid
sql = "delete from tblPost where iThemeID=" & iId
sql = "select * from tblContactValues where iContactID=" & iId
```

---

## 4. 信頼度評価

### 4.1 高信頼度の項目（0.85以上）

| 項目 | 理由 |
|------|------|
| テーブル名 | SQL文から直接抽出、誤りの可能性低い |
| 主キー（iId） | すべてのテーブルで一貫したパターン |
| 外部キー（iCustomerID） | マルチテナント構造が明確 |
| 主要カラム名 | Recordsetフィールド参照から直接抽出 |

### 4.2 中信頼度の項目（0.70-0.85）

| 項目 | 理由 |
|------|------|
| データ型 | 命名規則からの推定、実際と異なる可能性 |
| NULL許容性 | コード上の検証ロジックから推定 |
| カラム長 | left()関数の引数から一部推定 |
| リレーションシップ | DELETE/JOIN文から推定 |

### 4.3 低信頼度の項目（0.70未満）

| 項目 | 理由 |
|------|------|
| インデックス設計 | 推奨値のみ、実際のインデックス未確認 |
| 一部テーブルの詳細 | 参照のみで定義コードが見つからなかった |
| 制約定義 | Accessの参照整合性設定は未確認 |

---

## 5. 制限事項と仮定

### 5.1 制限事項

1. **直接スキーマ確認不可**
   - Access .mdbファイルへの直接アクセスができないため、実際のスキーマとの照合ができていない

2. **一部テーブル情報の欠落**
   - tblSecondAdmin, tblCustomerIntranetMessage, tblMail 等は参照のみで詳細カラム情報が不完全

3. **データ型精度**
   - Text型の長さ、Decimal型の精度等は推定値

4. **外部キー制約**
   - Microsoft Accessでは外部キー制約は任意設定のため、実装状況は不明

### 5.2 仮定

1. **主キー**
   - すべてのテーブルでiIdがAutoNumber型の主キーと仮定

2. **マルチテナント**
   - iCustomerIDカラムを持つテーブルは顧客別に分離されると仮定

3. **タイムスタンプ**
   - dCreatedTS, dUpdatedTSは監査用タイムスタンプと仮定

4. **削除フラグ**
   - bDeletedカラムはソフトデリート実装と仮定

---

## 6. 追加調査が必要な項目

### 6.1 高優先度

| 項目 | 理由 |
|------|------|
| 実際の.mdbファイル解析 | 正確なスキーマ情報取得のため |
| tblSecondAdminの詳細 | サブ管理者機能の完全理解 |
| tblCustomerIntranetMessageの詳細 | イントラネット通知機能の完全理解 |

### 6.2 中優先度

| 項目 | 理由 |
|------|------|
| インデックス実装状況 | パフォーマンス最適化の確認 |
| 外部キー制約設定 | データ整合性の確認 |
| tblCatalog, tblFormの詳細 | カタログ/フォーム機能の完全理解 |

---

## 7. 検証状況

| 検証項目 | 状態 | 備考 |
|---------|------|------|
| ソースコード解析 | 完了 | 主要ASPファイル解析済み |
| テーブル名確認 | 完了 | 36テーブルを特定 |
| カラム定義抽出 | 完了 | 主要テーブルのカラム抽出済み |
| リレーション特定 | 完了 | 主要な外部キー関係を特定 |
| 実DBスキーマ確認 | 未実施 | .mdbファイルへのアクセス不可 |
| レビュー | 未実施 | ドラフト段階 |

---

## 8. 変更履歴

| 版 | 日付 | 変更内容 | 担当者 |
|----|------|----------|--------|
| 1.0 | 2026-01-23 | 初版作成 | AI自動生成 |
