# データベース設計書

## 1. 概要

### 1.1 文書概要
本文書は、QuickerSite CMSのデータベース設計について記述する。QuickerSiteはClassic ASP (VBScript)で構築されたコンテンツ管理システムであり、Microsoft Access データベース (.mdb) を使用している。

### 1.2 データベース環境
| 項目 | 内容 |
|------|------|
| データベースタイプ | Microsoft Access (.mdb) |
| 接続方式 | ADO (ActiveX Data Objects) |
| 認証方式 | パスワード認証（データベースファイル） |

### 1.3 設計方針
- マルチテナントアーキテクチャ（iCustomerIDによる顧客分離）
- ソフトデリート対応（bDeletedフラグ使用）
- 監査証跡（dCreatedTS, dUpdatedTS）

---

## 2. テーブル一覧

| No | テーブル名 | 論理名 | 説明 | レコード規模想定 |
|----|-----------|--------|------|------------------|
| 1 | tblCustomer | 顧客マスタ | サイト/テナント情報管理 | 小（数百件） |
| 2 | tblPage | ページ | CMSページコンテンツ管理 | 中（数千件） |
| 3 | tblTemplate | テンプレート | ページテンプレート管理 | 小（数十件） |
| 4 | tblContact | 連絡先/ユーザー | イントラネットユーザー管理 | 中（数千件） |
| 5 | tblContactField | 連絡先カスタムフィールド定義 | カスタムフィールド定義 | 小（数十件） |
| 6 | tblContactValues | 連絡先カスタムフィールド値 | カスタムフィールド値 | 中（数千件） |
| 7 | tblContactRegistration | ユーザー登録チケット | 登録確認管理 | 小（数百件） |
| 8 | tblContactPage | ユーザー権限 | ページ編集権限管理 | 小（数百件） |
| 9 | tblGallery | ギャラリー | 画像ギャラリー管理 | 小（数百件） |
| 10 | tblNewsletter | ニュースレター | ニュースレター管理 | 小（数百件） |
| 11 | tblNewsletterCategory | ニュースレターカテゴリ | 購読カテゴリ管理 | 小（数十件） |
| 12 | tblNewsletterCategorySubscriber | 購読者 | カテゴリ購読関連 | 中（数千件） |
| 13 | tblPoll | 投票 | 投票・アンケート管理 | 小（数百件） |
| 14 | tblPollVote | 投票結果 | 投票結果記録 | 中（数千件） |
| 15 | tblGuestbook | ゲストブック | ゲストブック管理 | 小（数百件） |
| 16 | tblGuestbookItem | ゲストブックエントリ | ゲストブック投稿 | 中（数千件） |
| 17 | tblTheme | フォーラム/テーマ | フォーラム管理 | 小（数百件） |
| 18 | tblThemeSubscription | フォーラム購読 | フォーラム通知購読 | 中（数千件） |
| 19 | tblThemeTopicSubscription | トピック購読 | トピック通知購読 | 中（数千件） |
| 20 | tblPost | 投稿 | フォーラム投稿管理 | 中（数千件） |
| 21 | tblFeed | RSSフィード | 外部RSS管理 | 小（数十件） |
| 22 | tblPopup | ポップアップ | ポップアップ管理 | 小（数十件） |
| 23 | tblForm | フォーム | カスタムフォーム管理 | 小（数十件） |
| 24 | tblCatalog | カタログ | 製品カタログ管理 | 小（数百件） |
| 25 | tblConstant | 定数/定義値 | サイト定数管理 | 小（数十件） |
| 26 | tblMail | メール | 送信メールログ | 中（数千件） |
| 27 | tblMonitor | アクセスログ | サイト訪問ログ | 大（数万件） |
| 28 | tblSession | セッション | ユーザーセッション | 中（数千件） |
| 29 | tblSecondAdmin | サブ管理者 | 追加管理者設定 | 小（数十件） |
| 30 | tblCustomerIntranetMessage | イントラネットメッセージ | ステータス別メッセージ設定 | 小（数十件） |
| 31 | tblLanguage | 言語 | 多言語対応 | 小（数件） |
| 32 | tblCalendarBooking | カレンダー予約 | 予約管理 | 中（数千件） |
| 33 | tblQShopMake | ショップメーカー | 製造元管理 | 小（数十件） |
| 34 | tblQShopProduct | ショップ製品 | 製品管理 | 中（数百件） |
| 35 | tblQShopCategory | ショップカテゴリ | 製品カテゴリ | 小（数十件） |
| 36 | tblQShopProdCat | 製品カテゴリ関連 | 製品-カテゴリマッピング | 中（数百件） |

---

## 3. テーブル詳細定義

### 3.1 tblCustomer (顧客マスタ)

#### 概要
サイト/テナント情報を管理するマスタテーブル。マルチテナント構成の中核となる。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 顧客ID (自動採番) |
| 2 | sName | Text(255) | NO | | 顧客名/サイト名 |
| 3 | sURL | Text(255) | NO | | サイトURL |
| 4 | bOnline | Boolean | YES | | オンライン状態 |
| 5 | dCreatedTS | DateTime | YES | | 作成日時 |
| 6 | dUpdatedTS | DateTime | YES | | 更新日時 |
| 7 | dOnlineFrom | DateTime | YES | | 公開開始日 |
| 8 | dResetStats | DateTime | YES | | 統計リセット日 |
| 9 | sTotalPW | Text(255) | YES | | 全体パスワード |
| 10 | bApplication | Boolean | YES | | アプリケーションモード |
| 11 | bIntranet | Boolean | YES | | イントラネット機能有効 |
| 12 | bCatalog | Boolean | YES | | カタログ機能有効 |
| 13 | bMonitor | Boolean | YES | | アクセス監視有効 |
| 14 | bTopHeader | Boolean | YES | | トップヘッダー表示 |
| 15 | sTopheader | Memo | YES | | トップヘッダーHTML |
| 16 | sDescription | Memo | YES | | サイト説明 |
| 17 | siteName | Text(255) | YES | | 表示サイト名 |
| 18 | siteTitle | Text(255) | YES | | サイトタイトル |
| 19 | copyRight | Text(255) | YES | | 著作権表示 |
| 20 | webmasterEmail | Text(255) | YES | | 管理者メール |
| 21 | adminPassword | Text(255) | YES | | 管理者パスワード (SHA256) |
| 22 | webmaster | Text(255) | YES | | 管理者名 |
| 23 | keywords | Memo | YES | | SEOキーワード |
| 24 | language | Integer | YES | | 言語ID |
| 25 | hasFavicon | Boolean | YES | | ファビコン有無 |
| 26 | googleAnalytics | Text(255) | YES | | GoogleAnalyticsコード |
| 27 | intranetUse | Boolean | YES | | イントラネット利用 |
| 28 | intranetName | Text(255) | YES | | イントラネット名 |
| 29 | intranetPWEmail | Memo | YES | | パスワードリセットメール本文 |
| 30 | intranetUseMyProfile | Boolean | YES | | マイプロファイル機能 |
| 31 | intranetMyProfile | Text(255) | YES | | マイプロファイルラベル |
| 32 | intranetLogOff | Text(255) | YES | | ログオフラベル |
| 33 | bannerApplication | Memo | YES | | アプリケーションバナー |
| 34 | defaultTemplate | Integer | YES | | デフォルトテンプレートID |
| 35 | sFooter | Memo | YES | | フッターHTML |
| 36 | bScanReferer | Boolean | YES | | リファラースキャン有効 |
| 37 | sAlternateDomains | Memo | YES | | 代替ドメイン |
| 38 | sDefaultRSSLink | Text(255) | YES | | デフォルトRSSリンク |
| 39 | bUserFriendlyURL | Boolean | YES | | フレンドリーURL有効 |
| 40 | bAllowStorageOutsideWWW | Boolean | YES | | WWW外ストレージ許可 |
| 41 | sLeftBanner | Memo | YES | | 左バナーHTML |
| 42 | sRightBanner | Memo | YES | | 右バナーHTML |
| 43 | sDatumFormat | Text(50) | YES | | 日付フォーマット |
| 44 | sHeader | Memo | YES | | ヘッダーHTML |
| 45 | bAllowNewRegistrations | Boolean | YES | | 新規登録許可 |
| 46 | bSendMailUponNewMember | Boolean | YES | | 新規登録通知メール |
| 47 | sExplTicket | Memo | YES | | チケット説明文 |
| 48 | sMailTicket | Memo | YES | | チケットメール本文 |
| 49 | sLabelRegister | Text(255) | YES | | 登録ラベル |
| 50 | sExplProfile | Memo | YES | | プロファイル説明文 |
| 51 | sMailWelcome | Memo | YES | | ウェルカムメール本文 |
| 52 | sSubjectMailTicket | Text(255) | YES | | チケットメール件名 |
| 53 | iDefaultStatus | Integer | YES | | デフォルトステータス |
| 54 | sWelcomeMessage | Memo | YES | | ウェルカムメッセージ |
| 55 | sEmailNewRegistrations | Text(255) | YES | | 登録通知先メール |
| 56 | bEnableMainRSS | Boolean | YES | | メインRSS有効 |
| 57 | sLabelEditSite | Text(50) | YES | | サイト編集ラベル |
| 58 | sSiteSlogan | Text(255) | YES | | サイトスローガン |
| 59 | iPackageID | Integer | YES | | パッケージID |
| 60 | sContactInfo | Text(255) | YES | | 連絡先情報ラベル |
| 61 | sHighlights | Text(255) | YES | | ハイライトラベル |
| 62 | sNotifValidate | Text(255) | YES | | 検証通知メール |
| 63 | bEnableNewsletters | Boolean | YES | | ニュースレター機能有効 |
| 64 | sPopupViewmode | Text(10) | YES | | ポップアップ表示モード |
| 65 | iFolderSize | Integer | YES | | フォルダサイズ上限 |
| 66 | bUseAvatars | Boolean | YES | | アバター機能有効 |
| 67 | iAvatarSize | Integer | YES | | アバターサイズ |
| 68 | iLoginMode | Integer | YES | | ログインモード |
| 69 | sAvatarBorderColor | Text(50) | YES | | アバターボーダー色 |
| 70 | sProp01-sProp08 | Text(255) | YES | | 拡張プロパティ1-8 |
| 71 | bPeelEnabled | Boolean | YES | | ページピール有効 |
| 72 | sPeelURL | Text(255) | YES | | ピールリンクURL |
| 73 | sPeelImage | Text(255) | YES | | ピール画像 |
| 74 | bPeelOINW | Boolean | YES | | ピール新規ウィンドウ |
| 75 | sPeelFlipColor | Integer | YES | | ピール色設定 |
| 76 | sPeelIdleSize | Integer | YES | | ピールアイドルサイズ |
| 77 | sPeelMOSize | Integer | YES | | ピールマウスオーバーサイズ |
| 78 | sNLTemplate | Memo | YES | | ニュースレターテンプレート |
| 79 | sMOBBrowsers | Text(255) | YES | | モバイルブラウザ設定 |
| 80 | sMOBUrl | Text(255) | YES | | モバイルURL |
| 81 | iDefaultMobileTemplate | Integer | YES | | モバイルテンプレートID |
| 82 | bUseCachingForPages | Boolean | YES | | ページキャッシュ有効 |
| 83 | bCookieWarning | Boolean | YES | | Cookie警告有効 |
| 84 | sCWLocation | Text(50) | YES | | Cookie警告位置 |
| 85 | sCWNumber | Integer | YES | | Cookie警告番号 |
| 86 | sCWText | Memo | YES | | Cookie警告テキスト |
| 87 | sCWAccept | Text(255) | YES | | Cookie承諾テキスト |
| 88 | sCWError | Text(255) | YES | | Cookieエラーテキスト |
| 89 | sCWContinue | Text(255) | YES | | Cookie続行テキスト |
| 90 | sCWBackgroundColor | Text(50) | YES | | Cookie警告背景色 |
| 91 | sCWButtonClass | Text(50) | YES | | Cookie警告ボタンクラス |
| 92 | sCWTextColor | Text(50) | YES | | Cookie警告テキスト色 |
| 93 | sCWLinkColor | Text(50) | YES | | Cookie警告リンク色 |
| 94 | bCWUseAsNormalPP | Boolean | YES | | 通常PP表示 |
| 95 | sQSAccordionMain | Memo | YES | | アコーディオンメインスタイル |
| 96 | sQSAccordionHeader | Memo | YES | | アコーディオンヘッダースタイル |
| 97 | sQSAccordionContent | Memo | YES | | アコーディオンコンテンツスタイル |
| 98 | C_SMTPSERVER | Text(255) | YES | | SMTPサーバー |
| 99 | C_SMTPPORT | Integer | YES | | SMTPポート |
| 100 | C_SMTPUSERNAME | Text(255) | YES | | SMTPユーザー名 |
| 101 | C_SMTPUSERPW | Text(255) | YES | | SMTPパスワード |
| 102 | C_SENDUSING | Integer | YES | | 送信方式 |
| 103 | C_SMTPUSESSL | Boolean | YES | | SMTP SSL使用 |
| 104 | bCustom404 | Boolean | YES | | カスタム404有効 |
| 105 | sCustom404Title | Text(255) | YES | | 404タイトル |
| 106 | sCustom404Body | Memo | YES | | 404本文 |
| 107 | i404TemplateID | Integer | YES | | 404テンプレートID |
| 108 | sArrowUP | Text(255) | YES | | スクロールアップ矢印 |
| 109 | bListItemPic | Boolean | YES | | リストアイテム画像 |
| 110 | bShoppingCart | Boolean | YES | | ショッピングカート有効 |
| 111 | sBannerMenu | Memo | YES | | メニューバナー |

---

### 3.2 tblPage (ページ)

#### 概要
CMSのページコンテンツを管理するテーブル。階層構造（親子関係）をサポート。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | ページID |
| 2 | iParentID | Integer | YES | | 親ページID |
| 3 | iListPageID | Integer | YES | | リストページID |
| 4 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 5 | sTitle | Text(255) | NO | | ページタイトル |
| 6 | sValue | Memo | YES | | ページ本文HTML |
| 7 | sValueTextOnly | Memo | YES | | プレーンテキスト版 |
| 8 | sExternalURLPrefix | Text(50) | YES | | 外部URLプレフィックス |
| 9 | sExternalURL | Text(255) | YES | | 外部URL |
| 10 | bOpenInNewWindow | Boolean | YES | | 新規ウィンドウで開く |
| 11 | iRang | Integer | YES | | 表示順序 |
| 12 | bOnline | Boolean | YES | | オンライン状態 |
| 13 | bDeleted | Boolean | YES | | 削除フラグ |
| 14 | bHomepage | Boolean | YES | | ホームページフラグ |
| 15 | bContainerPage | Boolean | YES | | コンテナページ |
| 16 | bLossePagina | Boolean | YES | | 独立ページ |
| 17 | sPw | Text(255) | YES | | ページパスワード |
| 18 | updatedTS | DateTime | YES | | 更新日時 |
| 19 | createdTS | DateTime | YES | | 作成日時 |
| 20 | dOnlineUntill | DateTime | YES | | 公開終了日 |
| 21 | dOnlineFrom | DateTime | YES | | 公開開始日 |
| 22 | sOrderBY | Text(50) | YES | | 並び順設定 |
| 23 | dPage | DateTime | YES | | ページ日付 |
| 24 | iHits | Integer | YES | | ヒット数 |
| 25 | iVisitors | Integer | YES | | 訪問者数 |
| 26 | sApplication | Text(255) | YES | | アプリケーション設定 |
| 27 | sCode | Text(50) | YES | | ページコード (一意) |
| 28 | bOpenOnload | Boolean | YES | | 読込時展開 |
| 29 | bIntranet | Boolean | YES | | イントラネットページ |
| 30 | iCatalogId | Integer | YES | | カタログID (FK) |
| 31 | iFormID | Integer | YES | | フォームID (FK) |
| 32 | sFormAlign | Text(50) | YES | | フォーム配置 |
| 33 | bMenuGroup | Boolean | YES | | メニューグループ |
| 34 | iFeedId | Integer | YES | | フィードID (FK) |
| 35 | sKeywords | Memo | YES | | ページキーワード |
| 36 | sDescription | Memo | YES | | ページ説明 |
| 37 | iTemplateID | Integer | YES | | テンプレートID (FK) |
| 38 | bPushRSS | Boolean | YES | | RSSプッシュ |
| 39 | iHitsRSS | Integer | YES | | RSSヒット数 |
| 40 | sRSSLink | Text(255) | YES | | RSSリンク |
| 41 | sUserFriendlyURL | Text(200) | YES | | フレンドリーURL |
| 42 | sRedirectTo | Text(255) | YES | | リダイレクト先 |
| 43 | iReload | Integer | YES | | リロード間隔 |
| 44 | iThemeID | Integer | YES | | テーマID (FK) |
| 45 | sRel | Text(50) | YES | | リンクrel属性 |
| 46 | sSEOtitle | Text(255) | YES | | SEOタイトル |
| 47 | sLPExternalURL | Text(255) | YES | | リストページ外部URL |
| 48 | bLPExternalOINW | Boolean | YES | | リストページ新規ウィンドウ |
| 49 | sHeader | Memo | YES | | ページヘッダー |
| 50 | iLPOpenByDefault | Integer | YES | | リストページデフォルト展開 |
| 51 | sPageTitle | Text(255) | YES | | 表示ページタイトル |
| 52 | sValueToBeValidated | Memo | YES | | 検証待ち本文 |
| 53 | sTitleToBeValidated | Text(255) | YES | | 検証待ちタイトル |
| 54 | iUpdatedBy | Integer | YES | | 更新者ID |
| 55 | dUpdatedOn | DateTime | YES | | 更新日 |
| 56 | bHideDate | Boolean | YES | | 日付非表示 |
| 57 | sClassname | Text(255) | YES | | CSSクラス名 |
| 58 | sProp01-sProp08 | Text(255) | YES | | 拡張プロパティ1-8 |
| 59 | sPageCache | Memo | YES | | ページキャッシュ |
| 60 | bNocache | Boolean | YES | | キャッシュ無効 |
| 61 | bAccordeon | Boolean | YES | | アコーディオン表示 |
| 62 | bHideFromSearch | Boolean | YES | | 検索除外 |
| 63 | sItemPicture | Text(255) | YES | | アイテム画像 |
| 64 | sLPIC | Text(255) | YES | | リストページ画像 |
| 65 | iPMlocation | Integer | YES | | PM位置 |

---

### 3.3 tblContact (連絡先/ユーザー)

#### 概要
イントラネットユーザーを管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | ユーザーID |
| 2 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 3 | sEmail | Text(255) | NO | | メールアドレス |
| 4 | sOrigEmail | Text(255) | YES | | 元メールアドレス |
| 5 | sNickName | Text(50) | NO | | ニックネーム |
| 6 | sPw | Text(255) | NO | | パスワード |
| 7 | dUpdatedTS | DateTime | YES | | 更新日時 |
| 8 | dCreatedTS | DateTime | YES | | 作成日時 |
| 9 | dLastLoginTS | DateTime | YES | | 最終ログイン日時 |
| 10 | dLogoutTS | DateTime | YES | | ログアウト日時 |
| 11 | iStatus | Integer | YES | | ステータス |
| 12 | bGetEmailsFromSite | Boolean | YES | | サイトメール受信 |
| 13 | sAvatar | Text(255) | YES | | アバターファイル名 |

---

### 3.4 tblPost (投稿)

#### 概要
フォーラム投稿を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 投稿ID |
| 2 | dCreatedTS | DateTime | YES | | 作成日時 |
| 3 | dUpdatedTS | DateTime | YES | | 更新日時 |
| 4 | iContactID | Integer | YES | | ユーザーID (FK) |
| 5 | iThemeID | Integer | NO | | フォーラムID (FK) |
| 6 | iPostID | Integer | YES | | 親投稿ID (返信の場合) |
| 7 | sSubject | Text(255) | NO | | 件名 |
| 8 | sBody | Memo | YES | | 本文 |
| 9 | sKey | Text(128) | YES | | 投稿キー |
| 10 | bNeedsToBeValidated | Boolean | YES | | 検証必要フラグ |
| 11 | sAnName | Text(50) | YES | | 匿名投稿者名 |
| 12 | sFilename | Text(255) | YES | | 添付ファイル名 |
| 13 | sFileDesc | Text(255) | YES | | ファイル説明 |
| 14 | iFileSize | Integer | YES | | ファイルサイズ |

---

### 3.5 tblTheme (フォーラム/テーマ)

#### 概要
フォーラム/掲示板を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | フォーラムID |
| 2 | sName | Text(255) | NO | | フォーラム名 |
| 3 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 4 | iPageSize | Integer | YES | | ページサイズ |
| 5 | bOnline | Boolean | YES | | オンライン状態 |
| 6 | bLocked | Boolean | YES | | ロック状態 |
| 7 | bAllowComments | Boolean | YES | | コメント許可 |
| 8 | bAllowHTML | Boolean | YES | | HTML許可 |
| 9 | bPushRSS | Boolean | YES | | RSSプッシュ |
| 10 | iType | Integer | YES | | タイプ |
| 11 | iContactID | Integer | YES | | モデレーターID (FK) |
| 12 | iLimitReplyTo | Integer | YES | | 返信文字数制限 |
| 13 | iLimitTopicTo | Integer | YES | | トピック文字数制限 |
| 14 | sBodyNotification | Memo | YES | | 通知本文テンプレート |
| 15 | sSubjectNotification | Text(255) | YES | | 通知件名テンプレート |
| 16 | bForwardPostsToModerator | Boolean | YES | | モデレーター転送 |
| 17 | iSubLevel | Integer | YES | | 購読レベル |
| 18 | sTopicBodyNotification | Memo | YES | | トピック通知本文 |
| 19 | sTopicSubjectNotification | Text(255) | YES | | トピック通知件名 |
| 20 | sColorUneven | Text(50) | YES | | 奇数行色 |
| 21 | sColorEven | Text(50) | YES | | 偶数行色 |
| 22 | iWidth | Integer | YES | | 幅 |
| 23 | sCode | Text(50) | YES | | コード |
| 24 | bSmileys | Boolean | YES | | スマイリー有効 |
| 25 | bUpload | Boolean | YES | | アップロード許可 |
| 26 | bCompactList | Boolean | YES | | コンパクト表示 |
| 27 | bValidation | Boolean | YES | | 検証必要 |
| 28 | iSearchType | Integer | YES | | 検索タイプ |
| 29 | bEmbed | Boolean | YES | | 埋め込み許可 |
| 30 | bAllowAP | Boolean | YES | | 匿名投稿許可 |
| 31 | sLabelYourName | Text(50) | YES | | 名前ラベル |
| 32 | bFileUploads | Boolean | YES | | ファイルアップロード許可 |

---

### 3.6 tblGallery (ギャラリー)

#### 概要
画像ギャラリーを管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | ギャラリーID |
| 2 | sName | Text(255) | NO | | ギャラリー名 |
| 3 | sCode | Text(50) | YES | | コード |
| 4 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 5 | dCreatedTS | DateTime | YES | | 作成日時 |
| 6 | sPath | Text(255) | YES | | 画像パス |
| 7 | iType | Integer | YES | | ギャラリータイプ |
| 8 | iThumbSize | Integer | YES | | サムネイルサイズ |
| 9 | iFullImageSize | Integer | YES | | フル画像サイズ |
| 10 | iPicsInRow | Integer | YES | | 行あたり画像数 |
| 11 | sStyleTable | Text(255) | YES | | テーブルスタイル |
| 12 | bShowFileName | Boolean | YES | | ファイル名表示 |
| 13 | sStyleImage | Text(255) | YES | | 画像スタイル |
| 14 | sStyleTableCell | Text(255) | YES | | セルスタイル |
| 15 | iBrowseBy | Integer | YES | | ブラウズ方式 |
| 16 | iSlideShowTimerQS | Integer | YES | | スライドショー間隔 |
| 17 | bFSR | Boolean | YES | | フルスクリーンリサイズ |
| 18 | bAutoStartSS | Boolean | YES | | スライドショー自動開始 |
| 19 | bRandom | Boolean | YES | | ランダム表示 |
| 20 | sCustomLink | Text(255) | YES | | カスタムリンク |
| 21 | sType | Text(50) | YES | | タイプ文字列 |
| 22 | sBorder | Text(50) | YES | | ボーダー設定 |
| 23 | sBorderColor | Text(50) | YES | | ボーダー色 |
| 24 | sWidth | Text(50) | YES | | 幅 |
| 25 | sHeight | Text(50) | YES | | 高さ |
| 26 | bOpenInNewWindow | Boolean | YES | | 新規ウィンドウ |
| 27 | iSpecialEffect | Integer | YES | | 特殊効果 |
| 28 | sCycleEffect | Text(50) | YES | | サイクル効果 |
| 29 | iSortImagesBy | Integer | YES | | 画像ソート順 |
| 30 | sNSCss | Text(255) | YES | | NivoSlider CSS |
| 31 | bNSControlNav | Boolean | YES | | NivoSlider ナビ |
| 32 | bNSdirectionNav | Boolean | YES | | NivoSlider 方向ナビ |
| 33 | sNSImgLinks | Text(255) | YES | | NivoSlider リンク |

---

### 3.7 tblGuestbook (ゲストブック)

#### 概要
ゲストブック設定を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | ゲストブックID |
| 2 | sCode | Text(50) | NO | | コード |
| 3 | sName | Text(255) | NO | | ゲストブック名 |
| 4 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 5 | dOnlineFrom | DateTime | YES | | 公開開始日 |
| 6 | dOnlineUntil | DateTime | YES | | 公開終了日 |
| 7 | sTemplate | Memo | YES | | エントリテンプレート |
| 8 | sTemplateForm | Memo | YES | | フォームテンプレート |
| 9 | sTemplateReply | Memo | YES | | 返信テンプレート |
| 10 | bRequireValidation | Boolean | YES | | 検証必要 |
| 11 | sEmail | Text(255) | YES | | 通知メール |
| 12 | sFullTemplate | Memo | YES | | 全体テンプレート |
| 13 | sWarningApproval | Memo | YES | | 承認警告 |
| 14 | sBlockIP | Memo | YES | | ブロックIP |
| 15 | sSortBy | Text(50) | YES | | ソート順 |
| 16 | sTemplateErr | Memo | YES | | エラーテンプレート |
| 17 | iPaging | Integer | YES | | ページング数 |

---

### 3.8 tblGuestbookItem (ゲストブックエントリ)

#### 概要
ゲストブック投稿を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | エントリID |
| 2 | iGuestbookID | Integer | NO | | ゲストブックID (FK) |
| 3 | sValue | Memo | YES | | メッセージ本文 |
| 4 | sMessageBy | Text(50) | YES | | 投稿者名 |
| 5 | sMessageByEmail | Text(255) | YES | | 投稿者メール |
| 6 | dCreatedTS | DateTime | YES | | 作成日時 |
| 7 | bApproved | Boolean | YES | | 承認状態 |
| 8 | ip | Text(40) | YES | | IPアドレス |
| 9 | sReply | Memo | YES | | 管理者返信 |

---

### 3.9 tblPoll (投票)

#### 概要
投票・アンケートを管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 投票ID |
| 2 | sQuestion | Text(255) | NO | | 質問 |
| 3 | sCode | Text(50) | NO | | コード |
| 4 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 5 | dCreatedTS | DateTime | YES | | 作成日時 |
| 6 | bShowTitle | Boolean | YES | | タイトル表示 |
| 7 | label_viewresults | Text(255) | YES | | 結果表示ラベル |
| 8 | label_votenow | Text(255) | YES | | 投票ラベル |
| 9 | label_numberofvotes | Text(255) | YES | | 投票数ラベル |
| 10 | dVoteFrom | DateTime | YES | | 投票開始日 |
| 11 | dVoteUntil | DateTime | YES | | 投票終了日 |
| 12 | dVoteDeadline | DateTime | YES | | 投票期限 |
| 13 | dResetDate | DateTime | YES | | リセット日 |
| 14 | sA1-sA15 | Text(255) | YES | | 選択肢1-15 |
| 15 | sA1c-sA15c | Text(50) | YES | | 選択肢色1-15 |

---

### 3.10 tblPollVote (投票結果)

#### 概要
投票結果を記録するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 投票結果ID |
| 2 | iPollID | Integer | NO | | 投票ID (FK) |
| 3 | dVoteTS | DateTime | YES | | 投票日時 |
| 4 | iVote | Integer | YES | | 選択番号 |
| 5 | IP | Text(40) | YES | | IPアドレス |

---

### 3.11 tblNewsletter (ニュースレター)

#### 概要
ニュースレターを管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | ニュースレターID |
| 2 | sName | Text(150) | NO | | ニュースレター名 |
| 3 | sValue | Memo | YES | | 本文HTML |
| 4 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 5 | bOnline | Boolean | YES | | オンライン状態 |
| 6 | sSubject | Text(150) | YES | | 件名 |
| 7 | sFromEmail | Text(50) | YES | | 送信元メール |
| 8 | sFromName | Text(50) | YES | | 送信元名 |
| 9 | sUnsubscribeText | Text(50) | YES | | 購読解除テキスト |
| 10 | sBodyBGColor | Text(50) | YES | | 背景色 |
| 11 | sStyleLink | Text(255) | YES | | リンクスタイル |

---

### 3.12 tblTemplate (テンプレート)

#### 概要
ページテンプレートを管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | テンプレートID |
| 2 | sName | Text(50) | NO | | テンプレート名 |
| 3 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 4 | sValue | Memo | NO | | テンプレートHTML |
| 5 | sPrintValue | Memo | YES | | 印刷用テンプレート |
| 6 | sEmailValue | Memo | YES | | メール用テンプレート |
| 7 | sMobileValue | Memo | YES | | モバイル用テンプレート |
| 8 | sWAPValue | Memo | YES | | WAP用テンプレート |
| 9 | sCompressValue | Memo | YES | | 圧縮テンプレート |
| 10 | bCompress | Boolean | YES | | 圧縮有効 |

---

### 3.13 tblFeed (RSSフィード)

#### 概要
外部RSSフィード設定を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | フィードID |
| 2 | sName | Text(255) | NO | | フィード名 |
| 3 | sCode | Text(50) | YES | | コード |
| 4 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 5 | dCreatedTS | DateTime | YES | | 作成日時 |
| 6 | dUpdatedTS | DateTime | YES | | 更新日時 |
| 7 | sPrefixUrl | Text(255) | YES | | URLプレフィックス |
| 8 | sUrl | Memo | YES | | フィードURL |
| 9 | sUrls | Memo | YES | | 複数URL |
| 10 | iMaxItems | Integer | YES | | 最大アイテム数 |
| 11 | sKeywords | Text(255) | YES | | キーワード |
| 12 | bOpenLinkInNW | Boolean | YES | | 新規ウィンドウ |
| 13 | iReloadSec | Integer | YES | | リロード秒数 |
| 14 | iLimitTo | Integer | YES | | 制限文字数 |
| 15 | iTitleLimitTo | Integer | YES | | タイトル制限文字数 |
| 16 | iCache | Integer | YES | | キャッシュ時間 |
| 17 | bShowTitle | Boolean | YES | | タイトル表示 |
| 18 | bLinkOnTitle | Boolean | YES | | タイトルリンク |
| 19 | bShowAuthor | Boolean | YES | | 著者表示 |
| 20 | bShowCategory | Boolean | YES | | カテゴリ表示 |
| 21 | bShowDate | Boolean | YES | | 日付表示 |
| 22 | sTemplate | Memo | YES | | テンプレート |
| 23 | bTemplate | Boolean | YES | | テンプレート使用 |
| 24 | sHTMLBefore | Memo | YES | | 前置HTML |
| 25 | sHTMLAfter | Memo | YES | | 後置HTML |
| 26 | bRandom | Boolean | YES | | ランダム表示 |
| 27 | bEnableJS | Boolean | YES | | JavaScript有効 |

---

### 3.14 tblPopup (ポップアップ)

#### 概要
ポップアップを管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | ポップアップID |
| 2 | sName | Text(255) | NO | | ポップアップ名 |
| 3 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 4 | sUrl | Text(255) | YES | | リンクURL |
| 5 | dOnlineFrom | DateTime | YES | | 公開開始日 |
| 6 | dOnlineUntil | DateTime | YES | | 公開終了日 |
| 7 | iHeight | Integer | YES | | 高さ |
| 8 | iWidth | Integer | YES | | 幅 |
| 9 | bEnabled | Boolean | YES | | 有効フラグ |
| 10 | iTemplateID | Integer | YES | | テンプレートID |
| 11 | sValue | Memo | YES | | 本文HTML |
| 12 | iMode | Integer | YES | | 表示モード |
| 13 | iShows | Integer | YES | | 表示回数 |
| 14 | sViewmode | Text(50) | YES | | 表示方式 |
| 15 | iAutoclose | Integer | YES | | 自動閉じ秒数 |

---

### 3.15 tblConstant (定数)

#### 概要
サイト定数・変数を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 定数ID |
| 2 | sConstant | Text(255) | NO | | 定数名 |
| 3 | sValue | Memo | YES | | 値 |
| 4 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 5 | bOnline | Boolean | YES | | 有効フラグ |
| 6 | iType | Integer | YES | | タイプ |
| 7 | sParameters | Text(255) | YES | | パラメータ |
| 8 | sGlobal | Text(255) | YES | | グローバル設定 |

---

### 3.16 tblContactField (連絡先カスタムフィールド定義)

#### 概要
連絡先のカスタムフィールド定義を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | フィールドID |
| 2 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 3 | sName | Text(255) | NO | | フィールド名 |
| 4 | sType | Text(50) | YES | | データ型 |
| 5 | bMandatory | Boolean | YES | | 必須フラグ |
| 6 | bProfile | Boolean | YES | | プロファイル表示 |
| 7 | bSearchField | Boolean | YES | | 検索フィールド |
| 8 | iRang | Integer | YES | | 表示順 |

---

### 3.17 tblContactValues (連絡先カスタムフィールド値)

#### 概要
連絡先のカスタムフィールド値を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 値ID |
| 2 | iContactID | Integer | NO | | 連絡先ID (FK) |
| 3 | iFieldID | Integer | NO | | フィールドID (FK) |
| 4 | sValue | Memo | YES | | 値 |

---

### 3.18 tblContactPage (ユーザー権限)

#### 概要
ユーザーのページ編集権限を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 権限ID |
| 2 | iContactID | Integer | NO | | 連絡先ID (FK) |
| 3 | iTitleID | Integer | YES | | タイトル編集ページID |
| 4 | iBodyID | Integer | YES | | 本文編集ページID |
| 5 | iLPID | Integer | YES | | リストページID |

---

### 3.19 tblThemeSubscription (フォーラム購読)

#### 概要
フォーラム通知購読を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 購読ID |
| 2 | iContactID | Integer | NO | | 連絡先ID (FK) |
| 3 | iThemeID | Integer | NO | | フォーラムID (FK) |

---

### 3.20 tblThemeTopicSubscription (トピック購読)

#### 概要
トピック通知購読を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 購読ID |
| 2 | iContactID | Integer | NO | | 連絡先ID (FK) |
| 3 | iPostID | Integer | NO | | 投稿ID (FK) |

---

### 3.21 tblMonitor (アクセスログ)

#### 概要
サイト訪問ログを記録するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | ログID |
| 2 | iCustomerID | Integer | NO | | 顧客ID (FK) |
| 3 | dTS | DateTime | YES | | 日時 |
| 4 | sDetail | Memo | YES | | 詳細情報 |

---

### 3.22 tblLanguage (言語)

#### 概要
多言語対応の言語マスタテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 言語ID |
| 2 | sName | Text(50) | YES | | 言語名 |
| 3 | sValue | Memo | YES | | 言語データ |

---

### 3.23 tblCalendarBooking (カレンダー予約)

#### 概要
カレンダー予約を管理するテーブル。

#### カラム定義

| No | カラム名 | データ型 | NULL | PK | 説明 |
|----|----------|----------|------|----|----- |
| 1 | iId | AutoNumber | NO | YES | 予約ID |
| 2 | 各種予約情報 | - | - | | (実装により異なる) |

---

## 4. リレーションシップ

### 4.1 主要リレーション一覧

| 親テーブル | 子テーブル | 外部キー | 関係 | 説明 |
|-----------|-----------|---------|------|------|
| tblCustomer | tblPage | iCustomerID | 1:N | 顧客-ページ |
| tblCustomer | tblContact | iCustomerID | 1:N | 顧客-ユーザー |
| tblCustomer | tblGallery | iCustomerID | 1:N | 顧客-ギャラリー |
| tblCustomer | tblNewsletter | iCustomerID | 1:N | 顧客-ニュースレター |
| tblCustomer | tblPoll | iCustomerID | 1:N | 顧客-投票 |
| tblCustomer | tblGuestbook | iCustomerID | 1:N | 顧客-ゲストブック |
| tblCustomer | tblTheme | iCustomerID | 1:N | 顧客-フォーラム |
| tblCustomer | tblFeed | iCustomerID | 1:N | 顧客-フィード |
| tblCustomer | tblPopup | iCustomerID | 1:N | 顧客-ポップアップ |
| tblCustomer | tblTemplate | iCustomerID | 1:N | 顧客-テンプレート |
| tblCustomer | tblConstant | iCustomerID | 1:N | 顧客-定数 |
| tblCustomer | tblMonitor | iCustomerID | 1:N | 顧客-ログ |
| tblPage | tblPage | iParentID | 1:N | ページ階層構造 |
| tblTheme | tblPost | iThemeID | 1:N | フォーラム-投稿 |
| tblPost | tblPost | iPostID | 1:N | 投稿-返信 |
| tblContact | tblPost | iContactID | 1:N | ユーザー-投稿 |
| tblContact | tblContactValues | iContactID | 1:N | ユーザー-カスタム値 |
| tblContactField | tblContactValues | iFieldID | 1:N | フィールド定義-値 |
| tblContact | tblThemeSubscription | iContactID | 1:N | ユーザー-購読 |
| tblTheme | tblThemeSubscription | iThemeID | 1:N | フォーラム-購読 |
| tblContact | tblThemeTopicSubscription | iContactID | 1:N | ユーザー-トピック購読 |
| tblPost | tblThemeTopicSubscription | iPostID | 1:N | 投稿-トピック購読 |
| tblPoll | tblPollVote | iPollID | 1:N | 投票-結果 |
| tblGuestbook | tblGuestbookItem | iGuestbookID | 1:N | ゲストブック-エントリ |
| tblTemplate | tblPage | iTemplateID | 1:N | テンプレート-ページ |
| tblTemplate | tblCustomer | defaultTemplate | 1:N | デフォルトテンプレート |

---

## 5. インデックス設計

### 5.1 推奨インデックス

| テーブル | インデックス名 | カラム | タイプ | 説明 |
|---------|---------------|--------|--------|------|
| tblPage | idx_page_customer | iCustomerID | 非ユニーク | 顧客別検索 |
| tblPage | idx_page_code | sCode | ユニーク | コード検索 |
| tblPage | idx_page_ufl | sUserFriendlyURL | 非ユニーク | URL検索 |
| tblPage | idx_page_parent | iParentID | 非ユニーク | 親ページ検索 |
| tblContact | idx_contact_customer | iCustomerID | 非ユニーク | 顧客別検索 |
| tblContact | idx_contact_email | sEmail | 非ユニーク | メール検索 |
| tblPost | idx_post_theme | iThemeID | 非ユニーク | フォーラム別検索 |
| tblPost | idx_post_parent | iPostID | 非ユニーク | 親投稿検索 |
| tblPollVote | idx_vote_poll | iPollID | 非ユニーク | 投票別検索 |
| tblGuestbookItem | idx_gb_item | iGuestbookID | 非ユニーク | ゲストブック別検索 |

---

## 6. セキュリティ考慮事項

### 6.1 データ保護

| 対象 | 実装方式 | 説明 |
|------|----------|------|
| 管理者パスワード | SHA256ハッシュ | adminPasswordカラム |
| ユーザーパスワード | 平文保存 | sPwカラム（要改善） |
| セッション | Cookie + セッション変数 | ASP Session |
| CAPTCHA | セッション保存 | 画像認証 |

### 6.2 アクセス制御

- マルチテナント分離: iCustomerIDによるデータ分離
- ページパスワード: sPwによる保護
- ステータス制御: iStatusによる権限レベル
- CSRF対策: QS_secCodeによるトークン検証

---

## 7. 運用考慮事項

### 7.1 バックアップ

- データベースファイル (.mdb) の定期バックアップ推奨
- 添付ファイル (userfiles/) ディレクトリのバックアップ

### 7.2 メンテナンス

- tblMonitorの定期的なアーカイブまたは削除
- bDeleted=true のレコードの定期削除
- Access データベースの定期コンパクト

---

## 8. 変更履歴

| 版 | 日付 | 変更内容 | 担当者 |
|----|------|----------|--------|
| 1.0 | 2026-01-23 | 初版作成 | AI自動生成 |
