---
generated_at: 2026-01-23 21:47:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全バッチ処理がソースコードで確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_newsletterMailingSend.asp` - ニュースレター一括配信のメイン処理
- E-02: `asp/bs_massMailing2.asp` - 連絡先一括メール送信処理
- E-03: `asp/bs_newsletterImport.asp` - 購読者インポート処理
- E-04: `asp/ad_resetAllAPP.asp` - アプリケーション一括リセット処理
- E-05: `asp/bs_formExcel.asp` - フォームデータExcelエクスポート処理
- E-06: `asp/bs_gbExcel.asp` - ゲストブックExcelエクスポート処理
- E-07: `asp/ad_copysite.asp` - サイトコピー処理
- E-08: `rss.asp` - RSSフィード生成処理
- E-09: `sitemap.asp` - XMLサイトマップ生成処理
- E-10: `asp/ad_upgrade2.asp` - データベースアップグレード処理（スキーマ出力）
- E-11: `asp/ad_upgrade3.asp` - データベースアップグレード処理
- E-12: `asp/ad_upgrade4.asp` - データベースアップグレード処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ニュースレター一括配信バッチが存在する | E-01 | ○ |
| C-02 | 連絡先一括メール送信バッチが存在する | E-02 | ○ |
| C-03 | 購読者一括インポートバッチが存在する | E-03 | ○ |
| C-04 | アプリケーション一括リセットバッチが存在する | E-04 | ○ |
| C-05 | フォーム送信データExcel出力バッチが存在する | E-05 | ○ |
| C-06 | ゲストブックデータExcel出力バッチが存在する | E-06 | ○ |
| C-07 | サイトコピー処理バッチが存在する | E-07 | ○ |
| C-08 | RSSフィード生成バッチが存在する | E-08 | ○ |
| C-09 | XMLサイトマップ生成バッチが存在する | E-09 | ○ |
| C-10 | データベースアップグレードバッチが存在する | E-10, E-11, E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本プロジェクトはClassic ASPで構築されたCMSであり、OS/サーバーレベルのスケジュールタスク（cron、Windows Task Scheduler）の設定ファイルは確認できなかった
- 外部スケジューラーからの呼び出しが想定されるバッチ処理の有無は不明
  - 候補：Windowsタスクスケジューラ設定 / IIS設定ファイル / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのバッチ処理がソースコードで確認済み
- 1: 中リスク - ニュースレター配信のMETA HTTP-EQUIV refreshによる疑似バッチ処理は、ブラウザを閉じると中断される可能性がある
- 1: 中リスク - server.ScriptTimeoutの設定（10000秒）は、サーバーの負荷に影響を与える可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] バッチ一覧に記載された10件のバッチ処理が実際のソースコードファイルに対応しているか確認
- [ ] OSレベルのスケジューラー（Windows Task Scheduler等）で定期実行されているバッチが他にないか運用担当者に確認
- [ ] ニュースレター配信のブラウザリフレッシュ方式が運用上問題ないか確認
- [ ] データベースアップグレードスクリプトの実行タイミング・手順が文書化されているか確認
