# バッチ設計書 1-ニュースレター一括配信

## 概要

本ドキュメントは、QuickerSiteシステムにおけるニュースレター一括配信バッチの設計仕様を記載する。購読者へニュースレターを分割配信する疑似バッチ処理の仕様を定義する。

### 本バッチの処理概要

このバッチは、ニュースレターの購読者リストに登録されたユーザーに対して、一括でメール配信を行う処理である。ブラウザのMETA HTTP-EQUIV refreshを利用した疑似バッチ処理として実装されており、大量のメール配信をサーバー負荷を分散させながら実行する。

**業務上の目的・背景**：企業やサイト運営者がニュースレター購読者に対して、新着情報、キャンペーン情報、定期的なお知らせなどを一斉配信するために必要なバッチ処理である。手動で一通ずつ送信することは現実的でないため、自動化された一括配信機能が求められる。また、サーバーのタイムアウトやメモリ制限を回避するため、分割配信方式を採用している。

**バッチの実行タイミング**：管理者が管理画面から手動で実行する。ニュースレターの内容を作成・編集した後、配信対象のカテゴリを選択して配信を開始する。日次・週次などの定期実行ではなく、コンテンツ準備完了時に随時実行される。

**主要な処理内容**：
1. 配信対象のニュースレターと購読者カテゴリの取得
2. 購読者リストからアクティブな購読者のメールアドレスを抽出
3. 指定された間隔・件数でメール送信を実行
4. 配信ログの記録（bLog有効時）
5. ブラウザリフレッシュによる次バッチへの継続処理
6. 全件配信完了後の終了処理と履歴保存

**前後の処理との関連**：前提としてニュースレターの作成（bs_newsletterEdit.asp）と購読者の登録（bs_newsletterSubscribers.asp）が完了している必要がある。配信後は配信履歴（bs_newsletterMailingHistory.asp）で配信状況を確認可能。

**影響範囲**：tblNewsletterMailing、tblNewsletterLog、tblNewsletterCategorySubscriberテーブルに影響。また、外部メールサーバーへのSMTP送信が発生する。

## バッチ種別

通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 管理者操作時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（管理画面から実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ニュースレター作成済み | 配信対象のニュースレターが作成・保存されていること |
| 購読者登録済み | 対象カテゴリにアクティブな購読者が登録されていること |
| 管理者ログイン | secondAdmin.bNewsletter権限を持つ管理者がログインしていること |
| ブラウザ起動維持 | 配信完了までブラウザウィンドウを閉じないこと |

### 実行可否判定

- 購読者カテゴリが選択されており、対象カテゴリにアクティブな購読者が存在する場合に実行可能
- iNewsletterMailingIDが有効なレコードを参照している場合に実行可能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| iNewsletterMailingID | String（暗号化） | Yes | - | 配信対象のニュースレターメーリングID |
| iInterval | Integer | No | 10 | 一度に送信するメール件数 |
| iForceReload | Integer | No | 15 | リフレッシュ間隔（秒） |
| iStart | Integer | No | 0 | 配信開始位置（継続配信用） |
| postback | Boolean | No | false | 配信処理実行フラグ |
| sent | String | No | - | 配信状態（0:配信中、1:完了） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tblNewsletterMailing | DB | 配信設定情報 |
| tblNewsletterCategorySubscriber | DB | 購読者情報（カテゴリ別） |
| tblNewsletter | DB | ニュースレター本文・設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| tblNewsletterLog | DB | 配信ログ（bLog有効時） |
| tblNewsletterMailing.dSentDate | DB | 配信日時の更新 |
| メール | SMTP | 購読者へのニュースレターメール |

### 出力ファイル仕様

ファイル出力なし（メール配信およびDB更新のみ）

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 該当なし |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ セッション変数、パラメータの取得・設定
2. 配信対象データ取得
   └─ ニュースレターメーリング情報、カテゴリ別購読者リスト取得
3. 重複チェック用Dictionaryの初期化
   └─ 同一メールアドレスへの重複配信防止
4. 購読者ループ処理（iInterval件ずつ）
   └─ アクティブな購読者に対してメール送信
5. 配信ログ記録（bLog有効時）
   └─ tblNewsletterLogへのレコード追加
6. 継続判定
   └─ 残件ありの場合はMETA refreshで次バッチへ
7. 完了処理
   └─ 配信日時更新、セッション情報記録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ取得]
    B --> C[ニュースレターメーリング情報取得]
    C --> D[カテゴリ別購読者取得]
    D --> E{購読者存在?}
    E -->|なし| F[スキップ]
    E -->|あり| G[iInterval件のメール送信]
    G --> H{bLog有効?}
    H -->|Yes| I[配信ログ記録]
    H -->|No| J[ログスキップ]
    I --> K{残件あり?}
    J --> K
    K -->|あり| L[META refresh設定]
    L --> M[ブラウザリフレッシュ待機]
    M --> B
    K -->|なし| N[配信日時更新]
    N --> O[完了画面表示]
    F --> O
    O --> P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 購読者取得 | tblNewsletterCategorySubscriber | SELECT | カテゴリ別のアクティブ購読者を取得 |
| ログ記録 | tblNewsletterLog | INSERT | 配信ログレコードの追加 |
| 配信日時更新 | tblNewsletterMailing | UPDATE | 配信完了日時の記録 |
| メーリング削除 | tblNewsletterMailing | DELETE | bLog無効時のレコード削除 |
| ログ削除 | tblNewsletterLog | DELETE | メーリング削除時のログ削除 |

### テーブル別操作詳細

#### tblNewsletterCategorySubscriber

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sName, sEmail, sKey | bActive=true AND iCategoryID=指定カテゴリ | 購読者情報取得 |

#### tblNewsletterLog

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iSubscriberID | 購読者ID | 配信対象の購読者 |
| INSERT | iMailingID | メーリングID | 配信バッチの識別子 |
| INSERT | bRead | false | 開封フラグ初期値 |
| INSERT | dWhen | null | 開封日時初期値 |
| INSERT | sKey | generatePassword | 開封追跡用キー |

#### tblNewsletterMailing

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | dSentDate | now() | 配信完了日時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | メール送信エラー | SMTP接続失敗、無効なメールアドレス | 次の購読者へ継続、エラーログ記録 |
| - | DB接続エラー | データベース接続タイムアウト | ブラウザリフレッシュで再試行 |
| - | セッションタイムアウト | 長時間配信によるセッション切れ | 管理者再ログインして継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし（手動で再実行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- 配信途中でブラウザを閉じた場合：iStart値を指定してURLに直接アクセスすることで途中から再開可能
- メール送信エラー：allEmailsディクショナリにより重複配信を防止しながら継続

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | レコード単位（各メール送信ごと） |
| コミットタイミング | 各ログレコード挿入時、配信完了時 |
| ロールバック条件 | 明示的なトランザクション管理なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千件 |
| 目標処理時間 | iInterval件/iForceReload秒 |
| メモリ使用量上限 | ブラウザリフレッシュにより制限なし |

## 排他制御

- 同一ニュースレターメーリングの同時実行は想定していない
- allEmailsディクショナリにより、同一バッチ内での重複メールアドレスへの配信を防止

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | iStart=0時 | 配信開始時刻（セッション変数NLstartTime） |
| 進捗ログ | 各リフレッシュ時 | 送信済み件数（画面表示） |
| 終了ログ | 配信完了時 | 配信完了時刻（セッション変数NLstopTime） |
| エラーログ | 該当なし | 明示的なエラーログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 該当なし | 該当なし |
| エラー件数 | 該当なし | 該当なし |

## 備考

- META HTTP-EQUIV refreshを使用した疑似バッチ処理のため、管理者がブラウザを起動したまま配信完了を待つ必要がある
- bLog=trueの場合、開封追跡用の画像URLがメール本文に埋め込まれる
- 購読解除リンクは[NL_UNSUBSCRIBELINK]プレースホルダーで自動挿入される
