# バッチ設計書 10-データベースアップグレード

## 概要

本ドキュメントは、QuickerSiteシステムにおけるデータベースアップグレードバッチの設計仕様を記載する。データベーススキーマの更新・マイグレーション処理を実行するバッチの仕様を定義する。

### 本バッチの処理概要

このバッチは、QuickerSiteのデータベーススキーマ情報を読み取り、テーブル構造の追加・変更に必要なDDL文（CREATE TABLE、ALTER TABLE）を生成する処理である。ADOX.Catalogを使用して既存のスキーマ情報を取得し、マイグレーションスクリプトを出力する。複数のバージョン（ad_upgrade2.asp、ad_upgrade3.asp、ad_upgrade4.asp）が存在し、対象データベースの種類に応じて使い分ける。

**業務上の目的・背景**：QuickerSiteのバージョンアップ時や、新機能追加時にデータベーススキーマの変更が必要となる。手動でDDL文を作成することはエラーの原因となりやすいため、既存スキーマを解析して自動的にマイグレーションスクリプトを生成することで、データベース更新作業の安全性と効率性を向上させる。

**バッチの実行タイミング**：システム管理者がデータベースのアップグレードが必要な際に手動で実行する。QuickerSiteのバージョンアップ後や、新規環境構築時に実行される。

**主要な処理内容**：
1. ADOX.Catalogオブジェクトの初期化
2. データベース接続の確立
3. 全テーブルのスキーマ情報取得
4. 各テーブルのCREATE TABLE文生成
5. 各カラムのALTER TABLE ADD COLUMN文生成
6. プライマリキーのCREATE INDEX文生成
7. 生成されたDDL文の画面出力

**前後の処理との関連**：生成されたDDL文を新規データベースまたはアップグレード対象のデータベースで実行する。実行後はアプリケーション一括リセット（バッチ4）を実行してキャッシュをクリアすることが推奨される。

**影響範囲**：DDL文の生成のみであり、直接データベースを変更しない。生成されたスクリプトを手動で実行した場合、データベーススキーマが変更される。

## バッチ種別

データベース管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | システム管理者操作時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（管理画面から実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 管理者権限 | システム管理者権限を持つユーザーがログインしていること |
| データベース接続 | 対象データベースへの接続が可能であること |

### 実行可否判定

- ad_security.aspによる管理者認証が成功していること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ADOX.Catalog | COM | データベーススキーマ情報 |
| db.getConn | DB接続 | アクティブなデータベース接続 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 画面（HTML） | テキスト | DDL文（CREATE TABLE、ALTER TABLE、CREATE INDEX） |

### 出力ファイル仕様

ファイル出力なし（画面出力のみ）

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | HTTPレスポンス（HTML） |
| 文字コード | システム依存 |
| 区切り文字 | 該当なし |

### 出力DDL文の種類

| バージョン | 対象DB | 出力形式 |
|-----------|--------|---------|
| ad_upgrade2.asp | MS Access | db.execute("DDL文") |
| ad_upgrade3.asp | SQL Server | db.execute("DDL文") |
| ad_upgrade4.asp | 汎用 | 純粋なDDL文 |

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ ad_security.aspによる管理者認証
2. ADOX.Catalog初期化
   └─ Server.CreateObject("ADOX.Catalog")
3. データベース接続
   └─ set xCat.ActiveConnection = db.getConn
4. テーブルループ
   └─ 各テーブル（"tb"で始まるもの）に対して処理
5. CREATE TABLE文生成
   └─ テーブル作成DDL出力
6. カラムループ
   └─ 各カラムに対してALTER TABLE ADD COLUMN文生成
7. データ型マッピング
   └─ GetSQLTypeName関数でデータ型変換
8. プライマリキー生成
   └─ iIdカラム存在時にCREATE INDEX文出力
9. 完了
   └─ On Error Goto 0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[権限チェック]
    B --> C{管理者権限?}
    C -->|なし| D[アクセス拒否]
    C -->|あり| E[ADOX.Catalog作成]
    E --> F[DB接続設定]
    F --> G[On Error Resume Next]
    G --> H[テーブルループ開始]
    H --> I{テーブル名がtbで始まる?}
    I -->|No| J[スキップ]
    I -->|Yes| K[CREATE TABLE出力]
    K --> L[createPrimary=false]
    L --> M[カラムループ開始]
    M --> N[ALTER TABLE ADD COLUMN出力]
    N --> O{カラム名=iid?}
    O -->|Yes| P[createPrimary=true]
    O -->|No| Q[次のカラム]
    P --> Q
    Q --> R{次のカラムあり?}
    R -->|Yes| M
    R -->|No| S{createPrimary?}
    S -->|Yes| T[CREATE INDEX出力]
    S -->|No| U[次のテーブル]
    T --> U
    J --> V{次のテーブルあり?}
    U --> V
    V -->|Yes| H
    V -->|No| W[On Error Goto 0]
    W --> X[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| スキーマ取得 | 全テーブル | メタデータ読み取り | ADOX経由でスキーマ情報取得 |

### データ型マッピング（MS Access版）

| ADOX型コード | 型名 | 出力SQL型 |
|-------------|------|----------|
| 3 | Integer（Auto） | COUNTER NOT NULL |
| 3 | Integer | LONG NULL |
| 7 | DateTime | DATETIME NULL |
| 11 | Boolean | BIT NULL |
| 6 | Currency | MONEY |
| 128 | Binary | BINARY |
| 17 | TinyInt | TINYINT |
| 131 | Decimal | DECIMAL |
| 5 | Double | FLOAT |
| 2 | SmallInt | INTEGER NULL |
| 4 | Single | REAL |
| 72 | GUID | UNIQUEIDENTIFIER |
| 202 | VarChar | TEXT(255) |
| 203 | LongText | MEMO NULL |

### データ型マッピング（SQL Server版）

| ADOX型コード | 型名 | 出力SQL型 |
|-------------|------|----------|
| 3 | Integer（Auto） | INT IDENTITY(1,1) NOT NULL |
| 3 | Integer | INT NULL |
| 7 | DateTime | datetime NULL |
| 11 | Boolean | bit NULL |
| 6 | Currency | MONEY |
| 128 | Binary | BINARY |
| 17 | TinyInt | int |
| 131 | Decimal | int |
| 5 | Double | int |
| 2 | SmallInt | int NULL |
| 4 | Single | REAL |
| 72 | GUID | UNIQUEIDENTIFIER |
| 202 | VarChar | nvarchar(255) |
| 203 | LongText | ntext NULL |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 接続エラー | データベース接続失敗 | エラー情報を画面表示 |
| - | 権限エラー | スキーマ読み取り権限なし | エラー情報を画面表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- On Error Resume Nextでエラーを無視して処理を継続
- 最終的にOn Error Goto 0でエラーハンドリングを復元

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テーブル数に依存（数十テーブル） |
| 目標処理時間 | 同期処理のため画面応答時間内 |
| メモリ使用量上限 | 低（スキーマ情報のみ） |

## 排他制御

- 読み取り専用のため排他制御なし
- 生成されたDDL文を実行する際は、他のアクセスを停止することを推奨

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 該当なし | 明示的な開始ログなし |
| 進捗ログ | 該当なし | 明示的な進捗ログなし |
| 終了ログ | 該当なし | 明示的な終了ログなし |
| エラーログ | 該当なし | 明示的なエラーログなし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 該当なし | 該当なし |
| エラー件数 | 該当なし | 該当なし |

## 備考

- ADOX.Catalog：ActiveX Data Objects Extensionsを使用してスキーマ情報を取得
- "tb"で始まるテーブルのみを対象とする（システムテーブルを除外）
- iIdカラムが存在する場合、プライマリキーとしてINDEXを作成
- Autoincrement属性のチェックにより、IDENTITY/COUNTER型を判定
- 3つのバージョンが存在：
  - ad_upgrade2.asp：MS Access用（db.execute形式）
  - ad_upgrade3.asp：SQL Server用（db.execute形式）
  - ad_upgrade4.asp：汎用（純粋DDL文）
- 生成されたDDL文はコピー＆ペーストして手動実行する運用を想定
- 既存テーブル・カラムが存在する場合はエラーとなるが、On Error Resume Nextで継続
