# バッチ設計書 2-連絡先一括メール送信

## 概要

本ドキュメントは、QuickerSiteシステムにおける連絡先一括メール送信バッチの設計仕様を記載する。選択した連絡先に対して一括でメールを送信する処理の仕様を定義する。

### 本バッチの処理概要

このバッチは、CRM機能の一部として、登録された連絡先（コンタクト）に対して一括でメールを送信する処理である。server.ScriptTimeout=10000を設定することで長時間実行を許可し、大量の連絡先への一括メール送信を実現する。CC送信先の指定も可能である。

**業務上の目的・背景**：顧客管理（CRM）機能において、登録された連絡先に対してキャンペーン情報、お知らせ、フォローアップメールなどを一斉送信するために必要なバッチ処理である。個別に連絡先を選択してメールを送信でき、ニュースレターとは異なり、より柔軟な対象者選択が可能。また、CC送信先を指定することで、社内関係者への同報も実現できる。

**バッチの実行タイミング**：管理者が管理画面から手動で実行する。連絡先を選択し、件名・本文を入力した後に一括送信を開始する。定期実行ではなく、業務上の必要に応じて随時実行される。

**主要な処理内容**：
1. 選択された連絡先IDリストの取得
2. CC送信先メールアドレスの取得
3. 連絡先ごとにメール本文のプレースホルダーを置換
4. 各連絡先へメール送信を実行
5. CC送信先への同報メール送信
6. 送信履歴の記録（tblMail、tblMailContact）
7. 完了後のリダイレクト処理

**前後の処理との関連**：前提として連絡先の登録（コンタクト管理機能）とカスタムフィールドの設定が完了している必要がある。送信後は送信履歴画面（bs_massMailingFB.asp）で結果を確認可能。

**影響範囲**：tblMail、tblMailContactテーブルに影響。また、外部メールサーバーへのSMTP送信が発生する。連絡先のカスタムフィールド情報を参照する。

## バッチ種別

通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 管理者操作時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（管理画面から実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 連絡先登録済み | 送信対象の連絡先が登録されていること |
| 管理者ログイン | 管理者権限を持つユーザーがログインしていること |
| メールサーバー接続 | SMTPサーバーへの接続が可能であること |

### 実行可否判定

- 1件以上の連絡先が選択されていること
- 選択された連絡先に有効なメールアドレスが設定されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| iContactIDM | String（カンマ区切り、暗号化） | Yes | - | 送信対象の連絡先IDリスト |
| ccEmails | String（カンマ区切り） | No | - | CC送信先メールアドレスリスト |
| hSubject | String | Yes | - | メール件名 |
| hBody | String | Yes | - | メール本文 |
| hBodyBGColor | String | No | - | メール背景色 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tblContact | DB | 連絡先情報 |
| contactFields | DB | 連絡先カスタムフィールド定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| tblMail | DB | 送信メール履歴 |
| tblMailContact | DB | 送信先連絡先リスト |
| メール | SMTP | 連絡先へのメール |

### 出力ファイル仕様

ファイル出力なし（メール送信およびDB更新のみ）

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 該当なし |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ ScriptTimeout=10000設定、Dictionaryオブジェクト初期化
2. パラメータ取得
   └─ 連絡先IDリスト、CC送信先、件名、本文の取得
3. 連絡先ループ処理
   └─ 各連絡先に対して以下を実行
4. メール内容の動的置換
   └─ [email]、[sPw]、カスタムフィールドの置換
5. メール送信
   └─ 連絡先へのメイン送信
6. CC送信
   └─ CC送信先リストへの同報送信
7. 履歴記録
   └─ tblMail、tblMailContactへの保存
8. 完了処理
   └─ bs_massMailingFB.aspへのリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ScriptTimeout=10000設定]
    B --> C[パラメータ取得]
    C --> D[連絡先IDリスト分割]
    D --> E{連絡先あり?}
    E -->|なし| F[完了処理]
    E -->|あり| G[連絡先情報取得]
    G --> H{メールアドレスあり?}
    H -->|なし| I[次の連絡先へ]
    H -->|あり| J{重複チェック}
    J -->|重複| I
    J -->|新規| K[プレースホルダー置換]
    K --> L[メール送信]
    L --> M{CC送信先あり?}
    M -->|あり| N[CC送信]
    M -->|なし| O[Dictionary登録]
    N --> O
    O --> I
    I --> E
    F --> P[メール履歴保存]
    P --> Q[送信先履歴保存]
    Q --> R[bs_massMailingFB.aspへリダイレクト]
    R --> S[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 連絡先取得 | tblContact | SELECT | 連絡先情報の取得（cls_contact.pick） |
| メール履歴保存 | tblMail | INSERT | 送信メール情報の保存 |
| 送信先保存 | tblMailContact | INSERT | 送信先メールアドレスの保存 |

### テーブル別操作詳細

#### tblMail

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sBody | メール本文 | 置換後の本文 |
| INSERT | sSubject | メール件名 | 置換後の件名 |
| INSERT | sBodyBGColor | 背景色 | hBodyBGColorパラメータ |

#### tblMailContact

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | iMailID | メールID | tblMailのiId |
| INSERT | sEmail | メールアドレス | 送信先メールアドレス |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | メール送信エラー | SMTP接続失敗、無効なメールアドレス | ErrorReportで記録、次の連絡先へ継続 |
| - | 連絡先取得エラー | 無効な連絡先ID | エラーをクリアして次の連絡先へ |
| - | プレースホルダー置換エラー | フィールド参照エラー | On Error Resume Nextで継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- メール送信エラー時：ErrorReport関数でエラーログを記録し、次の連絡先への処理を継続
- 処理途中でのタイムアウト：ScriptTimeout=10000（約2.7時間）で長時間実行を許可

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 明示的なトランザクション管理なし |
| コミットタイミング | 各レコード挿入時に自動コミット |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百件 |
| 目標処理時間 | ScriptTimeout=10000秒以内 |
| メモリ使用量上限 | contactDictで重複管理、件数に比例 |

## 排他制御

- contactDictディクショナリにより同一バッチ内での重複送信を防止
- 同時実行の明示的な排他制御なし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 該当なし | 明示的な開始ログなし |
| 進捗ログ | 該当なし | 明示的な進捗ログなし |
| 終了ログ | 完了後リダイレクト | 送信件数（counter） |
| エラーログ | エラー発生時 | ErrorReport関数でメールアドレス、件名、エラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 該当なし | 該当なし |
| エラー件数 | 該当なし | 該当なし |

## 備考

- server.ScriptTimeout=10000により、約2.7時間の長時間実行が可能
- メール本文では以下のプレースホルダーが使用可能：
  - [email]：連絡先のメールアドレス
  - [sPw]：連絡先のパスワード
  - [フィールド名]：カスタムフィールドの値
- 日付型フィールドはconvertDateToPickerで変換される
- CC送信はCheckEmailSyntaxで構文チェック後に送信
