# バッチ設計書 4-アプリケーション一括リセット

## 概要

本ドキュメントは、QuickerSiteシステムにおけるアプリケーション一括リセットバッチの設計仕様を記載する。全サイトのApplicationオブジェクトを一括でリセットする処理の仕様を定義する。

### 本バッチの処理概要

このバッチは、QuickerSiteで管理されている全てのサイトのASP Applicationオブジェクトを一括でリセットする処理である。各サイトのad_resetAPP.aspエンドポイントにHTTPリクエストを送信し、サイトごとにキャッシュされたApplication変数をクリアする。

**業務上の目的・背景**：QuickerSiteはマルチテナント型のCMSであり、各サイトの設定情報やコンテンツはApplicationオブジェクトにキャッシュされている。システム設定の変更、データベーススキーマの更新、または障害復旧時に、全サイトのキャッシュを一括でクリアする必要がある。個別にサイトをリセットすることは管理上非効率であり、一括リセット機能により運用効率を向上させる。

**バッチの実行タイミング**：システム管理者が管理画面から手動で実行する。システムメンテナンス時、設定変更適用時、または障害復旧時に随時実行される。

**主要な処理内容**：
1. 全サイトリストの取得（cls_customerList）
2. 各サイトに対するリセットURL生成
3. MSXML2.ServerXMLHTTPによるHTTPリクエスト送信
4. レスポンス確認と結果表示
5. 全サイトの処理完了

**前後の処理との関連**：データベースアップグレード（ad_upgrade*.asp）後や、グローバル設定変更後に実行されることが多い。リセット後は各サイトが初回アクセス時にApplication変数を再構築する。

**影響範囲**：全サイトのApplicationオブジェクトがクリアされる。一時的にサイトのレスポンスが低下する可能性がある（キャッシュ再構築のため）。

## バッチ種別

システム管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | システム管理者操作時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（管理画面から実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 管理者権限 | システム管理者権限（ad_security.asp）を持つユーザーがログインしていること |
| ネットワーク接続 | 各サイトへのHTTPアクセスが可能であること |
| サイト稼働中 | リセット対象のサイトが起動していること |

### 実行可否判定

- システム管理者としてログインしていること
- 1つ以上のサイトが登録されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | パラメータなし（自動で全サイト対象） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tblCustomer | DB | サイト一覧情報（cls_customerList） |
| C_ADMINPASSWORD | 定数 | 管理者パスワード（認証用） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 画面表示 | HTML | 各サイトのリセット結果 |

### 出力ファイル仕様

ファイル出力なし

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 該当なし |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ ad_security.aspによる管理者認証
2. サイトリスト取得
   └─ cls_customerListで全サイト情報取得
3. サイトループ処理
   └─ 各サイトに対して以下を実行
4. リセットURL生成
   └─ sQSUrl/asp/ad_resetAPP.asp?apw=sha256(C_ADMINPASSWORD)
5. HTTPリクエスト送信
   └─ MSXML2.ServerXMLHTTPでGETリクエスト
6. レスポンス確認
   └─ HTTP 200かつ"Application Reset"文字列確認
7. 結果出力
   └─ Reset OK または Reset NOT OK
8. 完了
   └─ Response.End
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[権限チェック]
    B --> C{管理者権限?}
    C -->|なし| D[アクセス拒否]
    C -->|あり| E[サイトリスト取得]
    E --> F[サイトループ開始]
    F --> G[リセットURL生成]
    G --> H[sha256認証付きURL作成]
    H --> I[HTTPリクエスト送信]
    I --> J{HTTP 200?}
    J -->|No| K[Reset NOT OK表示]
    J -->|Yes| L{Application Reset文字列?}
    L -->|なし| K
    L -->|あり| M[Reset OK表示]
    K --> N[Response.Flush]
    M --> N
    N --> O{次のサイトあり?}
    O -->|あり| F
    O -->|なし| P[Response.End]
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| サイト一覧取得 | tblCustomer | SELECT | 全サイト情報の取得 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sUrl, sQSUrl | 全レコード | サイトURL情報 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | HTTPエラー | サイトへの接続失敗 | Reset NOT OK表示、次のサイトへ継続 |
| - | 認証エラー | レスポンスにApplication Reset文字列なし | Reset NOT OK表示、次のサイトへ継続 |
| - | タイムアウト | HTTPリクエストタイムアウト | エラークリアして次のサイトへ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- 個別サイトのリセット失敗時：エラー表示後、次のサイトへ処理を継続
- 全サイト失敗時：ネットワーク環境の確認、個別サイトへの手動リセット実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（DB更新なし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | サイト数に依存（数十〜数百サイト） |
| 目標処理時間 | サイトあたり数秒 |
| メモリ使用量上限 | 低（HTTPリクエストのみ） |

## 排他制御

- 同時実行の明示的な排他制御なし
- 各サイトのリセット処理は独立して実行される

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 該当なし | 明示的な開始ログなし |
| 進捗ログ | 各サイト処理後 | サイトURL + Reset OK/NOT OK |
| 終了ログ | 該当なし | 明示的な終了ログなし |
| エラーログ | 該当なし | 画面表示のみ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 該当なし | 該当なし |
| エラー件数 | 該当なし | 該当なし |

## 備考

- リセットURLにはsha256(C_ADMINPASSWORD)がパラメータとして付与され、不正アクセスを防止
- MSXML2.ServerXMLHTTPを使用した同期HTTPリクエスト
- Response.Flushにより各サイトの処理結果をリアルタイムで画面に表示
- サイトが停止している場合やネットワーク障害時はReset NOT OKとなる
- リセット後、各サイトは初回アクセス時にApplication変数を再構築するため、一時的なパフォーマンス低下が発生する可能性がある
