# バッチ設計書 5-フォーム送信データExcel出力

## 概要

本ドキュメントは、QuickerSiteシステムにおけるフォーム送信データExcel出力バッチの設計仕様を記載する。フォームへの送信データを一括でExcelファイルとして出力する処理の仕様を定義する。

### 本バッチの処理概要

このバッチは、QuickerSiteのフォーム機能で収集されたユーザー送信データを、Excelファイル形式で一括エクスポートする処理である。cls_excelfileクラスを使用してHTMLテーブルをExcel形式に変換し、ダウンロード可能なファイルとして出力する。

**業務上の目的・背景**：Webフォームで収集したお問い合わせ、アンケート回答、申し込みデータなどを、Excel形式でエクスポートすることにより、データの二次利用（分析、レポート作成、外部システムへの連携）を可能にする。CMS内だけでなく、社内の既存ワークフローやExcelベースの業務プロセスと連携するために必要な機能である。

**バッチの実行タイミング**：管理者が管理画面から手動で実行する。定期的なレポート作成時や、データ分析が必要な際に随時実行される。

**主要な処理内容**：
1. 対象フォームの情報取得
2. フォームフィールド定義の取得
3. 送信データの全件取得
4. HTMLテーブル形式でのデータ構築
5. cls_excelfileクラスによるExcel変換
6. ファイルダウンロードリダイレクト

**前後の処理との関連**：前提としてフォームの作成とユーザーからのデータ送信が完了している必要がある。エクスポート後はExcelファイルとしてローカルに保存される。

**影響範囲**：読み取り専用の処理であり、データベースへの書き込みは発生しない。出力ファイルにはフォーム送信データ全件が含まれる。

## バッチ種別

データエクスポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 管理者操作時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（管理画面から実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| フォーム存在 | 対象のフォームが作成されていること |
| secondAdmin.bFormExport | フォームエクスポート権限を持つ管理者がログインしていること |
| 送信データ存在 | エクスポート対象のデータが1件以上存在すること |

### 実行可否判定

- 指定されたフォームIDが有効であること
- フォームに対する送信データが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| iFormID | String（暗号化） | Yes | - | 対象フォームID（requestパラメータ） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tblForm | DB | フォーム定義情報 |
| tblFormField | DB | フォームフィールド定義 |
| tblFormSubmission | DB | フォーム送信データ |
| tblFormValue | DB | 送信データの各フィールド値 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Excelファイル | XLS/XLSX | フォーム送信データ一覧 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | cls_excelfileクラスで自動生成 |
| 出力先 | ブラウザダウンロード |
| 文字コード | システム依存 |
| 区切り文字 | Excel形式 |

### 出力項目

| 項目名 | 説明 |
|-------|------|
| ID | 送信データID（sKey） |
| 日付&時刻 | 送信日時（dCreatedTS） |
| カタログ | カタログ名（showCatalog=trueの場合） |
| アイテム | アイテムタイトル（showCatalog=trueの場合） |
| フィールド値 | 各フォームフィールドの値 |

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ secondAdmin.bFormExportの確認
2. フォーム情報取得
   └─ cls_formでフォーム定義取得
3. フィールド定義取得
   └─ form.fieldsでフィールド一覧取得
4. 送信データ取得
   └─ form.submissionsで全送信データ取得
5. カタログ表示判定
   └─ iItemIDの存在確認
6. HTMLテーブル構築
   └─ ヘッダー行とデータ行の生成
7. フィールドタイプ別処理
   └─ チェックボックス、ファイル、画像の特殊処理
8. Excel変換
   └─ cls_excelfile.exportでHTML→Excel変換
9. ダウンロードリダイレクト
   └─ excelfile.redirectLink()でファイル出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[権限チェック]
    B --> C{bFormExport?}
    C -->|なし| D[アクセス拒否]
    C -->|あり| E[フォーム情報取得]
    E --> F[フィールド定義取得]
    F --> G[送信データ取得]
    G --> H{カタログ関連データあり?}
    H -->|あり| I[showCatalog=true]
    H -->|なし| J[showCatalog=false]
    I --> K[HTMLテーブルヘッダー構築]
    J --> K
    K --> L[送信データループ]
    L --> M[フィールドループ]
    M --> N{フィールドタイプ判定}
    N -->|checkbox| O[Yes/No変換]
    N -->|file/image| P[URL生成]
    N -->|その他| Q[サニタイズ出力]
    O --> R[次のフィールド]
    P --> R
    Q --> R
    R --> S{次のフィールドあり?}
    S -->|あり| M
    S -->|なし| T{次の送信データあり?}
    T -->|あり| L
    T -->|なし| U[cls_excelfile.export]
    U --> V[redirectLink]
    V --> W[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| フォーム取得 | tblForm | SELECT | フォーム定義の取得 |
| フィールド取得 | tblFormField | SELECT | フィールド定義の取得 |
| 送信データ取得 | tblFormSubmission | SELECT | 全送信データの取得 |
| 値取得 | tblFormValue | SELECT | 各フィールド値の取得 |

### テーブル別操作詳細

#### tblFormSubmission

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, dCreatedTS, iItemID | iFormID=指定フォーム | 送信データ一覧 |

#### tblFormValue

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 各フィールド値 | iSubmissionID=送信データID | フィールド別の値 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | bFormExport権限なし | アクセス拒否 |
| - | データなし | 送信データ0件 | 空のテーブルを出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（同期処理） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- エラー発生時：標準的なASPエラーハンドリングに従う
- 大量データ時：メモリ不足の場合はデータの分割エクスポートを検討

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千件 |
| 目標処理時間 | 同期処理のため画面応答時間内 |
| メモリ使用量上限 | HTMLテーブル文字列サイズに依存 |

## 排他制御

- 読み取り専用のため排他制御なし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 該当なし | 明示的な開始ログなし |
| 進捗ログ | 該当なし | 明示的な進捗ログなし |
| 終了ログ | 該当なし | 明示的な終了ログなし |
| エラーログ | 該当なし | 明示的なエラーログなし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 該当なし | 該当なし |
| エラー件数 | 該当なし | 該当なし |

## 備考

- cls_excelfileクラスを使用してHTMLテーブルをExcel形式に変換
- フィールドタイプ別の特殊処理：
  - sb_ff_checkbox：convertCheckedYesNoでYes/No変換
  - sb_ff_file、sb_ff_image：linkUrlsでURL生成
  - sb_ff_comment：出力対象外
- カタログ連携フォームの場合、カタログ名とアイテムタイトルが追加列として出力される
- sanitize関数でXSS対策を実施
- formatTimeStampで日時フォーマット
