# バッチ設計書 6-ゲストブックデータExcel出力

## 概要

本ドキュメントは、QuickerSiteシステムにおけるゲストブックデータExcel出力バッチの設計仕様を記載する。ゲストブックのエントリーデータを一括でExcelファイルとして出力する処理の仕様を定義する。

### 本バッチの処理概要

このバッチは、QuickerSiteのゲストブック機能に投稿されたエントリーデータを、Excelファイル形式で一括エクスポートする処理である。cls_excelfileクラスを使用してHTMLテーブルをExcel形式に変換し、ダウンロード可能なファイルとして出力する。

**業務上の目的・背景**：ゲストブックに投稿されたコメント、お客様の声、フィードバックなどを、Excel形式でエクスポートすることにより、データの二次利用（分析、レポート作成、アーカイブ）を可能にする。マーケティング分析や顧客満足度調査の資料として活用するために必要な機能である。

**バッチの実行タイミング**：管理者が管理画面から手動で実行する。定期的なデータバックアップ時や、レポート作成が必要な際に随時実行される。

**主要な処理内容**：
1. 対象ゲストブックIDの取得
2. ゲストブックエントリーの全件取得
3. HTMLテーブル形式でのデータ構築
4. cls_excelfileクラスによるExcel変換
5. ファイルダウンロードリダイレクト

**前後の処理との関連**：前提としてゲストブックの作成とユーザーからの投稿が完了している必要がある。エクスポート後はExcelファイルとしてローカルに保存される。

**影響範囲**：読み取り専用の処理であり、データベースへの書き込みは発生しない。出力ファイルにはゲストブックエントリー全件が含まれる。

## バッチ種別

データエクスポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 管理者操作時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（管理画面から実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ゲストブック存在 | 対象のゲストブックが作成されていること |
| 管理者権限 | 管理者権限（bs_security.asp）を持つユーザーがログインしていること |
| エントリー存在 | エクスポート対象のエントリーが1件以上存在すること |

### 実行可否判定

- 指定されたゲストブックIDが有効であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| iGBID | String（暗号化） | Yes | - | 対象ゲストブックID（QueryString） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tblGuestBookItem | DB | ゲストブックエントリーデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Excelファイル | XLS/XLSX | ゲストブックエントリー一覧 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | cls_excelfileクラスで自動生成 |
| 出力先 | ブラウザダウンロード |
| 文字コード | システム依存 |
| 区切り文字 | Excel形式 |

### 出力項目

| 項目名 | カラム位置 | 説明 |
|-------|----------|------|
| rs(0) | 1列目 | エントリーID等 |
| rs(1) | 2列目 | ゲストブックID等 |
| rs(2) | 3列目 | 投稿者名等 |
| rs(3) | 4列目 | メールアドレス等 |
| rs(4) | 5列目 | コメント等 |
| rs(5) | 6列目 | 投稿日時等 |

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ bs_security.aspによる管理者認証
2. パラメータ取得
   └─ iGBIDの復号化
3. データ取得
   └─ tblGuestBookItemからSELECT
4. HTMLテーブル構築
   └─ ループでデータ行を生成
5. Excel変換
   └─ cls_excelfile.exportでHTML→Excel変換
6. ダウンロードリダイレクト
   └─ excelfile.redirectLink()でファイル出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[権限チェック]
    B --> C{管理者権限?}
    C -->|なし| D[アクセス拒否]
    C -->|あり| E[iGBID復号化]
    E --> F[SQLクエリ実行]
    F --> G[HTMLテーブル初期化]
    G --> H{データあり?}
    H -->|なし| I[空テーブル]
    H -->|あり| J[データ行追加]
    J --> K[rs.movenext]
    K --> L{次のレコードあり?}
    L -->|あり| J
    L -->|なし| M[テーブル終了タグ]
    I --> M
    M --> N[rs close]
    N --> O[cls_excelfile.export]
    O --> P[redirectLink]
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| エントリー取得 | tblGuestBookItem | SELECT | ゲストブックエントリーの全件取得 |

### テーブル別操作詳細

#### tblGuestBookItem

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iGuestbookID=指定ID, ORDER BY iId ASC | 全カラム取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 管理者権限なし | アクセス拒否 |
| - | パラメータエラー | 無効なiGBID | エラー発生 |
| - | データなし | エントリー0件 | 空のExcelファイル出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（同期処理） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- エラー発生時：標準的なASPエラーハンドリングに従う

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百件 |
| 目標処理時間 | 同期処理のため画面応答時間内 |
| メモリ使用量上限 | gbTable文字列サイズに依存 |

## 排他制御

- 読み取り専用のため排他制御なし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 該当なし | 明示的な開始ログなし |
| 進捗ログ | 該当なし | 明示的な進捗ログなし |
| 終了ログ | 該当なし | 明示的な終了ログなし |
| エラーログ | 該当なし | 明示的なエラーログなし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 該当なし | 該当なし |
| エラー件数 | 該当なし | 該当なし |

## 備考

- cls_excelfileクラスを使用してHTMLテーブルをExcel形式に変換
- tblGuestBookItemの全カラム（rs(0)〜rs(5)）をそのまま出力
- カラム名ではなくインデックス番号でアクセスしているため、テーブル構造の変更に注意が必要
- ORDER BY iId ASCで投稿順にソート
- フォーム送信データExcel出力（バッチ5）と同じcls_excelfileクラスを使用
