# バッチ設計書 7-サイトコピー処理

## 概要

本ドキュメントは、QuickerSiteシステムにおけるサイトコピー処理バッチの設計仕様を記載する。既存サイトの設定・コンテンツを複製して新しいサイトを作成する処理の仕様を定義する。

### 本バッチの処理概要

このバッチは、QuickerSiteで管理されている既存サイトの設定情報とコンテンツを完全に複製し、新しいサイトとして作成する処理である。cls_customerクラスのcopy()メソッドを使用して、サイト設定、テンプレート、ページ、コンテンツなどを一括でコピーする。

**業務上の目的・背景**：複数の類似サイトを運用する場合や、既存サイトをベースに新規サイトを立ち上げる場合に、ゼロから設定を行うことは非効率である。既存サイトの設定やコンテンツをコピーすることで、新規サイトの立ち上げ時間を大幅に短縮し、設定ミスを防止する。マルチテナント環境での効率的なサイト展開を実現するために必要な機能である。

**バッチの実行タイミング**：システム管理者が管理画面から手動で実行する。新規サイト立ち上げ時やサイトテンプレートからの複製時に随時実行される。

**主要な処理内容**：
1. コピー元サイト情報の取得
2. 新規サイト情報の入力・検証
3. サイト設定のコピー（URL、言語、日付形式など）
4. テンプレートのコピー
5. ページ・コンテンツのコピー
6. 関連データ（ニュースレターカテゴリ、フォームなど）のコピー
7. 新規サイトの保存と管理画面へのリダイレクト

**前後の処理との関連**：前提としてコピー元のサイトが存在し、正常に動作している必要がある。コピー後は新規サイトの管理画面（ad_default.asp）にリダイレクトされる。

**影響範囲**：新規サイト用のデータベースレコードが作成される。コピー元サイトには影響しない。

## バッチ種別

サイト管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | システム管理者操作時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動（管理画面から実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 管理者権限 | システム管理者権限（ad_security.asp）を持つユーザーがログインしていること |
| コピー元サイト存在 | コピー元となるサイトが正常に存在していること |

### 実行可否判定

- siteToBeCopiedIDが有効なサイトIDであること
- 新規サイトのURLが入力されていること
- 入力内容の検証（check()）が成功すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| siteToBeCopiedID | Integer | Yes | - | コピー元サイトID |
| sUrl | String | Yes | - | 新規サイトのURL |
| sAlternateDomains | String | No | - | 代替ドメイン（改行区切り） |
| sDescription | String | No | - | サイト説明（META description） |
| siteName | String | Yes | - | サイト名（組織名） |
| siteTitle | String | No | - | サイトタイトル |
| copyRight | String | No | - | コピーライト（META copyright） |
| keywords | String | No | - | キーワード（META keywords） |
| googleAnalytics | String | No | - | Google Analytics設定 |
| language | String | No | - | サイト言語 |
| sDatumFormat | String | No | - | 日付フォーマット |
| webmaster | String | No | - | Webmaster名（META author） |
| webmasterEmail | String | No | - | Webmasterメールアドレス |
| dOnlineFrom | Date | No | 当日 | 公開開始日 |
| bApplication | Boolean | No | false | アプリケーション許可 |
| bScanReferer | Boolean | No | false | リファラースキャン |
| bUserFriendlyURL | Boolean | No | false | ユーザーフレンドリーURL許可 |
| bAllowStorageOutsideWWW | Boolean | No | false | WWW外ストレージ許可 |
| bEnableMainRSS | Boolean | No | false | メインRSS有効化 |
| defaultTemplate | String | No | - | デフォルトテンプレート |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tblCustomer | DB | コピー元サイト情報 |
| フォーム入力 | POST | 新規サイト設定情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| tblCustomer | DB | 新規サイトレコード |
| 関連テーブル | DB | コピーされた各種データ |

### 出力ファイル仕様

ファイル出力なし

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 該当なし |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ ad_security.aspによるシステム管理者認証
2. コピー元サイト情報取得
   └─ cls_customer.pick(siteToBeCopiedID)
3. 初期値設定
   └─ sName、sURL、dOnlineFrom、sAlternateDomainsのクリア
4. フォーム入力取得（postback時）
   └─ checkCSRF()でCSRF対策
5. 入力値検証
   └─ siteToBeCopied.check()
6. サイトコピー実行
   └─ siteToBeCopied.copy()
7. リダイレクト
   └─ ad_default.asp?newAccount=True&iId=新規サイトID
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[権限チェック]
    B --> C{管理者権限?}
    C -->|なし| D[アクセス拒否]
    C -->|あり| E[コピー元サイト取得]
    E --> F[初期値クリア]
    F --> G{postback?}
    G -->|No| H[入力フォーム表示]
    G -->|Yes| I[CSRF検証]
    I --> J[フォーム入力取得]
    J --> K[入力値検証]
    K --> L{検証OK?}
    L -->|No| H
    L -->|Yes| M[siteToBeCopied.copy実行]
    M --> N[新規サイトID取得]
    N --> O[ad_default.aspへリダイレクト]
    O --> P[バッチ終了]
    H --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| サイト取得 | tblCustomer | SELECT | コピー元サイト情報の取得 |
| サイト作成 | tblCustomer | INSERT | 新規サイトレコードの作成 |
| コンテンツコピー | 複数テーブル | INSERT | ページ、テンプレート等のコピー |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId=siteToBeCopiedID | コピー元サイト全情報 |
| INSERT | sUrl | 入力された新URL | 必須項目 |
| INSERT | sName | 入力されたサイト名 | 必須項目 |
| INSERT | その他設定 | フォーム入力値 | コピー元の値を継承 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | システム管理者権限なし | アクセス拒否 |
| - | CSRFエラー | CSRFトークン不正 | フォーム再表示 |
| - | 検証エラー | 必須項目未入力、URL重複など | エラーメッセージ表示、フォーム再表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（同期処理） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- 検証エラー時：エラーメッセージを表示し、入力フォームを再表示
- コピー処理中のエラー：ロールバック後、エラーメッセージ表示

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | copy()メソッド内で管理（推定） |
| コミットタイミング | コピー完了時 |
| ロールバック条件 | コピー処理中のエラー発生時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1サイト/実行 |
| 目標処理時間 | 同期処理のため画面応答時間内 |
| メモリ使用量上限 | コピー対象データ量に依存 |

## 排他制御

- 同一サイトの同時コピーは想定していない
- 明示的な排他制御なし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 該当なし | 明示的な開始ログなし |
| 進捗ログ | 該当なし | 明示的な進捗ログなし |
| 終了ログ | 該当なし | 明示的な終了ログなし |
| エラーログ | 該当なし | 明示的なエラーログなし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 該当なし | 該当なし |
| エラー件数 | 該当なし | 該当なし |

## 備考

- checkCSRF()によりCSRF攻撃を防止
- コピー時にsName、sURL、sAlternateDomainsはクリアされ、新規入力が必要
- dOnlineFromはコピー実行日が初期値として設定される
- テンプレート選択はコピー元サイトのテンプレート一覧から選択可能
- siteToBeCopied.copy()メソッドは、cls_customerクラス内で定義されたサイト複製ロジックを実行
- 言語リスト（cls_languageListNew）と日付フォーマットリスト（cls_dateFormatList）から選択可能
