# バッチ設計書 8-RSSフィード生成

## 概要

本ドキュメントは、QuickerSiteシステムにおけるRSSフィード生成バッチの設計仕様を記載する。サイトのページ・リストアイテムからRSSフィードを動的に生成する処理の仕様を定義する。

### 本バッチの処理概要

このバッチは、QuickerSiteで管理されているページやリストアイテムの情報をRSS 2.0形式のXMLフィードとして動的に生成する処理である。cls_kwRSS_writerクラスを使用してRSSフィードを構築し、Application変数にキャッシュすることでパフォーマンスを最適化している。

**業務上の目的・背景**：RSSフィードを提供することで、サイトの更新情報をRSSリーダーやその他のアグリゲーターで購読できるようにする。これにより、ユーザーは定期的にサイトを訪問しなくても最新情報を取得でき、サイトへの再訪問を促進する効果がある。SEO対策としても有効であり、検索エンジンがサイトの更新頻度を把握するのに役立つ。

**バッチの実行タイミング**：ユーザーまたはRSSリーダーからのHTTPリクエスト時に動的に実行される。キャッシュが存在する場合はキャッシュから返却し、キャッシュがない場合は新規生成してキャッシュに保存する。

**主要な処理内容**：
1. リクエストパラメータの解析（メインRSS or ページ別RSS）
2. キャッシュの存在確認
3. ページ情報の取得（最大300件）
4. RSS XMLの構築
5. Application変数へのキャッシュ保存
6. XMLレスポンスの出力

**前後の処理との関連**：ページやリストアイテムの更新時にキャッシュがクリアされる必要がある（Application変数のリセット）。フィード購読者へのコンテンツ配信の起点となる。

**影響範囲**：読み取り専用の処理であり、データベースへの書き込みは発生しない。Application変数にキャッシュを保存する。

## バッチ種別

フィード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リクエスト時（オンデマンド） |
| 実行時刻 | ユーザーアクセス時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | HTTPリクエスト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| メインRSSの場合 | customer.bEnableMainRSSがtrueであること |
| ページRSSの場合 | selectedPage.bPushRSSがtrue、またはテーマ/カタログがRSS有効 |
| イントラネットページの場合 | logon.authenticatedIntranetがtrueであること |

### 実行可否判定

- メインRSS：customer.bEnableMainRSS=true
- ページRSS：ページが存在し、アクセス権限があること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| iID | String（暗号化） | No | - | ページID（ページ別RSSの場合） |
| viewtype | String | No | - | 表示タイプ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tblPage | DB | ページ情報 |
| tblListItem | DB | リストアイテム情報 |
| tblPost | DB | フォーラム投稿情報 |
| tblItem | DB | カタログアイテム情報 |
| Application変数 | メモリ | キャッシュされたRSSフィード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| HTTPレスポンス | XML（RSS 2.0） | RSSフィード |
| Application変数 | 文字列 | キャッシュされたRSS |

### 出力ファイル仕様

ファイル出力なし（HTTPレスポンスとして出力）

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | HTTPレスポンス |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

### RSS要素

| 要素名 | 説明 |
|-------|------|
| title | ページタイトルまたはサイト名 |
| link | ページURL |
| description | ページ内容または説明 |
| pubDate | 更新日時（RFC822形式） |
| author | webmasteremailとwebmaster名 |
| guid | 一意識別子（URL） |
| enclosure | 画像URL（リストアイテムの場合） |
| comments | コメントURL（フォーラムの場合） |

## 処理フロー

### 処理シーケンス

```
1. Content-Type設定
   └─ application/xml
2. リクエスト解析
   └─ selectedPage.iIdの確認
3. メインRSS判定
   └─ iId=0の場合はメインRSS
4. キャッシュ確認
   └─ Application("RSS" & cId)の存在確認
5. ページ取得（キャッシュなしの場合）
   └─ 最大300件のページを取得
6. RSS構築
   └─ kwRSS_writerでXML生成
7. キャッシュ保存
   └─ Application変数に保存
8. 出力処理
   └─ treatConstantsで定数置換後出力
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[Content-Type設定]
    B --> C{selectedPage.iId=0?}
    C -->|Yes| D[メインRSS処理]
    C -->|No| E[ページRSS処理]
    D --> F{bEnableMainRSS?}
    F -->|No| G[空レスポンス]
    F -->|Yes| H{キャッシュあり?}
    H -->|Yes| I[キャッシュ出力]
    H -->|No| J[ページ取得]
    J --> K[最大300件ループ]
    K --> L{公開条件チェック}
    L -->|OK| M[RSS項目追加]
    L -->|NG| N[スキップ]
    M --> O{次のページあり?}
    N --> O
    O -->|Yes| K
    O -->|No| P[キャッシュ保存]
    P --> I
    E --> Q{イントラネット認証?}
    Q -->|NG| R[アクセス拒否RSS]
    Q -->|OK| S{キャッシュあり?}
    S -->|Yes| T[キャッシュ出力]
    S -->|No| U[リストアイテム/テーマ/カタログ取得]
    U --> V[RSS構築]
    V --> W[キャッシュ保存]
    W --> T
    I --> X[バッチ終了]
    T --> X
    R --> X
    G --> X
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ取得 | tblPage | SELECT | 公開ページの取得（最大300件） |
| リストアイテム取得 | tblListItem | SELECT | ページ関連リストアイテム取得 |
| 投稿取得 | tblPost | SELECT | フォーラム投稿の取得 |
| カタログアイテム取得 | tblItem | SELECT | カタログアイテムの取得 |
| ヒットカウント | tblPage | UPDATE | RSSアクセス数の記録 |
| リファラー記録 | tblReferer | INSERT | リファラー情報の記録 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sTitle, sValue, updatedTS | iCustomerID=cId, ORDER BY updatedTS DESC | 更新順 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | イントラネットページへの未認証アクセス | "No Access"メッセージのRSS返却 |
| - | 無効ページ | 存在しないページID | 空のRSS返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（同期処理） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- キャッシュエラー時：キャッシュなしで毎回生成

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り中心） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大300件（メインRSS） |
| 目標処理時間 | 同期処理のため画面応答時間内 |
| メモリ使用量上限 | Application変数キャッシュサイズに依存 |

## 排他制御

- Application変数へのキャッシュ書き込みはASPの自動ロックに依存
- 同時アクセス時は最新の書き込みが有効

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 該当なし | 明示的な開始ログなし |
| 進捗ログ | 該当なし | 明示的な進捗ログなし |
| 終了ログ | 該当なし | 明示的な終了ログなし |
| エラーログ | 該当なし | 明示的なエラーログなし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 該当なし | 該当なし |
| エラー件数 | 該当なし | 該当なし |

## 備考

- kwRSS_writerクラスでRSS 2.0形式のXMLを生成
- Application変数にキャッシュすることでパフォーマンスを最適化
- キャッシュキー：メインRSS="RSS"+cId、ページRSS="RSS"+cId+pageId+viewtype
- 公開条件：bOnline=true、bDeleted=false、bContainerPage=false、bLossePagina=false、iListPageID=null、bIntranet=false、sApplication=null、sPw=null、sExternalURL=null
- RFC822形式の日付はFormat_RFC822_DateAndTime関数で変換
- treatConstants関数で定数（サイトURL等）を置換
- addHitRSSでRSSアクセス数をカウント
- logReferer()でリファラー情報を記録
