# バッチ設計書 9-XMLサイトマップ生成

## 概要

本ドキュメントは、QuickerSiteシステムにおけるXMLサイトマップ生成バッチの設計仕様を記載する。検索エンジン向けにサイト全体のXMLサイトマップを動的に生成する処理の仕様を定義する。

### 本バッチの処理概要

このバッチは、QuickerSiteで管理されているサイト全体のページとリストアイテムの情報を、Sitemaps.org仕様に準拠したXMLサイトマップ形式で動的に生成する処理である。cls_searchクラスを使用して全ページを取得し、XMLを構築する。

**業務上の目的・背景**：検索エンジン（Google、Bing等）にサイト構造を効率的に伝えることで、クローラーのインデックス効率を向上させる。XMLサイトマップを提供することで、検索エンジンがサイト内の全ページを発見しやすくなり、SEO効果の向上が期待できる。特に大規模サイトや動的コンテンツを持つサイトでは、サイトマップの提供が重要となる。

**バッチの実行タイミング**：検索エンジンのクローラーまたはユーザーからのHTTPリクエスト時に動的に実行される。sitemap.aspへのアクセスごとに最新の情報を生成する。

**主要な処理内容**：
1. cls_searchクラスの初期化
2. 全ページ・リストアイテムの取得
3. XMLサイトマップヘッダーの生成
4. 各ページのURL要素の生成
5. フォーラム投稿のURL要素の生成
6. XMLサイトマップの出力

**前後の処理との関連**：生成されたサイトマップURLをGoogle Search Consoleや他の検索エンジンツールに登録することで、クローリング効率が向上する。

**影響範囲**：読み取り専用の処理であり、データベースへの書き込みは発生しない。

## バッチ種別

サイトマップ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リクエスト時（オンデマンド） |
| 実行時刻 | クローラーアクセス時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | HTTPリクエスト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| サイト存在 | 対象サイトが存在し、ページが登録されていること |

### 実行可否判定

- sitemap.aspへのアクセスがあれば実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tblPage | DB | ページ情報 |
| tblListItem | DB | リストアイテム情報 |
| tblPost | DB | フォーラム投稿情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| HTTPレスポンス | XML | XMLサイトマップ |

### 出力ファイル仕様

ファイル出力なし（HTTPレスポンスとして出力）

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | HTTPレスポンス |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

### XMLサイトマップ構造

```xml
<?xml version="1.0" encoding="UTF-8"?>
<urlset
  xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
  http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">
  <url>
    <loc>ページURL</loc>
  </url>
  ...
</urlset>
```

## 処理フロー

### 処理シーケンス

```
1. XMLヘッダー生成
   └─ XML宣言とurlset要素の開始タグ
2. 検索オブジェクト初期化
   └─ cls_search設定（includeURL=false, includeListItems=true）
3. 全ページ取得
   └─ getSiteMap.resultsで全ページ取得
4. ページループ処理
   └─ 各ページに対して以下を実行
5. テーマ（フォーラム）処理
   └─ iThemeID>0の場合、投稿URLを追加
6. URL要素生成
   └─ リストアイテム/ユーザーフレンドリーURL/通常URLの判定
7. XML終了タグ
   └─ urlsetの終了タグ
8. 出力処理
   └─ Response.Write(sitemap)
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[XMLヘッダー生成]
    B --> C[cls_search初期化]
    C --> D[includeURL=false設定]
    D --> E[includeListItems=true設定]
    E --> F[allowEmptyString=true設定]
    F --> G[検索実行]
    G --> H[結果ループ開始]
    H --> I{iThemeID>0?}
    I -->|Yes| J[フォーラム投稿取得]
    J --> K[投稿URLループ]
    K --> L[投稿URL要素追加]
    L --> M[url要素開始]
    I -->|No| M
    M --> N{リストアイテム?}
    N -->|Yes| O[リストアイテムURL生成]
    N -->|No| P{ユーザーフレンドリーURL?}
    P -->|Yes| Q[ユーザーフレンドリーURL生成]
    P -->|No| R[通常URL生成]
    O --> S[loc要素追加]
    Q --> S
    R --> S
    S --> T[url要素終了]
    T --> U{次のページあり?}
    U -->|Yes| H
    U -->|No| V[urlset終了タグ]
    V --> W[Response.Write]
    W --> X[cleanUPASP]
    X --> Y[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ取得 | tblPage | SELECT | 全公開ページの取得 |
| リストアイテム取得 | tblListItem | SELECT | リストアイテムの取得 |
| 投稿取得 | tblPost | SELECT | フォーラム投稿の取得 |

### テーブル別操作詳細

#### tblPost

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId | (iPostID is null or iPostID=0) and iThemeID=指定ID | トップレベル投稿のみ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | データなし | ページが存在しない | 空のサイトマップ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（同期処理） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

- エラー発生時：空のサイトマップまたはエラーレスポンス

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | サイト規模に依存（数百〜数千ページ） |
| 目標処理時間 | 同期処理のため画面応答時間内 |
| メモリ使用量上限 | sitemap文字列サイズに依存 |

## 排他制御

- 読み取り専用のため排他制御なし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 該当なし | 明示的な開始ログなし |
| 進捗ログ | 該当なし | 明示的な進捗ログなし |
| 終了ログ | 該当なし | 明示的な終了ログなし |
| エラーログ | 該当なし | 明示的なエラーログなし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 該当なし | 該当なし |
| エラー件数 | 該当なし | 該当なし |

## 備考

- Sitemaps.org仕様（http://www.sitemaps.org/schemas/sitemap/0.9）に準拠
- XMLサイトマップの検証：http://www.xml-sitemaps.com/validate-xml-sitemap.html で検証可能
- URLエスケープ：&は&amp;にエスケープ
- URL生成パターン：
  1. フォーラム投稿：default.asp?iId=ページID&iPostID=投稿ID
  2. リストアイテム：default.asp?iId=リストページID&item=アイテムID
  3. ユーザーフレンドリーURL：/ユーザーフレンドリーURL文字列
  4. 通常ページ：default.asp?iId=ページID
- encrypt()関数でIDを暗号化
- customer.sQSUrlでサイトのベースURL取得
- cleanUPASP()でリソースのクリーンアップ
