---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：10-データベースアップグレード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **DDL実行手順**：生成後の実行方法の確認必要
  2. **監視・アラート仕様**：該当なしの妥当性確認必要
  3. **バージョン間の差異**：3つのバージョンの使い分け確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_upgrade2.asp` - MS Access版
- E-02: `asp/ad_upgrade3.asp` - SQL Server版
- E-03: `asp/ad_upgrade4.asp` - 汎用版
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ad_security.aspで管理者認証 | E-01, E-02, E-03 各ファイル冒頭 | ○ |
| C-02 | ADOX.Catalog使用 | E-01 L5, E-02 L5, E-03 L5 | ○ |
| C-03 | db.getConnで接続 | E-01 L6, E-02 L6, E-03 L6 | ○ |
| C-04 | On Error Resume Next | E-01 L7, E-02 L7, E-03 L7 | ○ |
| C-05 | "tb"で始まるテーブルをフィルタ | E-01 L10, E-02 L10, E-03 L10 | ○ |
| C-06 | CREATE TABLE文生成 | E-01 L11, E-02 L11, E-03 L11 | ○ |
| C-07 | ALTER TABLE ADD COLUMN文生成 | E-01 L15, E-02 L15, E-03 L15 | ○ |
| C-08 | iidカラムでプライマリキー判定 | E-01 L17-19, E-02 L17-19, E-03 L17-19 | ○ |
| C-09 | CREATE INDEX文生成 | E-01 L27, E-02 L27-28 | ○ |
| C-10 | GetSQLTypeName関数 | E-01 L38-54, E-02 L38-54, E-03 L38-54 | ○ |
| C-11 | 型コード3でCOUNTER/IDENTITY判定 | E-01 L40, E-02 L40, E-03 L40 | ○ |
| C-12 | Autoincrement属性チェック | E-01 L40, E-02 L40, E-03 L40 | ○ |
| C-13 | 型コード7でDATETIME | E-01 L41, E-02 L41, E-03 L41 | ○ |
| C-14 | 型コード11でBIT | E-01 L42, E-02 L42, E-03 L42 | ○ |
| C-15 | 型コード202でTEXT/nvarchar | E-01 L51, E-02 L51, E-03 L51 | ○ |
| C-16 | 型コード203でMEMO/ntext | E-01 L52, E-02 L52, E-03 L52 | ○ |
| C-17 | On Error Goto 0 | E-01 L37, E-02 L37, E-03 L37 | ○ |
| C-18 | db.execute形式（upgrade2,3） | E-01 L11, L15, E-02 L11, L15 | ○ |
| C-19 | 純粋DDL形式（upgrade4） | E-03 L11, L15 | ○ |
| C-20 | table.columnsでカラム取得 | E-01 L14, E-02 L14, E-03 L14 | ○ |
| C-21 | column.propertiesアクセス | E-01 L20-24, E-02 L20-24, E-03 L20-24 | ○ |
| C-22 | table.indexesアクセス | E-01 L31-34, E-02 L31-34, E-03 L31-34 | ○ |
| C-23 | Response.Writeで出力 | E-01, E-02, E-03 各所 | ○ |
| C-24 | createPrimaryフラグ | E-01 L13, L17-19, L26-28 | ○ |
| C-25 | DDL実行手順 | **根拠なし** | △ |
| C-26 | 監視・アラート：該当なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 生成されたDDL文の実行手順が未確認
  - 候補：運用マニュアル / デプロイ手順書
- 3つのバージョンの使い分け基準が未確認
  - 候補：運用マニュアル / データベース設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: ADOX.Catalogの使用は確認済み
- 0: データ型マッピングは確認済み
- 1: On Error Resume Nextにより一部エラーが隠蔽される可能性
- 1: 既存テーブル・カラムへの対応方法が不明確

## 6) レビュアーチェックリスト（最小）
- [ ] 生成されたDDL文の実行前にバックアップを取得する手順を確認
- [ ] 3つのバージョン（upgrade2/3/4）の使い分け基準を明確化
- [ ] 既存スキーマとの差分のみを適用する方法を確認
- [ ] アップグレード後のアプリケーションリセット手順を確認
