---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：4-アプリケーション一括リセット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **想定処理件数**：サイト数に依存の具体的な範囲確認必要
  2. **ad_resetAPP.asp**：個別リセット処理の実装確認必要
  3. **監視・アラート仕様**：該当なしの妥当性確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_resetAllAPP.asp` - メイン処理ファイル
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ad_security.aspで管理者認証 | E-01 L4 | ○ |
| C-02 | cls_customerListで全サイト取得 | E-01 L4-7 | ○ |
| C-03 | sQSUrl/asp/ad_resetAPP.aspへリクエスト | E-01 L10 | ○ |
| C-04 | sha256(C_ADMINPASSWORD)で認証 | E-01 L10 | ○ |
| C-05 | MSXML2.ServerXMLHTTPでHTTPリクエスト | E-01 L23 | ○ |
| C-06 | GETリクエスト送信 | E-01 L24 oXMLHTTP.open "GET" | ○ |
| C-07 | HTTP 200ステータス確認 | E-01 L30 | ○ |
| C-08 | "Application Reset"文字列確認 | E-01 L31 | ○ |
| C-09 | Reset OK表示 | E-01 L12 | ○ |
| C-10 | Reset NOT OK表示（赤色） | E-01 L14 font color=Red | ○ |
| C-11 | Response.Flushでリアルタイム表示 | E-01 L17 | ○ |
| C-12 | On Error Resume Nextでエラー継続 | E-01 L20 | ○ |
| C-13 | err.Clearでエラークリア | E-01 L27-28 | ○ |
| C-14 | Response.Endで処理終了 | E-01 L37 | ○ |
| C-15 | GetWebPage関数でHTTP通信 | E-01 L19-36 | ○ |
| C-16 | customers(c).sUrlで結果表示 | E-01 L12, L14 | ○ |
| C-17 | customersループで全サイト処理 | E-01 L9-18 | ○ |
| C-18 | apwパラメータで認証情報送信 | E-01 L10 | ○ |
| C-19 | 想定処理件数：数十〜数百サイト | **根拠なし** | △ |
| C-20 | 監視・アラート：該当なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定サイト数の根拠となる要件定義書またはシステム仕様書が未確認
  - 候補：要件定義書 / システム仕様書 / 運用実績データ
- ad_resetAPP.aspの実装詳細が未確認（個別リセット処理）
  - 候補：asp/ad_resetAPP.asp / 認証処理仕様

## 5) リスクフラグ（レビュー観点）
- 0: MSXML2.ServerXMLHTTPによるHTTP通信は確認済み
- 0: sha256認証によるセキュリティ対策は実装確認済み
- 1: HTTPタイムアウト設定が未確認
- 1: 大量サイト時の処理時間に注意

## 6) レビュアーチェックリスト（最小）
- [ ] ad_resetAPP.aspの実装がセキュリティ要件を満たすか確認
- [ ] sha256(C_ADMINPASSWORD)の認証方式が十分か確認
- [ ] HTTPリクエストのタイムアウト設定が適切か確認
- [ ] 大量サイト環境での処理時間が許容範囲内か確認
