---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：5-フォーム送信データExcel出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **想定処理件数**：具体的な数値の根拠なし
  2. **cls_excelfileクラス**：実装詳細の確認必要
  3. **監視・アラート仕様**：該当なしの妥当性確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_formExcel.asp` - メイン処理ファイル
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bFormExportで権限チェック | E-01 L4 logon.hasaccess | ○ |
| C-02 | cls_formでフォーム定義取得 | E-01 L6 | ○ |
| C-03 | form.fieldsでフィールド取得 | E-01 L7 | ○ |
| C-04 | form.submissionsで送信データ取得 | E-01 L8 | ○ |
| C-05 | showCatalogでカタログ表示判定 | E-01 L5, L9-14 | ○ |
| C-06 | iItemIDの存在確認 | E-01 L10 | ○ |
| C-07 | HTMLテーブル形式で出力 | E-01 L15-61 | ○ |
| C-08 | ID列の出力 | E-01 L32 sKey | ○ |
| C-09 | 日付&時刻列の出力 | E-01 L33 formatTimeStamp | ○ |
| C-10 | カタログ名の出力 | E-01 L35 submission.item.catalog.sName | ○ |
| C-11 | アイテムタイトルの出力 | E-01 L36 submission.item.sTitle | ○ |
| C-12 | sb_ff_checkboxでYes/No変換 | E-01 L42-43 convertCheckedYesNo | ○ |
| C-13 | sb_ff_file、sb_ff_imageでURL生成 | E-01 L44-49 linkUrls | ○ |
| C-14 | sb_ff_commentは出力対象外 | E-01 L39 | ○ |
| C-15 | sanitize関数でXSS対策 | E-01 L43, L51 | ○ |
| C-16 | cls_excelfile.exportでExcel変換 | E-01 L63-64 | ○ |
| C-17 | redirectLink()でダウンロード | E-01 L65 | ○ |
| C-18 | cleanUpStr関数でフィールド名処理 | E-01 L23 | ○ |
| C-19 | submission.valuesで値取得 | E-01 L31 | ○ |
| C-20 | sFileLocationでファイル出力先判定 | E-01 L46 | ○ |
| C-21 | 想定処理件数：数百〜数千件 | **根拠なし** | △ |
| C-22 | 監視・アラート：該当なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 想定処理件数の根拠となる要件定義書またはシステム仕様書が未確認
  - 候補：要件定義書 / システム仕様書 / 運用実績データ
- cls_excelfileクラスの実装詳細が未確認
  - 候補：asp/includes/excelfile.asp / クラス定義ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 権限チェックの実装は確認済み
- 0: フィールドタイプ別処理は確認済み
- 1: 大量データ時のメモリ使用量に注意（HTMLテーブル文字列）
- 0: sanitize関数によるXSS対策は実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] cls_excelfileクラスの出力形式がExcel互換か確認
- [ ] 大量データ時のメモリ使用量が問題ないか確認
- [ ] ファイル・画像フィールドのURLが正しく生成されるか確認
- [ ] 日本語データのエンコーディングが正しく処理されるか確認
