---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 21
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：7-サイトコピー処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：21 / 24、根拠なし：3
- 優先レビュー（高）
  1. **copy()メソッドの実装詳細**：cls_customerクラスの確認必要
  2. **トランザクション管理**：copy()内のトランザクション処理確認必要
  3. **監視・アラート仕様**：該当なしの妥当性確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_copysite.asp` - メイン処理ファイル
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ad_security.aspでシステム管理者認証 | E-01 L4 | ○ |
| C-02 | cls_customerでサイト情報取得 | E-01 L6-7 | ○ |
| C-03 | siteToBeCopied.pick(siteToBeCopiedID) | E-01 L7 | ○ |
| C-04 | sName、sURL、sAlternateDomainsのクリア | E-01 L8-11 | ○ |
| C-05 | dOnlineFromにdate()設定 | E-01 L10 | ○ |
| C-06 | checkCSRF()でCSRF対策 | E-01 L14 | ○ |
| C-07 | postbackフラグ判定 | E-01 L13 | ○ |
| C-08 | sUrl入力取得 | E-01 L15 | ○ |
| C-09 | sAlternateDomains入力取得 | E-01 L16 | ○ |
| C-10 | sDescription入力取得 | E-01 L17 | ○ |
| C-11 | siteName入力取得 | E-01 L18 | ○ |
| C-12 | bApplication入力取得 | E-01 L29 | ○ |
| C-13 | bUserFriendlyURL入力取得 | E-01 L31 | ○ |
| C-14 | bEnableMainRSS入力取得 | E-01 L33 | ○ |
| C-15 | defaultTemplate入力取得 | E-01 L34 | ○ |
| C-16 | siteToBeCopied.check()で検証 | E-01 L35 | ○ |
| C-17 | siteToBeCopied.copy()でコピー実行 | E-01 L36 | ○ |
| C-18 | ad_default.aspへリダイレクト | E-01 L37 | ○ |
| C-19 | newAccount=True&iId=新規IDパラメータ | E-01 L37 | ○ |
| C-20 | cls_languageListNew使用 | E-01 L41 | ○ |
| C-21 | cls_dateFormatList使用 | E-01 L43 | ○ |
| C-22 | copy()メソッドの詳細実装 | **根拠なし** | △ |
| C-23 | トランザクション管理 | **根拠なし** | △ |
| C-24 | 監視・アラート：該当なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_customerクラスのcopy()メソッドの実装詳細が未確認
  - 候補：asp/includes/customer.asp / クラス定義ファイル
- コピー処理時のトランザクション管理方式が未確認
  - 候補：copy()メソッド実装 / データベース設計書
- コピー対象となるテーブル・データの一覧が未確認
  - 候補：copy()メソッド実装 / データモデル定義

## 5) リスクフラグ（レビュー観点）
- 0: CSRF対策の実装は確認済み
- 0: 入力検証（check()）は確認済み
- 1: copy()メソッドの詳細実装が未確認のため、コピー範囲の網羅性に注意
- 1: 大規模サイトのコピー時のパフォーマンスに注意

## 6) レビュアーチェックリスト（最小）
- [ ] cls_customer.copy()メソッドの実装を確認し、コピー対象データを明確化
- [ ] コピー処理時のトランザクション管理が適切か確認
- [ ] 大規模サイトのコピー時のタイムアウト設定が適切か確認
- [ ] URLの重複チェックがcheck()内で実装されているか確認
