---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：9-XMLサイトマップ生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **cls_searchクラス**：実装詳細の確認必要
  2. **監視・アラート仕様**：該当なしの妥当性確認必要
  3. **大規模サイトのパフォーマンス**：ページ数上限の確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sitemap.asp` - メイン処理ファイル
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XML宣言（UTF-8） | E-01 L9 | ○ |
| C-02 | urlset要素とsitemaps.org名前空間 | E-01 L10-14 | ○ |
| C-03 | cls_search使用 | E-01 L17 | ○ |
| C-04 | includeURL=false設定 | E-01 L18 | ○ |
| C-05 | includeListItems=true設定 | E-01 L20 | ○ |
| C-06 | allowEmptyString=true設定 | E-01 L19 | ○ |
| C-07 | getResults取得 | E-01 L22-23 | ○ |
| C-08 | iThemeIDでフォーラム判定 | E-01 L29 | ○ |
| C-09 | フォーラム投稿クエリ | E-01 L32 | ○ |
| C-10 | 投稿URL生成 | E-01 L35 | ○ |
| C-11 | iListPageIDでリストアイテム判定 | E-01 L44 | ○ |
| C-12 | リストアイテムURL生成 | E-01 L45 | ○ |
| C-13 | bUserFriendlyURL判定 | E-01 L47 | ○ |
| C-14 | ユーザーフレンドリーURL生成 | E-01 L48 | ○ |
| C-15 | 通常URL生成 | E-01 L51 | ○ |
| C-16 | &amp;エスケープ | E-01 L35, L45 | ○ |
| C-17 | encrypt()でID暗号化 | E-01 L35, L45, L51 | ○ |
| C-18 | customer.sQSUrlでベースURL | E-01 L35, L45, L48, L51 | ○ |
| C-19 | urlset終了タグ | E-01 L55 | ○ |
| C-20 | cleanUPASP()呼び出し | E-01 L60 | ○ |
| C-21 | cls_searchクラスの詳細実装 | **根拠なし** | △ |
| C-22 | 監視・アラート：該当なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- cls_searchクラスの実装詳細が未確認
  - 候補：asp/includes/search.asp / クラス定義ファイル
- 大規模サイトでのページ数上限が未確認
  - 候補：cls_searchの実装 / サイトマップ仕様（50,000 URL上限）

## 5) リスクフラグ（レビュー観点）
- 0: XML宣言と名前空間の設定は確認済み
- 0: URLエスケープ（&amp;）は確認済み
- 1: 大規模サイトでの50,000 URL上限への対応が不明
- 0: encrypt()によるID暗号化は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] cls_searchクラスが全公開ページを正しく取得するか確認
- [ ] 50,000 URL上限を超える場合のサイトマップインデックス対応を検討
- [ ] 生成されたXMLがSitemaps.org仕様に準拠しているか検証
- [ ] 大規模サイトでのレスポンス時間が許容範囲内か確認
