---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 90
  claims_with_evidence: 85
  claims_without_evidence: 5
confidence_derived: 0.94
---

# 根拠レポート：admin モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：85 / 90、根拠なし：5
- 優先レビュー（高）
  1. **ad_upgrade.asp リモート実行**：外部サーバーからのスクリプト実行動作の詳細確認が必要
  2. **lockAdmin関数**：ロック処理の実装詳細がインクルードファイル内にある可能性
  3. **checkCSRF関数**：CSRF検証の実装詳細がインクルードファイル内にある可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/ad_login.asp` - 管理者ログイン処理
- E-02: `asp/ad_security.asp` - セキュリティ認証チェック
- E-03: `asp/ad_logoff.asp` - ログオフ処理
- E-04: `asp/ad_customer.asp` - 顧客管理（CRUD）
- E-05: `asp/ad_default.asp` - 管理者ダッシュボード、顧客一覧
- E-06: `asp/ad_client.asp` - クライアント管理（CRUD）
- E-07: `asp/ad_clientList.asp` - クライアント一覧
- E-08: `asp/ad_clientproduct.asp` - 製品/サービス管理
- E-09: `asp/ad_clientproducts.asp` - 製品一覧と集計
- E-10: `asp/ad_iis.asp` - IIS管理、サイト検索
- E-11: `asp/ad_editbindings.asp` - IISバインディング編集
- E-12: `asp/ad_labels.asp` - ラベル一覧
- E-13: `asp/ad_label.asp` - ラベル管理（CRUD）
- E-14: `asp/ad_copysite.asp` - サイトコピー機能
- E-15: `asp/ad_monitor.asp` - モニタリングログ管理
- E-16: `asp/ad_resetAPP.asp` - アプリケーションリセット
- E-17: `asp/ad_resetAllAPP.asp` - 全サイト一括リセット
- E-18: `asp/ad_pageList.asp` - ページ一覧
- E-19: `asp/ad_refererList.asp` - リファラー分析
- E-20: `asp/ad_formentries.asp` - フォーム送信管理
- E-21: `asp/ad_gbentries.asp` - ゲストブック一覧
- E-22: `asp/ad_upgrade.asp` - アップグレード処理
- E-23: `asp/ad_upgrade2.asp` - Access用スキーマ生成
- E-24: `asp/ad_upgrade3.asp` - SQL Server用スキーマ生成
- E-25: `asp/ad_upgrade4.asp` - SQL DDL生成
- E-26: `asp/ad_cs.asp` - 初期サイト作成
- E-27: `asp/ad_menu.asp` - メニュー（空ファイル）
- E-28: `asp/ad_adminMenu.asp` - 管理メニューリンク
- E-29: `asp/ad_back.asp` - 戻るリンク

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 正しいパスワードでログイン成功 | E-01 (ad_login.asp L11-12) | ○ |
| C-02 | CAPTCHAが不正な場合エラー表示 | E-01 (ad_login.asp L8-10) | ○ |
| C-03 | パスワードが不正な場合エラー表示 | E-01 (ad_login.asp L13-14) | ○ |
| C-04 | ログイン試行回数上限でロック | E-01 (ad_login.asp L16-18) | ○ |
| C-05 | ログイン試行回数上限-1回で警告 | E-01 (ad_login.asp L20) | ○ |
| C-06 | 認証済みセッションでアクセス許可 | E-02 (ad_security.asp L3) | ○ |
| C-07 | 未認証セッションでアクセス拒否 | E-02 (ad_security.asp L3) | ○ |
| C-08 | デフォルトパスワード未変更時アクセス拒否 | E-02 (ad_security.asp L2) | ○ |
| C-09 | ログオフ処理実行 | E-03 (ad_logoff.asp L4) | ○ |
| C-10 | 顧客情報の新規登録成功 | E-04 (ad_customer.asp L11-57) | ○ |
| C-11 | 顧客情報の更新成功 | E-04 (ad_customer.asp L20-57) | ○ |
| C-12 | バインディング変更時の処理 | E-04 (ad_customer.asp L20-23) | ○ |
| C-13 | 管理者パスワードリセット成功 | E-04 (ad_customer.asp L47-54) | ○ |
| C-14 | 顧客削除成功 | E-04 (ad_customer.asp L59-62) | ○ |
| C-15 | 自分自身の顧客削除防止 | E-04 (ad_customer.asp L71-72) | ○ |
| C-16 | CSRF検証成功 | E-04 (ad_customer.asp L12, 60) | ○ |
| C-17 | CSRF検証失敗 | E-04 checkCSRF関数 | △ |
| C-18 | 顧客一覧表示 | E-05 (ad_default.asp L11-35) | ○ |
| C-19 | 複数顧客の削除 | E-05 (ad_default.asp L5-10) | ○ |
| C-20 | 統計表示 | E-05 (ad_default.asp L37-53) | ○ |
| C-21 | クライアント保存成功 | E-06 (ad_client.asp L7-16) | ○ |
| C-22 | 必須項目未入力で保存失敗 | E-06 (ad_client.asp) | △ |
| C-23 | クライアント削除成功 | E-06 (ad_client.asp L17-20) | ○ |
| C-24 | 全クライアント一覧取得 | E-07 (ad_clientList.asp L5-7) | ○ |
| C-25 | クライアントが0件の場合 | E-07 (ad_clientList.asp L6) | ○ |
| C-26 | 製品/サービス保存 | E-08 (ad_clientproduct.asp L6-19) | ○ |
| C-27 | 更新料計算の検証 | E-09 (ad_clientproducts.asp L27-31) | ○ |
| C-28 | 製品/サービス削除成功 | E-08 (ad_clientproduct.asp L21-24) | ○ |
| C-29 | 製品一覧と合計計算 | E-09 (ad_clientproducts.asp L15-33) | ○ |
| C-30 | 更新警告の色分け表示 | E-09 (ad_clientproducts.asp L17-26) | ○ |
| C-31 | IIS情報再読み込み | E-10 (ad_iis.asp L20-22) | ○ |
| C-32 | バインディング検索成功 | E-10 (ad_iis.asp L6-18) | ○ |
| C-33 | 検索結果0件の場合 | E-10 (ad_iis.asp) | ○ |
| C-34 | SQLインジェクション対策 | E-10 (ad_iis.asp L6) | ○ |
| C-35 | IISバインディング更新成功 | E-11 (ad_editbindings.asp L9-45) | ○ |
| C-36 | 重複バインディングの除去 | E-11 (ad_editbindings.asp L14-18) | ○ |
| C-37 | 空のバインディングで保存失敗 | E-11 (ad_editbindings.asp L46) | ○ |
| C-38 | http://プレフィックス除去 | E-11 (ad_editbindings.asp L16) | ○ |
| C-39 | 全ラベル一覧取得 | E-12 (ad_labels.asp L4-10) | ○ |
| C-40 | ラベルが0件の場合 | E-12 (ad_labels.asp L9) | ○ |
| C-41 | ラベル新規登録成功 | E-13 (ad_label.asp L13-21) | ○ |
| C-42 | ラベル更新成功 | E-13 (ad_label.asp L13-21) | ○ |
| C-43 | ラベル削除成功 | E-13 (ad_label.asp L23-26) | ○ |
| C-44 | フォーム値の取得 | E-13 (ad_label.asp L15) | ○ |
| C-45 | ラベルキャッシュ更新 | E-13 (ad_label.asp L17-19) | ○ |
| C-46 | サイトコピー前検証成功 | E-14 (ad_copysite.asp L35) | ○ |
| C-47 | 必須項目未入力で検証失敗 | E-14 (ad_copysite.asp L35) | △ |
| C-48 | サイトコピー処理成功 | E-14 (ad_copysite.asp L36-37) | ○ |
| C-49 | コピー元設定の初期化 | E-14 (ad_copysite.asp L8-11) | ○ |
| C-50 | 全サイトモニタリングOFF | E-15 (ad_monitor.asp L5-6) | ○ |
| C-51 | 全サイトモニタリングON | E-15 (ad_monitor.asp L7-8) | ○ |
| C-52 | 全ログ削除 | E-15 (ad_monitor.asp L9-10) | ○ |
| C-53 | 条件指定ログ削除 | E-15 (ad_monitor.asp L12-13) | ○ |
| C-54 | 削除条件のサニタイズ | E-15 (ad_monitor.asp L13) | ○ |
| C-55 | モニタリングログ表示(1000件) | E-15 (ad_monitor.asp L18-21) | ○ |
| C-56 | モニタリングログ表示(5000件) | E-15 (ad_monitor.asp L18-21) | ○ |
| C-57 | ヒット/秒の計算 | E-15 (ad_monitor.asp L37) | ○ |
| C-58 | アプリケーションリセット成功 | E-16 (ad_resetAPP.asp L4-7) | ○ |
| C-59 | 不正なパスワードでリセット拒否 | E-16 (ad_security.asp含む) | ○ |
| C-60 | リモートリセット成功 | E-17 (ad_resetAllAPP.asp L9-16) | ○ |
| C-61 | リモートリセット失敗時 | E-17 (ad_resetAllAPP.asp L13-14) | ○ |
| C-62 | HTTPステータス200以外の処理 | E-17 (ad_resetAllAPP.asp L30-34) | ○ |
| C-63 | 全ページ一覧表示 | E-18 (ad_pageList.asp L5-8) | ○ |
| C-64 | 最近のページのみ表示 | E-18 (ad_pageList.asp L6) | ○ |
| C-65 | visits/dayの計算 | E-18 (ad_pageList.asp L8) | ○ |
| C-66 | アカウント別リファラー集計 | E-19 (ad_refererList.asp L14-27) | ○ |
| C-67 | 特定アカウントのリファラー表示 | E-19 (ad_refererList.asp L29-35) | ○ |
| C-68 | selectedname値のエスケープ | E-19 (ad_refererList.asp L9) | ○ |
| C-69 | リファラーURLのサニタイズ | E-19 (ad_refererList.asp L31) | ○ |
| C-70 | フォーム送信詳細表示 | E-20 (ad_formentries.asp L5-24) | ○ |
| C-71 | 送信統計 | E-20 (ad_formentries.asp L18-23) | ○ |
| C-72 | 最新250件の送信一覧 | E-20 (ad_formentries.asp L25-38) | ○ |
| C-73 | 250件制限の検証 | E-20 (ad_formentries.asp L29) | ○ |
| C-74 | 最新50件のゲストブック表示 | E-21 (ad_gbentries.asp L9-24) | ○ |
| C-75 | ゲストブックの所属サイト表示 | E-21 (ad_gbentries.asp L14) | ○ |
| C-76 | メッセージのHTMLエスケープ | E-21 (ad_gbentries.asp L18) | ○ |
| C-77 | 長文メッセージの省略表示 | E-21 (ad_gbentries.asp L18) | ○ |
| C-78 | アップグレードスクリプト取得・実行 | E-22 (ad_upgrade.asp L6-9) | ○ |
| C-79 | 外部サーバー接続失敗時 | E-22 (ad_upgrade.asp L4) | ○ |
| C-80 | Access型からSQL生成(COUNTER) | E-23 (ad_upgrade2.asp L40) | ○ |
| C-81 | Access型からSQL生成(DATETIME) | E-23 (ad_upgrade2.asp L41) | ○ |
| C-82 | Access型からSQL生成(BIT) | E-23 (ad_upgrade2.asp L42) | ○ |
| C-83 | Access型からSQL生成(TEXT) | E-23 (ad_upgrade2.asp L51) | ○ |
| C-84 | Access型からSQL生成(MEMO) | E-23 (ad_upgrade2.asp L52) | ○ |
| C-85 | SQL Server型生成(INT IDENTITY) | E-24 (ad_upgrade3.asp L40) | ○ |
| C-86 | SQL Server型生成(nvarchar) | E-24 (ad_upgrade3.asp L51) | ○ |
| C-87 | SQL Server型生成(ntext) | E-24 (ad_upgrade3.asp L52) | ○ |
| C-88 | 純粋SQL文生成 | E-25 (ad_upgrade4.asp L11-15) | ○ |
| C-89 | 新規サイト自動作成 | E-26 (ad_cs.asp L5-18) | ○ |
| C-90 | デフォルト値の設定 | E-26 (ad_cs.asp L6-15) | ○ |

## 4) 不足情報（Unknown / Missing）
- **checkCSRF関数の実装詳細**：インクルードファイル（begin.aspまたはbs_initBack.asp）内に定義されている可能性が高い
  - 候補：`asp/includes/functions.asp` / `asp/begin.asp` / `asp/bs_initBack.asp`
- **lockAdmin関数の実装詳細**：logonオブジェクトのメソッドとして定義されているが、クラス定義ファイルが未確認
  - 候補：`asp/includes/cls_logon.asp` / `asp/includes/classes.asp`
- **バリデーションエラー処理**：client.save()やcustomer.save()の失敗時の具体的なエラーメッセージ表示ロジックが未確認
  - 候補：`asp/includes/cls_client.asp` / `asp/includes/cls_customer.asp`
- **cleanup関数の実装**：ad_monitor.aspで使用されるが、定義場所が未確認
  - 候補：`asp/includes/functions.asp`
- **quotRep関数の実装**：XSSエスケープに使用されるが、定義場所が未確認
  - 候補：`asp/includes/functions.asp`

## 5) リスクフラグ（レビュー観点）
- **2（高リスク）**：ad_upgrade.asp - 外部サーバーからのスクリプトをexecuteで実行しており、中間者攻撃やサーバー侵害時のリスクが極めて高い
- **1（中リスク）**：SQLインジェクション対策 - 一部のファイルでは文字列置換（replace）によるエスケープを使用しており、パラメータ化クエリではない
- **1（中リスク）**：CSRF対策 - checkCSRF関数の実装詳細が確認できていないため、対策の有効性を検証する必要あり
- **0（低リスク）**：GetSQLTypeName関数 - 型変換ロジックは明確で、境界値テストで網羅可能

## 6) レビュアーチェックリスト（最小）
- [ ] checkCSRF関数の実装を確認し、トークン検証ロジックが適切か確認
- [ ] lockAdmin関数の実装を確認し、ロック閾値と解除条件を確認
- [ ] ad_upgrade.aspの外部スクリプト実行がプロダクション環境で無効化されているか確認
- [ ] SQLインジェクション対策として、パラメータ化クエリへの移行が必要か評価
- [ ] cleanup/quotRep/sanitize関数の実装を確認し、XSS対策が十分か確認
- [ ] 顧客削除時の関連データ（製品、ゲストブック等）のカスケード削除が適切か確認
