---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 80
  claims_with_evidence: 76
  claims_without_evidence: 4
confidence_derived: 0.95
---

# 根拠レポート：auth.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：76 / 80、根拠なし：4
- 優先レビュー（高）
  1. **UT-AUTH-058**：SHA256空文字列ハッシュの期待値 - 実際のハッシュ値要確認
  2. **UT-AUTH-042**：フォルダ作成処理のファイルシステム依存 - 実行環境依存
  3. **UT-AUTH-074**：blockDefaultPW変数の定義箇所不明 - 設定ファイル要確認
  4. **UT-AUTH-013**：dumpError関数の動作詳細 - 別ファイル参照必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_login.asp` - バックサイトログイン画面
- E-02: `asp/bs_logoff.asp` - バックサイトログオフ画面
- E-03: `asp/bs_security.asp` - セキュリティチェック処理
- E-04: `asp/includes/LogonEdit.asp` - cls_LogonEditクラス定義
- E-05: `asp/includes/sha256.asp` - SHA256ハッシュ関数
- E-06: `asp/includes/secondAdmin.asp` - cls_secondAdminクラス定義
- E-07: `asp/includes/encryption.asp` - Encrypt/decrypt関数
- E-08: `asp/process_login.asp` - ページログイン処理
- E-09: `asp/process_loginIntranet.asp` - イントラネットログイン処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cls_LogonEdit.logonメソッドでadminPassword認証 | E-04 (L22-44) | ○ |
| C-02 | cls_LogonEdit.logonでsecondAdmin認証 | E-04 (L33-35) | ○ |
| C-03 | QS_enableCookieMode有効時のCookie保存 | E-04 (L29-31) | ○ |
| C-04 | 空パスワードでlogon=false | E-04 (L24) | ○ |
| C-05 | 不正パスワードでlogon=false | E-04 (L25) | ○ |
| C-06 | adminPassword空時の挙動 | E-04 (L25) | ○ |
| C-07 | logonAdmin暗号化パスワード認証 | E-04 (L55-66) | ○ |
| C-08 | logonAdmin SHA256認証 | E-04 (L57) | ○ |
| C-09 | logonAdmin空パスワード無視 | E-04 (L56) | ○ |
| C-10 | logonAdmin不正パスワードエラー | E-04 (L61-62) | ○ |
| C-11 | lockAdmin管理者パスワード未設定時終了 | E-04 (L68-73) | ○ |
| C-12 | lockAdminログイン試行回数超過でIP制限 | E-04 (L74-84) | ○ |
| C-13 | lockAdminメール送信処理 | E-04 (L77-80) | △ |
| C-14 | lockBSAdmin正常アクセス許可 | E-04 (L86-98) | ○ |
| C-15 | lockBSAdminブルートフォース防止 | E-04 (L86-98) | ○ |
| C-16 | logonItemパスワード保護なし | E-04 (L99-119) | ○ |
| C-17 | logonItem Cookie認証 | E-04 (L105-112) | ○ |
| C-18 | logonItemパスワード認証・Cookie保存 | E-04 (L113-117) | ○ |
| C-19 | logonItem不正パスワード拒否 | E-04 (L99-119) | ○ |
| C-20 | logonIntranetメールモード認証 | E-04 (L120-165) | ○ |
| C-21 | logonIntranetニックネームモード認証 | E-04 (L127-132) | ○ |
| C-22 | logonIntranet mode1 Cookie永続保存 | E-04 (L139-145) | ○ |
| C-23 | logonIntranet空メール拒否 | E-04 (L122) | ○ |
| C-24 | logonIntranet空パスワード拒否 | E-04 (L122) | ○ |
| C-25 | logonIntranet未登録ユーザー拒否 | E-04 (L134) | ○ |
| C-26 | logonIntranetサイレントユーザー拒否 | E-04 (L129-131) | ○ |
| C-27 | logoff Cookieクリア | E-04 (L175-182) | ○ |
| C-28 | logoffセッションリセット | E-04 (L178-181) | ○ |
| C-29 | logoffBOセッション破棄 | E-04 (L183-188) | ○ |
| C-30 | logoffBOキャッシュクリア | E-04 (L184-186) | ○ |
| C-31 | currentPW SecondAdmin時の返却値 | E-04 (L45-54) | ○ |
| C-32 | currentPW Admin時の返却値 | E-04 (L50-53) | ○ |
| C-33 | currentPW未認証時の返却値 | E-04 (L45-54) | ○ |
| C-34 | resetPWパスワードリセット成功 | E-04 (L195-212) | ○ |
| C-35 | resetPW無効メール拒否 | E-04 (L197) | ○ |
| C-36 | resetPW未登録メール拒否 | E-04 (L202) | ○ |
| C-37 | hasaccess権限あり確認 | E-04 (L213-219) | ○ |
| C-38 | hasaccess権限なしリダイレクト | E-04 (L216-217) | ○ |
| C-39 | getAllPasswordsCS複数パスワード取得 | E-04 (L166-174) | ○ |
| C-40 | getAllPasswordsCS空Cookie時 | E-04 (L167) | ○ |
| C-41 | getUFP Admin時のパス | E-04 (L220-239) | ○ |
| C-42 | getUFPイントラネット時のフォルダ作成 | E-04 (L228-237) | △ |
| C-43 | cls_secondAdmin.check正常検証 | E-06 (L75-94) | ○ |
| C-44 | cls_secondAdmin.check空パスワード | E-06 (L77-79) | ○ |
| C-45 | cls_secondAdmin.check空確認欄 | E-06 (L77-79) | ○ |
| C-46 | cls_secondAdmin.checkパスワード不一致 | E-06 (L80-82) | ○ |
| C-47 | cls_secondAdmin.check adminPasswordと重複禁止 | E-06 (L83-85) | ○ |
| C-48 | cls_secondAdmin.checkデフォルトパスワード禁止 | E-06 (L86-89) | ○ |
| C-49 | cls_secondAdmin.Save新規作成 | E-06 (L95-172) | ○ |
| C-50 | cls_secondAdmin.Save更新 | E-06 (L104-107) | ○ |
| C-51 | cls_secondAdmin.Save検証失敗時の中断 | E-06 (L96-101) | ○ |
| C-52 | cls_secondAdmin.Pick読み込み | E-06 (L12-74) | ○ |
| C-53 | cls_secondAdmin.Pickレコードなし | E-06 (L16-72) | ○ |
| C-54 | cls_secondAdmin.delete削除 | E-06 (L227-231) | ○ |
| C-55 | cls_secondAdmin.getPasswordValues | E-06 (L173-176) | ○ |
| C-56 | cls_secondAdmin.getRequestValues | E-06 (L177-226) | ○ |
| C-57 | SHA256ハッシュ計算 | E-05 (L286-355) | ○ |
| C-58 | SHA256空文字列ハッシュ | E-05 | △ |
| C-59 | SHA256長文字列対応 | E-05 (L245-284) | ○ |
| C-60 | Encrypt文字列暗号化 | E-07 (L28-48) | ○ |
| C-61 | Encrypt数値暗号化（111倍） | E-07 (L30-32) | ○ |
| C-62 | decrypt復号化 | E-07 (L2-27) | ○ |
| C-63 | decrypt数値復号化 | E-07 (L22-23) | ○ |
| C-64 | Encrypt/decrypt可逆性 | E-07 | ○ |
| C-65 | bs_login.aspログイン成功フロー | E-01 (L8-20) | ○ |
| C-66 | bs_login.asp CAPTCHA検証 | E-01 (L9-11) | ○ |
| C-67 | bs_login.aspパスワード検証 | E-01 (L12-23) | ○ |
| C-68 | bs_login.asp試行回数カウント | E-01 (L24) | ○ |
| C-69 | bs_login.aspページリダイレクト | E-01 (L13-19) | ○ |
| C-70 | bs_logoff.aspログオフ処理 | E-02 (L4-9) | ○ |
| C-71 | bs_security.asp認証済みアクセス | E-03 (L7) | ○ |
| C-72 | bs_security.asp Cookie認証モード | E-03 (L8-9) | ○ |
| C-73 | bs_security.asp未認証リダイレクト | E-03 (L10-12) | ○ |
| C-74 | bs_security.aspデフォルトパスワード検出 | E-03 (L76-78) | △ |
| C-75 | bs_security.asp権限自動設定 | E-03 (L17-75) | ○ |
| C-76 | process_login.aspページ認証成功 | E-08 (L2-8) | ○ |
| C-77 | process_login.aspページ認証失敗 | E-08 (L6-7) | ○ |
| C-78 | process_loginIntranet.asp認証成功 | E-09 (L2-23) | ○ |
| C-79 | process_loginIntranet.asp CAPTCHA検証 | E-09 (L4-5) | ○ |
| C-80 | process_loginIntranet.asp認証エラー | E-09 (L21-23) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-13（UT-AUTH-013）**: dumpError関数の実装詳細が別ファイルに存在する可能性
  - 候補：asp/includes/functions.asp / asp/includes/messages.asp
- **C-42（UT-AUTH-042）**: ファイルシステム操作のエラーハンドリング詳細
  - 候補：実行環境でのテスト必要
- **C-58（UT-AUTH-058）**: SHA256空文字列の正確なハッシュ値
  - 候補：実際に実行して確認 / オンラインSHA256ツールで検証
- **C-74（UT-AUTH-074）**: blockDefaultPW変数の定義箇所
  - 候補：asp/config/web_config.asp / asp/includes/constants.asp

## 5) リスクフラグ（レビュー観点）
- **2（高リスク）**: 認証バイパスの可能性（logonメソッドの条件分岐）
  - UT-AUTH-001〜006を重点的にレビュー
- **2（高リスク）**: ブルートフォース攻撃防止の有効性
  - UT-AUTH-012, UT-AUTH-015の実装確認
- **1（中リスク）**: Cookie認証のセキュリティ
  - UT-AUTH-003, UT-AUTH-017, UT-AUTH-018のCookie処理確認
- **1（中リスク）**: 暗号化方式の強度
  - UT-AUTH-060〜064のEncrypt/decryptはROT13類似で可逆性が高い
- **0（低リスク）**: ユーザーフォルダ作成処理
  - UT-AUTH-042のファイルシステム操作

## 6) レビュアーチェックリスト（最小）
- [ ] cls_LogonEdit.logonメソッドの認証ロジックが正しく実装されているか確認
- [ ] ログイン試行回数制限（QS_number_of_allowed_attempts_to_login）の設定値が適切か確認
- [ ] Cookie認証モード（QS_enableCookieMode）のセキュリティリスクを評価
- [ ] SHA256ハッシュ化がパスワード保存に一貫して使用されているか確認
- [ ] Encrypt/decrypt関数の暗号化強度が十分か評価（ROT13類似のため弱い可能性）
- [ ] bs_security.aspのデフォルトパスワード検出が本番環境で機能するか確認
- [ ] cls_secondAdmin.checkのパスワードポリシーが要件を満たしているか確認
- [ ] CAPTCHA検証がすべての認証フローで実装されているか確認
