---
generated_at: 2026-01-24 12:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 97
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：calendar.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：97 / 100、根拠なし：3
- 優先レビュー（高）
  1. **UT-CAL-065 (QSMonthName範囲外)**: 範囲外入力時の動作が明示されていない
  2. **UT-CAL-068 (ajax.txt未存在)**: on error resume nextによる挙動の推定
  3. **UT-CAL-083 (フォントカスタマイズ)**: デフォルト値"Verdana"の仕様根拠不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_ac.asp` - メインルーティングファイル
- E-02: `asp/bs_ac_booking.asp` - 予約編集画面
- E-03: `asp/bs_ac_bookings.asp` - 予約一覧画面
- E-04: `asp/bs_ac_calendar.asp` - カレンダー編集画面
- E-05: `asp/bs_ac_mycals.asp` - カレンダー一覧画面
- E-06: `asp/bs_ac_view.asp` - カレンダービュー表示
- E-07: `asp/bs_ac_menu.asp` - メニューUI
- E-08: `asp/bs_ac_embed.asp` - 埋め込みコード生成
- E-09: `asp/includes/ac_calendar.asp` - cls_Calendarクラス定義
- E-10: `asp/includes/ac_calendarview.asp` - calendarviewクラス定義
- E-11: `asp/includes/ac_calendarbooking.asp` - cls_calendarbookingクラス定義
- E-12: `asp/includes/ac_statuslist.asp` - cls_statusListクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cls_Calendar.pickでIDによるレコード取得 | E-09 (pick関数内のSQL実行) | ○ |
| C-02 | isNumeriekによる数値検証 | E-09 (`if isNumeriek(id) then`) | ○ |
| C-03 | secureフラグによる顧客ID絞り込み | E-09 (`if secure then sql=sql& " and iCustomerID=" & cId`) | ○ |
| C-04 | cls_Calendar.checkで名前必須チェック | E-09 (`if isLeeg(sName) then message.addError`) | ○ |
| C-05 | cls_Calendar.saveでAddNew/Update分岐 | E-09 (`if isLeeg(iId) then rs.AddNew else rs.Open`) | ○ |
| C-06 | cls_Calendar.deleteでカスケード削除 | E-09 (`delete from tblCalendarBooking` + `delete from tblCalendar`) | ○ |
| C-07 | cls_Calendar.mycalsでDictionary返却 | E-09 (`set mycals=server.createObject("scripting.dictionary")`) | ○ |
| C-08 | cls_Calendar.calenderlistでHTMLオプション生成 | E-09 (for each loop + option HTML生成) | ○ |
| C-09 | cls_Calendar.bookingsでDictionary返却 | E-09 (`set bookings=server.createobject("scripting.dictionary")`) | ○ |
| C-10 | cls_calendarbooking.pickでレコード取得 | E-11 (pick関数内のSQL実行) | ○ |
| C-11 | cls_calendarbooking.getRequestValuesでフォーム値取得 | E-11 (`request.form("iStatus")`, etc.) | ○ |
| C-12 | cls_calendarbooking.checkで名前必須 | E-11 (`if isLeeg(sName) then message.addError`) | ○ |
| C-13 | cls_calendarbooking.checkで開始日必須 | E-11 (`if isLeeg(dStartDate) then`) | ○ |
| C-14 | cls_calendarbooking.checkで終了日必須 | E-11 (`if isLeeg(dEndDate) then`) | ○ |
| C-15 | cls_calendarbooking.checkで日付整合性 | E-11 (`if dEndDate<dStartDate then customErrorMessage`) | ○ |
| C-16 | cls_calendarbooking.checkで重複予約チェック | E-11 (4パターンの日付範囲比較ロジック) | ○ |
| C-17 | 半日予約の重複許可条件 | E-11 (`if not (convertBool(bEOnlyMorning) and convertBool(bs(b).bSOnlyAfternoon))`) | ○ |
| C-18 | cls_calendarbooking.saveでAddNew/Update分岐 | E-11 (`if isLeeg(iId) then rs.AddNew`) | ○ |
| C-19 | cls_calendarbooking.deleteでレコード削除 | E-11 (`delete from tblCalendarBooking where iId=`) | ○ |
| C-20 | calendarview.getDaysで予約日マップ生成 | E-10 (getDays関数内のSQL + Dictionary操作) | ○ |
| C-21 | 午後のみ予約でOAサフィックス | E-10 (`days(...)=booking.iStatus & "OA"`) | ○ |
| C-22 | 午前のみ予約でOMサフィックス | E-10 (`days(...)=booking.iStatus & "OM"`) | ○ |
| C-23 | calendarview.viewMonthでHTML生成 | E-10 (viewMonth関数内のHTML組み立て) | ○ |
| C-24 | cls_statusList初期化でステータス3種 | E-12 (`list.Add 20, "Confirmed"`, `17, "Pending"`, `15, "Unavailable"`) | ○ |
| C-25 | cls_statusList.getCSSで背景画像CSS | E-12 (`getCSS=getCSS& C_DIRECTORY_QUICKERSITE & "/fixedImages/Acimages/"`) | ○ |
| C-26 | cls_statusList.getImageでimgタグ | E-12 (`getImage="<img..."`) | ○ |
| C-27 | cls_statusList.showSelectedのsingle/optionモード | E-12 (Select Case mode) | ○ |
| C-28 | QSMonthNameで月名変換 | E-10 (function QSMonthName + select case) | ○ |
| C-29 | QSMonthName範囲外入力時の動作 | **根拠なし** | △ |
| C-30 | bs_ac_view.aspでmonths上限36 | E-06 (`if convertGetal(mm)>36 then mm=36`) | ○ |
| C-31 | bs_ac_view.aspでtime=0/1/2モード | E-06 (select case request.querystring("time")) | ○ |
| C-32 | bs_ac_view.aspでAJAXナビゲーション | E-06 (session操作 + prev/next処理) | ○ |
| C-33 | bs_ac_view.aspでlegend表示制御 | E-06 (`if request.querystring("legend")<>"false" then`) | ○ |
| C-34 | bs_ac_view.aspでmode=js/html/if出力 | E-06 (select case request.querystring("mode")) | ○ |
| C-35 | getAjaxJSでajax.txt読み込み | E-06 (`fso.opentextfile(server.mappath("ajax.txt"))`) | ○ |
| C-36 | getAjaxJSでファイル未存在時の挙動 | E-06 (`on error resume next`による推定) | △ |
| C-37 | bs_ac_view.aspで背景色適用 | E-06 (`if not isleeg(cal.sBGcolor) then response.write cal.sBGcolor`) | ○ |
| C-38 | bs_ac_view.aspでフォントファミリ適用 | E-06 (デフォルト"Verdana"の仕様根拠不明) | △ |
| C-39 | bs_ac_booking.aspでseeNotes表示 | E-02 (`if request.querystring("seeNotes")<>"" then`) | ○ |
| C-40 | bs_ac_booking.aspでSave/Delete処理 | E-02 (select case request.form("btAct")) | ○ |
| C-41 | bs_ac_calendar.aspでSave/Delete処理 | E-04 (select case request.form("btnName")) | ○ |
| C-42 | bs_ac_mycals.aspで0件メッセージ | E-05 (`if mycals.count=0 then response.write "No calendars yet."`) | ○ |
| C-43 | bs_ac_embed.aspで埋め込みコード3種生成 | E-08 (embedJSCode, embedIFcode, embedHTMLcode変数) | ○ |
| C-44 | bs_ac.aspでルーティング制御 | E-01 (select case lcase(action)) | ○ |

## 4) 不足情報（Unknown / Missing）
- **QSMonthName範囲外入力**: Select Caseに13以上/0以下の分岐がないため、空文字返却と推定したが明示的なコードなし
  - 候補：VBScriptのデフォルト動作 / エラー発生 / 空文字
- **ajax.txt未存在時の動作**: `on error resume next`があるためエラーは握りつぶされるが、戻り値は未定義
  - 候補：空文字 / Nothing / 実行時エラー
- **デフォルトフォント"Verdana"の仕様根拠**: コード内ハードコードだが、要件としての根拠文書なし
  - 候補：デザイン仕様書 / 顧客要件

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - cls_Calendar, cls_calendarbooking, calendarviewの主要メソッド（根拠明確）
- **1: 中リスク** - 半日予約の重複チェックロジック（条件が複雑で網羅性確認推奨）
- **1: 中リスク** - セッション操作によるナビゲーション（状態管理の正確性確認推奨）
- **2: 高リスク** - SQLインジェクション脆弱性の可能性（`left(id,9)`による制限はあるが要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] 重複予約チェック（UT-CAL-031〜036）の境界条件が正しいか
- [ ] secureフラグによるアクセス制御（UT-CAL-005, 006）がセキュリティ要件を満たすか
- [ ] 半日予約（OA/OMサフィックス）の表示ロジックが仕様と一致するか
- [ ] カスケード削除（UT-CAL-013）が意図した動作か（関連予約も全削除）
- [ ] AJAX prev/nextナビゲーションのセッション管理が正しいか
- [ ] 範囲外月数入力（QSMonthName）のエッジケース対応が必要か判断
