---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 147
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：catalog.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：147 / 150、根拠なし：3
- 優先レビュー（高）
  1. **UT-CAT-133〜140（ファイルアップロード系）**：物理ファイル操作のため実機検証推奨
  2. **UT-CAT-149〜150（CSRF対策）**：セキュリティ関連のため詳細検証推奨
  3. **UT-CAT-095〜099（checkOnline）**：アクセス制御の網羅性要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/catalog.asp` - cls_catalogクラス定義（337行）
- E-02: `asp/includes/catalogField.asp` - cls_catalogFieldクラス定義（194行）
- E-03: `asp/includes/catalogFileType.asp` - cls_catalogFileTypeクラス定義（79行）
- E-04: `asp/includes/catalogItem.asp` - cls_catalogItemクラス定義（410行）
- E-05: `asp/includes/catalogItemFile.asp` - cls_catalogItemFileクラス定義（103行）
- E-06: `asp/includes/catalogOrderBYList.asp` - cls_catalogOrderByListクラス定義（40行）
- E-07: `asp/includes/ItemSearch.asp` - cls_itemSearchクラス定義（342行）
- E-08: `asp/bs_catalogList.asp` - カタログ一覧画面（23行）
- E-09: `asp/bs_catalogEdit.asp` - カタログ編集画面（42行）
- E-10: `asp/bs_catalogFieldEdit.asp` - フィールド編集画面（23行）
- E-11: `asp/bs_catalogFileTypeEdit.asp` - ファイルタイプ編集画面（16行）
- E-12: `asp/bs_catalogItemEdit.asp` - アイテム編集画面（72行）
- E-13: `asp/bs_catalogItemSearch.asp` - アイテム検索画面（31行）
- E-14: `asp/bs_catalogItemPic.asp` - 画像アップロード画面（6行）
- E-15: `asp/bs_catalogItemPicUpload.asp` - 画像アップロード処理（50行）
- E-16: `asp/bs_catalogItemFile.asp` - ファイルアップロード画面（8行）
- E-17: `asp/bs_catalogItemFileUpload.asp` - ファイルアップロード処理（52行）
- E-18: `asp/bs_catalog.asp` - カタログ選択UI部品（3行）

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_catalog（UT-CAT-001〜036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Class_Initialize初期化時のデフォルト値設定 | E-01 (25-42行目) | ○ |
| C-02 | Pick関数でのデータ取得ロジック | E-01 (43-76行目) | ○ |
| C-03 | Check関数での必須バリデーション | E-01 (84-99行目) | ○ |
| C-04 | Save関数での新規/更新処理分岐 | E-01 (101-149行目) | ○ |
| C-05 | correFP関数でのパス正規化 | E-01 (9-23行目) | ○ |
| C-06 | statusプロパティのオンライン判定 | E-01 (77-83行目) | ○ |
| C-07 | getRequestValues関数でのフォーム値取得 | E-01 (163-189行目) | ○ |
| C-08 | fields関数でのフィルタ付きフィールド取得 | E-01 (244-266行目) | ○ |
| C-09 | filetypes関数でのファイルタイプ取得 | E-01 (228-243行目) | ○ |
| C-10 | items関数でのアイテム取得 | E-01 (267-281行目) | ○ |
| C-11 | remove関数でのカスケード削除 | E-01 (201-227行目) | ○ |
| C-12 | clearRSSCache関数でのキャッシュクリア | E-01 (150-162行目) | ○ |
| C-13 | copy関数でのカタログ複製 | E-01 (299-315行目) | ○ |
| C-14 | copyToCustomer関数での顧客間コピー | E-01 (316-336行目) | ○ |

### cls_catalogField（UT-CAT-037〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | Class_Initialize初期化とデフォルト値 | E-02 (12-21行目) | ○ |
| C-16 | Pick関数でのフィールドデータ取得 | E-02 (22-40行目) | ○ |
| C-17 | Check関数での条件付きバリデーション | E-02 (41-55行目) | ○ |
| C-18 | Save関数でのiRang自動設定 | E-02 (56-103行目) | ○ |
| C-19 | moveUp/moveDown関数での並び順変更 | E-02 (138-157行目) | ○ |
| C-20 | remove関数での関連データ削除 | E-02 (158-168行目) | ○ |
| C-21 | showSelected関数でのoption生成 | E-02 (169-186行目) | ○ |
| C-22 | copy関数でのフィールド複製 | E-02 (187-193行目) | ○ |

### cls_catalogFileType（UT-CAT-057〜066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | Class_Initialize初期化 | E-03 (6-12行目) | ○ |
| C-24 | Pick関数でのファイルタイプ取得 | E-03 (13-25行目) | ○ |
| C-25 | Check関数でのsName必須チェック | E-03 (26-32行目) | ○ |
| C-26 | Save関数での新規/更新処理 | E-03 (33-54行目) | ○ |
| C-27 | remove関数での関連ファイル削除 | E-03 (59-67行目) | ○ |
| C-28 | copy関数でのファイルタイプ複製 | E-03 (72-78行目) | ○ |

### cls_catalogItem（UT-CAT-067〜101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | Class_Initialize初期化とfields Dictionary | E-04 (5-14行目) | ○ |
| C-30 | Pick関数でのアイテム・フィールド値取得 | E-04 (50-79行目) | ○ |
| C-31 | Check関数での動的必須バリデーション | E-04 (80-99行目) | ○ |
| C-32 | Save関数でのアイテム・フィールド値保存 | E-04 (100-148行目) | ○ |
| C-33 | getRequestValues関数での型別変換処理 | E-04 (149-167行目) | ○ |
| C-34 | catalog関数でのキャッシュ付きカタログ取得 | E-04 (168-174行目) | ○ |
| C-35 | files関数でのファイル一覧取得 | E-04 (202-216行目) | ○ |
| C-36 | submissions関数での送信一覧取得 | E-04 (217-231行目) | ○ |
| C-37 | remove関数でのカスケード削除 | E-04 (175-194行目) | ○ |
| C-38 | removePic関数での画像削除 | E-04 (41-49行目) | ○ |
| C-39 | showPic関数でのサムネイル表示分岐 | E-04 (18-40行目) | ○ |
| C-40 | sFiche/sFicheRSS/sFicheITEMVIEWでのテンプレート処理 | E-04 (239-370行目) | ○ |
| C-41 | checkOnline関数でのアクセス制御 | E-04 (371-384行目) | ○ |
| C-42 | copy関数でのアイテム・ファイル複製 | E-04 (385-406行目) | ○ |

### cls_catalogItemFile（UT-CAT-102〜112）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | Class_Initialize初期化 | E-05 (13-15行目) | ○ |
| C-44 | Pick関数でのファイル情報取得 | E-05 (26-42行目) | ○ |
| C-45 | catalogitem関数でのキャッシュ付き親取得 | E-05 (17-23行目) | ○ |
| C-46 | url/simpleurlプロパティでのURL生成 | E-05 (43-54行目) | ○ |
| C-47 | Save関数でのファイルレコード保存 | E-05 (56-75行目) | ○ |
| C-48 | remove関数でのファイル・レコード削除 | E-05 (76-86行目) | ○ |
| C-49 | copy関数でのファイル複製 | E-05 (87-102行目) | ○ |

### cls_catalogOrderByList（UT-CAT-113〜115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | Class_Initializeでのソートオプション定義 | E-06 (11-20行目) | ○ |
| C-51 | showSelected関数でのoption/single形式出力 | E-06 (24-39行目) | ○ |

### cls_itemSearch（UT-CAT-116〜132）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | Class_Initialize初期化とページング設定 | E-07 (18-41行目) | ○ |
| C-53 | getRequestValues関数での検索条件取得 | E-07 (114-134行目) | ○ |
| C-54 | fixedSQL関数での動的SQL生成 | E-07 (42-113行目) | ○ |
| C-55 | getRows関数での検索実行 | E-07 (135-153行目) | ○ |
| C-56 | resultItems関数でのページング付きオブジェクト取得 | E-07 (154-188行目) | ○ |
| C-57 | resultTable関数でのHTML/Excel出力 | E-07 (216-293行目) | ○ |
| C-58 | browseTable関数でのページングUI生成 | E-07 (189-206行目) | ○ |
| C-59 | First_Record/Last_Recordプロパティ | E-07 (207-215行目) | ○ |

### ASPページ処理（UT-CAT-133〜150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | 画像アップロード処理とバリデーション | E-15 (1-49行目) | ○ |
| C-61 | ファイルアップロード処理とバリデーション | E-17 (1-51行目) | ○ |
| C-62 | MoveUP/MoveDOWN処理 | E-08 (7-13行目) | ○ |
| C-63 | カタログ保存/削除処理 | E-09 (11-20行目) | ○ |
| C-64 | アイテム保存/削除処理 | E-12 (15-43行目) | ○ |
| C-65 | CSRF検証（checkCSRF呼び出し） | E-08, E-09, E-10, E-11, E-12 (各ファイル) | ○ |
| C-66 | allowedFileTypesforThumbing定数の定義場所 | **根拠なし** | △ |
| C-67 | allowedFileTypes定数の定義場所 | **根拠なし** | △ |
| C-68 | checkCSRF_Upload関数の定義場所 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **allowedFileTypesforThumbing / allowedFileTypes定数**
  - 候補：`asp/includes/constants.asp` / `asp/begin.asp` / `asp/includes/functions.asp`
  - 対象テストケース：UT-CAT-133〜140
  - 影響：許可されるファイル拡張子の完全なリストが不明

- **checkCSRF_Upload関数の実装詳細**
  - 候補：`asp/includes/security.asp` / `asp/includes/functions.asp`
  - 対象テストケース：UT-CAT-149〜150
  - 影響：アップロード時のCSRF検証ロジックの詳細が不明

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 理由 |
|---|---|---|
| 2（高） | UT-CAT-095〜099 | アクセス制御のバイパス可能性検証が必要 |
| 2（高） | UT-CAT-133〜140 | ファイルアップロードはセキュリティ上重要 |
| 2（高） | UT-CAT-149〜150 | CSRF対策の検証は必須 |
| 1（中） | UT-CAT-029〜031 | カスケード削除のデータ整合性確認必要 |
| 1（中） | UT-CAT-118〜121 | SQLインジェクション対策確認必要 |
| 0（低） | その他 | 通常のCRUD操作 |

## 6) レビュアーチェックリスト（最小）

### 必須確認項目
- [ ] cls_catalogItem.checkOnlineのアクセス制御ロジックが適切か（UT-CAT-095〜099）
- [ ] ファイルアップロードの拡張子チェックが十分か（UT-CAT-133〜140）
- [ ] CSRF対策が全てのPOST操作に適用されているか（UT-CAT-149〜150）
- [ ] SQLクエリにおけるユーザー入力のサニタイズ（fixedSQL関数等）

### 推奨確認項目
- [ ] カスケード削除時の関連データ整合性（UT-CAT-029, 081）
- [ ] ファイルコピー時のエラーハンドリング（UT-CAT-100, 112）
- [ ] ページング計算の境界値（UT-CAT-125, 130, 131）

### 実機テスト推奨項目
- [ ] 大容量ファイルアップロード（5MB/6MB境界）
- [ ] 不正な拡張子でのアップロード試行
- [ ] 同時アクセス時のファイル操作競合
