---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 57
  claims_with_evidence: 52
  claims_without_evidence: 5
confidence_derived: 0.91
---

# 根拠レポート：constant.csv (単体テストケース一覧)

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：52 / 57、根拠なし：5
- 優先レビュー（高）
  1. **C-27, C-28, C-29 (bOnline境界値)**: isBetween関数の仕様詳細が不明
  2. **C-53 (エラーハンドリング)**: executeConstant関数の実装詳細が不明
  3. **C-49 (スクリプト実行)**: executeConstant関数のテスト環境での挙動確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/asp/includes/constant.asp` - cls_constantクラス定義（全113行）
- E-02: `/asp/includes/constants.asp` - システム定数定義（全115行）
- E-03: `/asp/bs_constantList.asp` - 定数一覧画面（全14行）
- E-04: `/asp/bs_constantEdit.asp` - 定数編集画面（全47行）
- E-05: `/asp/bs_constantTest.asp` - VBScriptテスト画面（全10行）
- E-06: `/asp/docs/code-to-docs/単体テストケース一覧/plan.md` - モジュール定義

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_constant クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Class_InitializeでiIdがnullで初期化される | E-01 (行6: `iId = null`) | ○ |
| C-02 | 初期化時にiContentIdを復号してPickが呼ばれる | E-01 (行8: `pick(decrypt(request("iContentId")))`) | ○ |
| C-03 | On Error Resume Nextでエラーが無視される | E-01 (行5: `On Error Resume Next`) | ○ |
| C-04 | Pick関数でSQLによりレコードが取得される | E-01 (行12-27: Pick関数定義) | ○ |
| C-05 | 存在しないIDでプロパティが変更されない | E-01 (行16-25: `if not rs.eof then`で条件付き設定) | ○ |
| C-06 | isNumeriek(id)でSQLインジェクション対策 | E-01 (行13: `if isNumeriek(id) then`) | ○ |
| C-07 | IDがnullの場合SQLが実行されない | E-01 (行13) | ○ |
| C-08 | IDが0の場合の挙動 | E-01 (行13: isNumeriekは0をtrueと判定する可能性) | ○ |
| C-09 | Check関数で有効なデータでtrueが返る | E-01 (行29-48: Check関数定義) | ○ |
| C-10 | 角括弧が除去される | E-01 (行31-32: Replace関数) | ○ |
| C-11 | 空のsConstantでerr_mandatoryエラー | E-01 (行33-36) | ○ |
| C-12 | 空のsValueでerr_mandatoryエラー | E-01 (行37-40) | ○ |
| C-13 | 重複定数名でerr_constantエラー | E-01 (行41-47) | ○ |
| C-14 | 自身のレコードは重複チェックから除外 | E-01 (行42: `iId<>` で自己参照除外) | ○ |
| C-15 | 新規レコードがAddNewで作成される | E-01 (行58-61: `rs.AddNew`) | ○ |
| C-16 | 既存レコードが更新される | E-01 (行62: 既存レコードをOpen) | ○ |
| C-17 | 定数名が大文字変換される | E-01 (行64: `ucase(left(sConstant,50))`) | ○ |
| C-18 | 定数名が50文字に切り詰められる | E-01 (行64: `left(sConstant,50)`) | ○ |
| C-19 | 保存後にcacheConstantsが呼ばれる | E-01 (行76: `customer.cacheConstants()`) | ○ |
| C-20 | Check失敗時にSave=falseで終了 | E-01 (行50-55) | ○ |
| C-21 | getRequestValuesでフォーム値が取得される | E-01 (行78-86) | ○ |
| C-22 | sConstantがtrimされる | E-01 (行79: `trim(convertStr(...))`) | ○ |
| C-23 | 日付がconvertDateFromPickerで変換される | E-01 (行82-83) | ○ |
| C-24 | 空リクエストでも例外が発生しない | E-01 (行78-86: convertStr/convertGetal使用) | ○ |
| C-25 | bOnlineでオンライン期間内判定 | E-01 (行87-89: `isBetween(dOnlineFrom,date,dOnlineUntill)`) | ○ |
| C-26 | bOnlineでオフライン期間外判定 | E-01 (行87-89) | ○ |
| C-27 | 開始日と同日でtrue | E-01 (行88) - **isBetween関数の仕様詳細不明** | △ |
| C-28 | 終了日と同日でtrue | E-01 (行88) - **isBetween関数の仕様詳細不明** | △ |
| C-29 | 日付がnullの場合の挙動 | E-01 (行88) - **isBetween関数のnull処理不明** | △ |
| C-30 | statusStringでオンライン時の文字列 | E-01 (行90-96) | ○ |
| C-31 | statusStringでオフライン時のスタイル付き文字列 | E-01 (行94: spanタグ生成) | ○ |
| C-32 | removeでレコードが削除される | E-01 (行97-104: DELETE SQL) | ○ |
| C-33 | 削除後にcacheConstantsが呼ばれる | E-01 (行102: `customer.cacheConstants()`) | ○ |
| C-34 | iIdが空の場合削除されない | E-01 (行98: `if not isLeeg(iId) then`) | ○ |
| C-35 | copyでレコードがコピーされる | E-01 (行105-111) | ○ |
| C-36 | コピー時に名前にプレフィックス付加 | E-01 (行108: `l("copyof") & " " & sConstant`) | ○ |
| C-37 | 数値でないIDでコピーされない | E-01 (行106: `if isNumeriek(iId) then`) | ○ |

### bs_constantList.asp

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | 定数一覧が表示される | E-03 (行6-11: forループで一覧生成) | ○ |
| C-39 | VBScriptタイプが除外される | E-03 (行10: `if QS_VBScript<>cconstants(keyconstants).iType then`) | ○ |
| C-40 | bHomeConstantsでアクセス制御 | E-03 (行4: `logon.hasaccess secondAdmin.bHomeConstants`) | ○ |

### bs_constantEdit.asp

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | 有効データで定数が保存される | E-04 (行10-15: save処理) | ○ |
| C-42 | CSRF検証が実行される | E-04 (行11: `checkCSRF()`) | ○ |
| C-43 | VBScriptタイプでbs_scriptlistへリダイレクト | E-04 (行19-20) | ○ |
| C-44 | その他タイプでbs_constantlistへリダイレクト | E-04 (行21-23) | ○ |
| C-45 | 使用箇所が検索される | E-04 (行33-43: cls_fullSearch使用) | ○ |
| C-46 | QS_textonlyでテキストエリア表示 | E-04 (行31: `case QS_textonly`) | ○ |
| C-47 | QS_htmlでFCKエディタ表示 | E-04 (行31: `case QS_html`) | ○ |
| C-48 | QS_VBScriptでVBScript編集フォーム表示 | E-04 (行31: `case QS_VBScript`) | ○ |

### bs_constantTest.asp

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | VBScriptが正しく実行される | E-05 (行7: `executeConstant(...)`) | ○ |
| C-50 | パラメータ付きスクリプトが実行される | E-05 (行7: sParametersValues引数) | ○ |
| C-51 | checkCSRFが呼ばれる | E-05 (行5: `checkCSRF()`) | ○ |
| C-52 | bHomeVBScriptでアクセス制御 | E-05 (行4: `logon.hasaccess secondAdmin.bHomeVBScript`) | ○ |
| C-53 | 不正スクリプトでエラー表示 | E-05 (行7) - **executeConstant内のエラーハンドリング詳細不明** | △ |

### constants.asp

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | アクション定数が定義されている | E-02 (行2-24) | ○ |
| C-55 | メニューボタン定数が定義されている | E-02 (行30-65) | ○ |
| C-56 | フォーマット定数が定義されている | E-02 (行79-82) | ○ |
| C-57 | キャッシュキーがcIdで一意化 | E-02 (行90-111: `& cId`) - **cId変数の定義元不明** | △ |

## 4) 不足情報（Unknown / Missing）

1. **isBetween関数の仕様**
   - 候補: `/asp/includes/functions.asp` / `/asp/includes/utils.asp` / 組み込み関数
   - 境界値（開始日・終了日の当日を含むか）の仕様確認が必要

2. **executeConstant関数の実装**
   - 候補: `/asp/includes/functions.asp` / `/asp/includes/process.asp`
   - エラーハンドリング、テストモードフラグの挙動確認が必要

3. **cId変数のスコープと初期化**
   - 候補: `/asp/begin.asp` / `/asp/includes/customer.asp`
   - マルチテナント環境でのcId取得方法の確認

4. **customer.cacheConstants()の実装**
   - 候補: `/asp/includes/customer.asp`
   - キャッシュの保存先、有効期限の確認

## 5) リスクフラグ（レビュー観点）

| リスク | 対象 | 説明 |
|--------|------|------|
| 2 (高) | C-06 SQLインジェクション | isNumeriek関数の実装が正しくSQLインジェクションを防いでいるか要確認 |
| 2 (高) | C-42, C-51 CSRF | checkCSRF関数の実装が適切か要確認 |
| 1 (中) | C-49, C-53 動的コード実行 | VBScriptの動的実行はセキュリティリスクが高い。executeConstant関数のサンドボックス化確認が必要 |
| 1 (中) | C-13 重複チェック | 大文字変換前の比較か後の比較かで挙動が変わる可能性 |
| 0 (低) | C-30, C-31 表示文字列 | 表示のみでセキュリティ影響なし |

## 6) レビュアーチェックリスト（最小）

- [ ] isBetween関数の境界値仕様を確認（開始日・終了日を含むか）
- [ ] executeConstant関数のエラーハンドリングとセキュリティ対策を確認
- [ ] isNumeriek関数がSQLインジェクションを完全に防いでいるか確認
- [ ] checkCSRF関数のトークン検証ロジックを確認
- [ ] cId変数のスコープとセッション管理を確認
- [ ] VBScript実行環境でのサンドボックス化の有無を確認
- [ ] 定数名の重複チェックが大文字変換後に行われていることを確認
