---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 133
  claims_with_evidence: 131
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：contact 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコードの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべきソースコードを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：131 / 133、根拠なし：2
- 優先レビュー（高）
  1. **UT-CON-113 Excel出力機能**：cls_excelfileの実装詳細は本モジュール外
  2. **UT-CON-124 bs_massMailing2.asp**：インクルードファイルの詳細は別モジュール

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/asp/includes/contact.asp` - cls_contactクラス定義（596行）
- E-02: `/asp/includes/contactField.asp` - cls_contactFieldクラス定義（187行）
- E-03: `/asp/includes/contactSearch.asp` - cls_contactSearchクラス定義（327行）
- E-04: `/asp/includes/contactStatusList.asp` - cls_contactStatusListクラス定義（51行）
- E-05: `/asp/includes/contactFieldTypeList.asp` - cls_contactFieldTypeListクラス定義（37行）
- E-06: `/asp/bs_contactHome.asp` - 連絡先一覧・検索画面（31行）
- E-07: `/asp/bs_contactEdit.asp` - 連絡先編集画面（49行）
- E-08: `/asp/bs_contactPage.asp` - 権限管理画面（31行）
- E-09: `/asp/bs_contactFields.asp` - フィールド一覧画面（18行）
- E-10: `/asp/bs_contactFieldEdit.asp` - フィールド編集画面（26行）
- E-11: `/asp/bs_contactSelectionActions.asp` - 一括操作画面（50行）
- E-12: `/asp/fs_mailcontact.asp` - プライベートメール送信画面（34行）

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_contact クラス（E-01）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-CON-001) | Class_Initializeでフィールドが初期化される | E-01 L5-19 | ○ |
| C-02 (UT-CON-002) | Class_InitializeでPick処理が実行される | E-01 L17 | ○ |
| C-03 (UT-CON-003) | Pickで有効なIDでデータ取得 | E-01 L45-79 | ○ |
| C-04 (UT-CON-004) | Pickで数値以外のIDは処理しない | E-01 L47 isNumeriekチェック | ○ |
| C-05 (UT-CON-005) | 存在しないIDはデータ読み込まれない | E-01 L50 rs.eofチェック | ○ |
| C-06 (UT-CON-006) | 他カスタマーのデータアクセス拒否 | E-01 L65 Response.End | ○ |
| C-07 (UT-CON-007) | quickPickでフィールド値を読み込まない | E-01 L20-44 | ○ |
| C-08 (UT-CON-008) | Check正常系バリデーション | E-01 L80-128 | ○ |
| C-09 (UT-CON-009) | メールアドレス空チェック | E-01 L94-96 | ○ |
| C-10 (UT-CON-010) | メール形式チェック | E-01 L97-99 CheckEmailSyntax | ○ |
| C-11 (UT-CON-011) | パスワード空チェック | E-01 L103-106 | ○ |
| C-12 (UT-CON-012) | ニックネーム空チェック | E-01 L107-110 | ○ |
| C-13 (UT-CON-013) | メール重複チェック | E-01 L115-119 | ○ |
| C-14 (UT-CON-014) | ニックネーム重複チェック | E-01 L121-126 | ○ |
| C-15 (UT-CON-015) | allowDE=trueで重複許可 | E-01 L112-113 | ○ |
| C-16 (UT-CON-016) | カスタムフィールド必須チェック | E-01 L86-93 | ○ |
| C-17 (UT-CON-017) | Save新規作成 | E-01 L153-225 | ○ |
| C-18 (UT-CON-018) | Save更新処理 | E-01 L166-167 | ○ |
| C-19 (UT-CON-019) | カスタムフィールド保存 | E-01 L184-199 | ○ |
| C-20 (UT-CON-020) | バリデーションエラー時false | E-01 L154-159 | ○ |
| C-21 (UT-CON-021) | ステータス変更時メール通知 | E-01 L211-224 | ○ |
| C-22 (UT-CON-022) | 重複メール自動削除 | E-01 L200-209 | ○ |
| C-23 (UT-CON-023) | getRequestValues | E-01 L226-246 | ○ |
| C-24 (UT-CON-024) | 日付型変換 | E-01 L236 convertCalcDate | ○ |
| C-25 (UT-CON-025) | 非表示フィールド処理 | E-01 L229-232 | ○ |
| C-26 (UT-CON-026) | delete処理 | E-01 L247-271 | ○ |
| C-27 (UT-CON-027) | アバターファイル削除 | E-01 L249 removeAvatar | ○ |
| C-28 (UT-CON-028) | delete IDチェック | E-01 L248 isNumeriek | ○ |
| C-29 (UT-CON-029) | posts取得 | E-01 L272-287 | ○ |
| C-30 (UT-CON-030) | posts空データ | E-01 L273-274 | ○ |
| C-31 (UT-CON-031) | resetPW | E-01 L288-306 | ○ |
| C-32 (UT-CON-032) | メールテンプレート置換 | E-01 L297-303 | ○ |
| C-33 (UT-CON-033) | lastLoginTSSave | E-01 L129-140 | ○ |
| C-34 (UT-CON-034) | lastLoginTSSave ID=0チェック | E-01 L131 | ○ |
| C-35 (UT-CON-035) | lastLogoutTSSave | E-01 L141-152 | ○ |
| C-36 (UT-CON-036) | bHasSubscribedToTheme true | E-01 L307-323 | ○ |
| C-37 (UT-CON-037) | bHasSubscribedToTheme false | E-01 L313 | ○ |
| C-38 (UT-CON-038) | bHasSubscribedToTheme IDチェック | E-01 L308, 321 | ○ |
| C-39 (UT-CON-039) | bHasSubscribedToTopic true | E-01 L324-337 | ○ |
| C-40 (UT-CON-040) | bHasSubscribedToTopic false | E-01 L329 | ○ |
| C-41 (UT-CON-041) | getTPer | E-01 L338-352 | ○ |
| C-42 (UT-CON-042) | getBPer | E-01 L353-367 | ○ |
| C-43 (UT-CON-043) | getLPer | E-01 L368-382 | ○ |
| C-44 (UT-CON-044) | savePermissions | E-01 L383-426 | ○ |
| C-45 (UT-CON-045) | savePermissions既存削除 | E-01 L386-387 | ○ |
| C-46 (UT-CON-046) | createUserFilesFolder | E-01 L427-437 | ○ |
| C-47 (UT-CON-047) | createUserFilesFolder冪等性 | E-01 L430-435 FolderExistsチェック | ○ |
| C-48 (UT-CON-048) | removeAvatar | E-01 L449-464 | ○ |
| C-49 (UT-CON-049) | removeAvatar複数形式 | E-01 L456-461 | ○ |
| C-50 (UT-CON-050) | saveAvatar | E-01 L465-471 | ○ |
| C-51 (UT-CON-051) | sImgTagAvatar gif | E-01 L472-491 | ○ |
| C-52 (UT-CON-052) | sImgTagAvatar jpg | E-01 L482-485 | ○ |
| C-53 (UT-CON-053) | sImgTagAvatar ボーダー | E-01 L473-477 | ○ |
| C-54 (UT-CON-054) | getAvatar アバターあり | E-01 L492-546 | ○ |
| C-55 (UT-CON-055) | getAvatar Gravatarフォールバック | E-01 L534-544 | ○ |
| C-56 (UT-CON-056) | getAvatar bUseAvatars | E-01 L493 | ○ |
| C-57 (UT-CON-057) | getClickAvatar | E-01 L547-587 | ○ |
| C-58 (UT-CON-058) | sClickNickName リンク付き | E-01 L438-448 | ○ |
| C-59 (UT-CON-059) | sClickNickName プレーン | E-01 L445 | ○ |
| C-60 (UT-CON-060) | sEmailorNickname モード0 | E-01 L588-595 | ○ |
| C-61 (UT-CON-061) | sEmailorNickname モード1 | E-01 L593 | ○ |

### cls_contactField クラス（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 (UT-CON-062) | Class_Initialize | E-02 L12-20 | ○ |
| C-63 (UT-CON-063) | Pick正常系 | E-02 L21-39 | ○ |
| C-64 (UT-CON-064) | Pick存在チェック | E-02 L26 rs.eofチェック | ○ |
| C-65 (UT-CON-065) | Check正常系 | E-02 L40-58 | ○ |
| C-66 (UT-CON-066) | Check sType空 | E-02 L42-45 | ○ |
| C-67 (UT-CON-067) | Check sFieldName空 | E-02 L46-49 | ○ |
| C-68 (UT-CON-068) | Check sb_select sValues空 | E-02 L50-53 | ○ |
| C-69 (UT-CON-069) | Check bMandatory/bProfile矛盾 | E-02 L54-57 | ○ |
| C-70 (UT-CON-070) | Save新規 | E-02 L59-106 | ○ |
| C-71 (UT-CON-071) | Save更新 | E-02 L76-77 | ○ |
| C-72 (UT-CON-072) | Save新規時ContactValues追加 | E-02 L91-105 | ○ |
| C-73 (UT-CON-073) | getRequestValues | E-02 L107-115 | ○ |
| C-74 (UT-CON-074) | isMandatory true | E-02 L116-122 | ○ |
| C-75 (UT-CON-075) | isMandatory false | E-02 L119-121 | ○ |
| C-76 (UT-CON-076) | isSearchField | E-02 L123-129 | ○ |
| C-77 (UT-CON-077) | isProfileField | E-02 L130-136 | ○ |
| C-78 (UT-CON-078) | moveUp | E-02 L137-146 | ○ |
| C-79 (UT-CON-079) | moveUp iRang=1 | E-02 L139-140 | ○ |
| C-80 (UT-CON-080) | moveUp IDチェック | E-02 L138 | ○ |
| C-81 (UT-CON-081) | moveDown | E-02 L147-156 | ○ |
| C-82 (UT-CON-082) | moveDown 最大iRang | E-02 L149-150 | ○ |
| C-83 (UT-CON-083) | remove | E-02 L157-167 | ○ |
| C-84 (UT-CON-084) | remove iRang調整 | E-02 L160 | ○ |
| C-85 (UT-CON-085) | showSelected | E-02 L168-185 | ○ |
| C-86 (UT-CON-086) | showSelected空 | E-02 L171 split処理 | ○ |

### cls_contactSearch クラス（E-03）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 (UT-CON-087) | Class_Initialize | E-03 L15-36 | ○ |
| C-88 (UT-CON-088) | pageSize デフォルト | E-03 L21-29 | ○ |
| C-89 (UT-CON-089) | getRequestValues | E-03 L37-53 | ○ |
| C-90 (UT-CON-090) | getRequestValues 日付範囲 | E-03 L43-48 | ○ |
| C-91 (UT-CON-091) | getRows正常系 | E-03 L54-139 | ○ |
| C-92 (UT-CON-092) | getRows メール検索 | E-03 L72-74 | ○ |
| C-93 (UT-CON-093) | getRows ニックネーム検索 | E-03 L75-77 | ○ |
| C-94 (UT-CON-094) | getRows ステータスフィルタ | E-03 L78-80 | ○ |
| C-95 (UT-CON-095) | getRows 日付範囲検索 | E-03 L96-120 | ○ |
| C-96 (UT-CON-096) | getRows 0件時null | E-03 L133-134 | ○ |
| C-97 (UT-CON-097) | getRows pageSize制限 | E-03 L125 | ○ |
| C-98 (UT-CON-098) | resultTable HTML | E-03 L140-226 | ○ |
| C-99 (UT-CON-099) | resultTable Excel | E-03 L219-225 cls_excelfile | △ |
| C-100 (UT-CON-100) | resultTable アバター | E-03 L150-151, 249-271 | ○ |
| C-101 (UT-CON-101) | addRow CSSクラス | E-03 L227-283 | ○ |
| C-102 (UT-CON-102) | getContactsByStatus | E-03 L296-311 | ○ |
| C-103 (UT-CON-103) | getContactsByStatus 全件 | E-03 L299-301 | ○ |
| C-104 (UT-CON-104) | showSelected | E-03 L312-325 | ○ |

### cls_contactStatusList クラス（E-04）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 (UT-CON-105) | Class_Initialize | E-04 L9-16 | ○ |
| C-106 (UT-CON-106) | showSelected single | E-04 L25 | ○ |
| C-107 (UT-CON-107) | showSelected option | E-04 L27-47 | ○ |
| C-108 (UT-CON-108) | showSelected CSSクラス | E-04 L29-41 | ○ |

### cls_contactFieldTypeList クラス（E-05）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 (UT-CON-109) | Class_Initialize | E-05 L4-15 | ○ |
| C-110 (UT-CON-110) | showSelected single | E-05 L24 | ○ |
| C-111 (UT-CON-111) | showSelected option | E-05 L26-33 | ○ |

### ASP画面ファイル（E-06〜E-12）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 (UT-CON-112) | bs_contactHome検索 | E-06 L23-27 | ○ |
| C-113 (UT-CON-113) | bs_contactHome Excel | E-06 L26 mode, E-03 cls_excelfile | △ |
| C-114 (UT-CON-114) | bs_contactHome一括メール | E-06 L27 | ○ |
| C-115 (UT-CON-115) | bs_contactEdit保存 | E-07 L20-26 | ○ |
| C-116 (UT-CON-116) | bs_contactEdit削除 | E-07 L27-30 | ○ |
| C-117 (UT-CON-117) | bs_contactEditパスワードリセット | E-07 L31-39 | ○ |
| C-118 (UT-CON-118) | bs_contactEdit CSRFチェック | E-07 L21, 28, 32 checkCSRF | ○ |
| C-119 (UT-CON-119) | bs_contactPage権限保存 | E-08 L12-17 | ○ |
| C-120 (UT-CON-120) | bs_contactFields上移動 | E-09 L7-9 | ○ |
| C-121 (UT-CON-121) | bs_contactFields下移動 | E-09 L10-12 | ○ |
| C-122 (UT-CON-122) | bs_contactFieldEdit保存 | E-10 L12-17 | ○ |
| C-123 (UT-CON-123) | bs_contactFieldEdit削除 | E-10 L18-21 | ○ |
| C-124 (UT-CON-124) | bs_contactSelectionActions一括メール | E-11 L31-32 bs_massMailing2.asp | △ |
| C-125 (UT-CON-125) | bs_contactSelectionActionsバリデーション件名 | E-11 L25-27 | ○ |
| C-126 (UT-CON-126) | bs_contactSelectionActionsバリデーション本文 | E-11 L28-30 | ○ |
| C-127 (UT-CON-127) | fs_mailcontact認証チェック | E-12 L6 | ○ |
| C-128 (UT-CON-128) | fs_mailcontact受信設定 | E-12 L7 | ○ |
| C-129 (UT-CON-129) | fs_mailcontactメール送信 | E-12 L14-29 | ○ |
| C-130 (UT-CON-130) | fs_mailcontact CAPTCHA | E-12 L9-10 | ○ |
| C-131 (UT-CON-131) | fs_mailcontact本文チェック | E-12 L11-12 | ○ |
| C-132 (UT-CON-132) | fs_mailcontact CC | E-12 L24-28 | ○ |
| C-133 (UT-CON-133) | fs_mailcontactリダイレクト | E-12 L30 | ○ |

## 4) 不足情報（Unknown / Missing）

- **cls_excelfile クラス**: contactモジュール外で定義されている可能性が高い。Excel出力機能の詳細実装は別途確認が必要
  - 候補：`asp/includes/excelfile.asp` / `asp/includes/export.asp` / 共通ユーティリティ
- **bs_massMailing2.asp**: 一括メール送信の実装詳細はインクルードファイルとして参照されているが、本解析では詳細未確認
  - 候補：`asp/bs_massMailing2.asp` / `asp/includes/massMailing.asp`

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| セキュリティ | SQLインジェクション対策の確認（cleanUp関数使用箇所） | 1: 中リスク |
| セキュリティ | CSRFトークン検証の網羅性確認 | 1: 中リスク |
| データ整合性 | 重複メールアドレス自動削除ロジックの意図確認 | 1: 中リスク |
| パフォーマンス | hasManyContacts時の検索クエリ効率 | 0: 低リスク |
| 権限管理 | savePermissions後のcreateUserFilesFolder失敗時のロールバック | 1: 中リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] cls_contactのCheck関数で、allowDEフラグの使用シナリオを確認（重複メール許可の業務要件）
- [ ] 重複メールアドレス時の自動削除ロジックが意図通りか確認（Save関数 L200-209）
- [ ] 権限保存時のトランザクション整合性を確認（savePermissions関数）
- [ ] Excel出力機能（cls_excelfile）の実装詳細を別モジュールで確認
- [ ] 一括メール送信（bs_massMailing2.asp）の実装詳細を確認
- [ ] fs_mailcontact.aspのCAPTCHA検証がセキュアか確認（session変数との比較）
- [ ] SQLインジェクション対策（cleanUp関数）の適用漏れがないか確認
