---
generated_at: 2026-01-24 00:35:00
metrics:
  claims_total: 90
  claims_with_evidence: 85
  claims_without_evidence: 5
confidence_derived: 0.94
---

# 根拠レポート：convert.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（convert.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：85 / 90、根拠なし：5
- 優先レビュー（高）
  1. **UT-CNV-086**：大きな数値の境界値テストはコード上のエラーハンドリングが限定的
  2. **UT-CNV-087**：科学的記数法のテストはVBScriptの仕様に依存
  3. **UT-CNV-089**：convertBoolの数値2以上の動作仕様が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `asp/includes/functions.asp` (convertGetal関数、94-112行目)
- E-02: `asp/includes/functions.asp` (convertLng関数、114-132行目)
- E-03: `asp/includes/functions.asp` (convertStr関数、134-145行目)
- E-04: `asp/includes/functions.asp` (convertBool関数、147-175行目)
- E-05: `asp/includes/functions.asp` (convertTF関数、176-182行目)
- E-06: `asp/includes/functions.asp` (convertTFS関数、183-189行目)
- E-07: `asp/includes/functions.asp` (isNumeriek関数、190-196行目)
- E-08: `asp/includes/functions.asp` (convertEuroDate関数、533-544行目)
- E-09: `asp/includes/functions.asp` (convertDateFromPicker関数、551-564行目)
- E-10: `asp/includes/functions.asp` (convertEuroDateTime関数、565-576行目)
- E-11: `asp/includes/functions.asp` (convertDateToPicker関数、577-588行目)
- E-12: `asp/includes/functions.asp` (convertCalcDate関数、589-602行目)
- E-13: `asp/includes/functions.asp` (convertCalcDateTime関数、603-606行目)
- E-14: `asp/includes/functions.asp` (convert2関数、689-695行目)
- E-15: `asp/includes/functions.asp` (convertCheckedYesNo関数、703-709行目)
- E-16: `asp/includes/functions.asp` (convertChecked関数、830-836行目)
- E-17: `asp/includes/functions.asp` (convertV関数、884-890行目)
- E-18: `asp/includes/page.asp` (bCanBeConvertedToFPプロパティ、1558-1560行目)
- E-19: `asp/includes/page.asp` (convertToFP関数、1561-1580行目)
- E-20: `asp/bs_process.asp` (ConvertToFPアクション、6-16行目)
- E-21: `asp/bs_convertToContainerItem.asp` (リンク表示条件、2行目)
- E-22: `asp/bs_convertToExternalURL.asp` (リンク表示条件、2行目)
- E-23: `asp/bs_convertToFreePage.asp` (リンク表示条件、2行目)
- E-24: `asp/bs_convertToItemWithContent.asp` (リンク表示条件、2行目)
- E-25: `asp/bs_convertToListpage.asp` (リンク表示条件、2行目)
- E-26: `asp/bs_convertToFP.asp` (インクルードとプロセス呼び出し、1-5行目)

## 3) Claims と根拠の対応（レビューの主戦場）

### functions.asp - 型変換関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-CNV-001) | convertGetalは数値文字列を数値に変換 | E-01 | ○ |
| C-02 (UT-CNV-002) | convertGetalは小数文字列を変換 | E-01 | ○ |
| C-03 (UT-CNV-003) | convertGetalは負の数値を変換 | E-01 | ○ |
| C-04 (UT-CNV-004) | convertGetalはnull入力で0を返却 | E-01 | ○ |
| C-05 (UT-CNV-005) | convertGetalは空文字列で0を返却 | E-01 | ○ |
| C-06 (UT-CNV-006) | convertGetalは非数値で0を返却 | E-01 | ○ |
| C-07 (UT-CNV-007) | convertGetalはスペースのみで0を返却 | E-01 | ○ |
| C-08 (UT-CNV-008) | convertLngは数値をLong型に変換 | E-02 | ○ |
| C-09 (UT-CNV-009) | convertLngはnull入力でnullを返却 | E-02 | ○ |
| C-10 (UT-CNV-010) | convertLngは空文字列でnullを返却 | E-02 | ○ |
| C-11 (UT-CNV-011) | convertLngは非数値でnullを返却 | E-02 | ○ |
| C-12 (UT-CNV-012) | convertStrは数値を文字列に変換 | E-03 | ○ |
| C-13 (UT-CNV-013) | convertStrはオブジェクトを文字列化 | E-03 | ○ |
| C-14 (UT-CNV-014) | convertStrはnull入力で空文字列を返却 | E-03 | ○ |
| C-15 (UT-CNV-015) | convertBoolは数値1でtrue | E-04 | ○ |
| C-16 (UT-CNV-016) | convertBoolは文字列"true"でtrue | E-04 | ○ |
| C-17 (UT-CNV-017) | convertBoolは大文字"TRUE"でtrue | E-04 | ○ |
| C-18 (UT-CNV-018) | convertBoolはブール値trueでtrue | E-04 | ○ |
| C-19 (UT-CNV-019) | convertBoolは文字列"0"でfalse | E-04 | ○ |
| C-20 (UT-CNV-020) | convertBoolは文字列"false"でfalse | E-04 | ○ |
| C-21 (UT-CNV-021) | convertBoolは空文字列でfalse | E-04 | ○ |
| C-22 (UT-CNV-022) | convertBoolはnull入力でfalse | E-04 | ○ |
| C-23 (UT-CNV-023) | convertTFはtrueで文字列"true"を返却 | E-05 | ○ |
| C-24 (UT-CNV-024) | convertTFはfalseで文字列"false"を返却 | E-05 | ○ |
| C-25 (UT-CNV-025) | convertTFSはtrueで緑色スタイルを返却 | E-06 | ○ |
| C-26 (UT-CNV-026) | convertTFSはfalseで赤色スタイルを返却 | E-06 | ○ |

### functions.asp - 日付変換関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 (UT-CNV-027) | convertEuroDateはUS形式で変換 | E-08 | ○ |
| C-28 (UT-CNV-028) | convertEuroDateはEU形式で変換 | E-08 | ○ |
| C-29 (UT-CNV-029) | convertEuroDateは空日付で空文字列 | E-08 | ○ |
| C-30 (UT-CNV-030) | convertEuroDateはnull日付で空文字列 | E-08 | ○ |
| C-31 (UT-CNV-031) | convertDateFromPickerはUS形式を変換 | E-09 | ○ |
| C-32 (UT-CNV-032) | convertDateFromPickerはEU形式を変換 | E-09 | ○ |
| C-33 (UT-CNV-033) | convertDateFromPickerは空値でnull | E-09 | ○ |
| C-34 (UT-CNV-034) | convertEuroDateTimeはUS形式で変換 | E-10 | ○ |
| C-35 (UT-CNV-035) | convertEuroDateTimeはEU形式で変換 | E-10 | ○ |
| C-36 (UT-CNV-036) | convertEuroDateTimeは空日時で空文字列 | E-10 | ○ |
| C-37 (UT-CNV-037) | convertDateToPickerはUS形式で変換 | E-11 | ○ |
| C-38 (UT-CNV-038) | convertDateToPickerはEU形式で変換 | E-11 | ○ |
| C-39 (UT-CNV-039) | convertDateToPickerは空値でnull | E-11 | ○ |
| C-40 (UT-CNV-040) | convertCalcDateはUS形式で計算用文字列 | E-12 | ○ |
| C-41 (UT-CNV-041) | convertCalcDateはEU形式で計算用文字列 | E-12 | ○ |
| C-42 (UT-CNV-042) | convertCalcDateは空値でnull | E-12 | ○ |
| C-43 (UT-CNV-043) | convertCalcDateTimeは日時を計算用文字列に | E-13 | ○ |

### functions.asp - ユーティリティ関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 (UT-CNV-044) | convert2は1桁をゼロパディング | E-14 | ○ |
| C-45 (UT-CNV-045) | convert2は2桁以上はそのまま | E-14 | ○ |
| C-46 (UT-CNV-046) | convert2は0を00に変換 | E-14 | ○ |
| C-47 (UT-CNV-047) | convertCheckedYesNoは"checked"をYesに | E-15 | ○ |
| C-48 (UT-CNV-048) | convertCheckedYesNoはそれ以外をNoに | E-15 | ○ |
| C-49 (UT-CNV-049) | convertCheckedはtrueでchecked属性 | E-16 | ○ |
| C-50 (UT-CNV-050) | convertCheckedはfalseで空白 | E-16 | ○ |
| C-51 (UT-CNV-051) | convertVはtrueでV | E-17 | ○ |
| C-52 (UT-CNV-052) | convertVはfalseでX | E-17 | ○ |
| C-53 (UT-CNV-053) | isNumeriekは数値でtrue | E-07 | ○ |
| C-54 (UT-CNV-054) | isNumeriekは数値文字列でtrue | E-07 | ○ |
| C-55 (UT-CNV-055) | isNumeriekは非数値でfalse | E-07 | ○ |
| C-56 (UT-CNV-056) | isNumeriekは空値でfalse | E-07 | ○ |
| C-57 (UT-CNV-057) | isNumeriekはnull値でfalse | E-07 | ○ |

### page.asp - ページ変換機能

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 (UT-CNV-058) | bCanBeConvertedToFPは条件を満たすとtrue | E-18 | ○ |
| C-59 (UT-CNV-059) | 子ページがあるとfalse | E-18 | ○ |
| C-60 (UT-CNV-060) | 既にフリーページだとfalse | E-18 | ○ |
| C-61 (UT-CNV-061) | リストページIDがあるとfalse | E-18 | ○ |
| C-62 (UT-CNV-062) | 外部URLプレフィックスがあるとfalse | E-18 | ○ |
| C-63 (UT-CNV-063) | secondAdmin.bPageBody=falseでfalse | E-18 | ○ |
| C-64 (UT-CNV-064) | convertToFPは条件満たすと変換成功 | E-19 | ○ |
| C-65 (UT-CNV-065) | 変換後iRang=0 | E-19 | ○ |
| C-66 (UT-CNV-066) | 変換後iParentid=null | E-19 | ○ |
| C-67 (UT-CNV-067) | 変換後bLossePagina=true | E-19 | ○ |
| C-68 (UT-CNV-068) | 同階層のランク更新 | E-19 | ○ |
| C-69 (UT-CNV-069) | イントラネットフィルタの適用 | E-19 | ○ |
| C-70 (UT-CNV-070) | 条件不満足でfalse | E-19 | ○ |
| C-71 (UT-CNV-071) | save()の結果が返却 | E-19 | ○ |

### bs_process.asp - ConvertToFPアクション

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 (UT-CNV-072) | ConvertToFP処理の実行 | E-20 | ○ |
| C-73 (UT-CNV-073) | 通常サイトへのリダイレクト | E-20 | ○ |
| C-74 (UT-CNV-074) | イントラネットへのリダイレクト | E-20 | ○ |
| C-75 (UT-CNV-075) | 失敗時のエラーメッセージ | E-20 | ○ |
| C-76 (UT-CNV-076) | CSRFチェックの実行 | E-20 | ○ |

### bs_convert*.asp - ビューファイル

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 (UT-CNV-077) | コンテナ変換リンク表示条件 | E-21 | ○ |
| C-78 (UT-CNV-078) | ホームページ除外 | E-21 | ○ |
| C-79 (UT-CNV-079) | 権限チェック | E-21 | ○ |
| C-80 (UT-CNV-080) | 外部URL変換リンク表示条件 | E-22 | ○ |
| C-81 (UT-CNV-081) | フリーページ変換リンク表示 | E-23 | ○ |
| C-82 (UT-CNV-082) | 変換不可時の非表示 | E-23 | ○ |
| C-83 (UT-CNV-083) | 確認ダイアログの表示 | E-23 | ○ |
| C-84 (UT-CNV-084) | アイテム変換リンク表示 | E-24 | ○ |
| C-85 (UT-CNV-085) | リストページ変換リンク表示 | E-25 | ○ |

### 境界値・追加テスト

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 (UT-CNV-086) | 大きな数値の処理 | **根拠なし** | △ |
| C-87 (UT-CNV-087) | 科学的記数法の処理 | **根拠なし** | △ |
| C-88 (UT-CNV-088) | 数値0のブール変換 | E-04 | ○ |
| C-89 (UT-CNV-089) | 数値2以上のブール変換 | **根拠不足** | △ |
| C-90 (UT-CNV-090) | 無効なIDの判定 | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）

### 境界値テストの根拠不足
- **C-86 (UT-CNV-086)**: convertGetalの大きな数値処理について、VBScriptのcdbl関数のオーバーフロー動作はコード上で明示的に処理されていない
  - 候補：VBScript言語仕様ドキュメント / エラーハンドリングテスト / 実行環境での動作確認

- **C-87 (UT-CNV-087)**: 科学的記数法（1.5e10など）の処理はIsNumeric関数の動作に依存
  - 候補：VBScript IsNumeric関数の仕様確認 / 実際のテスト実行

- **C-89 (UT-CNV-089)**: convertBoolで数値2以上の場合の動作はコードでは直接定義されていない（cBool関数の動作に依存）
  - 候補：VBScript cBool関数の仕様確認

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 1: 中リスク | 境界値テスト（C-86, C-87, C-89） | VBScriptの言語仕様に依存するため、実環境での検証が必要 |
| 0: 低リスク | 日付変換関数 | customer.sDatumFormatの設定に依存するが、コード上で明確に処理されている |
| 0: 低リスク | ページ変換機能 | 条件分岐が明確でコードから十分に推測可能 |
| 0: 低リスク | ビューファイル | 条件式が単純で理解しやすい |

## 6) レビュアーチェックリスト（最小）

- [ ] convertGetal/convertLngの大きな数値での動作を実環境で確認
- [ ] convertBoolの数値入力（0, 1, 2以上）の動作を確認
- [ ] 日付フォーマット（US/EU）の切り替えテストが実施されているか確認
- [ ] convertToFPの同階層ランク更新SQLが正しく動作するか確認
- [ ] CSRFチェック（checkCSRF）の実装が適切か確認
- [ ] bs_convert*.aspの暗号化ID（encrypt/decrypt）の動作確認
