---
generated_at: 2026-01-24 15:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：delete.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（delete.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **UT-DEL-037**：CSRF検証失敗時の具体的な挙動はコードから直接確認できない（checkCSRf関数の実装依存）
  2. **UT-DEL-041**：save関数がFalseを返すシナリオの具体的な条件が不明
  3. **UT-DEL-046**：VBScriptのcdbl関数のオーバーフロー限界値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_delete.asp` - 削除リンク表示コンポーネント
- E-02: `asp/bs_deleteButton.asp` - 削除ボタン表示コンポーネント
- E-03: `asp/bs_deleteButtonList.asp` - リスト用削除ボタン表示コンポーネント
- E-04: `asp/bs_deletelistitem.asp` - リストアイテム用削除リンク表示コンポーネント
- E-05: `asp/bs_processPage.asp` - ページ処理（削除処理含む）
- E-06: `asp/includes/page.asp` - Pageクラス定義（canBeDeleted, removeRang, deleteListItems関数）
- E-07: `asp/includes/functions.asp` - convertGetal関数定義
- E-08: `asp/includes/secondAdmin.asp` - セカンドアドミン権限クラス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 削除可能なページで削除リンクが表示されること | E-01（2行目: if page.canBeDeleted then） | ○ |
| C-02 | 削除不可なページで削除リンクが非表示になること | E-01（2行目: if page.canBeDeleted then - else節なし、条件不成立で非表示） | ○ |
| C-03 | 削除リンクのalt属性が多言語対応されること | E-01（2行目: alt='<%=l("delete")%>'） | ○ |
| C-04 | 削除可能なページで削除ボタンが表示されること | E-02（2行目: if page.canBeDeleted then） | ○ |
| C-05 | 削除不可なページで削除ボタンが非表示になること | E-02（2行目: if page.canBeDeleted then） | ○ |
| C-06 | 削除ボタンクリックでdeletePage関数が呼び出されること | E-02（2行目: onclick="javascript:deletePage();"） | ○ |
| C-07 | 有効なページIDで削除ボタンが表示されること（リスト用） | E-03（2行目: if convertGetal(page.iId)<>0 then） | ○ |
| C-08 | ページIDが0の場合に削除ボタンが非表示になること | E-03（2行目: convertGetal(page.iId)<>0 条件） | ○ |
| C-09 | ページIDがnullの場合に削除ボタンが非表示になること | E-03, E-07（convertGetal(null)=0） | ○ |
| C-10 | ページIDが空文字の場合に削除ボタンが非表示になること | E-03, E-07（convertGetal("")=0） | ○ |
| C-11 | 有効なページIDで削除リンクが表示されること（リストアイテム用） | E-04（2行目: if convertGetal(page.iId)<>0 then） | ○ |
| C-12 | ページIDが0の場合に削除リンクが非表示になること | E-04（2行目: convertGetal(page.iId)<>0 条件） | ○ |
| C-13 | ページIDが負数の場合に削除リンクが表示されること | E-04, E-07（convertGetal(-1)=-1<>0） | ○ |
| C-14 | 画像パスに正しい定数が使用されること | E-01, E-04（src="<%=C_DIRECTORY_QUICKERSITE%>/fixedImages/dustbin.gif"） | ○ |
| C-15 | セカンドアドミン権限あり・子なし・非ホームページ・ID有効でcanBeDeleted=True | E-06（690-702行目: canBeDeleted関数定義） | ○ |
| C-16 | セカンドアドミン権限がない場合にcanBeDeleted=False | E-06（691-692行目: if not secondAdmin.bPagesDelete then canBeDeleted=false） | ○ |
| C-17 | 子ページが存在する場合にcanBeDeleted=False | E-06（696行目: if copySubPages.count=0 条件） | ○ |
| C-18 | ホームページの場合にcanBeDeleted=False | E-06（696行目: not bHomepage 条件） | ○ |
| C-19 | ページIDが空の場合にcanBeDeleted=False | E-06（696行目: not isLeeg(iId) 条件） | ○ |
| C-20 | ページ削除時に同階層ページのiRangが更新されること | E-06（878-890行目: removeRang関数） | ○ |
| C-21 | リストページアイテムの場合はiRangが更新されないこと | E-06（879行目: if convertGetal(page.iListPageID)=0 条件） | ○ |
| C-22 | 単独ページの場合はiRangが更新されないこと | E-06（879行目: page.bLossePagina=false 条件） | ○ |
| C-23 | イントラネットページ削除時にbIntranet条件が適用されること | E-06（882-886行目: if page.bIntranet then） | ○ |
| C-24 | リストページ削除時に関連リストアイテムが全て削除フラグ設定されること | E-06（1144-1153行目: deleteListItems関数） | ○ |
| C-25 | リストアイテムがない場合はエラーなく処理完了すること | E-06（1146-1150行目: for each ループが空で正常終了） | ○ |
| C-26 | 削除後にメニューキャッシュがクリアされること | E-06（1152行目: clearMenuCache） | ○ |
| C-27 | 削除確認ダイアログでOK選択時にフォーム送信されること | E-05（2-7行目: if confirm then submit） | ○ |
| C-28 | 削除確認ダイアログでキャンセル選択時にフォーム送信されないこと | E-05（2-7行目: if confirm 条件により制御） | ○ |
| C-29 | ページ削除時にbDeleted=Trueが設定されること | E-05（28行目: page.bDeleted=true） | ○ |
| C-30 | ページ削除時にiRang=0が設定されること | E-05（30行目: page.iRang=0） | ○ |
| C-31 | ページ削除時にbOnline=Falseが設定されること | E-05（31行目: page.bOnline=false） | ○ |
| C-32 | ページ削除時にbHomepage=Falseが設定されること | E-05（32行目: page.bHomepage=false） | ○ |
| C-33 | イントラネット以外のページ削除後にbs_default.aspにリダイレクトされること | E-05（39行目: Response.Redirect ("bs_default.asp")） | ○ |
| C-34 | イントラネットページ削除後にbs_intranet.aspにリダイレクトされること | E-05（37行目: Response.Redirect ("bs_intranet.asp")） | ○ |
| C-35 | リストアイテム削除後にbs_listPage.aspにリダイレクトされること | E-05（42行目: Response.Redirect ("bs_listPage.asp?...")） | ○ |
| C-36 | 削除処理前にCSRFトークン検証が実行されること | E-05（27行目: checkCSRf()） | ○ |
| C-37 | 無効なCSRFトークンで削除処理が拒否されること | **根拠なし** | △ |
| C-38 | 削除時に親ページのremoveRang関数が呼び出されること | E-05（29行目: page.parentPage.removeRang(page)） | ○ |
| C-39 | リストページ削除時にdeleteListItems関数が呼び出されること | E-05（33行目: page.deleteListItems()） | ○ |
| C-40 | 削除処理後にsave関数が呼び出されること | E-05（34行目: if page.save then） | ○ |
| C-41 | save関数がFalseを返した場合にリダイレクトされないこと | **根拠なし** | △ |
| C-42 | 数値が正しく変換されること | E-07（94-109行目: convertGetal関数） | ○ |
| C-43 | nullが渡された場合に0が返されること | E-07（95行目: if not isnull(value) then - else節で0） | ○ |
| C-44 | 空文字が渡された場合に0が返されること | E-07（97行目: if trim(value)<>"" then - else節で0） | ○ |
| C-45 | 非数値文字列が渡された場合に0が返されること | E-07（96行目: if IsNumeric(value) then - else節で0） | ○ |
| C-46 | 非常に大きな数値が処理できること | **根拠なし** | △ |
| C-47 | データベースからbPagesDelete権限が正しく読み込まれること | E-08（44行目: bPagesDelete = rs("bPagesDelete")） | ○ |
| C-48 | bPagesDelete権限がデータベースに正しく保存されること | E-08（134行目: rs("bPagesDelete") = convertBool(bPagesDelete)） | ○ |
| C-49 | リクエストからbPagesDelete権限が正しく取得されること | E-08（199行目: bPagesDelete = convertBool(Request.Form ("bPagesDelete"))） | ○ |
| C-50 | dustbin.gif画像のパスが正しく生成されること | E-01, E-04（src属性の定義確認） | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-37**: checkCSRf関数の実装詳細が別ファイルにあり、失敗時の具体的な挙動（エラーページ表示、処理中断等）が確認できない
  - 候補：asp/includes/functions.asp / asp/includes/security.asp / 共通エラーハンドラ
- **C-41**: page.save関数がFalseを返すシナリオ（DB接続エラー、バリデーションエラー等）の具体的な条件定義が確認できない
  - 候補：asp/includes/page.asp のsave関数実装 / DBエラーハンドリング仕様
- **C-46**: VBScriptのcdbl関数の数値範囲限界（オーバーフロー時の挙動）がコードからは確認できない
  - 候補：VBScript仕様書 / Microsoft公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **リスク 1（高）**: CSRF防止機能（C-37）の実効性確認が必要。セキュリティ上重要な機能であり、checkCSRf関数の実装詳細を別途確認すべき
- **リスク 1（中）**: 削除操作は取り消し不可（論理削除であっても復元UIがない可能性）。ユーザー確認ダイアログの文言が適切かレビュー推奨
- **リスク 0（低）**: 境界値テスト（C-46）は実運用上発生しにくいため、優先度は低い

## 6) レビュアーチェックリスト（最小）
- [ ] checkCSRf関数の実装を確認し、CSRF攻撃を適切に防止できているか検証する
- [ ] page.save関数の失敗パターンを確認し、UT-DEL-041のテスト条件を具体化する
- [ ] 削除確認ダイアログの多言語対応（l("deletecomplete")）が適切か確認する
- [ ] canBeDeleted関数の条件網羅性を確認（子ページ、ホームページ、権限の組み合わせ）
- [ ] removeRang関数のSQL文が正しく並び順を更新するか確認する
