---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 75
  claims_with_evidence: 72
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：edit モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：72 / 75、根拠なし：3
- 優先レビュー（高）
  1. **UT-EDT-066 quotrep関数**：共通関数としてincludesディレクトリに存在する可能性があるが、直接確認できていない
  2. **UT-EDT-074 sanitize関数**：同上、共通関数の実装詳細が未確認
  3. **UT-EDT-075 createFCKInstance関数**：CKEditor統合関数の詳細実装が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editItem.asp`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editListItem.asp`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editPageBlocks.asp`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editFooter.asp`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editContainer.asp`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editExternalURL.asp`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editList.asp`
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editListTemplate.asp`
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editcode.asp`
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editProps.asp`
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editBannerMenu.asp`
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editpictureLI.asp`
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_editPage.asp`
- E-14: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_editListItem.asp`
- E-15: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_editListItemPic.asp`
- E-16: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_editListItems.asp`
- E-17: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_editListPage.asp`
- E-18: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editPageBlocksInc.asp`
- E-19: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/process_editsite.asp`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bs_editItem.aspのフォーム処理でページ保存が行われる | E-01 行4-16 | ○ |
| C-02 | iIdの暗号化/復号化にEnCrypt/decrypt関数を使用 | E-01 行4 | ○ |
| C-03 | checkCSRF()でCSRFトークン検証を実施 | E-03 行8 | ○ |
| C-04 | secondAdmin.bPageBody権限でエディタ表示を制御 | E-01 行13 | ○ |
| C-05 | bs_editListItem.aspで日付変換にconvertEuroDate使用 | E-02 行14-16 | ○ |
| C-06 | リストアイテムの外部URL設定機能が存在 | E-02 行17-19 | ○ |
| C-07 | bs_editPageBlocks.aspで8つのページブロック（sProp01-08）を管理 | E-03 行9-16 | ○ |
| C-08 | removeEmptyP関数で空のPタグを除去 | E-03 行9 | ○ |
| C-09 | bs_editFooter.aspでフッター編集機能を提供 | E-04 行6 | ○ |
| C-10 | bs_editContainer.aspでコンテナアイテム編集機能を提供 | E-05 行4 | ○ |
| C-11 | bs_editExternalURL.aspで外部URL編集機能を提供 | E-06 行5 | ○ |
| C-12 | cls_urlTypeListでURLプレフィックス選択を実装 | E-06 行4-5 | ○ |
| C-13 | bs_editList.aspでリストページのソート順設定を管理 | E-07 行4-5 | ○ |
| C-14 | アコーディオン効果（bAccordeon）の設定が可能 | E-07 行9 | ○ |
| C-15 | Push RSS（bPushRSS）の設定が可能 | E-07 行9 | ○ |
| C-16 | bs_editListTemplate.aspでリストテンプレート選択機能を提供 | E-08 行12-14 | ○ |
| C-17 | bs_editcode.aspでファイル拡張子による許可制御を実施 | E-09 行12-26 | ○ |
| C-18 | UserFiles外へのアクセスをブロック | E-09 行42-46 | ○ |
| C-19 | ファイル保存機能（btnAction="Save"） | E-09 行99-106 | ○ |
| C-20 | ファイルコピー機能（copy=1） | E-09 行70-95 | ○ |
| C-21 | GetFileExtension関数で拡張子を取得 | E-09 行119-123 | ○ |
| C-22 | bs_editProps.aspで8つのデフォルトブロックを管理 | E-10 行6-13 | ○ |
| C-23 | bs_editBannerMenu.aspで左右バナーとメニューを管理 | E-11 行6-9 | ○ |
| C-24 | bs_editpictureLI.aspで画像配置オプション（al, fp, ar, CC）を提供 | E-12 行35-44 | ○ |
| C-25 | deleteListItemImage()で画像削除を実行 | E-12 行19-21 | ○ |
| C-26 | customer.bListItemPicで機能の有効/無効を制御 | E-12 行6 | ○ |
| C-27 | fs_editPage.aspでgetTper/getBper権限チェック | E-13 行12-13 | ○ |
| C-28 | 検証通知メール送信機能（sNotifValidate） | E-13 行38-50 | ○ |
| C-29 | fs_editListItem.aspでリストアイテムの保存/削除機能 | E-14 行21-43 | ○ |
| C-30 | deleteListItems()でリストアイテム削除時のクリーンアップ | E-14 行39 | ○ |
| C-31 | fs_editListItemPic.aspで画像アップロード機能 | E-15 行22-77 | ○ |
| C-32 | 許可された画像形式（png, jpg, gif, jpeg）の検証 | E-15 行56-63 | ○ |
| C-33 | listitemimagesフォルダの自動作成 | E-15 行12-15 | ○ |
| C-34 | アップロード画像のページIDでのリネーム | E-15 行69 | ○ |
| C-35 | fs_editListItems.aspでリストアイテム一覧表示 | E-16 行13-14 | ○ |
| C-36 | getLper権限チェックでアクセス制御 | E-16 行7 | ○ |
| C-37 | fs_editListPage.aspでリストページ設定編集 | E-17 行15-32 | ○ |
| C-38 | process_editsite.aspで編集可能ページ一覧を取得 | E-19 行4-11 | ○ |
| C-39 | getTper, getBper, getLper権限の統合判定 | E-19 行13-31 | ○ |
| C-40 | bs_editPageBlocksInc.aspで条件付きリンク表示 | E-18 行2 | ○ |
| C-41 | QS_secCodeHiddenでCSRFトークンをhiddenフィールドに設定 | E-01 行4, E-02 行8 | ○ |
| C-42 | cls_pageクラスでページオブジェクト管理 | E-03 行5-6, E-08 行9-10 | ○ |
| C-43 | page.save()メソッドでページ保存 | E-03 行17, E-08 行14 | ○ |
| C-44 | message.Add()でフィードバックメッセージ追加 | E-03 行17, E-04 行7 | ○ |
| C-45 | encrypt/decrypt関数でIDの暗号化/復号化 | E-03 行6, E-08 行10 | ○ |
| C-46 | JQDatePicker関数で日付ピッカー生成 | E-02 行14-16 | ○ |
| C-47 | convertDateFromPicker関数で日付変換 | E-14 行23-25 | ○ |
| C-48 | convertChecked関数でチェックボックス状態変換 | E-07 行9 | ○ |
| C-49 | numberList関数で数値選択リスト生成 | E-07 行9 | ○ |
| C-50 | cls_orderByListでソート順選択肢を管理 | E-07 行4-5 | ○ |
| C-51 | logon.hasaccess関数でアクセス権限チェック | E-03 行4, E-04 行4 | ○ |
| C-52 | secondAdmin.bSetupPageElements権限でページ要素設定を制御 | E-03 行4, E-04 行4 | ○ |
| C-53 | customer.save()でカスタマー設定保存 | E-04 行7, E-10 行14 | ○ |
| C-54 | FreeASPUploadクラスでファイルアップロード処理 | E-15 行23-24 | ○ |
| C-55 | checkCSRF_Upload関数でアップロード時のCSRF検証 | E-15 行28 | ○ |
| C-56 | fso（FileSystemObject）でファイル操作 | E-09 行31, E-15 行11 | ○ |
| C-57 | server.mappath関数でパス変換 | E-09 行34, E-15 行12 | ○ |
| C-58 | Response.Redirect関数でリダイレクト | E-08 行14, E-14 行42 | ○ |
| C-59 | l()関数でローカライズ文字列取得 | E-01 行4, E-02 行8 | ○ |
| C-60 | getBOHeader関数でバックオフィスヘッダー取得 | E-01 行4, E-04 行4 | ○ |
| C-61 | getBOSetupMenu関数でセットアップメニュー取得 | E-04 行4, E-10 行4 | ○ |
| C-62 | CodeMirrorエディタでコード編集機能提供 | E-09 行127-175 | ○ |
| C-63 | logon.contact.getTper/getBper/getLperで権限情報取得 | E-13 行12-13, E-19 行13-16 | ○ |
| C-64 | logon.contact.createUserFilesFolder()でユーザーフォルダ作成 | E-13 行14 | ○ |
| C-65 | selectedPage変数でフロントサイド編集時のページ参照 | E-13 行17-60, E-14 行15 | ○ |
| C-66 | cls_mail_messageクラスでメール送信 | E-13 行44-49 | ○ |
| C-67 | cPopup.dumpJS()でポップアップJavaScript出力 | E-13 行67 | ○ |
| C-68 | cleanUPASP関数で終了処理 | E-09 行179, E-13 行68 | ○ |
| C-69 | convertStr関数で文字列変換 | E-03 行9, E-04 行6 | ○ |
| C-70 | convertBool関数で真偽値変換 | E-13 行15, E-14 行27 | ○ |
| C-71 | convertGetal関数で数値変換 | E-02 行17, E-17 行25 | ○ |
| C-72 | isLeeg関数で空値判定 | E-02 行17, E-12 行6 | ○ |
| C-73 | quotrep関数でHTMLエスケープ | **根拠不足** | △ |
| C-74 | sanitize関数でXSS対策 | **根拠不足** | △ |
| C-75 | createFCKInstance関数でCKEditor生成 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **quotrep, sanitize, createFCKInstance関数の実装詳細**
  - これらの関数は複数のASPファイルで使用されているが、includes/ディレクトリ内の共通ファイルに定義されていると推測される
  - 候補：`includes/functions.asp` / `begin.asp` / `bs_initBack.asp`
- **cls_pageクラスの完全な実装**
  - pickメソッド、saveメソッド、各プロパティの詳細な実装
  - 候補：`includes/` ディレクトリ内のクラス定義ファイル

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - bs_editcode.aspのファイル操作機能はセキュリティ上の注意が必要。パストラバーサル攻撃への対策（行42-46）は実装されているが、追加の検証が推奨される
- **1: 中リスク** - fs_editListItemPic.aspの画像アップロード機能。拡張子チェックは実装されているが、MIMEタイプ検証の有無を確認する必要がある
- **0: 低リスク** - CSRF対策はcheckCSRF()関数とQS_secCodeHiddenで適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] quotrep関数の実装を確認し、特殊文字のエスケープが適切か検証する
- [ ] sanitize関数の実装を確認し、XSS対策が十分か検証する
- [ ] createFCKInstance関数の実装を確認し、CKEditorの設定が適切か検証する
- [ ] bs_editcode.aspのパス検証ロジックが十分かセキュリティレビューする
- [ ] 画像アップロード機能のMIMEタイプ検証の有無を確認する
- [ ] 各権限チェック（secondAdmin, getTper, getBper, getLper）の適用範囲が適切か確認する
