---
generated_at: 2026-01-24 12:30:00
metrics:
  claims_total: 118
  claims_with_evidence: 118
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：feed.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードでの実装が確認できるか
2. **根拠との整合性**：テストケースの内容がコードの実装と矛盾していないか
3. **網羅性**：参照すべきメソッド・関数を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：118 / 118、根拠なし：0
- 優先レビュー（高）
  1. **XSS対策（UT-FED-063）**：bEnableJS=falseでのJavaScript除去が実際に安全か要確認
  2. **自己参照ループ防止（UT-FED-071）**：rss.asp内の防止ロジックの完全性
  3. **キャッシュ機構（UT-FED-066, 067）**：キャッシュのタイミング・TTL設定の妥当性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/feed.asp` - cls_feedクラスの完全な実装
- E-02: `asp/includes/rss_writer.asp` - kwRSS_writerクラスとaspXMLクラスの実装
- E-03: `asp/bs_feedEdit.asp` - フィード編集画面の実装
- E-04: `asp/bs_feedList.asp` - フィード一覧画面の実装
- E-05: `asp/bs_feedPreview.asp` - フィードプレビュー画面の実装
- E-06: `rss.asp` - RSSフィード生成エンドポイントの実装
- E-07: `asp/bs_feed.asp` - フィード選択UIコンポーネント
- E-08: `asp/bs_feedBack.asp` - フィード画面共通コンポーネント

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_feedクラス（E-01）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-FED-001) | Class_Initializeでデフォルト値が設定される | E-01: L6-27 | ○ |
| C-02 (UT-FED-002) | リクエストパラメータからifeedIdを復号化 | E-01: L25 `pick(decrypt(request("ifeedId")))` | ○ |
| C-03 (UT-FED-003) | sLinkプロパティでURL結合 | E-01: L28-30 `sLink=sPrefixUrl&sUrl` | ○ |
| C-04 (UT-FED-004) | sUrlが空でもsPrefixUrlのみ返却 | E-01: L28-30 結合ロジック | ○ |
| C-05 (UT-FED-005) | Pickで有効なIDからフィード取得 | E-01: L31-64 Pick関数の実装 | ○ |
| C-06 (UT-FED-006) | 数値でないIDで読み込み防止 | E-01: L33 `if isNumeriek(id) then` | ○ |
| C-07 (UT-FED-007) | 存在しないIDでプロパティ変更なし | E-01: L36 `if not rs.eof then` | ○ |
| C-08 (UT-FED-008) | nullのIDで処理スキップ | E-01: L33 isNumeriek判定 | ○ |
| C-09 (UT-FED-009) | ID=0の処理 | E-01: L33 isNumeriek判定に依存 | ○ |
| C-10 (UT-FED-010) | Check関数で有効入力true | E-01: L65-95 Check関数 | ○ |
| C-11 (UT-FED-011) | sName空でエラー | E-01: L67-70 `if isLeeg(sName) then` | ○ |
| C-12 (UT-FED-012) | sUrlとsUrls両方空でエラー | E-01: L71-73 | ○ |
| C-13 (UT-FED-013) | sUrls設定でチェック通過 | E-01: L71 `if isLeeg(sUrl) and isLeeg(sUrls) then` | ○ |
| C-14 (UT-FED-014) | http://プレフィックス除去 | E-01: L75 `replace(sUrl,"http://","",1,-1,1)` | ○ |
| C-15 (UT-FED-015) | https://プレフィックス除去 | E-01: L76 `replace(sUrl,"https://","",1,-1,1)` | ○ |
| C-16 (UT-FED-016) | default.asp?iId=でエラー | E-01: L77-80 instr判定 | ○ |
| C-17 (UT-FED-017) | default.asp?sCode=でエラー | E-01: L81-84 instr判定 | ○ |
| C-18 (UT-FED-018) | 重複sCodeでエラー | E-01: L86-94 重複チェックSQL | ○ |
| C-19 (UT-FED-019) | 更新時に自分自身除外 | E-01: L88 `iId<>` & convertGetal(iId)` | ○ |
| C-20 (UT-FED-020) | 新規フィード保存 | E-01: L96-147 Save関数 | ○ |
| C-21 (UT-FED-021) | 既存フィード更新 | E-01: L109-110 `rs.Open "select * from tblfeed where iId="& iId` | ○ |
| C-22 (UT-FED-022) | sName50文字制限 | E-01: L112 `left(sName,50)` | ○ |
| C-23 (UT-FED-023) | overruleCIDでcustomerID上書き | E-01: L119-123 | ○ |
| C-24 (UT-FED-024) | 保存後cacheFeeds呼び出し | E-01: L145 `customer.cacheFeeds()` | ○ |
| C-25 (UT-FED-025) | 保存後キャッシュクリア | E-01: L146 `application(QS_CMS_cacheFEED & iId)=""` | ○ |
| C-26 (UT-FED-026) | Check失敗で保存なし | E-01: L97-102 | ○ |
| C-27 (UT-FED-027) | getRequestValuesでフォーム値取得 | E-01: L148-181 | ○ |
| C-28 (UT-FED-028) | sCode大文字変換 | E-01: L156 `ucase(convertStr(Request.Form ("sCode")))` | ○ |
| C-29 (UT-FED-029) | テンプレート初期化条件 | E-01: L172-180 | ○ |
| C-30 (UT-FED-030) | iMaxItems空でconvertGetal処理 | E-01: L152 `convertGetal(Request.Form ("iMaxItems"))` | ○ |
| C-31 (UT-FED-031) | フィード削除 | E-01: L182-192 remove関数 | ○ |
| C-32 (UT-FED-032) | 削除時にページ関連付けnull | E-01: L185 `update tblPage set ifeedID=null where ifeedID=` | ○ |
| C-33 (UT-FED-033) | 削除後cacheFeeds呼び出し | E-01: L189 `customer.cacheFeeds()` | ○ |
| C-34 (UT-FED-034) | 削除後キャッシュクリア | E-01: L190 `application(QS_CMS_cacheFEED & iId)=""` | ○ |
| C-35 (UT-FED-035) | 空IDで削除スキップ | E-01: L183 `if not isLeeg(iId) then` | ○ |
| C-36 (UT-FED-036) | フィードコピー | E-01: L193-200 copy関数 | ○ |
| C-37 (UT-FED-037) | コピー後新しいiId | E-01: L195 `iId=null` | ○ |
| C-38 (UT-FED-038) | 非数値IDでコピースキップ | E-01: L194 `if isNumeriek(iId) then` | ○ |
| C-39 (UT-FED-039) | RSSフィード解析 | E-01: L285-288 RSS判定 | ○ |
| C-40 (UT-FED-040) | ATOMフィード解析 | E-01: L293-296 ATOM判定 | ○ |
| C-41 (UT-FED-041) | RDF形式フィード解析 | E-01: L289-292 rdf:RDF判定 | ○ |
| C-42 (UT-FED-042) | iMaxItemsで出力制限 | E-01: L391 `if J<iMaxItems` | ○ |
| C-43 (UT-FED-043) | bRandomでランダム順出力 | E-01: L457-478 | ○ |
| C-44 (UT-FED-044) | bTemplateでカスタムテンプレート | E-01: L207-208 | ○ |
| C-45 (UT-FED-045) | {TITLE}置換 | E-01: L404 `Replace(ItemContent,"{TITLE}",feedTitle,1,-1,1)` | ○ |
| C-46 (UT-FED-046) | {LINK}置換 | E-01: L392 `Replace(ItemTemplate,"{LINK}",feedlink,1,-1,1)` | ○ |
| C-47 (UT-FED-047) | {AUTHOR}置換 | E-01: L405 | ○ |
| C-48 (UT-FED-048) | {DATE}置換 | E-01: L406 | ○ |
| C-49 (UT-FED-049) | {CATEGORY}置換 | E-01: L407 | ○ |
| C-50 (UT-FED-050) | {DESCRIPTION}置換 | E-01: L425-428 | ○ |
| C-51 (UT-FED-051) | {IMAGE}置換 | E-01: L408 | ○ |
| C-52 (UT-FED-052) | {ENCLOSURE}置換 | E-01: L409 | ○ |
| C-53 (UT-FED-053) | {COUNTER}置換 | E-01: L410 `Replace(ItemContent,"{COUNTER}",j+1,1,-1,1)` | ○ |
| C-54 (UT-FED-054) | iLimitToで説明文制限 | E-01: L414-423 | ○ |
| C-55 (UT-FED-055) | QS_feedNoTextで説明文空 | E-01: L415-416 | ○ |
| C-56 (UT-FED-056) | iTitleLimitToでタイトル制限 | E-01: L394-401 | ○ |
| C-57 (UT-FED-057) | bShowTitle=falseでタイトル非表示 | E-01: L211 `if bShowTitle then` | ○ |
| C-58 (UT-FED-058) | bLinkOnTitle=falseでリンクなし | E-01: L213-221 | ○ |
| C-59 (UT-FED-059) | bOpenLinkInNW=trueで新しいウィンドウ | E-01: L215-217 | ○ |
| C-60 (UT-FED-060) | bShowDate=falseで日付非表示 | E-01: L226 `if bShowDate then` | ○ |
| C-61 (UT-FED-061) | bShowAuthor=falseで著者非表示 | E-01: L228 `if bShowAuthor then` | ○ |
| C-62 (UT-FED-062) | bShowCategory=falseでカテゴリ非表示 | E-01: L234 `if bShowCategory then` | ○ |
| C-63 (UT-FED-063) | bEnableJS=falseでJS除去 | E-01: L485 `removeJS(treatConstants(build,false))` | ○ |
| C-64 (UT-FED-064) | bEnableJS=trueでJSそのまま | E-01: L483 | ○ |
| C-65 (UT-FED-065) | sHTMLBefore/sHTMLAfter追加 | E-01: L490-494 | ○ |
| C-66 (UT-FED-066) | キャッシュから取得 | E-01: L454-456 `build=application(QS_CMS_cacheFEED & iId)` | ○ |
| C-67 (UT-FED-067) | キャッシュ期限切れで再取得 | E-01: L204 `cdate(now())>cdate(application(QS_CMS_cacheFEED & iId & "TS"))` | ○ |
| C-68 (UT-FED-068) | 複数URLで結合 | E-01: L243-249 arrLinks配列処理 | ○ |
| C-69 (UT-FED-069) | 無効URLで空文字 | E-01: L267-277 Load失敗時の処理 | ○ |
| C-70 (UT-FED-070) | XMLパースエラーでMSXML6再試行 | E-01: L270-276 | ○ |
| C-71 (UT-FED-071) | 自己参照ループ防止 | E-01: L251-256 | ○ |
| C-72 (UT-FED-072) | iId=0で空文字 | E-01: L203 `if convertGetal(iId)<>0 then` | ○ |
| C-73 (UT-FED-073) | 空divの除去 | E-01: L438-441 | ○ |
| C-74 (UT-FED-074) | copyToCustomerで顧客コピー | E-01: L498-507 | ○ |
| C-75 (UT-FED-075) | コピー先ページ関連更新 | E-01: L505 | ○ |
| C-76 (UT-FED-076) | copyToCustomerで非数値IDスキップ | E-01: L499 `if isNumeriek(iId) then` | ○ |

### kwRSS_writerクラス（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 (UT-FED-077) | CurrentItem初期値-1 | E-02: L25 `CurrentItem = -1` | ○ |
| C-78 (UT-FED-078) | AddNewでインクリメント | E-02: L66-68 `CurrentItem = CurrentItem + 1` | ○ |
| C-79 (UT-FED-079) | SetTitleでタイトル設定 | E-02: L34-36 | ○ |
| C-80 (UT-FED-080) | SetLinkでリンク設定 | E-02: L38-40 | ○ |
| C-81 (UT-FED-081) | SetDescで説明設定 | E-02: L42-44 | ○ |
| C-82 (UT-FED-082) | SetPubDateで日付設定 | E-02: L46-48 | ○ |
| C-83 (UT-FED-083) | SetAuthorで著者設定 | E-02: L50-52 | ○ |
| C-84 (UT-FED-084) | SetGuidでGUID設定 | E-02: L54-56 | ○ |
| C-85 (UT-FED-085) | setCommentsでコメント設定 | E-02: L62-64 | ○ |
| C-86 (UT-FED-086) | 空コメントは設定されない | E-02: L63 `if not isLeeg(ItemComments) then` | ○ |
| C-87 (UT-FED-087) | SetEnclosureでEnclosure設定 | E-02: L58-60 | ○ |
| C-88 (UT-FED-088) | GetRSSでRSS 2.0 XML生成 | E-02: L70-156 | ○ |
| C-89 (UT-FED-089) | チャンネル情報出力 | E-02: L75-78 | ○ |
| C-90 (UT-FED-090) | 画像情報出力 | E-02: L80-86 | ○ |
| C-91 (UT-FED-091) | Enclosure出力 | E-02: L110-116 | ○ |
| C-92 (UT-FED-092) | 0件でも有効RSS生成 | E-02: L70-156 ループ構造 | ○ |
| C-93 (UT-FED-093) | 最大500アイテム | E-02: L14 `Private Items(500, 8)` | ○ |

### aspXMLクラス（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 (UT-FED-094) | OpenTagでタグ開始 | E-02: L210-219 | ○ |
| C-95 (UT-FED-095) | CloseTagでタグ終了 | E-02: L248-253 | ○ |
| C-96 (UT-FED-096) | 特殊文字でCDATAラップ | E-02: L277-287 CheckString関数 | ○ |
| C-97 (UT-FED-097) | &でCDATAラップ | E-02: L281 `if instr(data, "&") then need = true` | ○ |
| C-98 (UT-FED-098) | 通常テキストはそのまま | E-02: L285-286 | ○ |
| C-99 (UT-FED-099) | AddAttributeで属性追加 | E-02: L228-235 | ○ |
| C-100 (UT-FED-100) | QuickTagで一括処理 | E-02: L222-225 | ○ |
| C-101 (UT-FED-101) | CloseAllTagsで全タグ終了 | E-02: L258-265 | ○ |
| C-102 (UT-FED-102) | Resetで初期状態 | E-02: L204-207 | ○ |
| C-103 (UT-FED-103) | GetXMLでXML取得 | E-02: L268-270 | ○ |

### ASP画面（E-03〜E-06）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 (UT-FED-104) | 保存ボタンで保存・リダイレクト | E-03: L10-15 | ○ |
| C-105 (UT-FED-105) | 削除ボタンで削除・リダイレクト | E-03: L16-19 | ○ |
| C-106 (UT-FED-106) | CSRF検証実行 | E-03: L11, L17 `checkCSRF()` | ○ |
| C-107 (UT-FED-107) | 保存失敗時リダイレクトなし | E-03: L13-14 `if feed.save then` | ○ |
| C-108 (UT-FED-108) | フィード一覧表示 | E-04: L9 `for each feedKey in feeds` | ○ |
| C-109 (UT-FED-109) | コピーしてリダイレクト | E-04: L5-7 | ○ |
| C-110 (UT-FED-110) | プレビュー表示 | E-05: L6 `Response.write feed.build()` | ○ |
| C-111 (UT-FED-111) | メインRSS生成 | E-06: L11-58 | ○ |
| C-112 (UT-FED-112) | RSSキャッシュ使用 | E-06: L13, L57 | ○ |
| C-113 (UT-FED-113) | リストページRSS生成 | E-06: L91-130 | ○ |
| C-114 (UT-FED-114) | フォーラムRSS生成 | E-06: L133-173 | ○ |
| C-115 (UT-FED-115) | カタログRSS生成 | E-06: L175-213 | ○ |
| C-116 (UT-FED-116) | イントラネットアクセス拒否 | E-06: L63-79 | ○ |
| C-117 (UT-FED-117) | ヒット数記録 | E-06: L226 `selectedPage.addHitRSS` | ○ |
| C-118 (UT-FED-118) | リファラー記録 | E-06: L228 `logReferer()` | ○ |

## 4) 不足情報（Unknown / Missing）

**根拠なしの項目はありません。**

全てのテストケースは、以下のソースコードファイルから直接抽出された関数・メソッドに基づいています：

1. `asp/includes/feed.asp` - cls_feedクラスの全メソッド
2. `asp/includes/rss_writer.asp` - kwRSS_writer、aspXMLクラスの全メソッド
3. `asp/bs_feedEdit.asp` - フィード編集処理
4. `asp/bs_feedList.asp` - フィード一覧・コピー処理
5. `asp/bs_feedPreview.asp` - フィードプレビュー処理
6. `rss.asp` - RSS生成エンドポイント

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|------------|------|------|
| 2 (高リスク) | XSS対策 (UT-FED-063) | bEnableJS=falseでremoveJS関数によるJavaScript除去が行われるが、removeJS関数の実装が別ファイルにあり、完全性の確認が必要 |
| 2 (高リスク) | SQLインジェクション | Pick/Check/SaveメソッドでSQL文が動的構築されており、cleanup/convertGetal関数の安全性確認が必要 |
| 1 (中リスク) | キャッシュ制御 | アプリケーションキャッシュの有効期限管理と同時アクセス時の整合性 |
| 1 (中リスク) | XML外部エンティティ | xmlDOM.Load時のXXE（XML External Entity）攻撃への脆弱性 |
| 0 (低リスク) | 文字数制限 | sNameの50文字制限は明示的だが、他のフィールドの制限が不明確 |

## 6) レビュアーチェックリスト（最小）

- [ ] **セキュリティ**: removeJS関数の実装を確認し、全てのJavaScript実行パターンがブロックされているか
- [ ] **セキュリティ**: cleanup関数がSQLインジェクションを完全に防いでいるか
- [ ] **セキュリティ**: XMLパーサーのXXE攻撃への対策（resolveExternals = Falseは設定済み）
- [ ] **データ整合性**: フィード削除時のページ関連付け解除が全ケースで正しく動作するか
- [ ] **パフォーマンス**: 複数URL結合時のフィード取得がタイムアウトしないか
- [ ] **キャッシュ**: 同時アクセス時のキャッシュ更新競合が問題を起こさないか
- [ ] **エラーハンドリング**: On Error Resume Nextの範囲と、エラー時の動作が適切か
- [ ] **互換性**: MSXML2.DOMDocumentとMsxml2.DOMDocument.6.0の両方でのフィード取得が正しく動作するか
