---
generated_at: 2026-01-24 15:30:00
metrics:
  claims_total: 115
  claims_with_evidence: 112
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：form.csv (単体テストケース一覧)

## 本レポートについて

### 目的
本レポートは、生成されたformモジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：112 / 115、根拠なし：3
- 優先レビュー（高）
  1. **getVisitorDetails関数の実装詳細**：includesファイル内に定義があると推測されるが、直接確認できていない
  2. **cls_mail_message.send()の動作詳細**：メール送信クラスの実装が別ファイルにあり、詳細未確認
  3. **allowedFileTypesの定義**：許可ファイルタイプの定義場所が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/includes/form.asp` - cls_formクラス定義（887行）
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/includes/FormField.asp` - cls_FormFieldクラス定義（385行）
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/includes/submission.asp` - cls_submissionクラス定義（140行）
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_formList.asp` - フォーム一覧ページ（10行）
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_formEdit.asp` - フォーム編集ページ（46行）
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_formFields.asp` - フィールド管理ページ（20行）
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_formPreview.asp` - プレビューページ（7行）
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_formExport.asp` - エクスポートページ（50行）
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_formExcel.asp` - Excel出力ページ（67行）
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_formSubmissionEdit.asp` - サブミッション編集ページ（45行）
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_form.asp` - フォーム選択UI（5行）
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_formExpl.asp` - フォームタイプ説明ページ（3行）
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/includes/formFieldTypeList.asp` - フィールドタイプ定数定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01~C-02 | cls_form Class_Initialize | E-01 (行7-26) | ○ |
| C-03~C-05 | cls_form Pick | E-01 (行27-63) | ○ |
| C-06~C-17 | cls_form Check | E-01 (行64-130) | ○ |
| C-18~C-22 | cls_form Save | E-01 (行131-184) | ○ |
| C-23~C-24 | cls_form getRequestValues | E-01 (行185-209) | ○ |
| C-25~C-28 | cls_form remove | E-01 (行210-232) | ○ |
| C-29~C-31 | cls_form fields | E-01 (行233-249) | ○ |
| C-32~C-41 | cls_form build | E-01 (行250-805) | ○ |
| C-42~C-43 | cls_form submissions | E-01 (行824-838) | ○ |
| C-44~C-45 | cls_form copy | E-01 (行839-851) | ○ |
| C-46~C-47 | cls_form copyToCustomer | E-01 (行852-868) | ○ |
| C-48 | cls_form insertSubmissionID | E-01 (行869-871) | ○ |
| C-49 | cls_form removeAllSubmissions | E-01 (行875-886) | ○ |
| C-50~C-51 | cls_form deleteTempFolder | E-01 (行806-823) | ○ |
| C-52~C-54 | cls_FormField Class_Initialize/Pick | E-02 (行9-57) | ○ |
| C-55~C-61 | cls_FormField Check | E-02 (行58-98) | ○ |
| C-62~C-65 | cls_FormField Save | E-02 (行99-156) | ○ |
| C-66~C-68 | cls_FormField getRequestValues | E-02 (行157-196) | ○ |
| C-69~C-70 | cls_FormField isMandatory | E-02 (行197-203) | ○ |
| C-71~C-74 | cls_FormField moveUp/moveDown | E-02 (行208-227) | ○ |
| C-75~C-77 | cls_FormField remove | E-02 (行243-276) | ○ |
| C-78~C-79 | cls_FormField showSelected | E-02 (行277-294) | ○ |
| C-80~C-82 | cls_FormField showSelectedRadio | E-02 (行298-328) | ○ |
| C-83~C-84 | cls_FormField showSelectedRadioCB | E-02 (行329-369) | ○ |
| C-85~C-86 | cls_FormField copy/form | E-02 (行370-384) | ○ |
| C-87~C-89 | cls_submission Class_Initialize/Pick | E-03 (行9-30) | ○ |
| C-90 | cls_submission Check | E-03 (行31-33) | ○ |
| C-91~C-93 | cls_submission Save | E-03 (行34-59) | ○ |
| C-92 | sVisitorDetailsはgetVisitorDetails()で設定 | **根拠不足** | △ |
| C-94~C-95 | cls_submission form/item | E-03 (行60-67) | ○ |
| C-96~C-97 | cls_submission remove | E-03 (行68-93) | ○ |
| C-98~C-99 | cls_submission values | E-03 (行94-107) | ○ |
| C-100~C-101 | cls_submission sCopyValues | E-03 (行110-138) | ○ |
| C-102 | bs_formList copyform.copy | E-04 (行5-6) | ○ |
| C-103~C-105 | bs_formEdit save/delete/CSRF | E-05 (行14-31) | ○ |
| C-106~C-107 | bs_formFields moveUp/moveDown | E-06 (行7-13) | ○ |
| C-108~C-109 | bs_formExport remove/removeAll | E-08 (行9-16) | ○ |
| C-110~C-111 | bs_formSubmissionEdit 編集/権限 | E-10 (行8-31) | ○ |
| C-112~C-113 | bs_formExcel export/showCatalog | E-09 (行9-65) | ○ |
| C-114 | bs_formPreview build | E-07 (行4-6) | ○ |
| C-115 | bs_form alignList | E-11 (行2-4) | ○ |
| C-40 | cls_mail_message.sendの動作詳細 | **根拠不足** | △ |
| C-38 | allowedFileTypesの定義 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **getVisitorDetails関数**：E-03内でgetVisitorDetails()が呼ばれているが、この関数の定義場所を特定できていない
  - 候補：asp/includes/common.asp / asp/includes/utilities.asp / 他のincludeファイル
- **cls_mail_message クラス**：E-01でcls_mail_messageが使用されているが、このクラスの詳細実装が未確認
  - 候補：asp/includes/mail.asp / asp/includes/mail_message.asp
- **allowedFileTypes Dictionary**：E-01でallowedFileTypes.existsが使用されているが、定義場所が未確認
  - 候補：asp/includes/fileTypes.asp / asp/includes/constants.asp

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：大部分のテストケースはソースコードから直接導出されており、信頼性が高い
- **リスク1（中）**：メール送信テスト(C-40, C-41)は外部依存があり、実際のテスト実装時にモック化が必要
- **リスク1（中）**：ファイルアップロードテスト(C-38, C-39, C-76, C-77, C-97)は物理ファイル操作を含むため、テスト環境の準備が必要
- **リスク0（低）**：CAPTCHAテスト(C-37)はSession依存があるが、テスト可能

## 6) レビュアーチェックリスト（最小）
- [ ] cls_formの重要メソッド（Check, Save, build, remove）のテストケースが網羅されているか確認
- [ ] cls_FormFieldの順序変更（moveUp, moveDown, setRangByNumber）のエッジケースが十分か確認
- [ ] セキュリティ関連（CSRF, 権限チェック, ファイルパス検証）のテストが十分か確認
- [ ] メール送信機能のテストケースがモック化を前提とした設計になっているか確認
- [ ] ファイルアップロード機能の境界値（サイズ上限、許可拡張子）テストが十分か確認
- [ ] 外部依存関数（getVisitorDetails, cls_mail_message, allowedFileTypes）の定義を確認し、必要に応じてテストケースを追加
