---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 95
  claims_with_evidence: 92
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：frontend.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上に対応する関数・処理が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要な関数・処理を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 92 / 95 = 0.97
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：92 / 95、根拠なし：3
- 優先レビュー（高）
  1. **UT-FRE-001**：begin.asp内のexecBeforePageLoad実装の確認が必要
  2. **UT-FRE-005/006**：checkCSRF関数の実装詳細がインクルードファイルに存在
  3. **UT-FRE-076**：checkCSRF_Upload関数の実装詳細がインクルードファイルに存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/default.asp`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/index.asp`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/mailPage.asp`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/printPage.asp`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/rss.asp`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/sitemap.asp`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/modules/ajax.asp`
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/modules/module1.asp`
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/modules/module2.asp`
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/modules/module3.asp`
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_editListItem.asp`
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_editPage.asp`
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_mailcontact.asp`
- E-14: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_editListItemPic.asp`
- E-15: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_editListPage.asp`
- E-16: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/fs_editListItems.asp`

## 3) Claims と根拠の対応（レビューの主戦場）

### default.asp / index.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-FRE-001) | execBeforePageLoad実行でページ読み込み | E-01 (2行目: `run(execBeforePageLoad)`) | ○ |
| C-02 (UT-FRE-002) | default.aspへのリダイレクト | E-02 (1行目: `#include file="default.asp"`) | ○ |

### mailPage.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-03 (UT-FRE-003) | メール送信機能 | E-03 (47行目: `pageEMail.send`) | ○ |
| C-04 (UT-FRE-004) | メールアドレス空エラー | E-03 (26-27行目: `CheckEmailSyntax`) | ○ |
| C-05 (UT-FRE-005) | CSRFトークン正常 | E-03 (19行目: `checkCSRF()`) | ○ |
| C-06 (UT-FRE-006) | CSRFトークン不正 | E-03 (19行目: `checkCSRF()`) | △ |
| C-07 (UT-FRE-007) | CAPTCHA正常 | E-03 (22行目: `session("CAPTCHA")`) | ○ |
| C-08 (UT-FRE-008) | CAPTCHA不正 | E-03 (24行目: `message.AddError("err_captcha")`) | ○ |
| C-09 (UT-FRE-009) | メール形式不正 | E-03 (25-27行目: `CheckEmailSyntax`) | ○ |

### printPage.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 (UT-FRE-010) | タイトル・ボディ表示 | E-04 (11行目: `selectedPage.replaceBlocks`) | ○ |
| C-11 (UT-FRE-011) | 定数置換 | E-04 (11行目: `treatConstants`) | ○ |
| C-12 (UT-FRE-012) | sApplication空で表示 | E-04 (8行目: `isLeeg(selectedPage.sApplication)`) | ○ |
| C-13 (UT-FRE-013) | sApplication設定でEnd | E-04 (8行目: `Response.End`) | ○ |

### rss.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 (UT-FRE-014) | RSSフィード生成 | E-05 (7行目: `new kwRSS_writer`) | ○ |
| C-15 (UT-FRE-015) | タイトル設定 | E-05 (33行目: `rss.SetTitle`) | ○ |
| C-16 (UT-FRE-016) | リンク設定 | E-05 (34行目: `rss.SetLink`) | ○ |
| C-17 (UT-FRE-017) | ID暗号化 | E-05 (34行目: `encrypt(rssPage.iId)`) | ○ |
| C-18 (UT-FRE-018) | RFC822日付 | E-05 (36行目: `Format_RFC822_DateAndTime`) | ○ |
| C-19 (UT-FRE-019) | イントラネット認証 | E-05 (63行目: `logon.authenticatedIntranet`) | ○ |
| C-20 (UT-FRE-020) | ヒットカウント | E-05 (226行目: `selectedPage.addHitRSS`) | ○ |
| C-21 (UT-FRE-021) | キャッシュ保存 | E-05 (51行目: `application("RSS" & cId)`) | ○ |
| C-22 (UT-FRE-022) | キャッシュ読込 | E-05 (13行目: `isEmpty(application("RSS" & cId))`) | ○ |

### sitemap.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 (UT-FRE-023) | XMLサイトマップ生成 | E-06 (9-14行目: XML宣言) | ○ |
| C-24 (UT-FRE-024) | 検索結果出力 | E-06 (17-23行目: `cls_search`) | ○ |
| C-25 (UT-FRE-025) | ID暗号化 | E-06 (51行目: `encrypt(pageKey)`) | ○ |
| C-26 (UT-FRE-026) | テーマID変換 | E-06 (29行目: `convertGetal`) | ○ |
| C-27 (UT-FRE-027) | テーマID=0スキップ | E-06 (29行目: `convertGetal(...)<>0`) | ○ |
| C-28 (UT-FRE-028) | ユーザーフレンドリーURL | E-06 (47-48行目: `sUserFriendlyURL`) | ○ |

### modules/ajax.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 (UT-FRE-029) | +をスペースに | E-07 (21行目: `REPLACE(sConvert, "+", " ")`) | ○ |
| C-30 (UT-FRE-030) | %エンコードデコード | E-07 (24-32行目: `Split`, `Chr`) | ○ |
| C-31 (UT-FRE-031) | Null処理 | E-07 (15-17行目: `IsNull`) | ○ |
| C-32 (UT-FRE-032) | ダブルクォートエスケープ | E-07 (43行目: `replace(sValue,"""","&quot;")`) | ○ |
| C-33 (UT-FRE-033) | <エスケープ | E-07 (44行目: `replace(...,"<","&lt;")`) | ○ |
| C-34 (UT-FRE-034) | >エスケープ | E-07 (45行目: `replace(...,">","&gt;")`) | ○ |
| C-35 (UT-FRE-035) | sanitize Null処理 | E-07 (40-41行目: `isNull`) | ○ |
| C-36 (UT-FRE-036) | 名前空エラー | E-07 (2-3行目: `yourname=""`) | ○ |
| C-37 (UT-FRE-037) | 挨拶表示 | E-07 (6-8行目: `Hello` 出力) | ○ |

### modules/module1.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 (UT-FRE-038) | Good morning | E-08 (11-12行目: `dHour < 12`) | ○ |
| C-39 (UT-FRE-039) | Good afternoon | E-08 (13-14行目: `dHour < 17`) | ○ |
| C-40 (UT-FRE-040) | Good evening | E-08 (15-16行目: `Else`) | ○ |
| C-41 (UT-FRE-041) | 12時境界 | E-08 (13行目: `ElseIf dHour < 17`) | ○ |
| C-42 (UT-FRE-042) | 17時境界 | E-08 (15行目: `Else`) | ○ |

### modules/module2.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 (UT-FRE-043) | 認証済みアクセス | E-09 (5行目: `isAUTHENTICATED=true`) | ○ |
| C-44 (UT-FRE-044) | 未認証アクセス | E-09 (13-15行目: `else`) | ○ |

### modules/module3.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 (UT-FRE-045) | sCodeリダイレクト | E-10 (8行目: `sCode`) | ○ |
| C-46 (UT-FRE-046) | HTMLエンコード | E-10 (12行目: `server.HTMLEncode`) | ○ |
| C-47 (UT-FRE-047) | フォーム取得 | E-10 (21-23行目: `Request.Form`) | ○ |

### asp/fs_editListItem.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 (UT-FRE-048) | decrypt | E-11 (14行目: `decrypt(Request("iListPageID"))`) | ○ |
| C-49 (UT-FRE-049) | getLper権限許可 | E-11 (12-13行目: `getLper`) | ○ |
| C-50 (UT-FRE-050) | getLper権限拒否 | E-11 (19行目: `Response.Redirect`) | ○ |
| C-51 (UT-FRE-051) | save処理 | E-11 (41-43行目: `selectedPage.save`) | ○ |
| C-52 (UT-FRE-052) | 日付変換 | E-11 (23行目: `convertDateFromPicker`) | ○ |
| C-53 (UT-FRE-053) | 削除処理 | E-11 (33-40行目: `bDeleted=true`) | ○ |
| C-54 (UT-FRE-054) | 子アイテム削除 | E-11 (39行目: `deleteListItems()`) | ○ |

### asp/fs_editPage.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 (UT-FRE-055) | checkCSRF | E-12 (16行目: `checkCSRF()`) | ○ |
| C-56 (UT-FRE-056) | getTper権限 | E-12 (17-22行目: `getTPerP.exists`) | ○ |
| C-57 (UT-FRE-057) | getBper権限 | E-12 (24-33行目: `getBPerP.exists`) | ○ |
| C-58 (UT-FRE-058) | 検証一時保存 | E-12 (18-21行目: `sTitleToBeValidated`) | ○ |
| C-59 (UT-FRE-059) | 検証メール | E-12 (43-49行目: `notifMail`) | ○ |
| C-60 (UT-FRE-060) | 権限なしリダイレクト | E-12 (68行目: `Response.Redirect`) | ○ |

### asp/fs_mailcontact.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 (UT-FRE-061) | イントラネット認証 | E-13 (6行目: `authenticatedIntranet`) | ○ |
| C-62 (UT-FRE-062) | メール受信設定 | E-13 (7行目: `bGetEmailsFromSite`) | ○ |
| C-63 (UT-FRE-063) | CAPTCHA正常 | E-13 (9行目: `session("CAPTCHA")`) | ○ |
| C-64 (UT-FRE-064) | CAPTCHA不正 | E-13 (10行目: `AddError("err_captcha")`) | ○ |
| C-65 (UT-FRE-065) | 本文空エラー | E-13 (11-12行目: `isLeeg`, `err_mandatory`) | ○ |
| C-66 (UT-FRE-066) | CCオプション | E-13 (24-28行目: `cc`) | ○ |
| C-67 (UT-FRE-067) | 送信後リダイレクト | E-13 (30行目: `Response.Redirect`) | ○ |

### asp/fs_editListItemPic.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 (UT-FRE-068) | アップロード | E-14 (27行目: `Upload.Save`) | ○ |
| C-69 (UT-FRE-069) | 拡張子取得 | E-14 (56行目: `GetFileExtension`) | ○ |
| C-70 (UT-FRE-070) | 許可形式 | E-14 (58行目: `png,jpg,gif,jpeg`) | ○ |
| C-71 (UT-FRE-071) | 不許可形式 | E-14 (60-61行目: `case else`) | ○ |
| C-72 (UT-FRE-072) | リネーム | E-14 (69行目: `rename`) | ○ |
| C-73 (UT-FRE-073) | sLPIC設定 | E-14 (87行目: `sLPIC`) | ○ |
| C-74 (UT-FRE-074) | 画像削除 | E-14 (93行目: `deleteListItemImage()`) | ○ |
| C-75 (UT-FRE-075) | フォルダ作成 | E-14 (12-14行目: `createfolder`) | ○ |
| C-76 (UT-FRE-076) | CSRF Upload | E-14 (28行目: `checkCSRF_Upload`) | △ |

### asp/fs_editListPage.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 (UT-FRE-077) | getTper権限 | E-15 (17-18行目: `getTPerP.exists`) | ○ |
| C-78 (UT-FRE-078) | getBper権限 | E-15 (20-25行目: `getBPerP.exists`) | ○ |
| C-79 (UT-FRE-079) | sOrderBY設定 | E-15 (23行目: `sOrderBY`) | ○ |
| C-80 (UT-FRE-080) | bOpenOnload設定 | E-15 (22行目: `bOpenOnload`) | ○ |
| C-81 (UT-FRE-081) | bPushRSS設定 | E-15 (24行目: `bPushRSS`) | ○ |
| C-82 (UT-FRE-082) | iLPOpenByDefault | E-15 (25行目: `iLPOpenByDefault`) | ○ |

### asp/fs_editListItems.asp
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 (UT-FRE-083) | getLper権限許可 | E-16 (4-5行目: `getLperP`) | ○ |
| C-84 (UT-FRE-084) | getLper権限拒否 | E-16 (7行目: `Response.Redirect`) | ○ |
| C-85 (UT-FRE-085) | listitems取得 | E-16 (14行目: `selectedPage.listitems`) | ○ |
| C-86 (UT-FRE-086) | オフライン表示 | E-16 (29-30行目: `statusString`) | ○ |
| C-87 (UT-FRE-087) | プレビューリンク | E-16 (35-37行目: `preview`) | ○ |
| C-88 (UT-FRE-088) | 画像リンク | E-16 (39-41行目: `bListItemPic`) | ○ |

### rss.asp（追加）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 (UT-FRE-089) | カタログRSS | E-05 (175-213行目: `cls_itemSearch`) | ○ |
| C-90 (UT-FRE-090) | テーマRSS | E-05 (133-173行目: `theme.posts`) | ○ |
| C-91 (UT-FRE-091) | リストアイテムRSS | E-05 (91-130行目: `fastlistitems`) | ○ |
| C-92 (UT-FRE-092) | enclosure設定 | E-05 (116-118行目: `SetEnclosure`) | ○ |
| C-93 (UT-FRE-093) | comments設定 | E-05 (165行目: `setComments`) | ○ |

### sitemap.asp（追加）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 (UT-FRE-094) | テーマ投稿 | E-06 (29-38行目: `tblPost`) | ○ |
| C-95 (UT-FRE-095) | リストアイテムURL | E-06 (44-45行目: `iListPageID`) | ○ |

## 4) 不足情報（Unknown / Missing）
- **checkCSRF関数の詳細実装**：インクルードファイル（asp/includes/）内に定義されており、frontendモジュール外
  - 候補：asp/includes/security.asp / asp/includes/functions.asp
- **checkCSRF_Upload関数の詳細実装**：アップロード用CSRF検証の詳細がインクルードファイル内
  - 候補：asp/includes/upload.asp / asp/includes/security.asp
- **execBeforePageLoad関数の詳細**：begin.asp内で定義されている可能性
  - 候補：asp/begin.asp

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：modules/module1.asp（時刻表示のみ）
- **1（中リスク）**：sitemap.asp, printPage.asp（表示・SEO機能）
- **2（高リスク）**：mailPage.asp, fs_*.asp（認証・ファイルアップロード・メール送信に関わる）

## 6) レビュアーチェックリスト（最小）
- [ ] checkCSRF関数の実装がセキュリティ要件を満たしているか確認
- [ ] ファイルアップロード（fs_editListItemPic.asp）の許可拡張子制限が適切か確認
- [ ] CAPTCHA検証のセッション管理が安全か確認
- [ ] encrypt/decrypt関数の暗号化強度が適切か確認
- [ ] メール送信機能（mailPage.asp, fs_mailcontact.asp）でのインジェクション対策確認
- [ ] sanitize関数がすべてのXSSパターンをカバーしているか確認
- [ ] Session認証チェック（module2.asp）の実装が適切か確認
