---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：gallery.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. **テストID: UT-GAL-014〜016**：Save関連テスト（データ永続化の重要機能）
  2. **テストID: UT-GAL-008〜013**：Check関連テスト（バリデーションの重要機能）
  3. **テストID: UT-GAL-061〜064**：セキュリティ関連テスト（CSRF保護）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/includes/gallery.asp` - cls_galleryクラス定義（695行）
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/includes/gallerySEList.asp` - cls_gallerySEListクラス定義（33行）
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/includes/galleryTypeList.asp` - cls_galleryTypeList、cls_galleryCycleListクラス定義（161行）
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_galleryEdit.asp` - ギャラリー編集ページ（195行）
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_galleryList.asp` - ギャラリー一覧ページ（10行）
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_galleryPreview.asp` - ギャラリープレビューページ（7行）
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_galleryBack.asp` - 戻るリンクパーツ（2行）

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_galleryクラスのテストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-GAL-001) | Class_Initialize初期化時のデフォルト値設定 | E-01 L7-41 | ○ |
| C-02 (UT-GAL-002) | iGalleryIDパラメータからのギャラリー読み込み | E-01 L38 | ○ |
| C-03 (UT-GAL-003) | 不正IDでのエラーハンドリング | E-01 L8,40 | ○ |
| C-04 (UT-GAL-004) | Pick関数での有効ID取得 | E-01 L62-108 | ○ |
| C-05 (UT-GAL-005) | Pick関数でのisNumeriek検証 | E-01 L64 | ○ |
| C-06 (UT-GAL-006) | Pick関数での存在しないID処理 | E-01 L67 | ○ |
| C-07 (UT-GAL-007) | Pick関数でのID=0境界値 | E-01 L64 | ○ |
| C-08 (UT-GAL-008) | Check関数での正常系バリデーション | E-01 L109-132 | ○ |
| C-09 (UT-GAL-009) | Check関数でのsName必須チェック | E-01 L111-114 | ○ |
| C-10 (UT-GAL-010) | Check関数でのsPath必須チェック | E-01 L115-118 | ○ |
| C-11 (UT-GAL-011) | Check関数でのsCode必須チェック | E-01 L119-122 | ○ |
| C-12 (UT-GAL-012) | Check関数での重複sCodeチェック | E-01 L123-131 | ○ |
| C-13 (UT-GAL-013) | Check関数での自身との重複除外 | E-01 L125 | ○ |
| C-14 (UT-GAL-014) | Save関数での新規保存 | E-01 L133-193 | ○ |
| C-15 (UT-GAL-015) | Save関数での更新保存 | E-01 L149 | ○ |
| C-16 (UT-GAL-016) | Save関数でのCheck失敗時の処理 | E-01 L134-139 | ○ |
| C-17 (UT-GAL-017) | Save関数でのキャッシュクリア | E-01 L191-192 | ○ |
| C-18 (UT-GAL-018) | Save関数でのsName文字数制限 | E-01 L151 | ○ |
| C-19 (UT-GAL-019) | getRequestValues関数でのフォーム値取得 | E-01 L194-269 | ○ |
| C-20 (UT-GAL-020) | getRequestValues関数でのsCode大文字変換 | E-01 L201 | ○ |
| C-21 (UT-GAL-021) | getRequestValues関数でのsCycleEffectデフォルト | E-01 L228 | ○ |
| C-22 (UT-GAL-022) | getRequestValues関数でのNivo Slider寸法デフォルト | E-01 L236-243 | ○ |
| C-23 (UT-GAL-023) | getRequestValues関数でのNivo Slider画像リンク処理 | E-01 L246-267 | ○ |
| C-24 (UT-GAL-024) | remove関数での削除処理 | E-01 L277-285 | ○ |
| C-25 (UT-GAL-025) | remove関数での空iIdガード | E-01 L278 | ○ |
| C-26 (UT-GAL-026) | remove関数でのキャッシュクリア | E-01 L282-283 | ○ |
| C-27 (UT-GAL-027) | build関数でのHTML生成 | E-01 L289-677 | ○ |
| C-28 (UT-GAL-028) | build関数でのiId=0ガード | E-01 L301 | ○ |
| C-29 (UT-GAL-029) | build関数でのフォルダ存在チェック | E-01 L308-310 | ○ |
| C-30 (UT-GAL-030) | build関数での空フォルダ処理 | E-01 L313,652-654 | ○ |
| C-31 (UT-GAL-031) | build関数でのページング（次へ） | E-01 L557-571 | ○ |
| C-32 (UT-GAL-032) | build関数でのページング（前へ） | E-01 L565-569 | ○ |
| C-33 (UT-GAL-033) | build関数での名前順ソート | E-01 L323-324 | ○ |
| C-34 (UT-GAL-034) | build関数でのランダムソート | E-01 L333-336 | ○ |
| C-35 (UT-GAL-035) | build関数でのColorBoxタイプ処理 | E-01 L363-376,663-676 | ○ |
| C-36 (UT-GAL-036) | build関数でのJQuery Cycleタイプ処理 | E-01 L609-633 | ○ |
| C-37 (UT-GAL-037) | build関数でのSlideShowタイプ処理 | E-01 L635-651 | ○ |
| C-38 (UT-GAL-038) | build関数でのNivo Sliderタイプ処理 | E-01 L583-608 | ○ |
| C-39 (UT-GAL-039) | build関数での特殊効果処理 | E-01 L397-406,494-507 | ○ |
| C-40 (UT-GAL-040) | build関数でのカスタムリンク変数置換 | E-01 L377-381 | ○ |
| C-41 (UT-GAL-041) | copy関数でのギャラリーコピー | E-01 L687-694 | ○ |
| C-42 (UT-GAL-042) | copy関数でのsCode再生成 | E-01 L691 | ○ |
| C-43 (UT-GAL-043) | copy関数での数値チェック | E-01 L688 | ○ |
| C-44 (UT-GAL-044) | sNextLinkプロパティ取得（backsitePV=false） | E-01 L45-51 | ○ |
| C-45 (UT-GAL-045) | sNextLinkプロパティ取得（backsitePV=true） | E-01 L46-48 | ○ |
| C-46 (UT-GAL-046) | sPreviousLinkプロパティ取得（backsitePV=false） | E-01 L55-61 | ○ |
| C-47 (UT-GAL-047) | sPreviousLinkプロパティ取得（backsitePV=true） | E-01 L56-58 | ○ |
| C-48 (UT-GAL-048) | iSlideShowTimerQSDefaultプロパティ（0の場合） | E-01 L270-276 | ○ |
| C-49 (UT-GAL-049) | iSlideShowTimerQSDefaultプロパティ（設定値） | E-01 L273-275 | ○ |
| C-50 (UT-GAL-050) | Jscriptプロパティ取得 | E-01 L678-686 | ○ |

### cls_galleryTypeListクラスのテストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 (UT-GAL-051) | Class_Initializeでのリスト初期化 | E-03 L7-16 | ○ |
| C-52 (UT-GAL-052) | showSelectedのsingleモード | E-03 L20-21 | ○ |
| C-53 (UT-GAL-053) | showSelectedのoptionモード | E-03 L22-34 | ○ |

### cls_gallerySEListクラスのテストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 (UT-GAL-054) | Class_Initializeでの特殊効果リスト初期化 | E-02 L5-12 | ○ |
| C-55 (UT-GAL-055) | showSelectedのoptionモード | E-02 L16-32 | ○ |

### cls_galleryCycleListクラスのテストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 (UT-GAL-056) | Class_Initializeでのサイクルエフェクトリスト初期化 | E-03 L38-70 | ○ |
| C-57 (UT-GAL-057) | showSelectedのoptionモード | E-03 L75-89 | ○ |
| C-58 (UT-GAL-058) | showSelectedNSのoptionモード | E-03 L91-117 | ○ |
| C-59 (UT-GAL-059) | showSelectedNS2のoptionモード | E-03 L120-158 | ○ |

### ASPページのテストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 (UT-GAL-060) | bs_galleryEdit.aspのpostBack処理 | E-04 L9-12 | ○ |
| C-61 (UT-GAL-061) | bs_galleryEdit.aspの保存処理 | E-04 L15-24 | ○ |
| C-62 (UT-GAL-062) | bs_galleryEdit.aspのプレビュー処理 | E-04 L20-22 | ○ |
| C-63 (UT-GAL-063) | bs_galleryEdit.aspの削除処理 | E-04 L26-29 | ○ |
| C-64 (UT-GAL-064) | bs_galleryEdit.aspのCSRF検証 | E-04 L17,27 | ○ |
| C-65 (UT-GAL-065) | bs_galleryList.aspの一覧表示 | E-05 L8-10 | ○ |
| C-66 (UT-GAL-066) | bs_galleryList.aspの空一覧処理 | E-05 L10 | ○ |
| C-67 (UT-GAL-067) | bs_galleryList.aspのコピー処理 | E-05 L5-7 | ○ |
| C-68 (UT-GAL-068) | bs_galleryPreview.aspのプレビュー表示 | E-06 L4-7 | ○ |
| C-69 (UT-GAL-069) | bs_galleryPreview.aspのbacksitePV設定 | E-06 L6 | ○ |
| C-70 (UT-GAL-070) | bs_galleryBack.aspの戻るリンク | E-07 L2 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：すべてのテストケースがソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードの直接的な解析に基づいており、根拠が明確である

## 6) レビュアーチェックリスト（最小）
- [ ] cls_galleryクラスの主要メソッド（Pick, Check, Save, build, remove, copy）のテストケースが網羅されているか確認
- [ ] 各ギャラリータイプ（ColorBox, JQuery Cycle, SlideShow, Nivo Slider）のbuild出力テストが含まれているか確認
- [ ] バリデーション関連（Check関数）のテストケースで必須項目と一意性チェックが網羅されているか確認
- [ ] セキュリティ関連（CSRF検証）のテストケースが含まれているか確認
- [ ] 境界値テスト（空値、0、存在しないID等）が適切に含まれているか確認
- [ ] Classic ASPの特性（On Error Resume Next等）を考慮したエラーハンドリングテストが含まれているか確認
