---
generated_at: 2026-01-24 12:30:00
metrics:
  claims_total: 77
  claims_with_evidence: 77
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：guestbook.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で該当項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：77 / 77、根拠なし：0
- 優先レビュー（高）
  1. **CAPTCHA関連テスト（C-24, C-25）**：セッション変数とリクエスト変数の組み合わせテスト
  2. **IPブロック機能（C-54）**：セキュリティ関連の重要機能
  3. **スパム防止チェック（C-50）**：href=検出ロジックの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/guestbook.asp` - cls_guestbookクラス定義（312行）
- E-02: `asp/includes/guestbookitem.asp` - cls_guestbookitemクラス定義（147行）
- E-03: `asp/bs_gbEdit.asp` - ゲストブック編集画面（38行）
- E-04: `asp/bs_gbEditItems.asp` - エントリ編集画面（32行）
- E-05: `asp/bs_gbExcel.asp` - Excelエクスポート機能（26行）
- E-06: `asp/bs_gbList.asp` - ゲストブック一覧画面（11行）
- E-07: `asp/bs_gbBack.asp` - 戻りリンクコンポーネント（3行）

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_guestbookクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Class_Initialize初期化時にデフォルト値設定 | E-01 (L19-33) | ○ |
| C-02 | 初期化時にデフォルトテンプレート設定 | E-01 (L25-30) | ○ |
| C-03 | getByCode正常系コード検索 | E-01 (L34-44) | ○ |
| C-04 | getByCode異常系存在しないコード | E-01 (L34-44) | ○ |
| C-05 | getByCode境界値50文字制限 | E-01 (L38) `left(cleanup(cValue),50)` | ○ |
| C-06 | Pick正常系ID検索 | E-01 (L45-70) | ○ |
| C-07 | Pick異常系非数値ID | E-01 (L47) `if isNumeriek(id)` | ○ |
| C-08 | Pick異常系存在しないID | E-01 (L50) `if not rs.eof` | ○ |
| C-09 | Check正常系バリデーション成功 | E-01 (L71-83) | ○ |
| C-10 | Check異常系sCode空 | E-01 (L73-77) | ○ |
| C-11 | Check異常系sName空 | E-01 (L78-82) | ○ |
| C-12 | Save正常系新規保存 | E-01 (L84-125) | ○ |
| C-13 | Save正常系更新 | E-01 (L98-99) | ○ |
| C-14 | Save異常系Check失敗 | E-01 (L86-91) | ○ |
| C-15 | Save overruleCID使用 | E-01 (L107-111) | ○ |
| C-16 | getRequestValues正常系 | E-01 (L126-142) | ○ |
| C-17 | getRequestValues sCode正規化 | E-01 (L127) `replace(lcase(...))` | ○ |
| C-18 | remove正常系削除 | E-01 (L143-151) | ○ |
| C-19 | remove異常系空ID | E-01 (L144) `if not isLeeg(iId)` | ○ |
| C-20 | copy正常系コピー | E-01 (L152-158) | ○ |
| C-21 | copy異常系非数値ID | E-01 (L153) `if isNumeriek(iId)` | ○ |
| C-22 | build正常系HTML生成 | E-01 (L159-284) | ○ |
| C-23 | build異常系ID=0 | E-01 (L160-162) | ○ |
| C-24 | build CAPTCHA成功 | E-01 (L173-205) | ○ |
| C-25 | build CAPTCHA失敗 | E-01 (L175-180) | ○ |
| C-26 | build ページング | E-01 (L228, L263-274) | ○ |
| C-27 | build ソート順（新しい順） | E-01 (L217-221) | ○ |
| C-28 | build ソート順（古い順） | E-01 (L219-221) | ○ |
| C-29 | build 未承認エントリ表示 | E-01 (L249-255) | ○ |
| C-30 | build 公開期間制御 | E-01 (L276-280) | ○ |
| C-31 | entries正常系 | E-01 (L285-302) | ○ |
| C-32 | entries境界値空 | E-01 (L286-301) | ○ |
| C-33 | copyToCustomer正常系 | E-01 (L303-311) | ○ |
| C-34 | copyToCustomer異常系 | E-01 (L304) `if isNumeriek(iId)` | ○ |

### cls_guestbookitemクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Class_Initialize初期化 | E-02 (L14-17) | ○ |
| C-36 | Class_Terminate解放 | E-02 (L18-20) | ○ |
| C-37 | approve正常系承認 | E-02 (L21-27) | ○ |
| C-38 | approve異常系ID=0 | E-02 (L22) `if convertGetal(iId)<>0` | ○ |
| C-39 | pickByKey正常系 | E-02 (L28-37) | ○ |
| C-40 | pickByKey異常系存在しない | E-02 (L32) `if not rs.eof` | ○ |
| C-41 | pickByKey境界値32文字 | E-02 (L30) `left(cleanup(key),32)` | ○ |
| C-42 | guestbook正常系リレーション | E-02 (L38-44) | ○ |
| C-43 | guestbookキャッシュ | E-02 (L39) `if p_guestbook is nothing` | ○ |
| C-44 | Pick正常系 | E-02 (L45-64) | ○ |
| C-45 | Pick異常系非数値 | E-02 (L47) `if isNumeriek(id)` | ○ |
| C-46 | Pick異常系存在しない | E-02 (L50) `if not rs.eof` | ○ |
| C-47 | Check正常系 | E-02 (L65-82) | ○ |
| C-48 | Check異常系sValue空 | E-02 (L67-71) | ○ |
| C-49 | Check異常系sMessageBy空 | E-02 (L72-76) | ○ |
| C-50 | Check異常系href=検出 | E-02 (L77-81) | ○ |
| C-51 | Save正常系新規 | E-02 (L83-138) | ○ |
| C-52 | Save正常系更新 | E-02 (L123-125) | ○ |
| C-53 | Save異常系Check失敗 | E-02 (L85-90) | ○ |
| C-54 | Save IPブロック | E-02 (L91-94) | ○ |
| C-55 | Save sKey自動生成 | E-02 (L97) `sKey=GeneratePassWord()` | ○ |
| C-56 | Save bRequireValidation=true | E-02 (L102-104) | ○ |
| C-57 | Save bRequireValidation=false | E-02 (L104-106) | ○ |
| C-58 | Save メール通知 | E-02 (L107-122) | ○ |
| C-59 | Save境界値sValue5000文字 | E-02 (L126) `left(sValue,5000)` | ○ |
| C-60 | Save境界値sMessageBy50文字 | E-02 (L127) `left(sMessageBy,50)` | ○ |
| C-61 | Save境界値sMessageByEmail50文字 | E-02 (L128) `left(sMessageByEmail,50)` | ○ |
| C-62 | Save キャッシュクリア | E-02 (L137) `selectedPage.clearPageCache()` | ○ |
| C-63 | remove正常系 | E-02 (L139-145) | ○ |
| C-64 | remove異常系ID=0 | E-02 (L140) `if convertGetal(iId)<>0` | ○ |

### ASPページ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | bs_gbEdit postBack処理 | E-03 (L7-10) | ○ |
| C-66 | bs_gbEdit save処理 | E-03 (L12-17) | ○ |
| C-67 | bs_gbEdit delete処理 | E-03 (L18-21) | ○ |
| C-68 | bs_gbEdit CSRF対策 | E-03 (L13, L19) `checkCSRF()` | ○ |
| C-69 | bs_gbEditItems エントリ更新 | E-04 (L10-26) | ○ |
| C-70 | bs_gbEditItems エントリ削除 | E-04 (L18-19) | ○ |
| C-71 | bs_gbEditItems 存在チェック | E-04 (L13) `if convertGetal(entry.iId)<>0` | ○ |
| C-72 | bs_gbExcel Excel出力 | E-05 (L5-25) | ○ |
| C-73 | bs_gbExcel SQLインジェクション対策 | E-05 (L5) `decrypt(request.querystring(...))` | ○ |
| C-74 | bs_gbList 一覧表示 | E-06 (L9-10) | ○ |
| C-75 | bs_gbList コピー処理 | E-06 (L5-7) | ○ |
| C-76 | bs_gbList 空一覧 | E-06 (L9) `if guestbooks.count>0` | ○ |
| C-77 | bs_gbBack 戻りリンク | E-07 (L2) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全てのテストケースがソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードから直接導出されており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] CAPTCHA検証ロジック（C-24, C-25）の境界条件が網羅されているか
- [ ] IPブロック機能（C-54）のバイパス可能性が考慮されているか
- [ ] スパム防止チェック（C-50）の大文字小文字区別が正しいか（`lcase`使用済み）
- [ ] 文字数制限（C-59, C-60, C-61）のテストでマルチバイト文字が考慮されているか
- [ ] SQLインジェクション対策（C-73）のdecrypt/convertGetalの組み合わせが十分か
- [ ] セッション管理（C-29）の未承認エントリ表示制御が正しく機能するか
