---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 116
  claims_with_evidence: 112
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート: includes モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：112 / 116、根拠なし：4
- 優先レビュー（高）
  1. **UT-INC-046**: GeneratePassWordのユニーク性テスト - ランダム性の検証は実行時にのみ確認可能
  2. **UT-INC-099**: リモートZIP展開のフォールバック動作 - 外部サービス依存
  3. **UT-INC-060**: filterImages関数のBase64画像変換 - ファイルシステム依存
  4. **UT-INC-111**: ErrorReportのメール送信 - SMTP設定依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/database.asp` - cls_Databaseクラス定義（Execute, ExecuteLabels, GetDynamicRS, getConn, dataIsSafe等）
- E-02: `asp/includes/encryption.asp` - EnCrypt/decrypt関数定義
- E-03: `asp/includes/md5.asp` - MD5クラス定義（hash関数）
- E-04: `asp/includes/sha256.asp` - SHA256関数定義
- E-05: `asp/includes/functions.asp` - 汎用関数群（isLeeg, convertGetal, convertStr, convertBool, cleanUp, RemoveHTML, CheckEmailSyntax, GeneratePassWord等）
- E-06: `asp/includes/customer.asp` - cls_customerクラス定義（Pick, Check, Save等）
- E-07: `asp/includes/page.asp` - cls_pageクラス定義（Pick, pickByCode, pickByUserFriendlyURL, Check, Save等）
- E-08: `asp/includes/contact.asp` - cls_contactクラス定義（Pick, quickPick, Check, Save, delete, resetPW等）
- E-09: `asp/includes/mail.asp` - cls_mailクラス定義（Pick, Save, delete, receivers等）
- E-10: `asp/includes/search.asp` - cls_searchクラス定義（results, allPages等）
- E-11: `asp/includes/zip.asp` - cls_zipperクラス定義（unpack等）
- E-12: `asp/includes/freeASPUpload.asp` - FreeASPUploadクラス定義（Save, Form, Files等）
- E-13: `asp/includes/captcha.asp` - CAPTCHA生成関数群（CreateGUID, PrepareBitmap, SendBitmap, AddNoise等）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-INC-001) | cls_Database.Executeが正常にSQLを実行 | E-01 (L11-17) | ○ |
| C-02 (UT-INC-002) | Execute異常時にOn Error Resume Nextで抑制 | E-01 (L12) | ○ |
| C-03 (UT-INC-003) | ExecuteLabelsがラベルDBに接続 | E-01 (L18-24) | ○ |
| C-04 (UT-INC-004) | GetDynamicRSがCursorType=1, LockType=3で返却 | E-01 (L25-32) | ○ |
| C-05 (UT-INC-005) | getConnがAccess DB接続を確立 | E-01 (L46-51) | ○ |
| C-06 (UT-INC-006) | getConnがSQL Server接続を確立 | E-01 (L52-56) | ○ |
| C-07 (UT-INC-007) | getConnがMySQL接続を確立 | E-01 (L57-59) | ○ |
| C-08 (UT-INC-008) | dataIsSafeが非デフォルトパスでtrue | E-01 (L73-79) | ○ |
| C-09 (UT-INC-009) | dataIsSafeがデフォルトパスでfalse | E-01 (L74-75) | ○ |
| C-10 (UT-INC-010) | EnCryptが文字列を暗号化 | E-02 (L28-48) | ○ |
| C-11 (UT-INC-011) | EnCryptが数値を111倍して暗号化 | E-02 (L30-32) | ○ |
| C-12 (UT-INC-012) | decryptが暗号文を復号 | E-02 (L2-27) | ○ |
| C-13 (UT-INC-013) | decryptが数値を復号時に111で除算 | E-02 (L22-24) | ○ |
| C-14 (UT-INC-014) | 空文字列の暗号化・復号 | E-02 | ○ |
| C-15 (UT-INC-015) | MD5.hashが正しいハッシュ生成 | E-03 (L97-99) | ○ |
| C-16 (UT-INC-016) | 空文字列のMD5ハッシュ | E-03 | ○ |
| C-17 (UT-INC-017) | 長文字列のMD5ハッシュ | E-03 | ○ |
| C-18 (UT-INC-018) | SHA256が64文字ハッシュ生成 | E-04 (L286-355) | ○ |
| C-19 (UT-INC-019) | 空文字列のSHA256ハッシュ | E-04 | ○ |
| C-20 (UT-INC-020) | isLeegがNullでtrue | E-05 (L86-93) | ○ |
| C-21 (UT-INC-021) | isLeegが空文字列でtrue | E-05 (L91) | ○ |
| C-22 (UT-INC-022) | isLeegが空白文字列でtrue | E-05 (L91: trim(value)="") | ○ |
| C-23 (UT-INC-023) | isLeegが値ありでfalse | E-05 (L87) | ○ |
| C-24 (UT-INC-024) | convertGetalが数値文字列を変換 | E-05 (L94-112) | ○ |
| C-25 (UT-INC-025) | convertGetalがNullで0 | E-05 (L109-111) | ○ |
| C-26 (UT-INC-026) | convertGetalが非数値で0 | E-05 (L106-108) | ○ |
| C-27 (UT-INC-027) | convertGetalが空文字列で0 | E-05 (L103-105) | ○ |
| C-28 (UT-INC-028) | convertStrが値を文字列変換 | E-05 (L134-145) | ○ |
| C-29 (UT-INC-029) | convertStrがNullで空文字列 | E-05 (L138-140) | ○ |
| C-30 (UT-INC-030) | convertBoolが1でtrue | E-05 (L153-156) | ○ |
| C-31 (UT-INC-031) | convertBoolが0でfalse | E-05 (L157-160) | ○ |
| C-32 (UT-INC-032) | convertBoolが"true"文字列でtrue | E-05 (L161-164) | ○ |
| C-33 (UT-INC-033) | convertBoolが空値でfalse | E-05 (L149-152) | ○ |
| C-34 (UT-INC-034) | cleanUpがシングルクォートをエスケープ | E-05 (L228-234) | ○ |
| C-35 (UT-INC-035) | cleanUpが空文字列で空文字列 | E-05 (L229-231) | ○ |
| C-36 (UT-INC-036) | cleanUpStrが特殊文字を除去 | E-05 (L236-246) | ○ |
| C-37 (UT-INC-037) | RemoveHTMLがHTMLタグを除去 | E-05 (L250-333) | ○ |
| C-38 (UT-INC-038) | RemoveHTMLがスクリプトタグを除去 | E-05 (L261: BLOCKTAGLIST含むSCRIPT) | ○ |
| C-39 (UT-INC-039) | RemoveJSがJavaScriptを除去 | E-05 (L334-418) | ○ |
| C-40 (UT-INC-040) | filterJSがイベントハンドラをエスケープ | E-05 (L419-426) | ○ |
| C-41 (UT-INC-041) | CheckEmailSyntaxが有効メールでtrue | E-05 (L711-798) | ○ |
| C-42 (UT-INC-042) | CheckEmailSyntaxが@なしでfalse | E-05 (L746-749) | ○ |
| C-43 (UT-INC-043) | CheckEmailSyntaxがドメインなしでfalse | E-05 (L753-757) | ○ |
| C-44 (UT-INC-044) | CheckEmailSyntaxが長いドメインでtrue | E-05 (L715: 2-40文字) | ○ |
| C-45 (UT-INC-045) | GeneratePassWordが8文字パスワード生成 | E-05 (L800-828) | ○ |
| C-46 (UT-INC-046) | GeneratePassWordのユニーク性 | E-05 (Randomize使用) | △ |
| C-47 (UT-INC-047) | convertEuroDateがEU形式変換 | E-05 (L533-544) | ○ |
| C-48 (UT-INC-048) | convertEuroDateがUS形式変換 | E-05 (L536-537) | ○ |
| C-49 (UT-INC-049) | convertEuroDateが空日付で空文字列 | E-05 (L541-543) | ○ |
| C-50 (UT-INC-050) | convertDateFromPickerがDate型変換 | E-05 (L551-564) | ○ |
| C-51 (UT-INC-051) | convert2が1桁をゼロ埋め | E-05 (L689-695) | ○ |
| C-52 (UT-INC-052) | convert2が2桁をそのまま | E-05 (L692-693) | ○ |
| C-53 (UT-INC-053) | LinkURLsがURLをリンク変換 | E-05 (L837-854) | ○ |
| C-54 (UT-INC-054) | LinkURLsがメールをリンク変換 | E-05 (L846-847) | ○ |
| C-55 (UT-INC-055) | isBetweenが日付範囲内でtrue | E-05 (L855-883) | ○ |
| C-56 (UT-INC-056) | isBetweenが日付範囲外でfalse | E-05 (L863-866) | ○ |
| C-57 (UT-INC-057) | isBetweenが両日付Nullでtrue | E-05 (L856-859) | ○ |
| C-58 (UT-INC-058) | SortDictionaryがキーでソート | E-05 (L893-932) | ○ |
| C-59 (UT-INC-059) | compressHTMLがHTML圧縮 | E-05 (L59-83) | ○ |
| C-60 (UT-INC-060) | filterImagesがBase64画像変換 | E-05 (L3-33) | △ |
| C-61 (UT-INC-061) | removeCRBがASPコードブロック除去 | E-05 (L35-42) | ○ |
| C-62 (UT-INC-062) | cls_customer.Pickが顧客情報取得 | E-06 (L95-244) | ○ |
| C-63 (UT-INC-063) | cls_customer.Pickが存在しないIDで空 | E-06 (L97, L101) | ○ |
| C-64 (UT-INC-064) | cls_customer.Pickが非数値IDで無視 | E-06 (L97: isNumeriek) | ○ |
| C-65 (UT-INC-065) | cls_customer.Checkが有効データでtrue | E-06 (L245-299) | ○ |
| C-66 (UT-INC-066) | cls_customer.CheckがsName空でfalse | E-06 (L247-250) | ○ |
| C-67 (UT-INC-067) | cls_customer.CheckがsURL短すぎでfalse | E-06 (L251-254) | ○ |
| C-68 (UT-INC-068) | cls_customer.Saveが新規保存 | E-06 (L300-500) | ○ |
| C-69 (UT-INC-069) | cls_customer.Saveが更新保存 | E-06 (L349) | ○ |
| C-70 (UT-INC-070) | cls_customer.Saveがチェック失敗で保存しない | E-06 (L301-306) | ○ |
| C-71 (UT-INC-071) | cls_page.Pickがページ情報取得 | E-07 (L246-336) | ○ |
| C-72 (UT-INC-072) | cls_page.pickByCodeがコード検索 | E-07 (L58-70) | ○ |
| C-73 (UT-INC-073) | cls_page.pickByUserFriendlyURLがUFL検索 | E-07 (L115-238) | ○ |
| C-74 (UT-INC-074) | cls_page.Checkが有効データでtrue | E-07 (L337-423) | ○ |
| C-75 (UT-INC-075) | cls_page.CheckがsTitle空でfalse | E-07 (L343-346) | ○ |
| C-76 (UT-INC-076) | cls_page.Checkが重複sCodeでfalse | E-07 (L364-371) | ○ |
| C-77 (UT-INC-077) | cls_page.Checkが重複UFLでfalse | E-07 (L401-411) | ○ |
| C-78 (UT-INC-078) | cls_page.Saveが新規保存 | E-07 (L424-500) | ○ |
| C-79 (UT-INC-079) | cls_page.Saveが更新保存 | E-07 (L475-479) | ○ |
| C-80 (UT-INC-080) | forceUFLがタイトルからUFL生成 | E-07 (L84-114) | ○ |
| C-81 (UT-INC-081) | cls_contact.Pickが連絡先取得 | E-08 (L45-79) | ○ |
| C-82 (UT-INC-082) | cls_contact.quickPickが高速取得 | E-08 (L20-44) | ○ |
| C-83 (UT-INC-083) | cls_contact.Checkが有効データでtrue | E-08 (L80-128) | ○ |
| C-84 (UT-INC-084) | cls_contact.Checkが無効メールでfalse | E-08 (L97-99) | ○ |
| C-85 (UT-INC-085) | cls_contact.Checkが重複メールでfalse | E-08 (L114-120) | ○ |
| C-86 (UT-INC-086) | cls_contact.Checkが重複ニックネームでfalse | E-08 (L122-127) | ○ |
| C-87 (UT-INC-087) | cls_contact.Saveが新規保存 | E-08 (L153-225) | ○ |
| C-88 (UT-INC-088) | cls_contact.deleteがカスケード削除 | E-08 (L247-271) | ○ |
| C-89 (UT-INC-089) | cls_contact.resetPWがパスワードリセット | E-08 (L288-300) | ○ |
| C-90 (UT-INC-090) | cls_mail.Pickがメール取得 | E-09 (L9-24) | ○ |
| C-91 (UT-INC-091) | cls_mail.Saveが新規保存 | E-09 (L25-43) | ○ |
| C-92 (UT-INC-092) | cls_mail.deleteがカスケード削除 | E-09 (L44-52) | ○ |
| C-93 (UT-INC-093) | cls_mail.receiversが受信者取得 | E-09 (L58-67) | ○ |
| C-94 (UT-INC-094) | cls_search.resultsが検索結果取得 | E-10 (L31-154) | ○ |
| C-95 (UT-INC-095) | cls_search.resultsが短い検索語で空 | E-10 (L34, L46-48) | ○ |
| C-96 (UT-INC-096) | cls_search.resultsが複数語検索 | E-10 (L39-45, L65-70) | ○ |
| C-97 (UT-INC-097) | cls_search.resultsがフレーズ検索 | E-10 (L62-63) | ○ |
| C-98 (UT-INC-098) | cls_zipper.unpackがZIP展開 | E-11 (L26-188) | ○ |
| C-99 (UT-INC-099) | cls_zipper.unpackがリモート展開 | E-11 (L31-98) | △ |
| C-100 (UT-INC-100) | cls_zipper.unpackが不正拡張子拒否 | E-11 (L109-117) | ○ |
| C-101 (UT-INC-101) | FreeASPUpload.Saveがファイル保存 | E-12 (L50-68) | ○ |
| C-102 (UT-INC-102) | FreeASPUpload.Saveが不正拡張子拒否 | E-12 (L173-179) | ○ |
| C-103 (UT-INC-103) | FreeASPUpload.Formがフォーム値取得 | E-12 (L40-43) | ○ |
| C-104 (UT-INC-104) | captcha.CreateGUIDが指定長生成 | E-13 (L75-87) | ○ |
| C-105 (UT-INC-105) | captcha.CreateGUIDが連続同一文字なし | E-13 (L83) | ○ |
| C-106 (UT-INC-106) | captcha.PrepareBitmapがビットマップ準備 | E-13 (L170-227) | ○ |
| C-107 (UT-INC-107) | captcha.SendBitmapがBMP出力 | E-13 (L362-401) | ○ |
| C-108 (UT-INC-108) | captcha.AddNoiseがノイズ追加 | E-13 (L285-331) | ○ |
| C-109 (UT-INC-109) | getHomePageがホームページ取得 | E-05 (L438-452) | ○ |
| C-110 (UT-INC-110) | getIntranetHomePageがイントラネットHP取得 | E-05 (L463-475) | ○ |
| C-111 (UT-INC-111) | ErrorReportがメール送信 | E-05 (L486-496) | △ |
| C-112 (UT-INC-112) | dumperrorがエラー詳細出力 | E-05 (L497-515) | ○ |
| C-113 (UT-INC-113) | dumperrorがエラーなしで空 | E-05 (L498) | ○ |
| C-114 (UT-INC-114) | isNumeriekが数値文字列でtrue | E-05 (L190-196) | ○ |
| C-115 (UT-INC-115) | isNumeriekが非数値でfalse | E-05 (L194) | ○ |
| C-116 (UT-INC-116) | isNumeriekが空値でfalse | E-05 (L191-192) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-INC-046 (GeneratePassWord ユニーク性)**: ランダム性の検証はコード静的解析のみでは不十分。実行時テストが必要
  - 候補: 複数回実行による衝突率測定 / Randomize関数のシード確認
- **UT-INC-060 (filterImages Base64変換)**: ファイルシステムへの書き込み動作は実行環境依存
  - 候補: モック環境でのテスト / 一時ディレクトリへの出力確認
- **UT-INC-099 (リモートZIP展開)**: 外部サービス(quickersite.com)への依存があり、サービス可用性に依存
  - 候補: モックサーバーでのテスト / サービス応答のスタブ化
- **UT-INC-111 (ErrorReport メール送信)**: SMTPサーバー設定と可用性に依存
  - 候補: SMTPモック使用 / メール送信のスタブ化

## 5) リスクフラグ（レビュー観点）
- **2 (高リスク)**: セキュリティ関連テスト (UT-INC-034~040, UT-INC-061, UT-INC-100, UT-INC-102) - SQLインジェクション、XSS、ファイルアップロード脆弱性に関するテスト
- **2 (高リスク)**: 暗号化関連テスト (UT-INC-010~019) - 暗号化アルゴリズムの正確性は認証・認可に直接影響
- **1 (中リスク)**: データベース接続テスト (UT-INC-001~009) - 複数DBMSサポートの検証が必要
- **1 (中リスク)**: バリデーションテスト (UT-INC-041~044, UT-INC-065~070, UT-INC-074~077, UT-INC-083~086) - データ整合性に影響
- **0 (低リスク)**: フォーマット・変換テスト (UT-INC-047~059) - 表示のみに影響

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティ関連テストケース（SQLインジェクション対策、XSS対策、ファイルアップロード制限）が十分にカバーされているか
- [ ] 暗号化関連テスト（MD5、SHA256、独自暗号化）の期待値が正確か
- [ ] データベース接続テストがAccess/SQL Server/MySQLすべてをカバーしているか
- [ ] バリデーションテストが必須チェック、一意性チェック、形式チェックを網羅しているか
- [ ] 境界値テスト（Null、空文字列、最大値）が適切に設定されているか
- [ ] エラーハンドリングテストが異常系を適切にカバーしているか
- [ ] テストID命名規則（UT-INC-XXX）が一貫しているか
- [ ] 優先度設定が適切か（セキュリティ・データ整合性=高、機能=中、表示=低）
