---
generated_at: 2026-01-24 01:15:00
metrics:
  claims_total: 72
  claims_with_evidence: 68
  claims_without_evidence: 4
confidence_derived: 0.94
---

# 根拠レポート：mail.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：68 / 72、根拠なし：4
- 優先レビュー（高）
  1. **UT-MAIL-040（メール開封トラッキング）**：sAddImageUrlの設定元が不明
  2. **UT-MAIL-069（背景色設定）**：sOWBodyBGColorのスコープと設定元が不明
  3. **UT-MAIL-072（prepareForExport）**：prepareForExport関数の詳細仕様が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/mail.asp` - cls_mailクラス定義
- E-02: `asp/includes/mail_message.asp` - cls_mail_messageクラス定義
- E-03: `asp/bs_mailReceivers.asp` - メール受信者一覧表示ページ
- E-04: `asp/bs_mailHistory.asp` - メール履歴管理ページ
- E-05: `asp/bs_mailDetail.asp` - メール詳細表示ページ
- E-06: `asp/bs_massMailingFB.asp` - 一括送信完了フィードバックページ
- E-07: `asp/bs_massMailing2.asp` - 一括メール送信処理ページ
- E-08: `asp/includes/functions.asp` - 共通関数（CheckEmailSyntax, wrapInHTML, prepareforEmail）
- E-09: `asp/includes/pb.asp` - 別のCheckEmailSyntax実装

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_mail クラス（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Class_Initializeでdecrypt+Pickが呼ばれる | E-01 L4-8 | ○ |
| C-02 | Pickでid検証後SQLを実行しプロパティ設定 | E-01 L9-24 | ○ |
| C-03 | isNumeriekでSQLインジェクション対策 | E-01 L11 | ○ |
| C-04 | Saveで新規/更新を判定して保存 | E-01 L25-43 | ○ |
| C-05 | 新規保存時にdDateSent=now()設定 | E-01 L31 | ○ |
| C-06 | deleteでtblMailContactとtblMailを削除 | E-01 L44-52 | ○ |
| C-07 | iNumberRecプロパティでreceiversのcounterを返す | E-01 L53-57 | ○ |
| C-08 | receiversでemail昇順ソートした配列を返す | E-01 L58-67 | ○ |

### cls_mail_message クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | class_initializeでreceiverNameとattachments初期化 | E-02 L10-13 | ○ |
| C-10 | sendでsubjectにtreatConstants適用 | E-02 L16 | ○ |
| C-11 | sendでbodyにwrapInHTML+prepareforEmail適用 | E-02 L17 | ○ |
| C-12 | fromemail空時はcustomer.webmasterEmail使用 | E-02 L23 | ○ |
| C-13 | fromname空時はcustomer.siteName使用 | E-02 L24 | ○ |
| C-14 | fromnameからダブルクォートとカンマをサニタイズ | E-02 L28-32 | ○ |
| C-15 | customer.SMTPSERVER設定時は顧客設定を優先 | E-02 L44-51 | ○ |
| C-16 | persits.mailsenderコンポーネント対応 | E-02 L54-75 | ○ |
| C-17 | cdo.messageコンポーネント対応 | E-02 L76-113 | ○ |
| C-18 | cdonts.newmailコンポーネント対応 | E-02 L114-127 | ○ |
| C-19 | jmail.messageコンポーネント対応 | E-02 L128-151 | ○ |
| C-20 | smtpsvg.mailerコンポーネント対応 | E-02 L152-168 | ○ |
| C-21 | 未対応コンポーネント時はエラー表示+Response.End | E-02 L169-171 | ○ |
| C-22 | SMTP認証情報設定（各コンポーネント共通） | E-02 L65-68, L85-89等 | ○ |
| C-23 | SSL設定反映（CDO.Message） | E-02 L90-94 | ○ |
| C-24 | 添付ファイル追加対応（各コンポーネント共通） | E-02 L70-72, L105-107等 | ○ |
| C-25 | sAddImageUrlでトラッキングピクセル追加 | E-02 L19-21 | ○ |
| C-26 | sAddImageUrlの設定元 | **根拠なし** | △ |

### bs_mailReceivers.asp（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | bIntranetMail権限チェック | E-03 L4 | ○ |
| C-28 | mail.receiversで受信者取得しolリスト表示 | E-03 L5-12 | ○ |

### bs_mailHistory.asp（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | bIntranetMail権限チェック | E-04 L4 | ○ |
| C-30 | iMail_ID指定時にcheckCSRF後delete実行 | E-04 L6-9 | ○ |
| C-31 | customer.mailsでメール一覧取得・表示 | E-04 L11-12 | ○ |
| C-32 | メール0件時は"nomessagessent"表示 | E-04 L12-13 | ○ |

### bs_mailDetail.asp（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | bIntranetMail権限チェック | E-05 L4 | ○ |
| C-34 | mail.sBodyを出力 | E-05 L6 | ○ |

### bs_massMailingFB.asp（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | bIntranetMail権限チェック | E-06 L4 | ○ |
| C-36 | counterパラメータの送信件数表示 | E-06 L4 | ○ |

### bs_massMailing2.asp（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | server.ScriptTimeout=10000設定 | E-07 L6 | ○ |
| C-38 | contactDictで重複メールアドレス除外 | E-07 L7-8, L24-25 | ○ |
| C-39 | contactIDSをカンマ分割してループ処理 | E-07 L17, L20 | ○ |
| C-40 | 連絡先のsEmailが空の場合はスキップ | E-07 L23 | ○ |
| C-41 | [email]プレースホルダをcontact.sEmailで置換 | E-07 L28, L30 | ○ |
| C-42 | [sPw]プレースホルダをcontact.sPwで置換 | E-07 L29, L31 | ○ |
| C-43 | contactFieldsのフィールドでプレースホルダ置換 | E-07 L32-41 | ○ |
| C-44 | sb_date型はconvertDateToPickerでフォーマット | E-07 L34-36 | ○ |
| C-45 | ccEmailsへの送信（CheckEmailSyntax検証付き） | E-07 L48-56 | ○ |
| C-46 | エラー時にErrorReport呼び出し | E-07 L58 | ○ |
| C-47 | mailobj.save()でメール履歴保存 | E-07 L66-69 | ○ |
| C-48 | tblMailContactに送信先保存 | E-07 L70-79 | ○ |
| C-49 | bs_massMailingFB.aspへリダイレクト | E-07 L80 | ○ |

### 共通関数（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | CheckEmailSyntaxでメールアドレス検証 | E-08 L724-730 | ○ |
| C-51 | wrapInHTMLでHTMLタグ追加判定 | E-08 L1436-1446 | ○ |
| C-52 | sOWBodyBGColor設定時にstyle属性追加 | E-08 L1439-1441 | ○ |
| C-53 | sOWBodyBGColorのスコープと設定元 | **根拠なし** | △ |
| C-54 | prepareforEmailで先頭タグ判定+pタグ付加 | E-08 L1103-1109 | ○ |
| C-55 | prepareForExport関数の詳細仕様 | **根拠なし** | △ |

### 推論ベースのテストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | ID=0や負数のisNumeriek判定挙動 | E-01参照（推論） | ○ |
| C-57 | customer.mailsプロパティの存在 | E-04参照 | ○ |
| C-58 | GetEmailValidator関数の詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **sAddImageUrlの設定元**：mail_message.asp内で参照されているが、どこで設定されるか不明
  - 候補：web_config.asp / customer設定 / グローバル変数
- **sOWBodyBGColorの設定元**：wrapInHTML関数内で参照されているが、スコープと設定元が不明
  - 候補：呼び出し元での設定 / グローバル変数 / customer設定
- **prepareForExport関数**：prepareforEmail内で呼び出されているが、詳細仕様が未確認
  - 候補：functions.asp内の別の場所 / 別ファイル
- **GetEmailValidator関数**：CheckEmailSyntax内で呼び出されているが、正規表現パターン等の詳細が未確認

## 5) リスクフラグ（レビュー観点）
- **リスク1（高）**：SQLインジェクション対策 - isNumeriekによる検証に依存。isNumeriekの実装が不十分な場合リスクあり
- **リスク1（高）**：CSRF対策 - bs_mailHistory.aspでcheckCSRF()を使用。正しく実装されているか要確認
- **リスク1（中）**：メールコンポーネントの設定 - 5種類のメールコンポーネントをサポート。設定ミスによる送信失敗リスク
- **リスク0（低）**：On Error Resume Nextの多用 - エラーが握りつぶされる可能性があるが、ErrorReport関数でログ出力あり
- **リスク1（中）**：重複除去ロジック - contactDictによる重複チェックは正常動作するが、大量送信時のメモリ消費に注意

## 6) レビュアーチェックリスト（最小）
- [ ] cls_mailのPickメソッドでiCustomerID=cidの条件が正しく機能するか確認
- [ ] cls_mail_messageのsend関数で全5種類のメールコンポーネントがテスト環境で動作するか確認
- [ ] bs_massMailing2.aspのcheckCSRF()が正しく呼び出されているか確認（現在はbs_mailHistory.aspのみ）
- [ ] CheckEmailSyntaxの正規表現パターンが十分に厳格か確認
- [ ] server.ScriptTimeout=10000（約2.8時間）が許容範囲か確認
- [ ] sAddImageUrlとsOWBodyBGColorの設定元を特定し、テストケースに反映
