---
generated_at: 2026-01-24 12:00:00
metrics:
  claims_total: 91
  claims_with_evidence: 89
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：navigation モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：89 / 91、根拠なし：2
- 優先レビュー（高）
  1. **UT-NAV-073**: イントラネット認証チェック - 早期終了の条件確認が必要
  2. **UT-NAV-066**: 親ページ遡り処理 - 無限ループ防止の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/menu.asp` - cls_menuクラス定義（348行）
- E-02: `asp/includes/showmenu.asp` - showMenu関数群（252行）
- E-03: `asp/includes/breadcrumbs.asp` - showBreadCrumbs関数（46行）
- E-04: `asp/includes/menuAlignList.asp` - cls_menuAlignListクラス定義（31行）
- E-05: `asp/bs_back.asp` - 戻りリンクテンプレート（3行）
- E-06: `asp/bs_backCatalog.asp` - カタログ戻りリンク（3行）
- E-07: `asp/bs_backContact.asp` - 連絡先戻りリンク（3行）
- E-08: `asp/bs_backContactField.asp` - 連絡先フィールド戻りリンク（3行）
- E-09: `asp/bs_backFavicon.asp` - ファビコン戻りリンク（3行）
- E-10: `asp/bs_backForm.asp` - フォーム戻りリンク（3行）
- E-11: `asp/bs_backFormField.asp` - フォームフィールド戻りリンク（3行）
- E-12: `asp/bs_backIntranet.asp` - イントラネット戻りリンク（3行）

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_menu クラス（menu.asp）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | class_initialize でstart=true, iSubMenuRoot=null が設定される | E-01 (L10-13) | ○ |
| C-02 | getMenu でpageObjがnullの場合に新規cls_pageが作成される | E-01 (L15-17) | ○ |
| C-03 | getMenu でcssType=0の場合シンプルulタグでラップされる | E-01 (L26-27) | ○ |
| C-04 | getMenu でcssType=2の場合sitemapクラス付きdivでラップされる | E-01 (L28-29) | ○ |
| C-05 | getMenu でcssType=artmenuの場合artmenuクラスが付与される | E-01 (L30-31) | ○ |
| C-06 | getMenu でデフォルトの場合QS_menulistクラスが付与される | E-01 (L32-33) | ○ |
| C-07 | cacheMenu でページ階層が再帰的に取得される | E-01 (L36-73) | ○ |
| C-08 | cacheMenu でイントラネットフラグによりフィルタされる | E-01 (L42-43) | ○ |
| C-09 | cacheMenu で空のサブメニューが除去される | E-01 (L72) | ○ |
| C-10 | getIntranetMenu でイントラネット未使用時に空文字が返却される | E-01 (L85-88) | ○ |
| C-11 | getIntranetMenu で認証済みユーザーにメニューが返却される | E-01 (L90-98) | ○ |
| C-12 | getIntranetMenu でマイプロファイルリンクが追加される | E-01 (L99-110) | ○ |
| C-13 | getIntranetMenu でログオフリンクが追加される | E-01 (L116-120) | ○ |
| C-14 | getBOMenu でバックオフィスメニューが生成される | E-01 (L150-212) | ○ |
| C-15 | getBOMenu でホームページアイコンが表示される | E-01 (L170-172) | ○ |
| C-16 | getBOMenu でコンテナアイコンが表示される | E-01 (L173-175) | ○ |
| C-17 | getBOMenu でリストアイコンが表示される | E-01 (L176-178) | ○ |
| C-18 | getBOMenu で外部URLアイコンが表示される | E-01 (L179-181) | ○ |
| C-19 | getBOMenu で権限チェックによりアイコンが表示される | E-01 (L182-201) | ○ |
| C-20 | showParents で親ページ階層が取得される | E-01 (L213-236) | ○ |
| C-21 | getReplaceMenu で移動先候補メニューが生成される | E-01 (L237-281) | ○ |
| C-22 | getReplaceMenu でオフラインページがスタイル付きで表示される | E-01 (L260-263) | ○ |
| C-23 | getReplaceMenu で移動元ページ自身が除外される | E-01 (L258) | ○ |
| C-24 | lossePaginas でルースページ一覧が取得される | E-01 (L282-301) | ○ |
| C-25 | getPRMenu で権限設定メニューが生成される | E-01 (L302-347) | ○ |

### showMenu 関数群（showmenu.asp）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | showMenu でメニューとイントラネットメニューが結合される | E-02 (L2-10) | ○ |
| C-27 | getBootstrapMenu でBootstrap3形式に変換される | E-02 (L12-35) | ○ |
| C-28 | JSremoveIDs でid属性が除去される | E-02 (L52-64) | ○ |
| C-29 | JStemplateVMENU で垂直メニュー形式に変換される | E-02 (L38-51) | ○ |
| C-30 | JStemplateHMENU で水平メニュー形式に変換される | E-02 (L65-85) | ○ |
| C-31 | qs_artisteer_menu でArtisteerメニューが生成される | E-02 (L89-101) | ○ |
| C-32 | qs_artisteer_full_menu で完全なArtisteerメニューが生成される | E-02 (L102-145) | ○ |
| C-33 | qs_mainmenu でシンプルリスト形式のメニューが返却される | E-02 (L146-154) | ○ |
| C-34 | qs_intranetmenu でイントラネットメニューが返却される | E-02 (L155-163) | ○ |
| C-35 | setActiveLink でqs_activelinkが付与される | E-02 (L164-184) | ○ |
| C-36 | setActiveLink でユーザーフレンドリーURL対応される | E-02 (L167-168) | ○ |
| C-37 | setActiveLinkWithString でカスタムクラスが付与される | E-02 (L185-210) | ○ |
| C-38 | art31MENUFIX でspan要素が除去される | E-02 (L211-214) | ○ |
| C-39 | art3XVMENUFIX でactiveクラスが付与される | E-02 (L215-252) | ○ |

### showBreadCrumbs 関数（breadcrumbs.asp）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | showBreadCrumbs でパンくずリストが生成される | E-03 (L2-46) | ○ |
| C-41 | showBreadCrumbs で未認証イントラネットページは早期終了する | E-03 (L3) | ○ |
| C-42 | showBreadCrumbs でサブページリンクが追加される | E-03 (L10-26) | ○ |
| C-43 | showBreadCrumbs でコンテナページはスキップされる | E-03 (L13-15, L19) | ○ |
| C-44 | showBreadCrumbs で親がコンテナの場合兄弟ページが表示される | E-03 (L27-40) | ○ |
| C-45 | 数値でないページIDの場合処理をスキップする | **推定** | △ |

### cls_menuAlignList クラス（menuAlignList.asp）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | Class_Initialize でメニュー配置オプションが初期化される | E-04 (L4-9) | ○ |
| C-47 | showSelected でsingleモードで選択値ラベルが返却される | E-04 (L18-19) | ○ |
| C-48 | showSelected でoptionモードでHTMLオプションタグが生成される | E-04 (L20-28) | ○ |

### bs_back*.asp 戻りリンクファイル
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | bs_back.asp で非イントラネットはbs_default.aspへリンク | E-05 (L2) | ○ |
| C-50 | bs_back.asp でイントラネットはbs_intranet.aspへリンク | E-05 (L2) | ○ |
| C-51 | bs_backCatalog.asp でbs_catalogList.aspへリンク | E-06 (L2) | ○ |
| C-52 | bs_backContact.asp でbs_contactHome.aspへリンク | E-07 (L2) | ○ |
| C-53 | bs_backContactField.asp でbs_contactFields.aspへリンク | E-08 (L2) | ○ |
| C-54 | bs_backFavicon.asp でbs_favicon.aspへリンク | E-09 (L2) | ○ |
| C-55 | bs_backForm.asp でbs_formList.aspへリンク | E-10 (L2) | ○ |
| C-56 | bs_backFormField.asp でbs_formFields.aspへリンク | E-11 (L2) | ○ |
| C-57 | bs_backIntranet.asp でbs_intranet.aspへリンク | E-12 (L2) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-45**: `isNumeriek` 関数の定義が別ファイルにあり、例外処理の詳細が確認できない
  - 候補: asp/includes/functions.asp / asp/includes/database.asp

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - bs_back*.asp の戻りリンクファイル群は単純なHTML出力のみ
- 1: 中リスク - 再帰的メニュー生成（cacheMenu, getBOMenu）は無限ループの可能性
- 1: 中リスク - セッション/認証状態に依存する処理（getIntranetMenu）のテスト環境構築
- 0: 低リスク - 文字列置換処理（setActiveLink系）は入力値の検証で対応可能

## 6) レビュアーチェックリスト（最小）
- [ ] cls_menuクラスの再帰処理（cacheMenu, getBOMenu, showParents, getReplaceMenu）で無限ループが発生しないことを確認
- [ ] getIntranetMenu のイントラネット認証チェックが正しく機能することを確認
- [ ] setActiveLink系関数のURL置換が正しく動作することを確認
- [ ] showBreadCrumbs のコンテナページ判定ロジックが正しいことを確認
- [ ] bs_backFormField.asp のencrypt関数呼び出しが正しいIDを使用していることを確認
