---
generated_at: 2026-01-24 12:30:00
metrics:
  claims_total: 96
  claims_with_evidence: 92
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：poll.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：92 / 96、根拠なし：4
- 優先レビュー（高）
  1. **UT-POL-091, 092**：GetXmlHttpObjectのブラウザ互換性テストは実行環境依存
  2. **UT-POL-082**：checkCSRF関数の実装詳細は別ファイル参照が必要
  3. **UT-POL-078**：権限チェックの詳細はbs_security.aspに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/asp/includes/poll.asp` - cls_pollクラスの実装（全388行）
- E-02: `/asp/bs_pollList.asp` - Poll一覧画面（全11行）
- E-03: `/asp/bs_pollEdit.asp` - Poll編集画面（全44行）
- E-04: `/asp/bs_pollBack.asp` - Poll戻るボタン（全3行）
- E-05: `/asp/process.asp` - pollアクション処理（61-81行目）
- E-06: `/js/pollv2.js` - クライアントサイドpoll処理（全55行）
- E-07: `/asp/includes/customer.asp` - cls_customerのpolls関数（854-870行目）
- E-08: `/asp/includes/customer.asp` - cls_customerのreset関数（605-650行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Class_Initializeでデフォルト値が設定される | E-01 (18-65行目) | ○ |
| C-02 | 初期化時にpickが自動呼び出しされる | E-01 (63行目) | ○ |
| C-03 | getRequestValuesでフォーム値が取得される | E-01 (66-83行目) | ○ |
| C-04 | 15件の回答オプションがループで取得される | E-01 (78-82行目) | ○ |
| C-05 | 日付フィールドがconvertDateFromPickerで変換される | E-01 (73-75行目) | ○ |
| C-06 | getByCodeでコード検索ができる | E-01 (84-94行目) | ○ |
| C-07 | getByCodeでSQLインジェクション対策がある | E-01 (88行目: cleanup関数, left関数) | ○ |
| C-08 | PickでIDによる検索ができる | E-01 (95-125行目) | ○ |
| C-09 | Pickで15件の回答がロードされる | E-01 (117-121行目) | ○ |
| C-10 | isNumeriekで数値チェックが行われる | E-01 (98行目) | ○ |
| C-11 | getQuestionで質問テキストが返る | E-01 (126-130行目) | ○ |
| C-12 | getQuestionColorで色が返る | E-01 (131-135行目) | ○ |
| C-13 | CheckでsQuestionの必須チェックが行われる | E-01 (136-145行目) | ○ |
| C-14 | CheckでsCodeの必須チェックが行われる | E-01 (142-145行目) | ○ |
| C-15 | Saveで新規レコードが挿入される | E-01 (158-161行目) | ○ |
| C-16 | Saveで既存レコードが更新される | E-01 (163行目) | ○ |
| C-17 | Saveで15件の回答が保存される | E-01 (178-181行目) | ○ |
| C-18 | removeでpollと投票が削除される | E-01 (187-195行目) | ○ |
| C-19 | resetで投票データのみ削除される | E-01 (196-204行目) | ○ |
| C-20 | resetでdResetDateが更新される | E-01 (201-202行目) | ○ |
| C-21 | buildで投票フォームHTMLが生成される | E-01 (205-241行目) | ○ |
| C-22 | buildでwithdivオプションが機能する | E-01 (210-212, 233-235行目) | ○ |
| C-23 | buildでbShowTitleが機能する | E-01 (214-216行目) | ○ |
| C-24 | buildで空の回答がスキップされる | E-01 (219行目: isLeeg判定) | ○ |
| C-25 | buildで投票不可時にshowresultsが返る | E-01 (237行目) | ○ |
| C-26 | canVoteでbCanVoteフラグが参照される | E-01 (246-249行目) | ○ |
| C-27 | canVoteでbIsOnlineが参照される | E-01 (250-253行目) | ○ |
| C-28 | canVoteでdVoteDeadlineが参照される | E-01 (254-259行目) | ○ |
| C-29 | canVoteでセッションが参照される | E-01 (268-271行目) | ○ |
| C-30 | canVoteでIP制限がチェックされる | E-01 (273-277行目) | ○ |
| C-31 | canVoteでCookieが参照される | E-01 (284-287行目) | ○ |
| C-32 | canVoteでdResetDateによる再投票許可がある | E-01 (278-283行目) | ○ |
| C-33 | registerVoteで投票が記録される | E-01 (299-320行目) | ○ |
| C-34 | registerVoteでセッションが設定される | E-01 (314行目) | ○ |
| C-35 | registerVoteでCookieが設定される | E-01 (315-316行目) | ○ |
| C-36 | bIsOnlineで日付範囲がチェックされる | E-01 (321-335行目) | ○ |
| C-37 | showresultsで結果HTMLが生成される | E-01 (336-380行目) | ○ |
| C-38 | showresultsでパーセンテージが計算される | E-01 (361行目) | ○ |
| C-39 | showresultsでゼロ除算が防止される | E-01 (350-354行目) | ○ |
| C-40 | showresultsで[NMBR]プレースホルダが置換される | E-01 (373行目) | ○ |
| C-41 | copyでpollが複製される | E-01 (381-387行目) | ○ |
| C-42 | copyでGeneratePasswordが呼ばれる | E-01 (384行目) | ○ |
| C-43 | bs_pollListでpoll一覧が表示される | E-02 (9行目) | ○ |
| C-44 | bs_pollListでコピー機能がある | E-02 (5-7行目) | ○ |
| C-45 | bs_pollEditで保存処理がある | E-03 (13-18行目) | ○ |
| C-46 | bs_pollEditで削除処理がある | E-03 (19-22行目) | ○ |
| C-47 | bs_pollEditでリセット処理がある | E-03 (23-26行目) | ○ |
| C-48 | bs_pollEditでcheckCSRFが呼ばれる | E-03 (14, 20, 24行目) | ○ |
| C-49 | process.aspでvoteアクションが処理される | E-05 (61-67行目) | ○ |
| C-50 | process.aspでvoteshowresultsが処理される | E-05 (68-74行目) | ○ |
| C-51 | process.aspでvoteshowballotが処理される | E-05 (75-81行目) | ○ |
| C-52 | pollv2.jsでgetVote関数がある | E-06 (5-32行目) | ○ |
| C-53 | pollv2.jsでstateChanged関数がある | E-06 (34-41行目) | ○ |
| C-54 | pollv2.jsでGetXmlHttpObject関数がある | E-06 (43-55行目) | ○ |
| C-55 | cls_customerでpolls関数がある | E-07 (854-870行目) | ○ |
| C-56 | cls_customerのresetでpollが削除される | E-08 (646-648, 660行目) | ○ |
| C-57 | GetXmlHttpObjectでXMLHttpRequestが使用される | E-06 (46-48行目) | ○ |
| C-58 | GetXmlHttpObjectでActiveXObjectが使用される | E-06 (50-52行目) | △ |
| C-59 | bs_pollListで権限チェックがある | E-02 (4行目: logon.hasaccess) | △ |
| C-60 | bs_pollEditで利用箇所検索がある | E-03 (33-42行目) | ○ |
| C-61 | pollv2.jsでmode=viewが処理される | E-06 (14-17行目) | ○ |
| C-62 | pollv2.jsでmode=voteが処理される | E-06 (18-21行目) | ○ |
| C-63 | bs_pollEditで12色のカラーピッカーがある | E-03 (29-31行目) | ○ |
| C-64 | checkCSRF関数の詳細実装 | **根拠なし** | △ |
| C-65 | ActiveXObjectの実際の動作検証 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- checkCSRF関数の実装詳細は別ファイル（おそらくbs_security.aspまたはcommon.asp）に存在
  - 候補：`/asp/bs_security.asp` / `/asp/includes/common.asp`
- ActiveXObjectによるIE対応は実際のIE環境でのテストが必要
  - 候補：実機テスト / 仮想環境でのテスト
- cleanup関数、convertStr関数、isLeeg関数などのユーティリティ関数の詳細実装
  - 候補：`/asp/includes/common.asp` / `/asp/includes/functions.asp`
- encrypt/decrypt関数の実装詳細
  - 候補：`/asp/includes/encryption.asp` / `/asp/includes/common.asp`

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - セキュリティ関連テストケース（UT-POL-008, UT-POL-082）の実装詳細確認が必要
- **1: 中リスク** - ブラウザ互換性テスト（UT-POL-091, UT-POL-092）は実行環境に依存
- **0: 低リスク** - 日付関連テストケースはタイムゾーン設定に注意
- **0: 低リスク** - IP制限テストはテスト環境のネットワーク構成に依存

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティ関連テストケース（SQLインジェクション、CSRF）の根拠を確認
- [ ] 日付境界値テストの期待結果がサーバーのタイムゾーンと一致するか確認
- [ ] IP制限テストの閾値（5回以上）が要件と一致するか確認
- [ ] Cookie有効期限（10日間）が要件と一致するか確認
- [ ] パーセンテージ計算のゼロ除算防止ロジックが正しいか確認
- [ ] 回答オプションの上限（15件）が要件と一致するか確認
- [ ] ActiveXObject対応が必要かどうかをプロジェクト要件で確認
