---
generated_at: 2026-01-24 00:35:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：popup.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **UT-POP-030**：cId変数の定義元がインクルードファイル内のため確認推奨
  2. **UT-POP-042**：headerDictionary, generatePasswordの定義元がインクルードファイル内のため確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/includes/popup.asp` - cls_popupクラス定義
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/includes/popupModeList.asp` - cls_popupModeListクラス定義
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_popupEdit.asp` - ポップアップ編集画面
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_popupList.asp` - ポップアップ一覧画面
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_popupMode.asp` - ポップアップモード設定画面
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_popupBack.asp` - 戻るリンク表示

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cls_popup初期化時のデフォルト値設定 | E-01 (行4-21) | ○ |
| C-02 | iPopupIDリクエストによる自動ロード | E-01 (行18) | ○ |
| C-03 | On Error Resume Nextによるエラーハンドリング | E-01 (行5, 19-20) | ○ |
| C-04 | sGetViewmodeプロパティのデフォルト値返却 | E-01 (行22-28) | ○ |
| C-05 | sGetUrlプロパティのURL返却ロジック | E-01 (行29-35) | ○ |
| C-06 | bOnlineプロパティの期間判定 | E-01 (行36-93) | ○ |
| C-07 | iMode別の表示制御ロジック | E-01 (行40-86) | ○ |
| C-08 | Cookie/Session管理によるポップアップ表示制御 | E-01 (行44-49, 51-85) | ○ |
| C-09 | getRequestValuesのフォーム値取得 | E-01 (行94-107) | ○ |
| C-10 | sNameの50文字制限 | E-01 (行95) | ○ |
| C-11 | Pickメソッドのデータベース取得 | E-01 (行108-132) | ○ |
| C-12 | PickのisNumeriek検証 | E-01 (行111) | ○ |
| C-13 | PickのiCustomerID条件 | E-01 (行112) | ○ |
| C-14 | Checkメソッドのバリデーション | E-01 (行133-143) | ○ |
| C-15 | sName必須チェック | E-01 (行135-138) | ○ |
| C-16 | sUrl/sValue必須チェック | E-01 (行139-142) | ○ |
| C-17 | SaveメソッドのADDNEW/UPDATE切り替え | E-01 (行144-179) | ○ |
| C-18 | SaveでのCheck連携 | E-01 (行145-150) | ○ |
| C-19 | removeメソッドのDELETE実行 | E-01 (行180-186) | ○ |
| C-20 | copyメソッドのコピー処理 | E-01 (行187-192) | ○ |
| C-21 | dumpJSのbNOPopup判定 | E-01 (行194) | ○ |
| C-22 | dumpJSのcolorbox JavaScript生成 | E-01 (行195-210) | ○ |
| C-23 | dumpJSのiAutoclose処理 | E-01 (行203-205) | ○ |
| C-24 | dumpJSのbUseAsSystemMessage処理 | E-01 (行211-223) | ○ |
| C-25 | dumpJSのmessageMode分岐 | E-01 (行214-219) | ○ |
| C-26 | dumpJSのbSticky処理 | E-01 (行220-222) | ○ |
| C-27 | dumpJSのbUseAsPopup処理 | E-01 (行224-229) | ○ |
| C-28 | closeメソッドのheaderDictionary追加 | E-01 (行231-233) | ○ |
| C-29 | cls_popupModeListの初期化 | E-02 (行3-16) | ○ |
| C-30 | cls_popupModeListのlist解放 | E-02 (行17-19) | ○ |
| C-31 | showSelectedのsingleモード | E-02 (行20-38) | ○ |
| C-32 | showSelectedのoptionモード | E-02 (行28-36) | ○ |
| C-33 | bs_popupEditのセキュリティチェック | E-03 (行4) | ○ |
| C-34 | bs_popupEditの削除処理フロー | E-03 (行9-12) | ○ |
| C-35 | bs_popupEditの保存処理フロー | E-03 (行13-18) | ○ |
| C-36 | checkCSRF呼び出し | E-03 (行15) | ○ |
| C-37 | bs_popupListのセキュリティチェック | E-04 (行4) | ○ |
| C-38 | bs_popupListのコピー処理 | E-04 (行5-7) | ○ |
| C-39 | bs_popupListのリセット処理 | E-04 (行8-12) | ○ |
| C-40 | bs_popupListの一覧表示 | E-04 (行15-16) | ○ |
| C-41 | bs_popupModeの保存処理 | E-05 (行4-7) | ○ |
| C-42 | cId変数の参照（SaveメソッドでiCustomerID設定） | **インクルードファイル参照** | △ |
| C-43 | headerDictionary, generatePasswordの参照 | **インクルードファイル参照** | △ |

## 4) 不足情報（Unknown / Missing）
- **cId変数**: グローバル変数としてインクルードファイル（おそらくbegin.aspまたはbs_initBack.asp）で定義されていると推測
  - 候補：`asp/begin.asp` / `asp/bs_initBack.asp` / `asp/includes/session.asp`
- **headerDictionary, generatePassword関数**: インクルードファイルで定義されていると推測
  - 候補：`asp/includes/functions.asp` / `asp/includes/helpers.asp`
- **customer.sQSUrl, customer.popups**: customerオブジェクトのプロパティ、別のインクルードファイルで定義
  - 候補：`asp/includes/customer.asp`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから直接確認可能
- **1（中リスク）**: 以下の項目は外部依存があるため要確認
  - SQLインジェクション対策: Pick, Save, removeメソッドでcidパラメータが直接SQL文に挿入されている（E-01行112, 159, 183）
  - convertGetal, isNumeriek, isLeeg等のヘルパー関数の実装詳細がインクルードファイル依存

## 6) レビュアーチェックリスト（最小）
- [ ] cls_popupクラスのプロパティ初期値がテストケースC-01と一致しているか確認
- [ ] bOnlineのiMode別ロジック（case 0〜10）が正しく網羅されているか確認
- [ ] SaveメソッドのiCustomerID設定におけるcId変数の出所を確認
- [ ] SQLインジェクションリスクの評価（cidパラメータの検証有無）
- [ ] checkCSRF関数の実装詳細とトークン検証方法の確認
- [ ] bs_popupEdit.aspのbNOPopup=true設定の影響範囲確認
- [ ] customer.popups の戻り値型（Dictionary）の確認
