---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 160
  claims_with_evidence: 158
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：process.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：158 / 160、根拠なし：2
- 優先レビュー（高）
  1. **process_send.asp**: ファイルが空のため、機能が不明
  2. **cls_poll/cls_popup等の外部クラス**: クラス定義が別ファイルのため詳細動作未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process.asp` - メインルーティング処理（290行）
- E-02: `asp/process_login.asp` - ページパスワードログイン処理（26行）
- E-03: `asp/process_register.asp` - ユーザー登録処理（30行）
- E-04: `asp/process_profile.asp` - プロファイル編集処理（118行）
- E-05: `asp/process_catalog.asp` - カタログ表示処理（129行）
- E-06: `asp/process_search.asp` - 検索処理（43行）
- E-07: `asp/process_listpage.asp` - リストページ表示処理（88行）
- E-08: `asp/process_avatar.asp` - アバター管理処理（80行）
- E-09: `asp/process_fileupload.asp` - ファイルアップロード処理（68行）
- E-10: `asp/process_loginIntranet.asp` - イントラネットログイン処理（87行）
- E-11: `asp/process_forgotPW.asp` - パスワード忘れ処理（30行）
- E-12: `asp/process_editsite.asp` - サイト編集処理（59行）
- E-13: `asp/process_unsubscribe.asp` - 購読解除処理（48行）
- E-14: `asp/process_itemform.asp` - アイテムフォーム処理（9行）
- E-15: `asp/process_showitem.asp` - アイテム表示処理（7行）
- E-16: `asp/process_showpost.asp` - 投稿表示処理（6行）
- E-17: `asp/process_sitemap.asp` - サイトマップ表示処理（3行）
- E-18: `asp/process_send.asp` - 送信処理（空ファイル・1行）
- E-19: `asp/bs_process.asp` - バックサイト処理（214行）
- E-20: `asp/bs_processPage.asp` - ページ処理（82行）

## 3) Claims と根拠の対応（レビューの主戦場）

### process.asp ルーティング処理（UT-PRC-001 ~ UT-PRC-029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pageActionによる分岐処理が存在 | E-01 L40-267 select case文 | ○ |
| C-02 | avataredit時にprocess_avatar.aspをインクルード | E-01 L42-45 | ○ |
| C-03 | fileupload時にprocess_fileupload.aspをインクルード | E-01 L46-49 | ○ |
| C-04 | search時にprocess_search.aspをインクルード | E-01 L50 | ○ |
| C-05 | vote時にcls_poll.registerVote()を呼び出し | E-01 L61-67 | ○ |
| C-06 | gbedit時にcls_guestbookitemを操作 | E-01 L107-128 | ○ |
| C-07 | cLogOff時にCSRF検証を実施 | E-01 L157 checkCSRF() | ○ |
| C-08 | 404エラー時にカスタム404ページを表示 | E-01 L23-33 | ○ |

### process_login.asp 認証処理（UT-PRC-030 ~ UT-PRC-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | logon.logonItemでパスワード検証 | E-02 L3 | ○ |
| C-10 | 認証失敗時にerr_loginエラー | E-02 L6-7 | ○ |
| C-11 | ログインフォームHTMLを生成 | E-02 L9-25 | ○ |

### process_register.asp 登録処理（UT-PRC-033 ~ UT-PRC-036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | CSRF検証を実施 | E-03 L3 checkCSRF() | ○ |
| C-13 | cls_ticketでチケット作成・送信 | E-03 L4-8 | ○ |
| C-14 | CAPTCHAフィールドを表示 | E-03 L20-21 | ○ |

### process_profile.asp プロファイル処理（UT-PRC-037 ~ UT-PRC-044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | チケット検証を実施 | E-04 L2-9 | ○ |
| C-16 | プロファイル保存処理 | E-04 L16-45 | ○ |
| C-17 | 重複メール許可フラグ設定 | E-04 L20 allowDE=true | ○ |
| C-18 | 新規メンバー通知メール送信 | E-04 L27-35 | ○ |
| C-19 | contactFieldsによるフォーム生成 | E-04 L73-110 | ○ |

### process_catalog.asp カタログ処理（UT-PRC-045 ~ UT-PRC-053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | カタログオンラインチェック | E-05 L4 | ○ |
| C-21 | 検索フォーム生成 | E-05 L17-46 | ○ |
| C-22 | 各フィールドタイプ別レンダリング | E-05 L29-41, L74-83 | ○ |
| C-23 | ファイルリスト表示 | E-05 L89-107 | ○ |
| C-24 | フォームリンク表示 | E-05 L109-116 | ○ |

### process_search.asp 検索処理（UT-PRC-054 ~ UT-PRC-061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | 検索値を100文字に制限 | E-06 L2-3 left(...,100) | ○ |
| C-26 | リストアイテムを検索対象に含む | E-06 L5 includeListItems=true | ○ |
| C-27 | 検索キーワードハイライト | E-06 L17,24,29,32 replace(...,"<b>"...) | ○ |
| C-28 | 結果件数をタイトルに表示 | E-06 L43 | ○ |

### process_listpage.asp リストページ処理（UT-PRC-062 ~ UT-PRC-069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | アコーディオン表示切替 | E-07 L82-86 | ○ |
| C-30 | 外部URLリンク処理 | E-07 L17,29-34 | ○ |
| C-31 | 展開制御 | E-07 L36,43 iLPOpenByDefault | ○ |
| C-32 | SEOタイトル設定 | E-07 L25 | ○ |

### process_avatar.asp アバター処理（UT-PRC-070 ~ UT-PRC-084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | アバター機能有効チェック | E-08 L2 | ○ |
| C-34 | 管理者認証チェック | E-08 L5-14 | ○ |
| C-35 | JPG/GIFファイル形式制限 | E-08 L39 | ○ |
| C-36 | 650KBファイルサイズ制限 | E-08 L42 | ○ |
| C-37 | セキュリティコード検証 | E-08 L32 | ○ |
| C-38 | isSecure関数による権限チェック | E-08 L76-79 | ○ |

### process_fileupload.asp ファイルアップロード処理（UT-PRC-085 ~ UT-PRC-092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | 認証チェック | E-09 L5 | ○ |
| C-40 | 対応ファイル形式リスト | E-09 L23-24 | ○ |
| C-41 | 7MBファイルサイズ制限 | E-09 L28 | ○ |
| C-42 | ファイル名生成 | E-09 L35 | ○ |

### process_loginIntranet.asp イントラネットログイン処理（UT-PRC-093 ~ UT-PRC-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | CAPTCHA検証 | E-10 L4-5 | ○ |
| C-44 | イントラネット認証 | E-10 L6 logon.logonIntranet | ○ |
| C-45 | ログインモード切替 | E-10 L38-43 | ○ |
| C-46 | 新規登録リンク表示 | E-10 L57-60 | ○ |

### process_forgotPW.asp パスワード忘れ処理（UT-PRC-103 ~ UT-PRC-106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | CAPTCHA検証 | E-11 L4 | ○ |
| C-48 | パスワードリセット | E-11 L5-9 logon.resetPW | ○ |

### process_editsite.asp サイト編集処理（UT-PRC-107 ~ UT-PRC-113）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | 権限取得 | E-12 L14-16 getTper/getBper/getLper | ○ |
| C-50 | 編集メニュー生成 | E-12 L18-54 | ○ |
| C-51 | セッションフラグ設定 | E-12 L57 | ○ |

### process_unsubscribe.asp 購読解除処理（UT-PRC-114 ~ UT-PRC-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | キー長検証(24文字) | E-13 L2 | ○ |
| C-53 | 購読解除(bActive=false) | E-13 L25 | ○ |
| C-54 | 解除通知メール送信 | E-13 L27-34 | ○ |

### process_itemform.asp アイテムフォーム処理（UT-PRC-120 ~ UT-PRC-123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | アイテム取得 | E-14 L2-3 | ○ |
| C-56 | オンラインチェック | E-14 L4 checkOnline() | ○ |
| C-57 | フォーム表示 | E-14 L7 | ○ |

### process_showitem.asp/showpost.asp/sitemap.asp（UT-PRC-124 ~ UT-PRC-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | カタログアイテム詳細表示 | E-15 L2-6 | ○ |
| C-59 | 投稿表示 | E-16 L2-5 | ○ |
| C-60 | サイトマップ表示 | E-17 L2-3 | ○ |

### bs_process.asp バックサイト処理（UT-PRC-129 ~ UT-PRC-151）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | ページFP変換 | E-19 L6-16 | ○ |
| C-62 | 統計リセット | E-19 L17-19 | ○ |
| C-63 | ページ移動(上下) | E-19 L20-35 | ○ |
| C-64 | ページ挿入 | E-19 L41-64 | ○ |
| C-65 | ページコピー | E-19 L65-73 | ○ |
| C-66 | ページタイプ選択 | E-19 L74-92 | ○ |
| C-67 | favicon削除 | E-19 L93-102 | ○ |
| C-68 | 管理者設定保存 | E-19 L103-126 | ○ |
| C-69 | イントラネット設定保存 | E-19 L127-156 | ○ |
| C-70 | 全体パスワード管理 | E-19 L157-166 | ○ |
| C-71 | 管理者PW変更 | E-19 L176-184 | ○ |
| C-72 | peel設定 | E-19 L185-213 | ○ |

### bs_processPage.asp ページ処理（UT-PRC-152 ~ UT-PRC-160）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | ページ保存処理 | E-20 L12-25 | ○ |
| C-74 | ページ削除処理 | E-20 L26-44 | ○ |
| C-75 | パスワード保存処理 | E-20 L45-60 | ○ |
| C-76 | パスワード削除処理 | E-20 L61-81 | ○ |

### 根拠なし項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | process_send.aspの機能 | E-18（空ファイル） | △ |
| C-78 | cls_poll/cls_popup等外部クラスの詳細動作 | **根拠なし**（別ファイル定義） | △ |

## 4) 不足情報（Unknown / Missing）
- **process_send.asp**: ファイルが空（1行のみ）のため、実装されていない可能性
  - 候補：将来実装予定 / 削除された機能 / 別ファイルで実装
- **外部クラス定義**: cls_poll, cls_popup, cls_guestbookitem, cls_newsletterCategory, cls_ticket, cls_contact等の詳細実装がincludesディレクトリ内に存在する可能性
  - 候補：asp/includes/内のクラス定義ファイル

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケースはソースコードから直接導出されており、高い信頼度
- **1 (中リスク)**: 外部クラスのメソッド呼び出しに関するテストケースは、クラス定義の詳細確認が必要
- **1 (中リスク)**: セキュリティ関連機能（CSRF、認証）のテストケースは実際のセキュリティ要件との照合が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] process_send.aspの空ファイルは意図的か確認
- [ ] CSRF保護（checkCSRF関数）の実装詳細をincludesで確認
- [ ] ファイルアップロードのサイズ制限（500KB/5MB/7MB）が要件と一致するか確認
- [ ] 対応ファイル形式（jpg,png,doc,zip,rar,pdf等）が要件と一致するか確認
- [ ] 外部クラス（cls_poll, cls_popup等）のテストケースが十分か確認
- [ ] セキュリティ関連テストケース（認証、権限チェック）の網羅性確認
