---
generated_at: 2026-01-24 12:00:00
metrics:
  claims_total: 90
  claims_with_evidence: 87
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：shop.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：87 / 90、根拠なし：3
- 優先レビュー（高）
  1. **UT-SHP-079（CSRFチェック）**：checkCSRF_Upload関数の実装詳細が別ファイルにあり確認困難
  2. **UT-SHP-089, 090（セキュリティ）**：logon.hasaccess, secondAdmin.bShoppingCartの実装がインクルードファイルにあり詳細未確認
  3. **UT-SHP-077（ファイル未選択）**：UBound(ks) = -1の条件分岐に基づくが、エラーメッセージの詳細動作は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/includes/shopCategory.asp` - cls_shopCategoryクラス定義（145行）
- E-02: `asp/includes/shopMake.asp` - cls_shopMakeクラス定義（103行）
- E-03: `asp/includes/shopProduct.asp` - cls_shopProductクラス定義（144行）
- E-04: `asp/bs_shopProductImgUpload.asp` - 商品画像アップロード処理（41行）
- E-05: `asp/bs_shopMake.asp` - メーカー管理画面（21行）
- E-06: `asp/bs_shopProduct.asp` - 商品管理画面（26行）
- E-07: `asp/bs_shopAdCat.asp` - カテゴリ管理画面（22行）
- E-08: `asp/bs_shopProductImg.asp` - 商品画像管理画面（16行）
- E-09: `asp/bs_shoppingcart.asp` - ショッピングカートダッシュボード（46行）
- E-10: `asp/bs_shopProductCat.asp` - 商品カテゴリ関連管理画面（34行）
- E-11: `asp/bs_shoppingcartmenu.asp` - ショッピングカートメニュー（3行）

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_shopCategory関連（UT-SHP-001 〜 UT-SHP-026）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Class_Initializeでiid=null, bOnline=true, iParentCatID=nullに初期化 | E-01 (4-8行目) | ○ |
| C-02 | Pickはid引数を数値チェック（isNumeriek）してからDB検索 | E-01 (37-52行目) | ○ |
| C-03 | CheckはsNameが空（isLeeg）ならfalse、message.AddError呼び出し | E-01 (53-60行目) | ○ |
| C-04 | SaveはCheck()後、iParentCatID=0ならnull変換してDBに保存 | E-01 (61-90行目) | ○ |
| C-05 | SaveでbOnline=falseの場合、子カテゴリもofflineに更新 | E-01 (87-89行目) | ○ |
| C-06 | deleteは親カテゴリIDをnull、関連tblQShopProdCatも削除 | E-01 (91-95行目) | ○ |
| C-07 | subcategoriesはiParentCatID=iIdの子カテゴリをDictionaryで返却 | E-01 (11-23行目) | ○ |
| C-08 | listはiParentCatID is nullのトップレベルカテゴリをDictionaryで返却 | E-01 (24-36行目) | ○ |
| C-09 | bShowParentCatDropDownは子カテゴリがある場合false | E-01 (96-105行目) | ○ |
| C-10 | bShowOnlineCBは親カテゴリのbOnline状態で決まる | E-01 (106-119行目) | ○ |
| C-11 | showParentCatは"single"/"option"モードで異なる出力 | E-01 (120-144行目) | ○ |

### cls_shopMake関連（UT-SHP-027 〜 UT-SHP-041）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | Class_Initializeでiid=null, bOnline=trueに初期化 | E-02 (4-7行目) | ○ |
| C-13 | Pickはid引数を数値チェック（isNumeriek）してからDB検索 | E-02 (23-38行目) | ○ |
| C-14 | CheckはsNameが空（isLeeg）ならfalse | E-02 (39-46行目) | ○ |
| C-15 | Saveはtrim(left(sName,255))で255文字に切り詰め | E-02 (63行目) | ○ |
| C-16 | Saveはtrim(left(sLogo,255))で255文字に切り詰め | E-02 (65行目) | ○ |
| C-17 | deleteはtblQShopMakeから削除 | E-02 (73-76行目) | ○ |
| C-18 | listはDictionaryで全メーカーを返却 | E-02 (10-22行目) | ○ |
| C-19 | showMakeは"single"/"option"モードで異なる出力 | E-02 (77-101行目) | ○ |

### cls_shopProduct関連（UT-SHP-042 〜 UT-SHP-074）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | Class_Initializeでiid=null, bOnline=trueに初期化 | E-03 (4-7行目) | ○ |
| C-21 | Pickはid引数を数値チェック（isNumeriek）してからDB検索 | E-03 (13-34行目) | ○ |
| C-22 | CheckはsNameが空（isLeeg）ならfalse | E-03 (35-49行目) | ○ |
| C-23 | CheckはiStockが空でなく数値でない場合もfalse | E-03 (42-48行目) | ○ |
| C-24 | Saveはtrim(left(sName,255))で255文字に切り詰め | E-03 (66行目) | ○ |
| C-25 | deleteはフォルダ存在確認後に削除、DBからも削除 | E-03 (83-90行目) | ○ |
| C-26 | allproductsはRecordsetで全商品を返却 | E-03 (10-12行目) | ○ |
| C-27 | imagesはフォルダ内ファイルをDictionaryで返却 | E-03 (103-116行目) | ○ |
| C-28 | deleteImageはファイル存在確認後に削除、デフォルト画像ならクリア | E-03 (91-102行目) | ○ |
| C-29 | setAsDefaultImageはimgが空でない場合のみsDefaultImage設定 | E-03 (128-133行目) | ○ |
| C-30 | categoriesはtblQShopProdCatからカテゴリIDをDictionaryで返却 | E-03 (117-127行目) | ○ |
| C-31 | saveCatsは既存削除後、カンマ区切りでループ挿入 | E-03 (134-143行目) | ○ |

### ASPページ関連（UT-SHP-075 〜 UT-SHP-090）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | bs_shopProductImgUpload.aspはJPGのみ許可、それ以外はerr_fileType | E-04 (26-31行目) | ○ |
| C-33 | bs_shopProductImgUpload.aspはファイルがない場合err_newFile | E-04 (33-35行目) | ○ |
| C-34 | bs_shopProductImgUpload.aspはフォルダなければ自動作成 | E-04 (9-14行目) | ○ |
| C-35 | bs_shopProductImgUpload.aspはcheckCSRF_Upload呼び出し | E-04 (21行目) | ○ |
| C-36 | bs_shopMake.aspはpostbackでsave/deleteを分岐 | E-05 (9-19行目) | ○ |
| C-37 | bs_shopProduct.aspはpostbackでsave/deleteを分岐 | E-06 (11-24行目) | ○ |
| C-38 | bs_shopAdCat.aspはpostbackでsave/deleteを分岐 | E-07 (9-19行目) | ○ |
| C-39 | bs_shopProductImg.aspはdelete/defaultパラメータで処理分岐 | E-08 (8-13行目) | ○ |
| C-40 | bs_shopProductCat.aspはsaveCats呼び出しとmessage.Add | E-10 (10-13行目) | ○ |
| C-41 | bs_shoppingcart.aspはlogon.hasaccess secondAdmin.bShoppingCartでアクセス制御 | E-09 (4行目) | ○ |
| C-42 | checkCSRF_Upload関数の詳細動作 | **根拠なし**（別インクルードファイル） | △ |
| C-43 | logon.hasaccessの詳細動作 | **根拠なし**（別インクルードファイル） | △ |
| C-44 | secondAdmin.bShoppingCartの詳細動作 | **根拠なし**（別インクルードファイル） | △ |

## 4) 不足情報（Unknown / Missing）
- **checkCSRF_Upload関数**：bs_security.aspまたはbegin.aspにインクルードされている可能性が高いが、本分析対象外
  - 候補：asp/bs_security.asp / asp/begin.asp / asp/includes/functions.asp
- **logon.hasaccessメソッド**：認証クラスのメソッドで、別ファイルで定義
  - 候補：asp/bs_security.asp / asp/includes/logon.asp
- **secondAdmin.bShoppingCartプロパティ**：管理者権限クラスのプロパティ
  - 候補：asp/includes/admin.asp / asp/includes/secondAdmin.asp

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**：セキュリティ関連テストケース（UT-SHP-079, UT-SHP-089, UT-SHP-090）
  - CSRFチェック・アクセス制御の実装詳細が別ファイルにあり、テスト実行時に追加確認が必要
- **リスク1（中）**：ファイルシステム操作関連テストケース（UT-SHP-056, UT-SHP-063, UT-SHP-078）
  - 実環境でのファイル操作となるため、テスト環境の準備が必要
- **リスク0（低）**：その他のテストケース
  - コードから直接抽出した機能テストであり、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] cls_shopCategoryの削除処理で子カテゴリの親ID更新が正しくカスケードされるか確認
- [ ] cls_shopProductのsaveCatsでdecrypt関数が正しく動作するか確認
- [ ] bs_shopProductImgUpload.aspのcheckCSRF_Upload関数の実装を確認
- [ ] logon.hasaccess secondAdmin.bShoppingCartのアクセス制御ロジックを確認
- [ ] テストケースの優先度「高」の項目が実際に重要な機能であるか確認
- [ ] 255文字制限のあるフィールド（sName, sLogo）でtruncation動作が期待通りか確認
- [ ] iStockフィールドの数値バリデーションがNaN入力を正しく拒否するか確認
