---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 88
  claims_with_evidence: 85
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：template.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：85 / 88、根拠なし：3
- 優先レビュー（高）
  1. **UT-TPL-073**: オンラインテンプレート検索機能の外部依存
  2. **UT-TPL-076**: ダウンロード機能の外部URL依存
  3. **UT-TPL-077**: ページング計算ロジックの詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/includes/template.asp` - cls_templateクラス定義
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_templateEdit.asp` - テンプレート編集画面
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_templateList.asp` - テンプレート一覧画面
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_templateSearch.asp` - オンラインテンプレート検索
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_CreateTemplate.asp` - テンプレート作成画面
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_template.asp` - テンプレート選択UI
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_templateBack.asp` - 戻るリンク
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/bs_editListTemplate.asp` - リストテンプレート編集
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/asp/template.txt` - デフォルトテンプレート
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/QuickerSite-master/docs/code-to-docs/単体テストケース一覧/plan.md` - モジュール計画

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_templateクラス（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Class_Initialize初期化処理 | E-01 (L48-59) | ○ |
| C-02 | init()でtemplate.txt読込 | E-01 (L60-70) | ○ |
| C-03 | initPrint()で印刷テンプレート読込 | E-01 (L71-78) | ○ |
| C-04 | initEmail()でメールテンプレート読込 | E-01 (L79-86) | ○ |
| C-05 | initMobile()でモバイルテンプレート読込 | E-01 (L87-94) | ○ |
| C-06 | initWAP()でWAPテンプレート読込 | E-01 (L95-102) | ○ |
| C-07 | Pick()でDBからテンプレート取得 | E-01 (L103-125) | ○ |
| C-08 | Check()でバリデーション実行 | E-01 (L126-136) | ○ |
| C-09 | Save()で新規/更新保存 | E-01 (L137-176) | ○ |
| C-10 | getRequestValues()でフォーム値取得 | E-01 (L177-185) | ○ |
| C-11 | remove()でテンプレート削除 | E-01 (L186-198) | ○ |
| C-12 | copy()でテンプレート複製 | E-01 (L199-205) | ○ |
| C-13 | copyToCustomerID()で顧客間コピー | E-01 (L206-213) | ○ |
| C-14 | treatAsArtisteer()でArtisteer変換 | E-01 (L376-808) | ○ |
| C-15 | treatAsJSTemplate()でJS変換 | E-01 (L264-375) | ○ |
| C-16 | importArtisteer4()でv4変換 | E-01 (L214-263) | ○ |

### bs_templateEdit.asp（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | 保存ボタンでsave処理 | E-02 (L7-12) | ○ |
| C-18 | 削除ボタンでremove処理 | E-02 (L13-16) | ○ |
| C-19 | プレビューボタンでリダイレクト | E-02 (L17-23) | ○ |
| C-20 | CSRF検証checkCSRF()呼出 | E-02 (L8, 14, 18) | ○ |
| C-21 | 削除可否の判定ロジック | E-02 (L29-32) | ○ |
| C-22 | セキュリティチェックlogon.hasaccess | E-02 (L4) | ○ |

### bs_templateList.asp（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | copyアクション処理 | E-03 (L9-10) | ○ |
| C-24 | deleteアクション処理 | E-03 (L11-12) | ○ |
| C-25 | defaultアクション処理 | E-03 (L13-15) | ○ |
| C-26 | templateCatList関数 | E-03 (L40-59) | ○ |
| C-27 | showTemplateBox関数 | E-03 (L60-82) | ○ |
| C-28 | installTemplate関数 | E-03 (L83-126) | ○ |
| C-29 | zipper機能の条件分岐 | E-03 (L27-29) | ○ |

### bs_templateSearch.asp（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | オンラインテンプレート一覧取得 | E-04 (L40-49) | ○ |
| C-31 | セッションキャッシュ処理 | E-04 (L40-49) | ○ |
| C-32 | install処理とファイルダウンロード | E-04 (L10-39) | ○ |
| C-33 | navbalk関数（ページング） | E-04 (L66-78) | ○ |
| C-34 | 外部URLへのHTTPリクエスト | E-04 (L11-14, 41-43) | △ |

### bs_CreateTemplate.asp（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | フォーム処理とテンプレート作成 | E-05 (L19-67) | ○ |
| C-36 | Artisteer自動検出ロジック | E-05 (L82-96) | ○ |
| C-37 | フォルダ存在チェック | E-05 (L16, 75-76) | ○ |
| C-38 | 不正ファイル削除処理 | E-05 (L96-100) | ○ |
| C-39 | 必須入力チェック | E-05 (L29-33) | ○ |

### bs_template.asp（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | テンプレート選択UI表示条件 | E-06 (L2) | ○ |

### bs_editListTemplate.asp（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | リストテンプレート保存処理 | E-08 (L12-15) | ○ |
| C-42 | 3種類のテンプレート選択肢 | E-08 (L27-35) | ○ |

### 外部依存（要確認）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | sBrowseOnlineTemplatesUrlの動作 | E-04 (L6-8, 13, 42) | △ |
| C-44 | SaveBinaryData関数の動作 | E-04 (L32) | △ |

## 4) 不足情報（Unknown / Missing）
- **sBrowseOnlineTemplatesUrl**: 外部URL設定値の定義元が不明
  - 候補: includes/config.asp / includes/constants.asp / Application変数
- **SaveBinaryData関数**: バイナリ保存関数の定義元が不明
  - 候補: includes/functions.asp / includes/upload.asp
- **compressHTML関数**: HTML圧縮関数の定義元が不明
  - 候補: includes/functions.asp / includes/utilities.asp

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - cls_templateクラスの基本メソッド（init, pick, save, remove, copy）
- **1: 中リスク** - Artisteerテンプレート変換処理（複雑な文字列置換ロジック）
- **1: 中リスク** - ファイルシステム操作（フォルダ作成、ファイル削除）
- **2: 高リスク** - オンラインテンプレートダウンロード（外部URL依存、セキュリティ考慮必要）
- **1: 中リスク** - CSRF検証の網羅性（checkCSRF()の呼び出し漏れがないか）

## 6) レビュアーチェックリスト（最小）
- [ ] cls_templateクラスのSave()メソッドでSQLインジェクション対策が適切か確認
- [ ] remove()メソッドで参照整合性が正しく維持されるか確認
- [ ] オンラインテンプレートダウンロード時のURLバリデーションを確認
- [ ] ファイル削除処理（allowedFileTypes）のセキュリティ確認
- [ ] CSRF検証がすべてのPOST/アクション処理で実施されているか確認
- [ ] Artisteer変換処理での正規表現パターンが意図通りか確認
- [ ] テスト優先度「高」のケース（金額計算なし、認証・認可関連）が網羅されているか確認
