---
generated_at: 2026-01-24 10:30:00
metrics:
  claims_total: 112
  claims_with_evidence: 108
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：theme.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当処理が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：テスト対象のクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：108 / 112、根拠なし：4
- 優先レビュー（高）
  1. **UT-THM-096（incJS）**：プライベートプロパティのためテスト方法要検討
  2. **UT-THM-093, 094（themeSubs, topicSubs）**：プライベート関数のためテスト方法要検討
  3. **UT-THM-095（buildSubs）**：プライベート関数のためテスト方法要検討

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `asp/includes/theme.asp` - cls_themeクラス定義（909行）
- E-02: `asp/includes/themeTypeList.asp` - cls_themeTypeListクラス定義（34行）
- E-03: `asp/includes/themeSubscriptionList.asp` - cls_theme_sublevelListクラス定義（36行）
- E-04: `asp/bs_themeEdit.asp` - テーマ編集画面（50行）
- E-05: `asp/bs_themesList.asp` - テーマ一覧画面（11行）
- E-06: `asp/bs_theme.asp` - テーマ選択コンポーネント（3行）

## 3) Claims と根拠の対応（レビューの主戦場）

### cls_theme クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Class_Initializeでデフォルト値設定 | E-01: 8-49行 | ○ |
| C-02 | QueryStringからstartpage取得 | E-01: 39-46行 | ○ |
| C-03 | startpage=0で1に補正 | E-01: 44-46行 | ○ |
| C-04 | startpage>500で1に補正 | E-01: 44-46行 | ○ |
| C-05 | Pick関数でデータ取得 | E-01: 58-98行 | ○ |
| C-06 | Pick関数でisNumeriekチェック | E-01: 60行 | ○ |
| C-07 | Pick関数で存在しないIDの処理 | E-01: 63行（if not rs.eof then） | ○ |
| C-08 | Check関数で必須項目検証 | E-01: 99-134行 | ○ |
| C-09 | Check関数でsName必須チェック | E-01: 101-104行 | ○ |
| C-10 | Check関数でsBodyNotification必須チェック | E-01: 105-108行 | ○ |
| C-11 | Check関数でsSubjectNotification必須チェック | E-01: 109-112行 | ○ |
| C-12 | Check関数でbAllowAP時のsLabelYourName必須 | E-01: 113-118行 | ○ |
| C-13 | Check関数でPersonal Blog時のiContactID必須 | E-01: 119-124行 | ○ |
| C-14 | Check関数でsCode重複チェック | E-01: 125-133行 | ○ |
| C-15 | Check関数でsCode空時のスキップ | E-01: 125行 | ○ |
| C-16 | Save関数で新規保存 | E-01: 135-218行 | ○ |
| C-17 | Save関数で既存更新 | E-01: 144-148行 | ○ |
| C-18 | Save関数でcheck失敗時の終了 | E-01: 136-141行 | ○ |
| C-19 | Save関数でsName切り詰め | E-01: 150行（left(sName,255)） | ○ |
| C-20 | Save関数で購読削除（sublevel_none） | E-01: 187-195行 | ○ |
| C-21 | Save関数で購読削除（sublevel_authortopic） | E-01: 196-204行 | ○ |
| C-22 | Save関数でコメント削除 | E-01: 209-213行 | ○ |
| C-23 | Save関数でRSSキャッシュクリア | E-01: 215行 | ○ |
| C-24 | Save関数でテーマキャッシュ更新 | E-01: 217行 | ○ |
| C-25 | clearRSScache関数の実装 | E-01: 219-231行 | ○ |
| C-26 | getRequestValues関数の実装 | E-01: 232-263行 | ○ |
| C-27 | getRequestValuesでsCode大文字変換 | E-01: 253行（ucase） | ○ |
| C-28 | remove関数の実装 | E-01: 264-280行 | ○ |
| C-29 | remove関数で空iIDチェック | E-01: 265行 | ○ |
| C-30 | allowPostプロパティの実装 | E-01: 281-292行 | ○ |
| C-31 | allowPostでbLockedチェック | E-01: 283-284行 | ○ |
| C-32 | allowPostでログインチェック | E-01: 285-286行 | ○ |
| C-33 | allowPostで権限チェック | E-01: 287-288行 | ○ |
| C-34 | allowPostでPersonal Blog制限 | E-01: 289-290行 | ○ |
| C-35 | allowSubプロパティの実装 | E-01: 293-302行 | ○ |
| C-36 | allowSubでbLockedチェック | E-01: 295-296行 | ○ |
| C-37 | allowSubでログインチェック | E-01: 297-298行 | ○ |
| C-38 | allowSubでiSubLevelチェック | E-01: 299-300行 | ○ |
| C-39 | build関数の実装 | E-01: 303-381行 | ○ |
| C-40 | build関数でオフライン時の処理 | E-01: 306行 | ○ |
| C-41 | build関数でcSubscribeToTheme処理 | E-01: 310-314行 | ○ |
| C-42 | build関数でcUnSubscribeToTheme処理 | E-01: 315-319行 | ○ |
| C-43 | build関数でcPostTopic処理 | E-01: 330-335行 | ○ |
| C-44 | build関数でcPostReply処理 | E-01: 336-338行 | ○ |
| C-45 | build関数でcSearchTheme処理 | E-01: 343-344行 | ○ |
| C-46 | buildSearch関数の実装 | E-01: 382-415行 | ○ |
| C-47 | buildSearch関数で検索結果表示 | E-01: 395-412行 | ○ |
| C-48 | buildSearch関数で空検索処理 | E-01: 395行（if not isLeeg） | ○ |
| C-49 | postTopic関数の実装 | E-01: 416-653行 | ○ |
| C-50 | postTopic関数でallowPostチェック | E-01: 417行 | ○ |
| C-51 | postTopic関数で編集権限チェック | E-01: 419-421行 | ○ |
| C-52 | postTopic関数でCAPTCHA検証 | E-01: 483-484行 | ○ |
| C-53 | postTopic関数で削除処理 | E-01: 426-433行 | ○ |
| C-54 | postTopic関数で承認処理 | E-01: 434-460行 | ○ |
| C-55 | postTopic関数でHTMLエディタ表示 | E-01: 534-545行 | ○ |
| C-56 | postTopic関数でテキストエリア表示 | E-01: 570-595行 | ○ |
| C-57 | postTopic関数でJS除去 | E-01: 442, 474行（removeJS） | ○ |
| C-58 | postTopic関数でファイル添付UI | E-01: 546-567行 | ○ |
| C-59 | contact関数の実装 | E-01: 654-657行 | ○ |
| C-60 | subscribeToTopic関数の実装 | E-01: 658-683行 | ○ |
| C-61 | subscribeToTopic関数でallowSubチェック | E-01: 660行 | ○ |
| C-62 | subscribeToTopic関数でiSubLevelチェック | E-01: 661行 | ○ |
| C-63 | subscribeToTopic関数で作成者チェック | E-01: 664-665行 | ○ |
| C-64 | unsubscribeFromTopic関数の実装 | E-01: 684-696行 | ○ |
| C-65 | subscribeToTheme関数の実装 | E-01: 697-726行 | ○ |
| C-66 | subscribeToTheme関数でトピック購読削除 | E-01: 713-720行 | ○ |
| C-67 | subscribeToTheme関数でallowSubチェック | E-01: 699行 | ○ |
| C-68 | subscribeToTheme関数でiSubLevelチェック | E-01: 700行 | ○ |
| C-69 | unsubscribeFromTheme関数の実装 | E-01: 727-739行 | ○ |
| C-70 | shortNavBar関数の実装 | E-01: 740-745行 | ○ |
| C-71 | shortNavBar関数でallowPostチェック | E-01: 742行 | ○ |
| C-72 | navbar関数の実装 | E-01: 746-788行 | ○ |
| C-73 | navbar関数でログインリンク表示 | E-01: 747-751行 | ○ |
| C-74 | navbar関数で購読ボタン表示 | E-01: 755-764行 | ○ |
| C-75 | navbar関数で購読解除ボタン表示 | E-01: 759-760行 | ○ |
| C-76 | posts関数の実装 | E-01: 789-824行 | ○ |
| C-77 | posts関数でページネーション | E-01: 806-816行 | ○ |
| C-78 | posts関数で未承認フィルタ | E-01: 797-799行 | ○ |
| C-79 | posts関数でPMSフィルタ | E-01: 794-796行 | ○ |
| C-80 | posts関数で無効ID処理 | E-01: 791行 | ○ |
| C-81 | copy関数の実装 | E-01: 825-832行 | ○ |
| C-82 | copy関数で名前変更 | E-01: 828行 | ○ |
| C-83 | copy関数でsCodeリセット | E-01: 829行 | ○ |
| C-84 | copy関数で非数値ID処理 | E-01: 826行 | ○ |
| C-85 | searchPosts関数の実装 | E-01: 833-864行 | ○ |
| C-86 | searchPosts関数で200件制限 | E-01: 847行（maxresults<200） | ○ |
| C-87 | searchPosts関数で未承認フィルタ | E-01: 844行 | ○ |
| C-88 | searchPosts関数でPMSフィルタ | E-01: 841-843行 | ○ |
| C-89 | searchPosts関数で親トピック返却 | E-01: 849-853行 | ○ |
| C-90 | searchPosts関数で無効ID処理 | E-01: 835行 | ○ |
| C-91 | searchPosts関数で空検索処理 | E-01: 836行 | ○ |
| C-92 | searchPosts関数で100文字制限 | E-01: 840行（left(sValue,100)） | ○ |
| C-93 | themeSubs関数の実装 | E-01: 883-895行 | ○ |
| C-94 | topicSubs関数の実装 | E-01: 896-908行 | ○ |
| C-95 | buildSubs関数の実装 | E-01: 865-882行 | ○ |
| C-96 | incJSプロパティの実装 | E-01: 50-57行 | △ |

### cls_themeTypeList クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | Class_Initializeの実装 | E-02: 7-12行 | ○ |
| C-98 | showSelectedでsingleモード | E-02: 20-21行 | ○ |
| C-99 | showSelectedでoptionモード | E-02: 23-30行 | ○ |
| C-100 | showSelectedで型変換 | E-02: 18行（convertGetal） | ○ |

### cls_theme_sublevelList クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | Class_Initializeの実装 | E-03: 8-14行 | ○ |
| C-102 | showSelectedでsingleモード | E-03: 22-23行 | ○ |
| C-103 | showSelectedでoptionモード | E-03: 25-31行 | ○ |

### bs_themeEdit.asp

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | 保存処理の実装 | E-04: 12-17行 | ○ |
| C-105 | CSRF対策の実装 | E-04: 13, 19行（checkCSRF） | ○ |
| C-106 | 削除処理の実装 | E-04: 18-22行 | ○ |
| C-107 | アクセス制御の実装 | E-04: 4行（logon.hasaccess） | ○ |

### bs_themesList.asp

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | 一覧表示の実装 | E-05: 9-10行 | ○ |
| C-109 | コピー処理の実装 | E-05: 5-7行 | ○ |
| C-110 | アクセス制御の実装 | E-05: 4行（logon.hasaccess） | ○ |

### bs_theme.asp

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | テーマ選択ドロップダウン表示 | E-06: 2行 | ○ |
| C-112 | テーマ数による条件表示 | E-06: 2行（customer.themes.count>0） | ○ |

## 4) 不足情報（Unknown / Missing）

- **プライベートメソッド/プロパティのテスト**：VBScript/Classic ASPではPrivateメンバーへのアクセスが制限されるため、以下のテストケースは実装方法の検討が必要
  - UT-THM-093: themeSubs（Private関数）
  - UT-THM-094: topicSubs（Private関数）
  - UT-THM-095: buildSubs（Private関数）
  - UT-THM-096: incJS（Private Property）
  - 候補：統合テストで間接的に検証 / ラッパー関数の追加 / テスト用のPublicメソッド追加

- **外部依存の仮定**
  - `message`オブジェクト、`db`オブジェクト、`logon`オブジェクト等の存在を前提としている
  - `l()`関数（多言語対応）の実装詳細は不明

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 2 (高) | SQLインジェクション対策 | cleanup()関数による入力サニタイズが行われているが、searchPosts等で動的SQLが構築されている |
| 2 (高) | 権限チェック | allowPost/allowSubのロジックが複雑で、すべてのパスが正しくテストされているか確認が必要 |
| 1 (中) | CSRF対策 | checkCSRF()が適切に呼び出されているか全パスで確認が必要 |
| 1 (中) | XSS対策 | bEmbed設定によるJavaScript除去（removeJS）が正しく機能するか確認が必要 |
| 1 (中) | データ整合性 | Save時の購読削除ロジックが複雑、状態遷移の検証が必要 |
| 0 (低) | 表示系処理 | navbar/shortNavBar等の表示系は影響範囲が限定的 |

## 6) レビュアーチェックリスト（最小）

- [ ] UT-THM-006, 007: Pick関数のSQLインジェクション対策が十分か確認
- [ ] UT-THM-008〜014: Check関数のバリデーションが仕様と一致しているか確認
- [ ] UT-THM-030〜034: allowPostの権限チェックロジックが全パスでテストされているか確認
- [ ] UT-THM-052: CAPTCHA検証がbypassされないか確認
- [ ] UT-THM-057: removeJS関数がすべてのXSSパターンを防げるか確認
- [ ] UT-THM-085〜092: searchPosts関数のSQL構築が安全か確認
- [ ] プライベートメソッド（themeSubs, topicSubs, buildSubs, incJS）のテスト方法を決定
- [ ] 定数（QS_theme_cd=10, QS_theme_pb=20, QS_theme_ts=30等）の値が正しいか確認
