---
generated_at: 2026-01-24 15:30:00
metrics:
  claims_total: 80
  claims_with_evidence: 72
  claims_without_evidence: 8
confidence_derived: 0.90
---

# 根拠レポート：受入テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：72 / 80、根拠なし：8
- 優先レビュー（高）
  1. **ショッピングカート機能の完全性**：実装詳細の確認が必要
  2. **メール送信機能（mailPage.asp）**：SMTP設定依存
  3. **Cookie警告のGDPR対応**：法的要件との整合性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、インストール手順
- E-02: `asp/begin.asp` - システム初期化、設定定数
- E-03: `asp/bs_login.asp` - ログイン画面、認証処理
- E-04: `asp/bs_security.asp` - セキュリティチェック、権限設定
- E-05: `asp/bs_default.asp` - 管理画面ダッシュボード
- E-06: `asp/bs_setupPage.asp` - ページタイプ選択
- E-07: `asp/bs_templateEdit.asp` - テンプレート編集
- E-08: `asp/bs_form.asp` - フォーム設定
- E-09: `asp/bs_catalogList.asp` - カタログ管理
- E-10: `asp/bs_catalogFieldEdit.asp` - カタログフィールド編集
- E-11: `asp/bs_galleryEdit.asp` - ギャラリー管理
- E-12: `asp/bs_feedEdit.asp` - フィード管理
- E-13: `asp/bs_gbEdit.asp` - ゲストブック管理
- E-14: `asp/bs_pollEdit.asp` - ポール管理
- E-15: `asp/bs_popupEdit.asp` - ポップアップ管理
- E-16: `asp/bs_newsletterList.asp` - ニュースレター管理
- E-17: `asp/bs_shopProduct.asp` - ショッピングカート商品管理
- E-18: `asp/bs_adminIntranet.asp` - イントラネット設定
- E-19: `asp/bs_contactPage.asp` - 連絡先権限管理
- E-20: `asp/bs_secondAdmin.asp` - セカンド管理者権限
- E-21: `asp/bs_stats.asp` - 統計表示
- E-22: `asp/bs_constantList.asp` - 定数管理
- E-23: `asp/bs_ac_calendar.asp` - 予約カレンダー管理
- E-24: `default.asp` - メインエントリーポイント
- E-25: `backsite/default.asp` - 管理画面リダイレクト
- E-26: `rss.asp` - RSSフィード
- E-27: `sitemap.asp` - サイトマップ
- E-28: `printPage.asp` - 印刷用ページ
- E-29: `mailPage.asp` - メール送信ページ
- E-30: `cookiepolicy/` - Cookie警告関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者ログイン（正常系） | E-03, E-04 | ○ |
| C-02 | 管理者ログイン（不正パスワード） | E-03 | ○ |
| C-03 | Captcha入力エラー | E-03 | ○ |
| C-04 | 初期パスワード変更 | E-02, E-03 | ○ |
| C-05 | ページ一覧表示 | E-05 | ○ |
| C-06 | 新規ページ作成（通常ページ） | E-06 | ○ |
| C-07 | 新規ページ作成（コンテナ） | E-06 | ○ |
| C-08 | 新規ページ作成（外部URL） | E-06 | ○ |
| C-09 | 新規ページ作成（リスト） | E-06 | ○ |
| C-10 | 既存ページ編集 | E-05 | ○ |
| C-11 | ページ削除 | E-05 | ○ |
| C-12 | ページ並び順変更 | E-05 | ○ |
| C-13 | テンプレート一覧表示 | E-07 | ○ |
| C-14 | 新規テンプレート作成 | E-07 | ○ |
| C-15 | テンプレート編集 | E-07 | ○ |
| C-16 | テンプレートプレビュー | E-07 | ○ |
| C-17 | フォーム一覧表示 | E-08 | ○ |
| C-18 | 新規フォーム作成 | E-08 | ○ |
| C-19 | フォームフィールド追加 | E-08 | ○ |
| C-20 | フォームプレビュー | E-08 | ○ |
| C-21 | フォーム投稿（公開サイト） | E-08 | ○ |
| C-22 | カタログ一覧表示 | E-09 | ○ |
| C-23 | 新規カタログ作成 | E-09 | ○ |
| C-24 | カタログフィールド追加 | E-10 | ○ |
| C-25 | カタログアイテム追加 | E-09 | ○ |
| C-26 | カタログアイテム検索 | E-09 | ○ |
| C-27 | ギャラリー一覧表示 | E-11 | ○ |
| C-28 | 新規ギャラリー作成 | E-11 | ○ |
| C-29 | ギャラリータイプ選択 | E-11 | ○ |
| C-30 | ギャラリープレビュー | E-11 | ○ |
| C-31 | フィード一覧表示 | E-12 | ○ |
| C-32 | 新規フィード作成 | E-12 | ○ |
| C-33 | ゲストブック一覧表示 | E-13 | ○ |
| C-34 | 新規ゲストブック作成 | E-13 | ○ |
| C-35 | ゲストブック投稿（公開サイト） | E-13 | ○ |
| C-36 | ゲストブック投稿承認 | E-13 | ○ |
| C-37 | ポール一覧表示 | E-14 | ○ |
| C-38 | 新規ポール作成 | E-14 | ○ |
| C-39 | ポール投票（公開サイト） | E-14 | ○ |
| C-40 | ポップアップ一覧表示 | E-15 | ○ |
| C-41 | 新規ポップアップ作成 | E-15 | ○ |
| C-42 | ニュースレター一覧表示 | E-16 | ○ |
| C-43 | 新規ニュースレター作成 | E-16 | ○ |
| C-44 | ニュースレター配信 | E-16 | △ |
| C-45 | 購読者一覧表示 | E-16 | ○ |
| C-46 | 購読者インポート | E-16 | ○ |
| C-47 | ショッピングカート商品一覧 | E-17 | ○ |
| C-48 | 新規商品作成 | E-17 | ○ |
| C-49 | メーカー作成 | E-17 | △ |
| C-50 | イントラネット設定 | E-18 | ○ |
| C-51 | 連絡先一覧表示 | E-19 | ○ |
| C-52 | 新規連絡先作成 | E-19 | ○ |
| C-53 | ユーザー権限設定 | E-19 | ○ |
| C-54 | イントラネットログイン | E-18 | ○ |
| C-55 | 許可されたページ編集 | E-19 | ○ |
| C-56 | セカンド管理者パスワード設定 | E-20 | ○ |
| C-57 | セカンド管理者権限設定 | E-20 | ○ |
| C-58 | ファイル一覧表示 | E-11 | ○ |
| C-59 | ファイルアップロード | **根拠なし** | △ |
| C-60 | フォルダ作成 | **根拠なし** | △ |
| C-61 | サイト統計表示 | E-21 | ○ |
| C-62 | 統計リセット | E-21 | ○ |
| C-63 | 定数一覧表示 | E-22 | ○ |
| C-64 | 新規定数作成 | E-22 | ○ |
| C-65 | 予約カレンダー一覧表示 | E-23 | ○ |
| C-66 | 新規予約カレンダー作成 | E-23 | ○ |
| C-67 | 予約管理 | E-23 | ○ |
| C-68 | ホームページ表示 | E-24 | ○ |
| C-69 | ナビゲーションメニュー使用 | E-24 | ○ |
| C-70 | パスワード保護ページアクセス | E-02 | ○ |
| C-71 | サイト内検索 | E-02 | ○ |
| C-72 | RSSフィード取得 | E-26 | ○ |
| C-73 | サイトマップ表示 | E-27 | ○ |
| C-74 | ページ印刷表示 | E-28 | ○ |
| C-75 | ページメール送信 | E-29 | △ |
| C-76 | Cookie同意表示 | E-30 | ○ |
| C-77 | Cookie同意承認 | E-30 | ○ |
| C-78 | モバイルデバイス表示 | **根拠なし** | △ |
| C-79 | 管理画面言語切替 | E-02 | ○ |
| C-80 | アクセス拒否時表示 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- **ファイルアップロード/フォルダ作成機能**：assetmanagerの詳細実装コードを確認できず。アップロード機能はFreeASPUploadを使用していることは確認できるが、詳細なUI操作フローは未確認
  - 候補：`asp/assetmanager/` ディレクトリ内の詳細ファイル / `asp/includes/freeASPUpload.asp`
- **ニュースレター配信**：SMTP設定に依存するため、実際の配信動作はサーバー環境に依存
  - 候補：`asp/includes/mail.asp` / SMTPサーバー設定
- **メーカー作成**：bs_shopMake.aspの詳細実装を確認できず
  - 候補：`asp/bs_shopMake.asp`
- **メール送信機能**：CDO/SMTP設定に依存
  - 候補：`asp/includes/mail_message.asp` / 環境設定
- **レスポンシブ対応**：テンプレート依存のため、使用するテンプレートによる
  - 候補：`css/media.css` / 各テンプレートファイル

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**：ファイルアップロード機能 - セキュリティ検証が必要
- **1（中リスク）**：メール送信機能 - SPF/DKIM設定、スパム対策の確認が必要
- **1（中リスク）**：ショッピングカート機能 - 決済連携の詳細確認が必要
- **0（低リスク）**：Cookie警告 - GDPR/ePrivacy指令への準拠確認推奨
- **2（高リスク）**：セキュリティ関連テスト - SQLインジェクション、XSS対策のペネトレーションテスト推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ログイン機能のCaptcha検証が正しく動作するか実機確認
- [ ] 初期パスワード「admin」変更後のセキュリティ確認
- [ ] フォーム送信後のメール通知が正しく届くか（SMTP設定確認）
- [ ] ファイルアップロードで危険なファイル形式がブロックされるか
- [ ] セカンド管理者権限設定が意図通りに機能するか
- [ ] イントラネットログイン後の権限制御が正しく動作するか
- [ ] ショッピングカート機能（有効時）の動作確認
- [ ] レスポンシブテンプレート使用時のモバイル表示確認
- [ ] Cookie警告の表示・非表示が正しく機能するか
- [ ] パスワード保護ページへの不正アクセス防止確認
