---
generated_at: 2026-01-23 21:47:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_formExcel.asp` - フォーム送信Excelエクスポート機能の実装ファイル
- E-02: `asp/bs_gbExcel.asp` - ゲストブックExcelエクスポート機能の実装ファイル
- E-03: `asp/bs_contactHome.asp` - 連絡先管理画面（Excelエクスポートボタンを含む）
- E-04: `asp/includes/contactSearch.asp` - 連絡先検索・Excelエクスポートのクラス実装
- E-05: `asp/bs_catalogItemSearch.asp` - カタログアイテム検索画面（Excelエクスポートボタンを含む）
- E-06: `asp/includes/ItemSearch.asp` - カタログアイテム検索・Excelエクスポートのクラス実装
- E-07: `asp/includes/excelFile.asp` - cls_excelFileクラスの実装（Excelエクスポート共通機能）
- E-08: `printPage.asp` - 印刷用ページ出力機能
- E-09: `rss.asp` - RSSフィード出力機能
- E-10: `asp/includes/rss_writer.asp` - kwRSS_writerクラスの実装
- E-11: `sitemap.asp` - XMLサイトマップ出力機能
- E-12: `mailPage.asp` - メールページ送信機能

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォーム送信Excelエクスポート：フォーム送信データをExcel形式でエクスポートする | E-01, E-07 | ○ |
| C-02 | ゲストブックExcelエクスポート：ゲストブックのエントリをExcel形式でエクスポートする | E-02, E-07 | ○ |
| C-03 | 連絡先Excelエクスポート：連絡先検索結果をExcel形式でエクスポートする | E-03, E-04, E-07 | ○ |
| C-04 | カタログアイテムExcelエクスポート：カタログアイテム検索結果をExcel形式でエクスポートする | E-05, E-06, E-07 | ○ |
| C-05 | 印刷用ページ：ページコンテンツを印刷用に整形して出力する | E-08 | ○ |
| C-06 | RSSフィード：ページ更新情報やリストアイテムをRSS形式で出力する | E-09, E-10 | ○ |
| C-07 | XMLサイトマップ：サイト全体のURL一覧をXML形式で出力する | E-11 | ○ |
| C-08 | メールページ送信：ページコンテンツをHTML形式のメールとして送信する | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべての主張に対してソースコードによる根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべての帳票はソースコードで確認済み。

### 補足
- cls_excelFileクラスはHTMLテーブルをExcel形式（.xls）のファイルとして出力する共通クラス
- Excelエクスポートは管理画面（バックオフィス）からの操作であり、セキュリティチェック（logon.hasaccess）が適用されている
- RSSフィードとXMLサイトマップはパブリックアクセス可能な出力

## 6) レビュアーチェックリスト（最小）
- [ ] 各Excelエクスポート機能でセキュリティチェック（認証・権限）が適切に実装されているか確認
- [ ] cls_excelFileクラスの出力形式が要件を満たしているか確認
- [ ] RSSフィード・サイトマップで機密情報が漏洩しないことを確認
- [ ] メールページ送信機能でスパム対策（CAPTCHA）が機能しているか確認
