# 帳票設計書 1-フォーム送信Excelエクスポート

## 概要

本ドキュメントは、QuickerSiteのフォーム送信データをExcel形式でエクスポートする帳票機能について記述する。管理者がフォームに投稿されたすべてのデータを一括でExcelファイルとしてダウンロードできる機能である。

### 本帳票の処理概要

本帳票は、Webサイトのフォームに送信されたユーザーデータを管理者が分析・活用するために、Excel形式で一括エクスポートする機能を提供する。

**業務上の目的・背景**：Webサイトに設置されたお問い合わせフォームやアンケートフォームに投稿されたデータは、マーケティング分析、顧客対応、業務改善などに活用される重要な情報資産である。これらのデータをExcel形式でエクスポートすることで、データの二次利用、集計分析、外部システムへの連携が容易になる。

**帳票の利用シーン**：サイト管理者がフォーム送信データを定期的にバックアップする場合、マーケティング担当者がアンケート結果を集計・分析する場合、カスタマーサポート担当者が問い合わせ履歴を確認する場合、データをCSVやExcelで外部システムにインポートする場合などに利用される。

**主要な出力内容**：
1. 送信ID（一意の識別子）
2. 送信日時（タイムスタンプ形式）
3. カタログ名（関連カタログがある場合）
4. アイテム名（関連アイテムがある場合）
5. 各フォームフィールドの入力値（テキスト、チェックボックス、ファイルURLなど）

**帳票の出力タイミング**：管理画面のフォーム管理セクションで「Excelエクスポート」ボタンをクリックした際に即座に出力される。

**帳票の利用者**：サイト管理者、マーケティング担当者、カスタマーサポート担当者

## 帳票種別

一覧表（データエクスポート形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | フォーム管理画面 | asp/bs_formExcel.asp | 「Excelエクスポート」ボタンクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel（.xls形式のHTML） |
| 用紙サイズ | 指定なし（データ量に応じて可変） |
| 向き | 横（フィールド数に依存） |
| ファイル名 | IEExport_{ランダム文字列}.xls |
| 出力方法 | ブラウザリダイレクトによるダウンロード |
| 文字コード | ISO-8859-1（設定による） |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | デフォルト（指定なし） |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

HTMLテーブル形式でExcelファイルを生成する。ヘッダー行にフィールド名、データ行に各送信データが配置される。

```
┌─────────────────────────────────────────────────────────────┐
│  ID  │ 日時&時間 │ カタログ │ アイテム │ フィールド1 │ ...  │
├─────────────────────────────────────────────────────────────┤
│  1   │ 2024/01/01│  商品A   │  商品1   │   値1      │ ...  │
│  2   │ 2024/01/02│  商品B   │  商品2   │   値2      │ ...  │
│ ...  │    ...    │   ...    │   ...    │   ...      │ ...  │
└─────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ID | 送信ID | tblFormSubmission.iId | 整数 |
| 2 | date & hour | 送信日時 | tblFormSubmission.dCreatedTS | formatTimeStamp形式 |
| 3 | catalog | カタログ名（条件付き） | tblCatalog.sName | テキスト |
| 4 | item | アイテム名（条件付き） | tblCatalogItem.sTitle | テキスト |
| 5+ | {フィールド名} | フォームフィールド名 | tblFormField.sName | テキスト |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ID | 送信ID | submissions key | 整数 | 自動 |
| 2 | 日時 | 送信タイムスタンプ | submission.dCreatedTS | 日時 | 自動 |
| 3 | カタログ | カタログ名 | submission.item.catalog.sName | テキスト | 自動 |
| 4 | アイテム | アイテムタイトル | submission.item.sTitle | テキスト | 自動 |
| 5+ | フィールド値 | 各フィールドの入力値 | values(cField) | フィールド型依存 | 自動 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| フォームID | エクスポート対象のフォームID | Yes |
| 管理者権限 | フォームエクスポート権限（bFormExport） | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 送信日時（dCreatedTS） | 降順（コード上は明示されていないが、submissionsの取得順に依存） |

### 改ページ条件

改ページなし（全データを1シートに出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| tblForm | フォーム定義情報 | iId = リクエストのiFormID |
| tblFormField | フォームフィールド定義 | iFormID = tblForm.iId |
| tblFormSubmission | フォーム送信データ | iFormID = tblForm.iId |
| tblFormFieldValue | フィールド値 | iSubmissionId = tblFormSubmission.iId |
| tblCatalogItem | カタログアイテム | iId = tblFormSubmission.iItemID |
| tblCatalog | カタログ | iId = tblCatalogItem.iCatalogID |

### テーブル別参照項目詳細

#### tblFormSubmission

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| iId | ID列 | iFormID指定 | 送信識別子 |
| dCreatedTS | 日時列 | - | formatTimeStamp関数で整形 |
| iItemID | カタログアイテム参照 | - | NULL可能 |

#### tblFormFieldValue

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| sValue | 各フィールド値 | iSubmissionId, iFormFieldId | フィールドタイプにより表示形式変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| チェックボックス値 | convertCheckedYesNo(値) | - | 「Yes」または「No」に変換 |
| ファイルURL | customer.sVDUrl & application("QS_CMS_userfiles") & 値 | - | ファイルフィールドの場合のみ |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[出力要求] --> B[権限チェック]
    B --> C{権限あり?}
    C -->|No| D[アクセス拒否]
    C -->|Yes| E[フォーム情報取得]
    E --> F[フィールド定義取得]
    F --> G[送信データ取得]
    G --> H[カタログ連携チェック]
    H --> I[HTMLテーブル生成]
    I --> J[cls_excelfile.export]
    J --> K[Excelファイル保存]
    K --> L[ブラウザリダイレクト]
    L --> M[ダウンロード完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| アクセス拒否 | bFormExport権限なし | （リダイレクト） | 管理者に権限付与を依頼 |
| データなし | フォームに送信データがない | （空のテーブル） | データ投稿後に再実行 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 〜10,000件 |
| 目標出力時間 | 10秒以内 |
| 同時出力数上限 | 1（旧ファイル自動削除のため） |

## セキュリティ考慮事項

- 管理者権限（secondAdmin.bFormExport）によるアクセス制御を実施
- フォームデータにはsanitize関数を適用してXSS対策を実施
- ファイル出力時にランダムパスワードを使用してファイル名を予測不能に
- 旧エクスポートファイルは新規エクスポート時に自動削除

## 備考

- Excel形式はHTML形式のXLSファイルとして生成されるため、Excel以外の表計算ソフトでも開ける
- コメントタイプ（sb_ff_comment）のフィールドはエクスポート対象外
- ファイル/画像フィールドはURLリンクとして出力される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、フォーム関連のデータ構造とクラス定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | form.asp | `asp/includes/form.asp` | cls_formクラスの構造、fields/submissionsプロパティの定義を確認 |
| 1-2 | excelFile.asp | `asp/includes/excelFile.asp` | cls_excelFileクラスのexport/redirectLink関数を確認 |

**読解のコツ**: ASP/VBScriptのクラス定義は`Class`〜`End Class`で囲まれる。Publicプロパティがデータ構造を示す。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_formExcel.asp | `asp/bs_formExcel.asp` | エクスポート処理全体の流れを把握 |

**主要処理フロー**:
1. **行4**: セキュリティチェック（logon.hasaccess secondAdmin.bFormExport）
2. **行6-8**: フォーム、フィールド、送信データの取得
3. **行9-14**: カタログ連携の判定
4. **行16-26**: ヘッダー行の生成
5. **行28-61**: データ行の生成（ループ処理）
6. **行63-66**: Excelファイル出力とリダイレクト

#### Step 3: Excelファイル生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | excelFile.asp | `asp/includes/excelFile.asp` | cls_excelFileクラスの実装詳細 |

**主要処理フロー**:
- **行14-29**: export関数 - HTMLテーブルをXLSファイルとして保存
- **行30-35**: downloadLinkプロパティ - ダウンロードリンクの生成
- **行36-38**: redirectLink関数 - ブラウザリダイレクト
- **行39-53**: deleteOthers関数 - 旧ファイルの削除

### プログラム呼び出し階層図

```
bs_formExcel.asp
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess()
    │
    ├─ cls_form（フォームクラス）
    │      ├─ fields（フィールド取得）
    │      │      └─ cls_formField
    │      └─ submissions（送信データ取得）
    │             └─ cls_submission
    │                    └─ values()
    │                    └─ item（カタログアイテム参照）
    │
    └─ cls_excelFile
           ├─ export()
           ├─ redirectLink()
           └─ deleteOthers()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リクエスト            bs_formExcel.asp               Excelファイル
(iFormID) ───────▶  HTMLテーブル生成 ───────▶     (.xls)
                          │                            │
tblForm ─────────▶       │                            │
tblFormField ────▶  cls_excelFile.export ───▶  ブラウザダウンロード
tblFormSubmission ▶       │
tblFormFieldValue ▶       ▼
tblCatalogItem ──▶  ファイルシステム保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_formExcel.asp | `asp/bs_formExcel.asp` | ソース | エントリーポイント、メイン処理 |
| form.asp | `asp/includes/form.asp` | ソース | フォームクラス定義（cls_form） |
| excelFile.asp | `asp/includes/excelFile.asp` | ソース | Excelファイル生成クラス（cls_excelFile） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・権限チェック |
