# 帳票設計書 2-ゲストブックExcelエクスポート

## 概要

本ドキュメントは、QuickerSiteのゲストブック（掲示板）に投稿されたエントリをExcel形式でエクスポートする帳票機能について記述する。管理者がゲストブックのすべての投稿データを一括でExcelファイルとしてダウンロードできる機能である。

### 本帳票の処理概要

本帳票は、Webサイトのゲストブック機能に投稿された訪問者のコメントやメッセージを、管理者が分析・バックアップするためにExcel形式で一括エクスポートする機能を提供する。

**業務上の目的・背景**：ゲストブックはWebサイト訪問者からのフィードバック、感想、質問などを収集する重要な機能である。これらの投稿データをExcel形式でエクスポートすることで、ユーザーフィードバックの分析、コンテンツ改善の検討、投稿内容の長期保存やバックアップが可能になる。

**帳票の利用シーン**：サイト管理者がゲストブックの投稿を定期的にバックアップする場合、マーケティング担当者がユーザーフィードバックを分析する場合、カスタマーサポート担当者が顧客の声を確認・共有する場合、データをアーカイブとして保存する場合などに利用される。

**主要な出力内容**：
1. 投稿ID（一意の識別子）
2. ゲストブックID（所属するゲストブックの識別子）
3. 投稿者情報
4. 投稿内容
5. 投稿日時
6. その他のメタデータ

**帳票の出力タイミング**：管理画面のゲストブック管理セクションで「Excelエクスポート」リンクをクリックした際に即座に出力される。

**帳票の利用者**：サイト管理者、マーケティング担当者

## 帳票種別

一覧表（データエクスポート形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ゲストブック管理画面 | asp/bs_gbExcel.asp | 「Excelエクスポート」リンククリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel（.xls形式のHTML） |
| 用紙サイズ | 指定なし（データ量に応じて可変） |
| 向き | 横 |
| ファイル名 | IEExport_{ランダム文字列}.xls |
| 出力方法 | ブラウザリダイレクトによるダウンロード |
| 文字コード | ISO-8859-1（設定による） |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | デフォルト（指定なし） |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

HTMLテーブル形式でExcelファイルを生成する。tblGuestBookItemテーブルの全カラムがそのまま出力される。

```
┌────────────────────────────────────────────────────────────┐
│ カラム0 │ カラム1 │ カラム2 │ カラム3 │ カラム4 │ カラム5 │
├────────────────────────────────────────────────────────────┤
│  値0    │  値1    │  値2    │  値3    │  値4    │  値5    │
│  ...    │  ...    │  ...    │  ...    │  ...    │  ...    │
└────────────────────────────────────────────────────────────┘
```

### ヘッダー部

ヘッダー行は出力されない。データベースのカラム値がそのまま行として出力される。

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | rs(0) | 第1カラム（iId等） | tblGuestBookItem | そのまま | 自動 |
| 2 | rs(1) | 第2カラム | tblGuestBookItem | そのまま | 自動 |
| 3 | rs(2) | 第3カラム | tblGuestBookItem | そのまま | 自動 |
| 4 | rs(3) | 第4カラム | tblGuestBookItem | そのまま | 自動 |
| 5 | rs(4) | 第5カラム | tblGuestBookItem | そのまま | 自動 |
| 6 | rs(5) | 第6カラム | tblGuestBookItem | そのまま | 自動 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ゲストブックID | エクスポート対象のゲストブックID（iGBID） | Yes |
| 管理者権限 | 管理画面アクセス権限 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | iId | 昇順 |

### 改ページ条件

改ページなし（全データを1シートに出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| tblGuestBookItem | ゲストブック投稿データ | iGuestbookID = リクエストのiGBID |

### テーブル別参照項目詳細

#### tblGuestBookItem

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| * (全カラム) | 各列に対応 | iGuestbookID指定 | SELECT * で取得 |

## 計算仕様

### 計算項目一覧

計算処理は存在しない。データベースの値をそのまま出力する。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[出力要求] --> B[権限チェック]
    B --> C{権限あり?}
    C -->|No| D[アクセス拒否]
    C -->|Yes| E[ゲストブックID復号]
    E --> F[SQLクエリ実行]
    F --> G[レコードセットループ]
    G --> H[HTMLテーブル生成]
    H --> I[cls_excelfile.export]
    I --> J[Excelファイル保存]
    J --> K[ブラウザリダイレクト]
    K --> L[ダウンロード完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| アクセス拒否 | 管理者権限なし | （リダイレクト） | 管理者に権限付与を依頼 |
| データなし | ゲストブックに投稿がない | （空のテーブル） | データ投稿後に再実行 |
| 不正なID | iGBIDが無効 | （空の結果） | 正しいゲストブックを選択 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 〜5,000件 |
| 目標出力時間 | 5秒以内 |
| 同時出力数上限 | 1（旧ファイル自動削除のため） |

## セキュリティ考慮事項

- 管理画面セキュリティ（bs_security.asp）によるアクセス制御を実施
- ゲストブックIDは暗号化（encrypt/decrypt）されて受け渡し
- ファイル出力時にランダムパスワードを使用してファイル名を予測不能に
- 旧エクスポートファイルは新規エクスポート時に自動削除

## 備考

- Excel形式はHTML形式のXLSファイルとして生成されるため、Excel以外の表計算ソフトでも開ける
- ヘッダー行がないため、カラムの意味を理解するにはデータベース構造の知識が必要
- データサニタイズ処理がないため、出力時の文字化けや特殊文字に注意が必要

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ゲストブック関連のデータベース構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | excelFile.asp | `asp/includes/excelFile.asp` | cls_excelFileクラスのexport/redirectLink関数を確認 |

**読解のコツ**: このエクスポート処理は非常にシンプルで、データベースから直接SELECT *で取得した結果をそのままExcelに出力している。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_gbExcel.asp | `asp/bs_gbExcel.asp` | エクスポート処理全体の流れを把握 |

**主要処理フロー**:
1. **行1**: begin.aspのインクルード（初期化処理）
2. **行4**: bs_security.aspのインクルード（セキュリティチェック）
3. **行5**: SQLクエリ実行（SELECT * FROM tblGuestBookItem）
4. **行7-19**: HTMLテーブル生成（whileループ）
5. **行21-25**: Excelファイル出力とリダイレクト

#### Step 3: Excelファイル生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | excelFile.asp | `asp/includes/excelFile.asp` | cls_excelFileクラスの実装詳細 |

**主要処理フロー**:
- **行14-29**: export関数 - HTMLテーブルをXLSファイルとして保存
- **行36-38**: redirectLink関数 - ブラウザリダイレクト

### プログラム呼び出し階層図

```
bs_gbExcel.asp
    │
    ├─ begin.asp（初期化処理）
    │      └─ データベース接続（db）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │
    ├─ db.execute()
    │      └─ SELECT * FROM tblGuestBookItem
    │
    └─ cls_excelFile
           ├─ export()
           ├─ redirectLink()
           └─ deleteOthers()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リクエスト            bs_gbExcel.asp               Excelファイル
(iGBID暗号化) ────▶  decrypt(iGBID) ─────▶         (.xls)
                          │                            │
                          ▼                            │
tblGuestBookItem ─▶  SQLクエリ実行 ────▶       ブラウザダウンロード
                          │
                          ▼
                   cls_excelFile.export
                          │
                          ▼
                   ファイルシステム保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_gbExcel.asp | `asp/bs_gbExcel.asp` | ソース | エントリーポイント、メイン処理 |
| excelFile.asp | `asp/includes/excelFile.asp` | ソース | Excelファイル生成クラス（cls_excelFile） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・権限チェック |
