# 帳票設計書 3-連絡先Excelエクスポート

## 概要

本ドキュメントは、QuickerSiteの連絡先（コンタクト）管理機能における検索結果をExcel形式でエクスポートする帳票機能について記述する。管理者が連絡先の検索結果を一括でExcelファイルとしてダウンロードできる機能である。

### 本帳票の処理概要

本帳票は、Webサイトのイントラネット機能で管理されている連絡先（ユーザー）データの検索結果を、管理者が分析・活用するためにExcel形式で一括エクスポートする機能を提供する。

**業務上の目的・背景**：イントラネット機能を持つWebサイトでは、登録ユーザー（連絡先）の管理が重要な業務となる。これらの連絡先データをExcel形式でエクスポートすることで、ユーザー分析、メールマガジン送信リストの作成、外部システムへの連携、バックアップなどが可能になる。

**帳票の利用シーン**：サイト管理者が登録ユーザーの一覧を取得する場合、マーケティング担当者がメール配信リストを作成する場合、特定条件でフィルタリングしたユーザーデータをエクスポートする場合、ユーザー情報のバックアップを取得する場合などに利用される。

**主要な出力内容**：
1. カスタムフィールド値（設定されたフィールド）
2. メールアドレス
3. ニックネーム
4. メンバーステータス（権限レベル）
5. 最終ログイン日時
6. ユーザーID

**帳票の出力タイミング**：管理画面の連絡先管理セクションで検索条件を入力し、「Excel」ボタンをクリックした際に即座に出力される。

**帳票の利用者**：サイト管理者、マーケティング担当者、カスタマーサポート担当者

## 帳票種別

一覧表（データエクスポート形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | 連絡先ホーム画面 | asp/bs_contactHome.asp | 検索条件入力後「Excel」ボタンクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel（.xls形式のHTML） |
| 用紙サイズ | 指定なし（データ量に応じて可変） |
| 向き | 横（フィールド数に依存） |
| ファイル名 | IEExport_{ランダム文字列}.xls |
| 出力方法 | ダウンロードリンクを画面に表示 |
| 文字コード | ISO-8859-1（設定による） |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | デフォルト（指定なし） |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

HTMLテーブル形式でExcelファイルを生成する。ヘッダー行にフィールド名、データ行に各連絡先データが配置される。

```
┌──────────────────────────────────────────────────────────────────────┐
│ フィールド1 │ フィールド2 │ ... │ iId │ ニックネーム │ E-mail │ last login │
├──────────────────────────────────────────────────────────────────────┤
│    値1     │    値2     │ ... │  1  │    山田    │ a@b.com │ 2024/01/01 │
│    ...     │    ...     │ ... │ ... │    ...     │   ...   │    ...     │
└──────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1〜N | カスタムフィールド名 | 設定されたフィールド名 | tblContactField.sFieldname | テキスト |
| N+1 | iId | ユーザーID | tblContact.iId | 整数 |
| N+2 | nickname | ニックネーム | tblContact.sNickname | テキスト |
| N+3 | E-mail | メールアドレス | tblContact.sEmail | テキスト |
| N+4 | last login | 最終ログイン日時 | tblContact.dLastLoginTS | 日時 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1〜N | フィールド値 | カスタムフィールドの値 | tblContactValues.sValue | フィールド型依存 | 自動 |
| N+1 | iId | ユーザーID | tblContact.iId | 整数 | 自動 |
| N+2 | ニックネーム | ユーザーニックネーム | tblContact.sNickname | テキスト | 自動 |
| N+3 | E-mail | メールアドレス | tblContact.sEmail | テキスト | 自動 |
| N+4 | last login | 最終ログイン日時 | tblContact.dLastLoginTS | 日時 | 自動 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| イントラネット連絡先権限 | bIntranetContacts権限 | Yes |
| フィールド値 | 各カスタムフィールドでの検索条件 | No |
| メールアドレス | 部分一致検索 | No |
| ニックネーム | 部分一致検索 | No |
| メンバーロール | ステータスによるフィルタリング | No |
| 日付範囲 | 日付フィールドの範囲指定 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | iContactID | 降順 |
| 2 | iRang（フィールド表示順） | 昇順 |

### 改ページ条件

改ページなし（全データを1シートに出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| tblContact | 連絡先基本情報 | iCustomerID = 現在の顧客ID |
| tblContactField | カスタムフィールド定義 | iCustomerID = 現在の顧客ID |
| tblContactValues | フィールド値 | iContactID = tblContact.iId AND iFieldID = tblContactField.iId |

### テーブル別参照項目詳細

#### tblContact

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| iId | iId列 | 検索条件による | 連絡先識別子 |
| sEmail | E-mail列 | - | メールアドレス |
| sNickname | nickname列 | - | ニックネーム |
| iStatus | ステータスフィルタ | - | メンバー権限レベル |
| dLastLoginTS | last login列 | - | 最終ログイン日時 |
| sAvatar | （アバター表示用） | - | アバター画像名 |

#### tblContactValues

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| sValue | 各フィールド値 | iContactID, iFieldID | フィールドタイプにより表示形式変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| チェックボックス値 | convertCheckedYesNo(値) | - | 「Yes」または「No」に変換 |
| 日付値 | convertDateToPicker(値) | - | ピッカー形式に変換 |
| リッチテキスト | removeHTML(値) | - | HTMLタグを除去 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[出力要求] --> B[権限チェック]
    B --> C{権限あり?}
    C -->|No| D[アクセス拒否]
    C -->|Yes| E[検索条件取得]
    E --> F[cls_contactSearch.getRows]
    F --> G[resultTable生成]
    G --> H{mode判定}
    H -->|l("excel")| I[cls_excelfile.export]
    H -->|l("search")| J[画面表示用テーブル]
    I --> K[ダウンロードリンク表示]
    K --> L[ユーザーダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| アクセス拒否 | bIntranetContacts権限なし | （リダイレクト） | 管理者に権限付与を依頼 |
| データなし | 検索条件に一致するデータがない | 0件表示 | 検索条件を変更 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 〜10,000件 |
| 目標出力時間 | 10秒以内 |
| 同時出力数上限 | 1（旧ファイル自動削除のため） |
| ページサイズ | hasManyContactsの場合100件、それ以外は100,000件 |

## セキュリティ考慮事項

- 管理者権限（secondAdmin.bIntranetContacts）によるアクセス制御を実施
- 検索フィールドIDは暗号化（encrypt/decrypt）されて受け渡し
- sanitize関数によるXSS対策を実施
- ファイル出力時にランダムパスワードを使用してファイル名を予測不能に

## 備考

- Excel形式はHTML形式のXLSファイルとして生成されるため、Excel以外の表計算ソフトでも開ける
- フィールドタイプ（テキスト、日付、チェックボックス等）に応じて出力形式が変換される
- URLフィールドとEメールフィールドはリンク形式で出力される
- アバター列はExcelエクスポート時は出力されない（画面表示のみ）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、連絡先検索クラスとExcelファイル生成クラスの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | contactSearch.asp | `asp/includes/contactSearch.asp` | cls_contactSearchクラスの構造、resultTable関数の定義を確認 |
| 1-2 | excelFile.asp | `asp/includes/excelFile.asp` | cls_excelFileクラスのexport/downloadLink関数を確認 |

**読解のコツ**: ASP/VBScriptのクラス定義は`Class`〜`End Class`で囲まれる。resultTable関数内のmode分岐（l("excel")とl("search")）が重要。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_contactHome.asp | `asp/bs_contactHome.asp` | 検索画面の全体構造と処理フローを把握 |

**主要処理フロー**:
1. **行4**: セキュリティチェック（logon.hasaccess secondAdmin.bIntranetContacts）
2. **行9-14**: cls_contactSearchのインスタンス生成と検索条件設定
3. **行19-20**: resultTableの取得（検索結果またはExcelエクスポート）
4. **行26-27**: mode判定（l("search") or l("excel")）による出力分岐

#### Step 3: 検索・エクスポート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contactSearch.asp | `asp/includes/contactSearch.asp` | cls_contactSearchクラスの詳細実装 |

**主要処理フロー**:
- **行54-139**: getRows関数 - SQLクエリ生成と実行
- **行140-226**: resultTable関数 - HTMLテーブル生成とExcelエクスポート
- **行219-225**: Excel出力分岐（mode = l("excel")の場合）
- **行227-283**: addRow関数 - 行データの生成

### プログラム呼び出し階層図

```
bs_contactHome.asp
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess()
    │
    ├─ cls_contactSearch
    │      ├─ getRequestValues()（検索条件取得）
    │      ├─ getRows()（SQLクエリ実行）
    │      │      └─ db.execute()
    │      └─ resultTable()
    │             ├─ headerRow生成
    │             ├─ データ行生成（addRow）
    │             └─ mode分岐
    │                    ├─ l("search") → 画面表示
    │                    └─ l("excel") → cls_excelFile.export
    │
    └─ cls_excelFile
           ├─ export()
           └─ downloadLink
```

### データフロー図

```
[入力]                       [処理]                         [出力]

リクエスト              bs_contactHome.asp             Excelファイル
(検索条件) ──────────▶  cls_contactSearch ───────▶      (.xls)
                              │                            │
tblContact ─────────▶        │                            │
tblContactField ────▶  resultTable() ─────────▶   ダウンロードリンク表示
tblContactValues ───▶        │
                              ▼
                       cls_excelFile.export
                              │
                              ▼
                       ファイルシステム保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_contactHome.asp | `asp/bs_contactHome.asp` | ソース | エントリーポイント、画面制御 |
| contactSearch.asp | `asp/includes/contactSearch.asp` | ソース | 連絡先検索クラス（cls_contactSearch） |
| excelFile.asp | `asp/includes/excelFile.asp` | ソース | Excelファイル生成クラス（cls_excelFile） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・権限チェック |
