# 帳票設計書 4-カタログアイテムExcelエクスポート

## 概要

本ドキュメントは、QuickerSiteのカタログアイテム検索結果をExcel形式でエクスポートする帳票機能について記述する。管理者がカタログに登録されたアイテムの検索結果を一括でExcelファイルとしてダウンロードできる機能である。

### 本帳票の処理概要

本帳票は、Webサイトのカタログ機能で管理されている商品・サービス等のアイテムデータの検索結果を、管理者が分析・活用するためにExcel形式で一括エクスポートする機能を提供する。

**業務上の目的・背景**：ECサイトや商品カタログサイトでは、カタログアイテムの管理が重要な業務となる。これらのアイテムデータをExcel形式でエクスポートすることで、在庫管理、価格分析、商品マスタの更新作業、外部システムとの連携などが可能になる。

**帳票の利用シーン**：サイト管理者が商品一覧を取得する場合、マーケティング担当者が商品データを分析する場合、特定条件でフィルタリングした商品データをエクスポートする場合、商品マスタのバックアップを取得する場合などに利用される。

**主要な出力内容**：
1. アイテムタイトル
2. 検索フィールドの値（設定されたフィールド）
3. オンライン/オフラインステータス
4. 公開開始日・終了日
5. サムネイル画像（画面表示時のみ）

**帳票の出力タイミング**：管理画面のカタログアイテム検索セクションでカタログを選択し、検索条件を入力後「Excel」ボタンをクリックした際に即座に出力される。

**帳票の利用者**：サイト管理者、商品担当者、マーケティング担当者

## 帳票種別

一覧表（データエクスポート形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | カタログアイテム検索画面 | asp/bs_catalogItemSearch.asp | カタログ選択・検索条件入力後「Excel」ボタンクリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel（.xls形式のHTML） |
| 用紙サイズ | 指定なし（データ量に応じて可変） |
| 向き | 横（フィールド数に依存） |
| ファイル名 | IEExport_{ランダム文字列}.xls |
| 出力方法 | ダウンロードリンクを画面に表示 |
| 文字コード | ISO-8859-1（設定による） |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| シート名 | デフォルト（指定なし） |
| 保護設定 | 無 |

## 帳票レイアウト

### レイアウト概要

HTMLテーブル形式でExcelファイルを生成する。ヘッダー行にフィールド名、データ行に各アイテムデータが配置される。

```
┌────────────────────────────────────────────────────────────────┐
│  タイトル  │ フィールド1 │ フィールド2 │ ... │ 空白列 │ 空白列 │
├────────────────────────────────────────────────────────────────┤
│  商品A    │    値1     │    値2     │ ... │        │        │
│  商品B    │    値3     │    値4     │ ... │        │        │
│   ...     │    ...     │    ...     │ ... │        │        │
└────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | title | アイテムタイトル | tblCatalogItem.sTitle | テキスト |
| 2〜N | フィールド名 | 検索フィールド名 | tblCatalogField.sName | テキスト |
| N+1 | （空白） | 操作列のプレースホルダー | - | 空白 |
| N+2 | （空白） | 操作列のプレースホルダー | - | 空白 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | タイトル | アイテムタイトル | tblCatalogItem.sTitle | テキスト | 自動 |
| 2〜N | フィールド値 | 検索フィールドの値 | tbCatalogItemFields.sValue | フィールド型依存 | 自動 |
| N+1 | （空白） | Excel用プレースホルダー | - | 空白 | 自動 |
| N+2 | （空白） | Excel用プレースホルダー | - | 空白 | 自動 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| カタログID | エクスポート対象のカタログID | Yes |
| カタログ管理権限 | bCatalog権限 | Yes |
| タイトル | 部分一致検索 | No |
| フィールド値 | 各フィールドでの検索条件 | No |
| 日付範囲 | 日付フィールドの範囲指定 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | sOrderItemsBy（カタログ設定） | カタログ設定による |
| 2 | iItemID | 降順 |
| 3 | iRang（フィールド表示順） | 昇順 |

### 改ページ条件

改ページなし（全データを1シートに出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| tblCatalogItem | カタログアイテム基本情報 | iCatalogID = 選択されたカタログID |
| tblCatalogField | カタログフィールド定義 | iCatalogID = 選択されたカタログID |
| tbCatalogItemFields | フィールド値 | iItemID = tblCatalogItem.iId AND iFieldID = tblCatalogField.iId |
| tblCatalog | カタログ基本情報 | iId = 選択されたカタログID |

### テーブル別参照項目詳細

#### tblCatalogItem

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| iId | 内部参照 | iCatalogID指定 | アイテム識別子 |
| sTitle | タイトル列 | - | アイテム名 |
| dOnlineFrom | オンライン期間判定 | - | 公開開始日 |
| dOnlineUntill | オンライン期間判定 | - | 公開終了日 |
| sPicExt | （画面表示用） | - | サムネイル画像拡張子 |

#### tbCatalogItemFields

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| sValue | 各フィールド値 | iItemID, iFieldID | フィールドタイプにより表示形式変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| チェックボックス値 | convertCheckedYesNo(値) | - | 「Yes」または「No」に変換 |
| 日付値 | convertDateToPicker(値) | - | ピッカー形式に変換 |
| リッチテキスト | removeHTML(値) | - | HTMLタグを除去 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[出力要求] --> B[権限チェック]
    B --> C{権限あり?}
    C -->|No| D[アクセス拒否]
    C -->|Yes| E[カタログ選択確認]
    E --> F{カタログ選択済?}
    F -->|No| G[カタログ選択画面表示]
    F -->|Yes| H[検索条件取得]
    H --> I[cls_itemSearch.getRows]
    I --> J[resultTable生成]
    J --> K{mode判定}
    K -->|l("excel")| L[cls_excelFile.export]
    K -->|l("search")| M[画面表示用テーブル]
    L --> N[ダウンロードリンク表示]
    N --> O[ユーザーダウンロード]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| アクセス拒否 | bCatalog権限なし | （リダイレクト） | 管理者に権限付与を依頼 |
| カタログ未選択 | iCatalogIDが未指定 | カタログ選択画面 | カタログを選択 |
| データなし | 検索条件に一致するデータがない | 0件表示 | 検索条件を変更 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 〜10,000件 |
| 目標出力時間 | 10秒以内 |
| 同時出力数上限 | 1（旧ファイル自動削除のため） |
| デフォルトページサイズ | 9999件 |

## セキュリティ考慮事項

- 管理者権限（secondAdmin.bCatalog）によるアクセス制御を実施
- カタログIDは暗号化（encrypt/decrypt）されて受け渡し
- 検索フィールドIDも暗号化されて受け渡し
- ファイル出力時にランダムパスワードを使用してファイル名を予測不能に

## 備考

- Excel形式はHTML形式のXLSファイルとして生成されるため、Excel以外の表計算ソフトでも開ける
- フィールドタイプ（テキスト、日付、チェックボックス等）に応じて出力形式が変換される
- URLフィールドとEメールフィールドはリンク形式で出力される
- サムネイル画像列とステータス列はExcelエクスポート時は空白となる（画面表示のみ）
- "search"モードの検索フィールドのみがエクスポート対象

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、カタログアイテム検索クラスとExcelファイル生成クラスの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ItemSearch.asp | `asp/includes/ItemSearch.asp` | cls_itemSearchクラスの構造、resultTable関数の定義を確認 |
| 1-2 | excelFile.asp | `asp/includes/excelFile.asp` | cls_excelFileクラスのexport/downloadLink関数を確認 |

**読解のコツ**: cls_itemSearchクラスはcls_contactSearchと類似の構造。resultTable関数内のmode分岐（l("excel")とl("search")）が重要。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_catalogItemSearch.asp | `asp/bs_catalogItemSearch.asp` | 検索画面の全体構造と処理フローを把握 |

**主要処理フロー**:
1. **行4**: セキュリティチェック（logon.hasaccess secondAdmin.bCatalog）
2. **行5-15**: cls_itemSearchのインスタンス生成と検索条件設定
3. **行21-25**: カタログ選択とフィールド検索UI
4. **行29**: resultTableの呼び出し（検索結果またはExcelエクスポート）

#### Step 3: 検索・エクスポート処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ItemSearch.asp | `asp/includes/ItemSearch.asp` | cls_itemSearchクラスの詳細実装 |

**主要処理フロー**:
- **行42-113**: fixedSQL関数 - SQLクエリ生成
- **行114-134**: getRequestValues関数 - 検索条件取得
- **行135-153**: getRows関数 - SQLクエリ実行
- **行216-293**: resultTable関数 - HTMLテーブル生成とExcelエクスポート
- **行280-292**: Excel出力分岐（mode = l("excel")の場合）
- **行294-322**: addRow関数 - 行データの生成

### プログラム呼び出し階層図

```
bs_catalogItemSearch.asp
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ bs_security.asp（セキュリティチェック）
    │      └─ logon.hasaccess()
    │
    ├─ cls_itemSearch
    │      ├─ getRequestValues()（検索条件取得）
    │      ├─ fixedSQL()（SQL生成）
    │      ├─ getRows()（SQLクエリ実行）
    │      │      └─ db.execute()
    │      └─ resultTable()
    │             ├─ headerRow生成
    │             ├─ データ行生成（addRow）
    │             └─ mode分岐
    │                    ├─ l("search") → 画面表示
    │                    └─ l("excel") → cls_excelFile.export
    │
    └─ cls_excelFile
           ├─ export()
           └─ downloadLink
```

### データフロー図

```
[入力]                         [処理]                         [出力]

リクエスト                bs_catalogItemSearch.asp         Excelファイル
(iCatalogID, 検索条件) ─▶  cls_itemSearch ──────────▶      (.xls)
                                │                            │
tblCatalog ──────────▶         │                            │
tblCatalogItem ──────▶   resultTable() ──────────▶  ダウンロードリンク表示
tblCatalogField ─────▶         │
tbCatalogItemFields ─▶         ▼
                         cls_excelFile.export
                                │
                                ▼
                         ファイルシステム保存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_catalogItemSearch.asp | `asp/bs_catalogItemSearch.asp` | ソース | エントリーポイント、画面制御 |
| ItemSearch.asp | `asp/includes/ItemSearch.asp` | ソース | カタログアイテム検索クラス（cls_itemSearch） |
| excelFile.asp | `asp/includes/excelFile.asp` | ソース | Excelファイル生成クラス（cls_excelFile） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティ・権限チェック |
| bs_backCatalog.asp | `asp/bs_backCatalog.asp` | ソース | カタログ管理共通UI |
