# 帳票設計書 5-印刷用ページ

## 概要

本ドキュメントは、QuickerSiteのページコンテンツを印刷用に整形して出力するHTML帳票機能について記述する。ユーザーがWebページの内容を印刷可能なフォーマットで取得し、ページロード時に自動で印刷ダイアログを表示する機能である。

### 本帳票の処理概要

本帳票は、Webサイトの任意のページコンテンツを印刷に適した形式でHTMLとして出力し、ユーザーがコンテンツを紙媒体で保存・共有できるようにする機能を提供する。

**業務上の目的・背景**：Webサイトの情報を紙で保存・配布したいというニーズは、ビジネス文書、製品情報、記事コンテンツなど様々な場面で発生する。画面表示用のデザインをそのまま印刷すると、ナビゲーションや広告なども印刷されてしまう。印刷用ページ機能により、コンテンツのみを整形して印刷可能にすることで、ユーザビリティが向上する。

**帳票の利用シーン**：サイト訪問者が記事やニュースを印刷して保存する場合、製品情報やサービス説明を印刷して社内共有する場合、イベント情報やマニュアルを印刷物として配布する場合、契約条件やポリシー文書を印刷して確認する場合などに利用される。

**主要な出力内容**：
1. ページタイトル（太字表示）
2. ページ本文（コンテンツブロック置換済み）
3. 水平線（タイトルと本文の区切り）

**帳票の出力タイミング**：ユーザーがページの「印刷」リンクをクリックした際に、新しいウィンドウでページが開き、自動的に印刷ダイアログが表示される。

**帳票の利用者**：サイト訪問者（一般ユーザー）、サイト管理者

## 帳票種別

印刷出力（HTML形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | 印刷用ページ | printPage.asp?iId={暗号化ページID} | ページ上の印刷リンククリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML |
| 用紙サイズ | ブラウザ/プリンタ設定依存 |
| 向き | ブラウザ/プリンタ設定依存 |
| ファイル名 | - （直接印刷） |
| 出力方法 | ブラウザ印刷ダイアログ（window.print()） |
| 文字コード | QS_CHARSET（設定による） |

## 帳票レイアウト

### レイアウト概要

シンプルなHTML構造で、タイトルと本文のみを出力する。

```
┌─────────────────────────────────────┐
│         ページタイトル（太字）        │
├─────────────────────────────────────┤
│              水平線                  │
├─────────────────────────────────────┤
│                                     │
│            ページ本文                │
│          （コンテンツ）              │
│                                     │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ページタイトル | ページの表示タイトル | selectedPage.showTitle / pageTitle | 太字（<b>タグ） |
| 2 | 水平線 | タイトルと本文の区切り | - | <hr />タグ |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ページ本文 | コンテンツブロック置換済みの本文 | selectedPage.replaceBlocks(pageBody) | HTML | 100% |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ページID | 印刷対象のページID（iId） | Yes |
| アプリケーションでない | sApplicationが空であること | Yes（アプリページは印刷不可） |

### 改ページ条件

ブラウザ/プリンタの設定に依存

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| tblPage | ページ基本情報 | iId = リクエストのiId |

### テーブル別参照項目詳細

#### tblPage

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| sTitle | ページタイトル | iId指定 | showTitleプロパティ経由 |
| sValue | ページ本文 | iId指定 | pageBody経由、replaceBlocksで置換 |
| sApplication | アプリケーション判定 | iId指定 | 空でない場合は処理終了 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| タイトル置換 | treatConstants(selectedPage.replaceBlocks(pageTitle),true) | - | 定数とブロックを置換 |
| 本文置換 | treatConstants(selectedPage.replaceBlocks(pageBody),true) | - | 定数とブロックを置換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[印刷リンククリック] --> B[printPage.asp読み込み]
    B --> C[begin.asp初期化]
    C --> D[process.asp処理]
    D --> E{sApplication判定}
    E -->|空でない| F[Response.End]
    E -->|空| G[HTML生成]
    G --> H[タイトル出力]
    H --> I[本文出力]
    I --> J[window.print()実行]
    J --> K[印刷ダイアログ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| アプリケーションページ | sApplicationが空でない | （処理終了） | 通常ページから印刷を実行 |
| ページ不存在 | 指定IDのページがない | 空白ページ | 正しいページIDを指定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1ページ |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- ページIDは暗号化（encrypt/decrypt）されて受け渡し
- アプリケーションページは印刷対象外（sApplicationチェック）
- ページの公開状態やアクセス権限はprocess.aspで制御

## 備考

- 印刷スタイルシート（qs_{tdir}.css）が適用される
- JavaScript（sorttable.js）が読み込まれるが印刷には影響しない
- onloadイベントでwindow.focus()とwindow.print()が実行される
- printReplies変数がtrueに設定され、コメント/返信も印刷対象となる
- treatConstants関数により[QS_*]形式の定数が実際の値に置換される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ページクラスとコンテンツ処理の仕組みを理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | process.asp | `asp/process.asp` | pageTitle, pageBody変数の設定を確認 |

**読解のコツ**: printReplies変数がtrueの場合、コメント/返信も含めた完全なページ内容が取得される。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printPage.asp | `printPage.asp` | 印刷用ページの全体構造を把握 |

**主要処理フロー**:
1. **行1**: begin.aspインクルード、printReplies=true設定
2. **行1**: process.aspインクルード（ページデータ取得）
3. **行4**: selectedPage.showTitleでタイトル取得
4. **行8**: sApplicationチェック（空でなければ処理終了）
5. **行10**: onload="javascript: window.focus();window.print();" で自動印刷
6. **行11**: タイトルと本文の出力（treatConstants、replaceBlocks適用）

#### Step 3: コンテンツ置換処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process.asp | `asp/process.asp` | pageTitle、pageBody変数の生成ロジック |

**主要処理フロー**:
- replaceBlocks(): コンテンツブロックを実際の内容に置換
- treatConstants(): [QS_*]形式の定数を実際の値に置換

### プログラム呼び出し階層図

```
printPage.asp
    │
    ├─ begin.asp（初期化処理）
    │      └─ データベース接続、セッション設定
    │
    ├─ process.asp（ページ処理）
    │      ├─ selectedPage（cls_page）
    │      │      ├─ showTitle
    │      │      ├─ replaceBlocks()
    │      │      └─ sApplication
    │      ├─ pageTitle（変数）
    │      └─ pageBody（変数）
    │
    └─ treatConstants()
           └─ [QS_*]定数置換
```

### データフロー図

```
[入力]                    [処理]                         [出力]

リクエスト            printPage.asp                  HTML（印刷用）
(iId暗号化) ────▶  begin.asp ────────────────▶      <html>
                        │                              │
                        ▼                              ▼
                   process.asp               <title>ページタイトル</title>
                        │                              │
                        ▼                              ▼
tblPage ─────────▶  selectedPage            <body onload="window.print()">
                        │                       <b>タイトル</b>
                        ▼                       <hr />
                   replaceBlocks()              本文
                        │
                        ▼
                   treatConstants()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printPage.asp | `printPage.asp` | ソース | エントリーポイント、HTML出力 |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
| process.asp | `asp/process.asp` | ソース | ページデータ取得・処理 |
| qs_{tdir}.css | `css/qs_{tdir}.css` | スタイルシート | 印刷用スタイル |
| sorttable.js | `js/sorttable.js` | JavaScript | テーブルソート（印刷には不要） |
