# 帳票設計書 6-RSSフィード

## 概要

本ドキュメントは、QuickerSiteのページ更新情報やリストアイテムをRSS 2.0形式で出力するXML帳票機能について記述する。サイトの最新情報をRSSリーダーで購読可能な形式で提供する機能である。

### 本帳票の処理概要

本帳票は、Webサイトのページ更新情報、リストアイテム、フォーラム投稿、カタログアイテムなどの最新コンテンツをRSS 2.0形式のXMLとして出力し、ユーザーがRSSリーダーで更新情報を購読できるようにする機能を提供する。

**業務上の目的・背景**：RSSフィードは、Webサイトの更新情報を自動的に配信する標準的な技術である。ユーザーはRSSリーダーを使用することで、複数のサイトの更新情報を一元的に確認でき、サイト運営者にとっては定期的な訪問を促進する効果がある。また、外部サービスとの連携やコンテンツ配信にも活用される。

**帳票の利用シーン**：サイト訪問者がニュースや更新情報をRSSリーダーで購読する場合、外部サービス（Feedlyなど）でコンテンツを集約する場合、検索エンジンやアグリゲーターにコンテンツを配信する場合、自動化ツールでコンテンツ更新を監視する場合などに利用される。

**主要な出力内容**：
1. チャンネル情報（タイトル、URL、説明、言語）
2. 各アイテム情報（タイトル、リンク、説明、公開日、著者、GUID）
3. 画像情報（オプション）
4. エンクロージャ（添付画像、オプション）
5. コメントリンク（フォーラム投稿の場合）

**帳票の出力タイミング**：RSSフィードURLにアクセスした際にリアルタイムで生成される（ただしアプリケーションキャッシュを使用）。

**帳票の利用者**：サイト訪問者、RSSリーダーユーザー、外部サービス、検索エンジン

## 帳票種別

フィード出力（XML形式 / RSS 2.0）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | メインRSSフィード | rss.asp | 直接アクセス |
| - | ページ固有RSSフィード | rss.asp?iId={暗号化ページID} | RSSリンククリック |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | XML（RSS 2.0） |
| MIMEタイプ | application/xml |
| 文字コード | QS_CHARSET（設定による） |
| ファイル名 | - （直接出力） |
| 出力方法 | HTTPレスポンス |
| キャッシュ | アプリケーションレベルでキャッシュ |

## 帳票レイアウト

### レイアウト概要

RSS 2.0仕様に準拠したXML構造で出力する。

```xml
<?xml version="1.0" encoding="UTF-8"?>
<rss version="2.0">
  <channel>
    <title>チャンネルタイトル</title>
    <link>サイトURL</link>
    <description>説明</description>
    <language>言語コード</language>
    <item>
      <title>アイテムタイトル</title>
      <link>アイテムURL</link>
      <pubDate>公開日時</pubDate>
      <author>著者</author>
      <guid>一意識別子</guid>
      <description>説明</description>
    </item>
    ...
  </channel>
</rss>
```

### チャンネル部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | title | チャンネルタイトル | customer.siteName / selectedPage.sTitle | テキスト |
| 2 | link | サイトURL | customer.sUrl | URL |
| 3 | description | 説明 | customer.sDescription | テキスト |
| 4 | language | 言語コード | langCode | 言語コード |

### アイテム部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | title | アイテムタイトル | page.sTitle / listItem.sDateAndTitle | テキスト |
| 2 | link | アイテムURL | ページURL / ユーザーフレンドリーURL | URL |
| 3 | pubDate | 公開日時 | updatedTS | RFC822形式 |
| 4 | author | 著者 | customer.webmasteremail | メールアドレス |
| 5 | guid | 一意識別子 | ページURL | URL |
| 6 | description | 説明 | page.sValue / listItem.sValue | CDATA |
| 7 | enclosure | 添付画像（オプション） | sItemPicture | URL |
| 8 | comments | コメントリンク（オプション） | フォーラム投稿URL | URL |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ページID | フィード対象のページID（指定時） | No |
| bEnableMainRSS | メインRSSの有効/無効 | Yes（メインRSSの場合） |
| bPushRSS | ページ固有RSSの有効/無効 | Yes（ページRSSの場合） |
| イントラネット認証 | イントラネットページの場合は認証必要 | 条件付き |
| bOnline | オンラインステータス | Yes |
| bDeleted | 削除フラグ | No（falseのみ） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | updatedTS | 降順 |

### 改ページ条件

最大300件まで（メインRSSの場合）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| tblPage | ページ情報 | iCustomerID = 現在の顧客ID |
| tblCustomer | 顧客情報 | iId = 現在の顧客ID |
| tblPost | フォーラム投稿 | iThemeID = ページのテーマID |
| tblTheme | フォーラムテーマ | iId = ページのiThemeID |
| tblCatalogItem | カタログアイテム | iCatalogID = ページのカタログID |

### テーブル別参照項目詳細

#### tblPage

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| iId | GUID、リンク生成 | bOnline=true | ページ識別子 |
| sTitle | title | - | ページタイトル |
| sValue | description | - | ページ内容 |
| updatedTS | pubDate | - | 更新日時 |
| bOnline | 出力判定 | - | オンラインフラグ |
| bDeleted | 出力判定 | - | 削除フラグ |
| bContainerPage | 出力判定 | - | コンテナページフラグ |
| bLossePagina | 出力判定 | - | 独立ページフラグ |
| bIntranet | アクセス制御 | - | イントラネットフラグ |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| pubDate | Format_RFC822_DateAndTime(updatedTS) | - | RFC822形式に変換 |
| GUID | customer.sQSUrl & "/default.asp?iID=" & encrypt(pageId) | - | 一意URL生成 |
| description | prepareForExport(content) | - | エクスポート用に整形 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[RSSリクエスト] --> B{ページID指定?}
    B -->|No| C{メインRSS有効?}
    C -->|No| D[空応答]
    C -->|Yes| E{キャッシュあり?}
    E -->|Yes| F[キャッシュ出力]
    E -->|No| G[ページ一覧取得]
    G --> H[RSS XML生成]
    H --> I[キャッシュ保存]
    I --> F
    B -->|Yes| J{イントラネット認証?}
    J -->|要認証・未認証| K[No Access出力]
    J -->|認証OK/不要| L{キャッシュあり?}
    L -->|Yes| M[キャッシュ出力]
    L -->|No| N[コンテンツ取得]
    N --> O{リストアイテム?}
    O -->|Yes| P[リストアイテム処理]
    O -->|No| Q{フォーラム?}
    Q -->|Yes| R[フォーラム投稿処理]
    Q -->|No| S{カタログ?}
    S -->|Yes| T[カタログアイテム処理]
    P --> U[RSS XML生成]
    R --> U
    T --> U
    S -->|No| U
    U --> V[キャッシュ保存]
    V --> M
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| メインRSS無効 | bEnableMainRSS=false | （空応答） | 管理画面で有効化 |
| アクセス拒否 | イントラネットページ・未認証 | "No Access" | 認証後にアクセス |
| ページ不存在 | 指定IDのページがない | （空フィード） | 正しいページIDを指定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 最大300件（メインRSS） |
| 目標出力時間 | 2秒以内（キャッシュヒット時は即時） |
| 同時出力数上限 | 制限なし |
| キャッシュ | アプリケーションスコープでキャッシュ |

## セキュリティ考慮事項

- ページIDは暗号化（encrypt）されてURLに含まれる
- イントラネットページは認証チェックを実施
- パスワード保護ページはRSSフィードに含まれない
- 外部URLページはRSSフィードに含まれない
- 削除済みページ、非公開ページは除外
- CDATA使用によるXMLインジェクション対策

## 備考

- RSS 2.0形式で出力（kwRSS_writerクラスを使用）
- アプリケーションキャッシュによりパフォーマンスを最適化
- キャッシュキーは顧客ID + ページIDで構成
- ユーザーフレンドリーURL対応
- enclosure要素でリストアイテム画像を配信可能
- フォーラム投稿のcomments要素でコメントリンクを提供
- カタログアイテムも配信可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、RSS生成クラスの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | rss_writer.asp | `asp/includes/rss_writer.asp` | kwRSS_writerクラスとaspXMLクラスの構造を確認 |

**読解のコツ**: kwRSS_writerクラスはRSS 2.0仕様に準拠したXML生成を担当。SetTitle, SetLink, SetDesc等のメソッドでアイテム情報を設定する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rss.asp | `rss.asp` | RSSフィード生成の全体フローを把握 |

**主要処理フロー**:
1. **行4**: Content-Typeをapplication/xmlに設定
2. **行9-59**: メインRSSフィード処理（ページID未指定時）
3. **行61-231**: ページ固有RSSフィード処理
4. **行63-79**: イントラネット認証チェック
5. **行91-130**: リストアイテム処理（bPushRSS）
6. **行133-173**: フォーラム投稿処理（bPushRSS）
7. **行175-213**: カタログアイテム処理

#### Step 3: RSS生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rss_writer.asp | `asp/includes/rss_writer.asp` | kwRSS_writerクラスの詳細実装 |

**主要処理フロー**:
- **行34-68**: アイテム設定メソッド群
- **行70-157**: GetRSS関数 - XML生成
- **行182-289**: aspXMLクラス - XML構築ヘルパー

### プログラム呼び出し階層図

```
rss.asp
    │
    ├─ begin.asp（初期化処理）
    │
    ├─ rss_writer.asp
    │      └─ kwRSS_writer
    │             ├─ SetTitle(), SetLink(), SetDesc()
    │             ├─ SetPubDate(), SetAuthor(), SetGuid()
    │             ├─ SetEnclosure(), setComments()
    │             ├─ AddNew()
    │             └─ GetRSS()
    │                    └─ aspXML
    │
    ├─ メインRSS処理
    │      └─ db.execute("select iId from tblPage...")
    │             └─ cls_page.pick()
    │
    └─ ページ固有RSS処理
           ├─ selectedPage.fastlistitems（リストアイテム）
           ├─ selectedPage.theme.posts（フォーラム）
           └─ selectedPage.catalog（カタログ）
```

### データフロー図

```
[入力]                       [処理]                         [出力]

リクエスト                 rss.asp                     RSS XML
(iId任意) ──────────▶  キャッシュ確認 ──────────▶    <rss>
                              │                          │
                              ▼                          ▼
tblPage ─────────────▶  kwRSS_writer ──────────▶   <channel>
tblCustomer ─────────▶      │                       <title>
tblPost ─────────────▶      │                       <item>
tblCatalogItem ──────▶      ▼                       ...
                       aspXML.GetXML() ──────────▶  </rss>
                              │
                              ▼
                       application("RSS"&key) キャッシュ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rss.asp | `rss.asp` | ソース | エントリーポイント、メイン処理 |
| rss_writer.asp | `asp/includes/rss_writer.asp` | ソース | RSS生成クラス（kwRSS_writer, aspXML） |
| begin.asp | `asp/begin.asp` | ソース | 共通初期化処理 |
